function reducefigure(figfile);
% Usage: reducefigure(figfile);
% Loads the figure, and replots it using only every 10th child
%  of its only axis and the last four, then saves it
%  to a related filename.

fprintf('Operating on %s\n', figfile);

infile = figfile;
outfile = [figfile(1 : end - 3), 'sub.fig'];

hgload(infile);

ch = get(gca, 'Children');
ax = axis;
tit = get(gca, 'Title');
tit = get(tit, 'String');
xl = get(gca, 'XLabel');
xl = get(xl, 'String');
yl = get(gca, 'YLabel');
yl = get(yl, 'String');

N = length(ch);

nfig = figure;
clf;
hold on;

for n = [N : -10 : 5, 4 : -1 : 1],

   x = get(ch(n), 'XData');
   y = get(ch(n), 'YData');
   col = get(ch(n), 'Color');

   plot(x, y, 'Color', col);

   fprintf('\r...done %d of %d...        ', n);
end
fprintf('\r...finished - saving...           \n');

hold off;
axis(ax);
title(tit);
xlabel(xl);
ylabel(yl);

hgsave(nfig, outfile);

fprintf('...done.\n');

close all

return;

