function sizzle(nfig, probvis, numimmune);
% Usage: sizzle(nfig, probvis, numimmune);
% This function takes a figure in which a number of lines are plotted
%  in a single axis, and makes all but the numimmune most 
%  recently plotted lines visible with probability probvis.
% numimmune defaults to 1 unless the most recently plotted
%  line is black, in which case it defaults to 2.
% Press any key to move to next frame, or control-C to exit.

% Change Log:
%
%     1.1          15:oct:19    rfs      First version.
%     1.17         15:oct:19    rfs      Version number harmonisation.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.sizzle.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 3,
   numimmune = [];
end

figure(nfig);
axi = gca;

ch = get(axi, 'Children');

if isempty(numimmune),
   numimmune = 1 + all(get(ch(1), 'Color') == 0);
end

Nch = length(ch);

onoff = {'off', 'on'};

while 1,
   for nch = 1 + numimmune : Nch,
      set(ch(nch), 'Visible', onoff{1 + (rand < probvis)});
   end
   pause;
end

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



