function generate_data_test(censorprob, randomseed);
% Usage: generate_data_test(censorprob, randomseed);
% Test generation of data, by comparing theoretical
%  survival curves with sampled data.
% Set randomseed to 0 to get a set of samples chosen 
%  by jc2062 or rfs34. Set it to a positive integer
%  to effect random seeding, or [] or not passed if you
%  don't want to change the random generator state.
% censorprob does NOT give the fraction of patients whose
%  death times are censored, but the (larger) probability
%  that the censoring time is finite (but could still be
%  later than the time of observed death, resulting in no
%  censoring).

% Change Log:
%
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.4          11:oct:19    rfs34    Prior parameters changed, to match MAIN.m;
%                                        made a function with parameter to choose fixed 
%                                        or random..
%     1.8          12:oct:19    rfs34    Plots and parameters rearranged.
%     1.13         14:oct:19    rfs34    Now uses setpriorcoords.m .
%     1.14         14:oct:19    rfs34    Now accounts for censoring.
%     1.20         16:oct:19    rfs34    Changed convention on cheat or not in 
%                                        generate_params_and_data.m .
%     1.41         22:oct:19    rfs34    Fixed missing parameter.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.generate_data_test.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls thisstate

if nargin < 1,
   censorprob = [];
end
if nargin < 2,
   randomseed = [];
end

if isempty(censorprob),
   censorprob = 0;
end
if ~isempty(randomseed),
   rng(randomseed);
end
thisstate = rng;

xr = 400;

% Set up the parameters of the priors.
priorcoords = setpriorcoords;
[a_J, a_p, b_p, a_m, b_m, a_r, b_r, a_k, b_k, c_k, l_k] = priorcoords{:};
r_r = 1 / b_r;

% With fixed values of J,p,m,r,k.

if isscalar(randomseed) && ~iscell(randomseed) && randomseed == 0,

   J = 2;
   p = [0.2 0.3];
   m = [1 0.3];
   r = [2 1];
   k = [1 1];
   
   y = generate_params_and_data(100, priorcoords, censorprob, {0, J}, {0, p}, {0, m}, {0, r}, {0, k});
   deaths = y{end};
   
   sample = struct('J', 2, 'p', [0.2, 0.3], 'm', [1, 0.3], 'r', [2, 1], 'k', [1, 1]);

else % i.e. if random not fixed

   % With sampled parameters.
   
   y = generate_params_and_data(300,priorcoords, censorprob, {2}, {2}, {2}, {2}, {2});
   [true_J, true_p, true_m, true_r, true_k, true_adherences, true_x, deaths] = y{:};
   sample = struct('J', true_J, 'p', true_p, 'm', true_m, 'r', true_r, 'k', true_k);
   deaths = y{end};

end

censored = true_adherences == 0;

nfig = 1;
thistitle = 'Resulting distributions';
plot_survival_curve(sample, 1, xr, 'b', [nfig, nfig + 1, nfig + 2, NaN, NaN].', thistitle, 0);
figure(nfig);
hold on;
plot_survival_data(deaths, censored, xr, 'k');
hold off;
title(sprintf('Comparison of survival probability and actual surviving fraction (%g censored)', sum(censored) / length(censored)));

figure(4);
[sd, ind] = sort(deaths);
sc = censored(ind);
plot(sd, cumsum(~sc) / length(deaths), 'k', ...
     sd, cumsum(sc) / length(deaths), 'k-.');
axis([0, xr, -0.01, 1.01]);
xlabel('Time (days)');
ylabel('Fraction censored (-.) or observed to die (solid)');
title('Fraction censored (-.) or observed to die (solid)');

return;

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
