function y = log_k_density(k, a, b, c, l, sw)
% Usage: y = log_k_density(k, a, b, c, l, sw)
% Returns the log density of k at the parameter values a,b,c,
%  where l is the length of b and c,
%  and if sw is 1 then k gets transposed first.
% Prior for k of the form:
%  P(scalar k) proportional to 
%   abs(k) .^ a .* prod(b .^ (c .* k) .* exp(- c .* b .^ k))
%  for positive scalar integer a, and vectors b and c 
%  of positive reals of the same length as each other.
% Note that zero entries in b (and the corresponding entries in c)
%  are ignored (they are used to flag entries corresponding to
%  infinite death times).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.5          11:oct:19    rfs34    Dimension bug fixed.
%     1.43         23:oct:19    rfs34    Comments only changed.
%     1.55         13:dec:19    rfs34    Important change to comments above.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.log_k_density.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if sw == 1
    k = k';
end

b = reshape(cell2mat(b), [l 1]);
c = reshape(cell2mat(c), [l 1]);

M = size(k);
M = M(2);

kl = repmat(k, l, 1);
b = repmat(b, 1, M);
c = repmat(c, 1, M);

d = b;
d(b == 0) = 1;
dd = d.^kl;
dd(b == 0) = 0;

y = log(abs(k)).*a + sum((log(d).*(c.*kl) - (c .* (dd))), 1);
end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
