 function [segments, segtraj] = circFRET_roving4_drift_thumbs(imstack,infile,outf,segments) 
% circFRET_roving3

%Extract single-pair FRET trajectories from a multipage TIFF or CXD file
% from a "roving" ALEX experiment.
%
% Usage: [segments, segtraj] = circFRET_roving4(imstack,infile,outf,segments)
%
% infile supplies key parameters
% Sample infile:
% 10    border - width of murky boundary between channels
% 3     period - number of total frames per frame Aex
% 4     boxwidth - width of box to draw around points
% 0.95  thresh - threshold for finding points (quantile cutoff)
% 5     pksize - expected size of particles (determins allowable dist)
% 0.90  thresh2 - threshold for background determination
% 0.7   corrthresh - image correlation threshold for defining a new field of view
% 20    maxdisp - maximum displacement between channels
% 
% Can optionally enter segment definitions from a previous run of this code
% to save time.
%
% Version 2 uses pkfnd2, which uses a disk-shaped region rather than a box
% to determine if particles are too close to each other.  (Also, the box
% was asymmetric in the original version of pkfnd).
%
% TG 20150128: Modified to use BioFormats package
%
% TG 20150416: 
% - Switched to channel alignment by the position-specific image
% correlation method imcorr_8sect_multi_im
% - Export input arguments to a file that can be used as input for a
% subsequent analysis
% - Added additional input parameters:
%   * correlation threshold for FOV segmentation
%   * maximum displacement for calculating image alignment
%   * radius of exclusion for particle finding
% - Switched to local background subtraction (in the immediate vicinity of
% the ROI) rather than global background subtraction.
% - Added integrated intensity of bandpass-filtered spots and particle
% coordinates to the output.
% - Added outputs that can be used to filter out unfocused frames.
%
% TG 20150512
% changed to a new method of finding the illumination phase of the movie,
% since the old method was giving some errors
%
% TG 20150520
% Corrected a glitch that produced an error upon encountering final
% segments of length 1.
%
% TG 20150523
% Eliminated particles that were too close in the Cy3 channel.
%
% TG 20150525 
% This version corrects for nonlinear stage translation during long
% acquisitions.
%
% TG 20150528
% Also saves thumbnail images of each particle for
% movie-making/troubleshooting purposes.
% Commented out the part of bpass that sets pixels < 0 equal to 0.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SEAN CARNEY 2018 10 17 Notes on channel misalignment
%Changed all instances of 256 pixels to '242' based on slight misalignment
% of channels that I didn't change before or during data collection
%There is ~9-12 pixels on the left side of the Cy3 channel that are cut off
%and contain no spots. The border still seems to be ~256 and the murkey
%region of channel overlap is still ~10pixels. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%for more information see:
%Graham, T. G. W., Walter, J. C. & Loparo, J. J. Two-Stage Synapsis of DNA Ends during Nonhomologous End Joining. Mol. Cell 61, 850?858 (2016). 
%Graham, T. G. W., Walter, J. C. & Loparo, J. J. Ensemble and Single-Molecule Analysis of NonHomologous End Joining in Frog Egg Extracts. Methods Enzymol. 591, 233?270 (2017). 
% %% SMC 9 16 16
%enter location of .cxd file
imstack = 'C:\Point\To\DataFile\Here\file.cxd';
infile = [];
%enter location of destination folder for saving
outf = 'C:\Directory\Where\Analysis\Data\Will\Be\Saved\';
mkdir(outf);
%% 
% % % THIS SHOULD BE CHANGED TO THE LOCATION OF BFMATLAB ON YOUR COMPUTER:
bfGetReaderPath = 'C:\Location\Of\MATLAB\BioformatPlugin\bfmatlab\';   
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %


% infile parsing
if isempty(infile)
    % Default settings:
    border      = 10; % Width of murky boundary between channels
    %border      = 3; % Width of murky boundary between channels %%FOR EXPERIMETNTS PERFORMED ON 2018 01 15
    period      = 5; % number of total frames per acceptor direct excitation frame
    boxwidth    = 4; % Width of box to draw around points
    %boxwidth    = 6; % Width of box to draw around points
    thresh      = 0.95; % Threshold for finding points for analysis (intensity quantile cutoff), will only select peaks in the top x % of intensity
    corrthresh  = 0.4; % correlation threshold for detecting change in FOV
    maxdisp     = 20; % maximum displacement to expect between channels
    rexclude    = 7; % minimum distance between adjacent points
    %rexclude    = 5; % minimum distance between adjacent points
    SegLengthThresh=10; %minimum number of frames in a segment for processing to move forward
    SegSelect   = 0; %1=use corrthresh to cut movie into segments, 0=manually click-select segments
else
    inargs = importdata(infile);
    border      = inargs(1); 
    period      = inargs(2); 
    boxwidth    = inargs(3); 
    thresh      = inargs(4);
    corrthresh  = inargs(5);
    maxdisp     = inargs(6);
    rexclude    = inargs(7);
end

% Write out input parameters to a new input file (for future reference and
% also for the sake of documentation).
infileout = fopen([outf '_in'],'w');
fprintf(infileout,'%d\n%d\n%d\n%f\n%f\n%d\n%d',...
    border,period,boxwidth,thresh,corrthresh,maxdisp,rexclude);
fclose(infileout);

if ~exist('bfGetReader')
    addpath(bfGetReaderPath);
end

reader = bfGetReader(imstack); %low level access to image/movie without loading it

% I'm defining the "phase" (ph) as the first frame with acceptor excitation
% ph = findphaseBF(reader,period);  
ph = findphaseBF2(reader,period);  % TG 20150512: switched to new method of finding phase


%% Determine number of frames
nframes = reader.getImageCount;

if ~exist('segments')  % if segments are not pre-defined, segment movie into similar-looking fields of view
 
    % Determine correlation coefficient between successive periods of
    % frames
    [~, fcorr] = framecorr_periodBF(reader, period, border);
    
    % segments will be a ? x 2 array where each row gives the start
    % position and the width of each segment 
    
    % The width of a segment where only a single pair of successive periods
    % have a correlation > 0.7 is defined to be 1
    
    segments = [];
    corr95= quantile(fcorr,0.95);
%to manually select segments using mouse clicks: SMC edit 2017 02 24
if SegSelect==0
    figure(7); clf; hold off; plot(fcorr,'b-');
    % overlay correlation threshold for FOV segmentation:
    hold on; plot(1:numel(fcorr),ones(1,numel(fcorr))*corr95*corrthresh,'r-');
    
    
    prompt1 = input('How many segments are there?' )
    disp('Click to select x-axis positions for start and end of each segment');
    [xSeg,~] = ginput(prompt1*2);
    xSeg=round(xSeg);
    
%     plotYseg=[0;1];
%     for ii=1:prompt1
%         plotYseg=vercat*prompt1
%     
%     xplotSeg=[xSeg(:,1);-0.1,1];
%     hold on
%     plot(xplotSeg)
%     hold on
    
    for ii=2:2:length(xSeg)
        segments(ii,1)=xSeg(ii-1,1);
        segments(ii,2)=xSeg(ii,1)-xSeg(ii-1,1);
    end
    plot(-.1:1:1)
    % save plot:
    saveas(gcf, [outf '_fcorr.fig']); 
end
    
%Use corrthresh to segment into FOVs
if SegSelect==1
    %to segment movie based on fcorr threshold
    % plot frame correlation:
    figure(7); clf; hold off; plot(fcorr,'b-');
    % overlay correlation threshold for FOV segmentation:
    hold on; plot(1:numel(fcorr),ones(1,numel(fcorr))*corr95*corrthresh,'r-');
    % save plot:
    saveas(gcf, [outf '_fcorr.fig']);
    
    % Loop through correlation vector and divide into segments where the
    % correlation is above corrthresh:
    inFOV = 0; % whether we're currently in a field of view (0==not in FOV)..
    for j=1:numel(fcorr)
        if inFOV %if the preceeding frame(s) had correlation above threshold..
            if fcorr(j) > corrthresh*corr95
                segments(end,2) = segments(end,2) + 1;
            else %if preceeding frame(s) had correlation below corrthresh..
                if ~isempty(segments) && segments(end,2) < 2  % Throw away segments of length < 2
                    segments(end,:) = [];
                end
                inFOV = 0;
            end
        else
            if fcorr(j) > corrthresh*corr95
                segments(end+1,:) = [j,1];
                inFOV = 1;
            end
        end
    end
    if segments(end,2) < 2  % Throw away final segment if it has length < 2 (TG 20150520)
        segments(end,:) = [];
    end
    
end

%SMC edit 2017 01 16 to filter out any short segments
for ii=1:length(segments)
    if segments(ii,2)<SegLengthThresh
        segments(ii,1:2)=0;
    end
end
%remove segments that were too short
segments( ~any(segments,2), : ) = [];  %rows

end
% Number of segments
nseg = size(segments,1);

%% Determine the best transformation between the two channels using
% average-intensity projections of the first ten (five?) segments (or all
% segments, whichever is less):
ims1 = {}; ims2 = {};
for j=1:min(5,nseg)
    % project the entire length of the segment or the first 30 frames,
    % whichever is less
    startframe = (segments(j,1)-1)*period+1;
    endframe = startframe + min(segments(j,2)*period,30);  
    im = zeros(512);
    for k=startframe:endframe
        im = im+double(bfGetPlane(reader,k)); %sum up intenisty values from all frames being considered..
    end
    im = im/min(segments(j,2)*period,30); %Now divide the total sum by the number of frames considered to get average intensity..
    %dchan = im(:,10+border:256-border); % donor half of the image
    dchan = im(:,1+border:256-border); % donor half of the image: COMMENTED OUT 2018 10 17
    achan = im(:,257+border:end-border); % acceptor half of the image
    % Not normalizing in this version, because I actually want differences
    % in signal intensity to be reflected in the strength of the
    % correlation
    ims1{j} = dchan;
    ims2{j} = achan;
end
%Find optimal translation (by pixels)
[bestcorr, midrow, midcol] = imcorr_8sect_multi_im(ims1, ims2, maxdisp);

save([outf '_channel_translation.mat'],'bestcorr','midrow','midcol');

% ASSUMING IN THIS VERSION THAT STAGE DRIFT IS NEGLIGIBLE

segtraj = {};
w = waitbar(0,'Integrating spot intensities in segment 1.');

% mask that will be used to "cut out" spots later on for background
% determination: Used to determine spot shape and size
se = strel('disk',boxwidth,0);
sen = se.getnhood();
sen_border_size = sum(sum(1-sen));

for segind = 1:nseg  % Loop over segments in distinct fields of view
    
    segstart = segments(segind,1); % frame period where the segment starts
    seglength = segments(segind,2); % length of the segment in periods
    segfirst = segstart*period + 1; % first frame in absolute frame numbers
    seglast = segfirst + period*(seglength-1) - 1; %last frame in absolute frame numbers
    nsegframes = period*(seglength-1); % number of frames in the segment
    
    % Initialize data structure containing trajectories for this segment.
    segtraj{segind} = struct('segfirst',segfirst,'seglast',seglast,'nsegframes',nsegframes, ...
        't',segfirst:seglast,'ph',mod(segfirst-ph,period)+1,...
        'ddtraj',[],'datraj',[],'aatraj',[],'ddback',[], ...
        'daback',[],'aaback',[],'ddtraj_bpass',[],'datraj_bpass',[],...
        'aatraj_bpass',[],'ddback_bpass',[],'daback_bpass',[],...
        'aaback_bpass',[],...
        'ddthumbs',[],'dathumbs',[],'aathumbs',[]);
    
    % In this version, I eliminated averaging of frames entirely to avoid
    % detection bias against acceptors that bleach more quickly.  Find
    % find particles in the first Aex frame.
    pfindim = double(bfGetPlane(reader, segstart*period + ph));
    achan = pfindim(:,257+border:end-border); % acceptor half of the image
    % rescale channels so that min = 0 and max = 1
    achan = (achan-min(achan(:)))/(max(achan(:))-min(achan(:)));  
    % Shift channels according to predetermined offsets, and make composite
    achan_bpass = bpass(achan,1,5);
    
    % Select the subsequent Dex frame to exclude overlapping particles in
    % the donor channel.  This is not quite perfect, because it could miss
    % high-FRET particles.
    dpim = double(bfGetPlane(reader, segstart*period + ph + 1));
	dexdem = dpim(:,1+border:256-border); % donor half of the image COMMENTED OUT 2018 10 17
	%dexdem = dpim(:,10+border:256-border); % donor half of the image
    dexaem = dpim(:,257+border:end-border);
    dchan = combine_da(dexdem,dexaem,bestcorr,midrow,midcol);
    % rescale channels so that min = 0 and max = 1
    dchan = (dchan-min(dchan(:)))/(max(dchan(:))-min(dchan(:)));  

    dchan_bpass = bpass(dchan,1,5);
    
    % Calculate drift collection
    [offy, offx] = getMyDrift_nonlin(dchan,reader,segfirst,seglast,period,border,outf);  % CORRECTED - TG 20150224
    segtraj{segind}.offx = offx;
    segtraj{segind}.offy = offy;
    maxxdrift = max(offx);
    minxdrift = min(offx);
    maxydrift = max(offy);
    minydrift = min(offy);
    
    % in this version, I will find particles in the acceptor channel
    % (de-noised and background subtracted using bandpass filtering)
    ap = pkfnd2(achan_bpass,quantile(achan_bpass(:),thresh),rexclude);
    
    dp_peaks = peakfind(dchan_bpass,quantile(dchan_bpass(:),thresh));
    
    % Determine corresponding particles in the donor channel
    p = zeros(size(ap,1),size(ap,2));
    for j=1:size(ap,1)
        p(j,:) = shiftxy8(ap(j,1), ap(j,2), bestcorr, midrow, midcol);
    end
    
    % Identify which particles are within the bounds in both channels and
    % not too close to other peaks in the donor channel
    se_exclude = strel('disk',rexclude,0);  %%%%%
    isgood = zeros(size(p,1),1);
    for j=1:size(p,1)
        % the following assumes that rexclude > boxwidth (which it should
        % be!)
        
        % check if the particle is within the bounds in both channels and
        % if it will stay within the bounds given the drift (this feature
        % added 20150525 (TG))
        if      (p(j,2) + rexclude + maxydrift < 512) & ...
                (p(j,2) - rexclude + minydrift > 0) & ...   % x coord donor channel
                (ap(j,2)+ rexclude + maxydrift < 512) & ... 
                (ap(j,2)- rexclude + minydrift > 0) & ...   % x coord acceptor channel
                (p(j,1) + rexclude + maxxdrift < 256-2*border) & ...
                (p(j,1) - rexclude + minxdrift > 0) & ...   % y coord donor channel
                (ap(j,1)+ rexclude + maxxdrift < 256-2*border) & ...
                (ap(j,1)- rexclude + minxdrift > 0)         % y coord acceptor channel
       
            % next, check if there is more than one particle in the
            % vicinity in the DexDem or DexAem channels.
            roi = dp_peaks( (p(j,2)-rexclude):(p(j,2)+rexclude),(p(j,1)-rexclude:(p(j,1)+rexclude)));
            roi = roi.*se_exclude.getnhood();
            % if there is no more than a single spot within the exclusion
            % zone in the donor channel
            if sum(roi(:)) < 2
                isgood(j) = 1; % set this particle to be good
            end
        end
    end

    badp = p(isgood~=1,:);
    p = p(isgood==1,:);
    ap = ap(isgood==1,:);
    
    
    % Show overlay
    imD = double(bfGetPlane(reader, segstart*period + ph + 1));
    dchan = imD(:,1+border:256-border); % donor half of the image
    achan = combine_da(0*achan,achan,bestcorr,midrow,midcol);
    dchan = scaleim(dchan);
    achan = scaleim(achan);
%     dchan_bpass = bpass(dchan,1,5);
%     achan_bpass = (achan_bpass - mean(achan_bpass(:)))/(quantile(achan_bpass(:),0.99)-quantile(achan_bpass(:),0.01));
%     achan_bpass = combine_da(0*achan_bpass,achan_bpass,bestcorr,midrow,midcol);
%     dchan_bpass = (dchan_bpass - mean(dchan_bpass(:)))/(quantile(dchan_bpass(:),0.99)-quantile(dchan_bpass(:),0.01));
   
% Visualization of identified particles:
    figure(1);
    hold off;
%     imshow(cat(3,achan_bpass,dchan_bpass,0*achan_bpass))
    imshow(cat(3,achan,dchan,0*achan))
    hold on;
    if ~isempty(p)
        plot(p(:,1), p(:,2),'co');
    end
    if ~isempty(badp)
        plot(badp(:,1), badp(:,2),'mo');
    end
    
    saveas(gcf, [outf '_shifted_overlay_' num2str(segind) '.fig']);
    
    % Initialize trajectory and background arrays
    nump = size(p,1);
    segtraj{segind}.ddtraj = zeros((seglength-1)*(period-1),nump);
    segtraj{segind}.datraj = zeros((seglength-1)*(period-1),nump);
    segtraj{segind}.aatraj = zeros((seglength-1),nump);
    segtraj{segind}.ddback = zeros((seglength-1)*(period-1),1);
    segtraj{segind}.daback = zeros((seglength-1)*(period-1),1);
    segtraj{segind}.aaback = zeros((seglength-1),1);
	segtraj{segind}.aatraj_bpass = zeros((seglength-1),nump);
    segtraj{segind}.aaback_bpass = zeros((seglength-1),nump);
    segtraj{segind}.ddtraj_bpass = zeros((seglength-1)*(period-1),nump);
    segtraj{segind}.ddback_bpass = zeros((seglength-1)*(period-1),nump);
    segtraj{segind}.datraj_bpass = zeros((seglength-1)*(period-1),nump);
    segtraj{segind}.daback_bpass = zeros((seglength-1)*(period-1),nump);
    % include particle coordinates
    segtraj{segind}.p = p;
    segtraj{segind}.ap = ap;
    % include two metrics for determining how in-focus the images are
    segtraj{segind}.dd_xysig = zeros((seglength-1)*(period-1),2);
    segtraj{segind}.aa_xysig = zeros((seglength-1),2);
    segtraj{segind}.dd_fqual = zeros((seglength-1)*(period-1),1);
    segtraj{segind}.aa_fqual = zeros((seglength-1),1);
    % include thumbnail images of all particles
    segtraj{segind}.ddthumbs = zeros(2*boxwidth+1,2*boxwidth+1,(seglength-1)*(period-1),nump);
    segtraj{segind}.dathumbs = zeros(2*boxwidth+1,2*boxwidth+1,(seglength-1)*(period-1),nump);
    segtraj{segind}.aathumbs = zeros(2*boxwidth+1,2*boxwidth+1,seglength-1,nump);
    
    waitbar(0,w,['Integrating spot intensities in segment ' num2str(segind)...
        ': Frame 1 of ' num2str(nsegframes)]);

    ddind = 1;
    aaind = 1;

    qc_dd = zeros(512,256-2*border);
    qc_da = zeros(512,256-2*border);
    qc_aa = zeros(512,256-2*border);
    for j = segfirst:seglast
        currframe = bfGetPlane(reader,j);
        dchan = currframe(:,1+border:256-border); % donor half of the image
        achan = currframe(:,257+border:end-border); % acceptor half of the image
        dchan_bpass = bpass(dchan,1,5);
        achan_bpass = bpass(achan,1,5);
        waitbar((j-segfirst+1)/nsegframes, w, ['Integrating spot intensities in segment ' ...
            num2str(segind) ': Frame ' num2str(j-segfirst+1)...
            ' of ' num2str(nsegframes)]);
        
%         figure(17);
%         clf;
%         subplot(1,2,1);
%         imagesc(dchan); colormap gray;
%         hold on; plot(p(:,1) + offx(floor((j-segfirst)/period)+1),...
%             p(:,2) + offy(floor((j-segfirst)/period)+1),'ro');
%         subplot(1,2,2);
%         imagesc(achan); colormap gray;
%         hold on; plot(ap(:,1) + offx(floor((j-segfirst)/period)+1),...
%             ap(:,2) + offy(floor((j-segfirst)/period)+1),'ro');
        
        sdxy = [0,0];
        for k = 1:size(p,1);
           
            yd = p(k,2) + offy(floor((j-segfirst)/period)+1); 
            ya = ap(k,2) + offy(floor((j-segfirst)/period)+1);
            xd = p(k,1) + offx(floor((j-segfirst)/period)+1);
            xa = ap(k,1) + offx(floor((j-segfirst)/period)+1);
            
            % Cut out boxes containing particles in donor and acceptor channels, and crop with structuring element:           
            dbox_orig = double(dchan(yd-boxwidth:yd+boxwidth,xd-boxwidth:xd+boxwidth));
            dbox_back = dbox_orig.*(1-sen);
            dbox = dbox_orig.*sen;
            
            abox_orig = double(achan(ya-boxwidth:ya+boxwidth,xa-boxwidth:xa+boxwidth));
            abox_back = abox_orig.*(1-sen);
            abox = abox_orig.*sen;
            
            dbox_bpass_orig = double(dchan_bpass(yd-boxwidth:yd+boxwidth,xd-boxwidth:xd+boxwidth));
            dbox_bpass_back = dbox_bpass_orig.*(1-sen);
            dbox_bpass = dbox_bpass_orig.*sen;
            
            abox_bpass_orig = double(achan_bpass(ya-boxwidth:ya+boxwidth,xa-boxwidth:xa+boxwidth));
            abox_bpass_back = abox_bpass_orig.*(1-sen);
            abox_bpass = abox_bpass_orig.*sen;
            
            if mod(j-ph,period)==0 % if this is an Aex frame
                segtraj{segind}.aatraj(aaind,k) = sum(abox(:));
                segtraj{segind}.aaback(aaind,k) = sum(abox_back(:))/sen_border_size;
                segtraj{segind}.aatraj_bpass(aaind,k) = sum(abox_bpass(:));
                segtraj{segind}.aaback_bpass(aaind,k) = sum(abox_bpass_back(:))/sen_border_size;
                segtraj{segind}.aathumbs(:,:,aaind,k) = abox_bpass_orig;
                cf = crudefit(abox);
                sdxy = sdxy + cf(3:4);
            else % if this is a Dex frame
                segtraj{segind}.ddtraj(ddind,k) = sum(dbox(:));
                segtraj{segind}.datraj(ddind,k) = sum(abox(:));
                segtraj{segind}.ddback(ddind,k) = sum(dbox_back(:))/sen_border_size;
                segtraj{segind}.daback(ddind,k) = sum(abox_back(:))/sen_border_size;
                segtraj{segind}.ddtraj_bpass(ddind,k) = sum(dbox_bpass(:));
                segtraj{segind}.ddback_bpass(ddind,k) = sum(dbox_bpass_back(:))/sen_border_size;
                segtraj{segind}.datraj_bpass(ddind,k) = sum(abox_bpass(:));
                segtraj{segind}.daback_bpass(ddind,k) = sum(abox_bpass_back(:))/sen_border_size;
                segtraj{segind}.ddthumbs(:,:,ddind,k) = dbox_bpass_orig;
                segtraj{segind}.dathumbs(:,:,ddind,k) = abox_bpass_orig;
                cf = crudefit(dbox);
                sdxy = sdxy + cf(3:4);
            end
        end
        
        if mod(j-ph,period)==0 % if this is an Aex frame
            segtraj{segind}.aa_fqual(aaind) = get_fqual(achan);
            segtraj{segind}.aa_xysig(aaind,:) = sdxy/nump;
            aaind = aaind + 1;
            qc_aa = qc_aa + double(achan);
        else % if this is a Dex frame
            segtraj{segind}.dd_fqual(ddind) = get_fqual(dchan);
            segtraj{segind}.dd_xysig(ddind,:) = sdxy/nump;
            ddind = ddind + 1;
            qc_dd = qc_dd + double(dchan);
            qc_da = qc_da + double(achan);
        end

    end
    
    qc_dd = (qc_dd-quantile(qc_dd(:),0.10))/(quantile(qc_dd(:),0.99)-quantile(qc_dd(:),0.01));
    qc_da = (qc_da-quantile(qc_da(:),0.10))/(quantile(qc_da(:),0.99)-quantile(qc_da(:),0.01));
    qc_aa = (qc_aa-quantile(qc_aa(:),0.10))/(quantile(qc_aa(:),0.99)-quantile(qc_aa(:),0.01));
    
    
    figure(3); clf;
    combined = cat(3,qc_aa,qc_dd,qc_da);
    imshow(combined)
    imwrite(combined, [outf '_overlay_' num2str(segind) '.tif'],'tif','ColorSpace','rgb');
    if ~isempty(p)
        hold on; plot(p(:,1), p(:,2),'co');
        hold on; plot(ap(:,1), ap(:,2),'mo');
    end
    saveas(gcf, [outf '_overlay_' num2str(segind) '.fig']);
    
end

close(w)

% TG 20150424: Changed this to avoid redundancy; my analysis wrapper script
% was saving segtraj and segments under a different name:
st = segtraj; s = segments;
save([outf '_output.mat'],'st','s','-v7.3');  

end



function rv = gaussfit2(input)
   starting = estimate_gauss(input);
   options=optimset('Algorithm','interior-point','LargeScale','off','Display','off','MaxIter',5000,'MaxFunEvals',5000);
   rv = fminunc(@gausserror, starting, options, input);
end

function params = estimate_gauss(data)

[X, Y] = meshgrid(1:size(data,1),1:size(data,2));

B = min(data(:));

minusB = data - B;

A = sum(minusB(:));

x0 = sum(sum(X.*minusB))/A;
y0 = sum(sum(Y.*minusB))/A;

sigx = sum(sum((X-x0).^2.*minusB))/A;
sigy = sum(sum((Y-y0).^2.*minusB))/A;

params = [x0 y0 sigx sigy A B];


end

function error = gausserror(params,data)
  x0 = params(1); % mean positions in x and y directions
  y0 = params(2);
  sigx = params(3);  % std deviations in x and y directions
  sigy = params(4);
  A = params(5); % amplitude
  B = params(6); % constant background offset
  error = 0;
  imsize = size(data);

  i = 1:imsize(1); % i is the col number or x coord
  j = 1:imsize(2); % j is the row number or y coord
  [Y,X] = meshgrid(i,j); %matrices of x and y coord respectively

  Xerf = (erf((X-x0)/(sqrt(2)*sigx))-erf((X-1-x0)/(sqrt(2)*sigx)))/2;
  
  Yerf = (erf((Y-y0)/(sqrt(2)*sigy))-erf((Y-1-y0)/(sqrt(2)*sigy)))/2;

%  Calculate difference from discrete Gaussian...
  sse = sum(sum((data - ( A*(Xerf.*Yerf) + B) ).^2 ));

  error = sqrt(sse);


end

function res = bpass(image_array,lnoise,lobject,threshold)
% 
% NAME:
%               bpass
% PURPOSE:
%               Implements a real-space bandpass filter that suppresses 
%               pixel noise and long-wavelength image variations while 
%               retaining information of a characteristic size.
% 
% CATEGORY:
%               Image Processing
% CALLING SEQUENCE:
%               res = bpass( image_array, lnoise, lobject )
% INPUTS:
%               image:  The two-dimensional array to be filtered.
%               lnoise: Characteristic lengthscale of noise in pixels.
%                       Additive noise averaged over this length should
%                       vanish. May assume any positive floating value.
%                       May be set to 0 or false, in which case only the
%                       highpass "background subtraction" operation is 
%                       performed.
%               lobject: (optional) Integer length in pixels somewhat 
%                       larger than a typical object. Can also be set to 
%                       0 or false, in which case only the lowpass 
%                       "blurring" operation defined by lnoise is done,
%                       without the background subtraction defined by
%                       lobject.  Defaults to false.
%               threshold: (optional) By default, after the convolution,
%                       any negative pixels are reset to 0.  Threshold
%                       changes the threshhold for setting pixels to
%                       0.  Positive values may be useful for removing
%                       stray noise or small particles.  Alternatively, can
%                       be set to -Inf so that no threshholding is
%                       performed at all.
%
% OUTPUTS:
%               res:    filtered image.
% PROCEDURE:
%               simple convolution yields spatial bandpass filtering.
% NOTES:
% Performs a bandpass by convolving with an appropriate kernel.  You can
% think of this as a two part process.  First, a lowpassed image is
% produced by convolving the original with a gaussian.  Next, a second
% lowpassed image is produced by convolving the original with a boxcar
% function. By subtracting the boxcar version from the gaussian version, we
% are using the boxcar version to perform a highpass.
% 
% original - lowpassed version of original => highpassed version of the
% original
% 
% Performing a lowpass and a highpass results in a bandpassed image.
% 
% Converts input to double.  Be advised that commands like 'image' display 
% double precision arrays differently from UINT8 arrays.

% MODIFICATION HISTORY:
%               Written by David G. Grier, The University of Chicago, 2/93.
%
%               Greatly revised version DGG 5/95.
%
%               Added /field keyword JCC 12/95.
% 
%               Memory optimizations and fixed normalization, DGG 8/99.
%               Converted to Matlab by D.Blair 4/2004-ish
%
%               Fixed some bugs with conv2 to make sure the edges are
%               removed D.B. 6/05
%
%               Removed inadvertent image shift ERD 6/05
% 
%               Added threshold to output.  Now sets all pixels with
%               negative values equal to zero.  Gets rid of ringing which
%               was destroying sub-pixel accuracy, unless window size in
%               cntrd was picked perfectly.  Now centrd gets sub-pixel
%               accuracy much more robustly ERD 8/24/05
%
%               Refactored for clarity and converted all convolutions to
%               use column vector kernels for speed.  Running on my 
%               macbook, the old version took ~1.3 seconds to do
%               bpass(image_array,1,19) on a 1024 x 1024 image; this
%               version takes roughly half that. JWM 6/07
%
%       This code 'bpass.pro' is copyright 1997, John C. Crocker and 
%       David G. Grier.  It should be considered 'freeware'- and may be
%       distributed freely in its original form when properly attributed.  

if nargin < 3, lobject = false; end
if nargin < 4, threshold = 0; end

normalize = @(x) x/sum(x);

image_array = double(image_array);

if lnoise == 0
  gaussian_kernel = 1;
else      
  gaussian_kernel = normalize(...
    exp(-((-ceil(5*lnoise):ceil(5*lnoise))/(2*lnoise)).^2));
end

if lobject  
  boxcar_kernel = normalize(...
      ones(1,length(-round(lobject):round(lobject))));
end
  
% JWM: Do a 2D convolution with the kernels in two steps each.  It is
% possible to do the convolution in only one step per kernel with 
%
  % gconv = conv2(gaussian_kernel',gaussian_kernel,image_array,'same');
  % bconv = conv2(boxcar_kernel', boxcar_kernel,image_array,'same');
% 
% but for some reason, this is slow.  The whole operation could be reduced
% to a single step using the associative and distributive properties of
% convolution:
%
  % filtered = conv2(image_array,...
  %   gaussian_kernel'*gaussian_kernel - boxcar_kernel'*boxcar_kernel,...
  %   'same');
%
% But this is also comparatively slow (though inexplicably faster than the
% above).  It turns out that convolving with a column vector is faster than
% convolving with a row vector, so instead of transposing the kernel, the
% image is transposed twice.

gconv = conv2(image_array',gaussian_kernel','same');
gconv = conv2(gconv',gaussian_kernel','same');

if lobject
  bconv = conv2(image_array',boxcar_kernel','same');
  bconv = conv2(bconv',boxcar_kernel','same');

  filtered = gconv - bconv;
else
  filtered = gconv;
end

% Zero out the values on the edges to signal that they're not useful.     
lzero = max(lobject,ceil(5*lnoise));

filtered(1:(round(lzero)),:) = 0;
filtered((end - lzero + 1):end,:) = 0;
filtered(:,1:(round(lzero))) = 0;
filtered(:,(end - lzero + 1):end) = 0;

% JWM: I question the value of zeroing out negative pixels.  It's a
% nonlinear operation which could potentially mess up our expectations
% about statistics.  Is there data on 'Now centroid gets subpixel accuracy
% much more robustly'?  To choose which approach to take, uncomment one of
% the following two lines.
% ERD: The negative values shift the peak if the center of the cntrd mask
% is not centered on the particle.

% filtered(filtered < threshold) = 0;
res = filtered;

end

function fqual = get_fqual(im)
% Gaussian fitting of correlation matrix
cm = imcorrmat(im,im,2);
cf = crudefit(cm);
fqual = cf(5)/cf(3);
end

function scaled = scaleim(im)
    scaled = (im-quantile(im(:),0.01))/(quantile(im(:),0.99)-quantile(im(:),0.01));
end