%function annotations = simple_browse_localback_thumbnails(segtraj,segn, n,usebpass)
% simple_browse_localback_thumbnails.m
% Usage: simple_browse_localback_thumbnails(segtraj,segn, n,usebpass)
% segtraj - cell array of outputs from circFRET_roving4_drift_thumbs
% segn - segment number
% n - trajectory number
% usebpass - plots integrated intensity of raw image if set to 0, integrated
% intensity of bandpass-filtered image otherwise
close all
tic
%SMC: 2017 01 08, load '_output.mat' file from circFRET_roving4_drift_thumbs_SMC.m
%This output file contains 'st' variable where the data was saved
%Most recent edits--SeanC--'e' option to save raw data 2017 09 22
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%User must fill out block of variables below
%SELECTOPTION 3- review traces ('s' to skip through review) and truncate data based on S and E thresholds
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%for more information see:
%Graham, T. G. W., Walter, J. C. & Loparo, J. J. Two-Stage Synapsis of DNA Ends during Nonhomologous End Joining. Mol. Cell 61, 850?858 (2016). 
%Graham, T. G. W., Walter, J. C. & Loparo, J. J. Ensemble and Single-Molecule Analysis of NonHomologous End Joining in Frog Egg Extracts. Methods Enzymol. 591, 233?270 (2017). 
%cd to dir where you want data to be saved
savename='EnterFileNameForSavingHere';%select name of folder where data/figs will be saved;
selectoption=3;%read above
truncatebleaching=1; %use '1' to have the program automatically truncate traces based on FRETE and S thresholds, use '0' keep entire trace for all traces
segtraj=st;%
%st=stAll;%
%segtraj=stAll;%
savesize=20; %minimum number of FRET data pts or DonorEx frames for saving inforvbFRET
usebpass=0;    
boxwidth = 4;
period = 5; %How many frames total per 1 frame of Aex
LowerSthresh=0.05;%For filtering out bad regions of traces
UpperSthresh=0.95;%For filtering out bad regions of traces
FRETupperThresh=1.5;%For filtering out bad regions of traces
FretlowerThresh=-1;%For filtering out bad regions of traces
NHEJthresh=0.35;%Above this FRET value will be considered positive joining/synaptic complex formation
TranScan=2; %scan this # of frames surrounding click pt. within trace
AveScan=2; %difference of running average over this many points will yeild transitions
TimeDelay=1; %in seconds
ExposureTime=1;%in seconds
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
numsegs=length(st);
SaveTraces={};
frethist=[];
EvS=[];
sumtest=0;
key=0; %initialize this for optoin 3 skipping
segtrack=[];
Badtraces=0;
DNAtrace=0;
Goodtrace=0;
DataSel={};
SelDCount=1;

%Correction Factors determined empirically by TG, pulled from'pretty_browse_localback_sorted.m'
% CORRECTION FACTORS
l = 0.061;
% X = 0.056;
X = 0.068;
gam = 0.8;


for i=1:numsegs
    %if segtraj{i}.nsegframes>10 %if there are a least 10 frames to analyze, go forward
    segtrack(i)=1;
    segn=i;
    %n=(segtraj{segn}.nsegframes);
    n=1;
    % Read in data from files
    if usebpass==0
        ddtraj = segtraj{segn}.ddtraj;
        datraj = segtraj{segn}.datraj;
        aatraj = segtraj{segn}.aatraj;
        ddback = segtraj{segn}.ddback;
        daback = segtraj{segn}.daback;
        aaback = segtraj{segn}.aaback;
    else
        % % BPASS FILTER W/O BACKGROUND SUBTRACTION (SEE TG 20150525 NOTES)
        ddtraj = segtraj{segn}.ddtraj_bpass;
        datraj = segtraj{segn}.datraj_bpass;
        aatraj = segtraj{segn}.aatraj_bpass;
        ddback = segtraj{segn}.ddback_bpass; % multiply these by 0 if not applying additional background subtraction
        daback = segtraj{segn}.daback_bpass;
        aaback = segtraj{segn}.aaback_bpass;
    end
    
    t = segtraj{segn}.t;
    ph = segtraj{segn}.ph;
    
    npks = size(ddtraj,2);
    annotations =  ones(1,npks);
    
    ntime = length(t);
    
    ddt = t(mod((1:ntime)-ph,period)~=0)';
    aat = t(mod((1:ntime)-ph,period)==0)';
    mint = min([ddt;aat]);
    ddt = ddt-mint;
    aat = aat-mint;
    
    se = strel('disk',boxwidth,0);
    sesize = sum(sum(se.getnhood()));
    
    
    % Fit to intensity histograms to get 1-fluorophore and 0-fluorophore peaks
    % for initial state assignments.
    
    % ddbsubt = ddtraj - sesize*ddback*ones(1,size(ddtraj,2));
    % aabsubt = aatraj - sesize*aaback*ones(1,size(aatraj,2));
    
    dd_bsub = ddtraj - ddback*sesize;
    da_bsub = datraj - daback*sesize;
    aa_bsub = aatraj - aaback*sesize;
    
    % scales for graphs
    ddscalemax = quantile(dd_bsub(:),0.99);
    % ddscalemin = quantile(dd_bsub(:),0.01);
    dascalemax = quantile(da_bsub(:),0.99);
    % dascalemin = quantile(da_bsub(:),0.01);
    aascalemax = quantile(aa_bsub(:),0.99);
    aascalemin = quantile(aa_bsub(:),0.01);
    
    ddthumbmin = mean(segtraj{segn}.ddthumbs(1,1,1,:));
    ddthumbmax = quantile(segtraj{segn}.ddthumbs(5,5,1,:),0.8);
    dathumbmin = mean(segtraj{segn}.dathumbs(1,1,1,:));
    dathumbmax = quantile(segtraj{segn}.dathumbs(5,5,1,:),0.8);
    aathumbmin = mean(segtraj{segn}.aathumbs(1,1,1,:));
    aathumbmax = quantile(segtraj{segn}.aathumbs(5,5,1,:),0.8);
    
    
    colors = [[0.75,0,0]; [0,0.75,0]; [0,0,0.75]; [0,0,0]];
    if selectoption==1
        f = figure();
        set(f,'Position',[107   122   814   543]);
        userinp_fnum = '';
    end
    
    [numpts,~]=size(da_bsub);
    
    %Initialize SaveTraces variables and pad with zeros
    SaveTraces{segn}.aatimeTrunc=zeros(numpts,npks);
    SaveTraces{segn}.aat=zeros(numpts,npks);
    SaveTraces{segn}.aaTrunc=zeros(numpts,npks);
    SaveTraces{segn}.curr_aa_bsub=zeros(numpts,npks);
    SaveTraces{segn}.ddtimeTrunc=zeros(numpts,npks);
    SaveTraces{segn}.ddt=zeros(numpts,npks);
    SaveTraces{segn}.ddTrunc=zeros(numpts,npks);
    SaveTraces{segn}.curr_dd_bsub=zeros(numpts,npks);
    SaveTraces{segn}.daTrunc=zeros(numpts,npks);
    SaveTraces{segn}.curr_da_bsub=zeros(numpts,npks);
    SaveTraces{segn}.S=zeros(numpts,npks);
    SaveTraces{segn}.Strunc=zeros(numpts,npks);
    SaveTraces{segn}.FRETEtrunc=zeros(numpts,npks);
    SaveTraces{segn}.FRETE=zeros(numpts,npks);
    SaveTraces{segn}.AveFRETEtrunc=zeros(numpts,npks);
    SaveTraces{segn}.AveFRETE=zeros(numpts,npks);
    SaveTraces{segn}.STimetrunc=zeros(numpts,npks);
    SaveTraces{segn}.FillFRET=zeros(numpts,npks);
    SaveTraces{segn}.FillFRETTrunc=zeros(numpts,npks);
    SaveTraces{segn}.Bleach=zeros(1,npks);
    
    Selcount=1;
    while n <= npks

        % perform background subtraction on thumbnails
        curr_dd_bsub = dd_bsub(:,n);
        curr_da_bsub = da_bsub(:,n);
        curr_aa_bsub = aa_bsub(:,n);
        currddthumb = scaleim(mean(segtraj{segn}.ddthumbs(:,:,:,n),3),ddthumbmin,ddthumbmax);
        currdathumb = scaleim(mean(segtraj{segn}.dathumbs(:,:,:,n),3),dathumbmin,dathumbmax);
        curraathumb = scaleim(mean(segtraj{segn}.aathumbs(:,:,:,n),3),aathumbmin,aathumbmax);
        %        %% THESE CORRECTIONS NEED HELP-FINAL PLOTS LOOK A BIT OFF
        %         %calculate FRETE
        dd=curr_dd_bsub;
        da=curr_da_bsub;
        aa=curr_aa_bsub;
        
        aa2=[];
        %Sean Edits 2017 05 04 ~~~~TEST THIS BIT FOR PERIODS OTHER THAN 3~~~~
            %to fill in aa matrix to match size of dd and da, use period -1
            %because that is the number of donor excited frames used
        for j=1:length(aa)
            if j==1
                aa2(1:period-1,1)=aa(1,1);
            else
                aa2(length(aa2)+1:length(aa2)+period-1,1)=aa(j,1); 
            end
        end
               
        %         %!!!!!!!!Include CORRECTION FACTORS HERE!!!!!!!!!!!!!!!!!!!!!!!!!!!
        %         %Corrections pulled from'pretty_browse_localback_sorted.m' 
        % apply corrections FROM TG's program
        da2 = da - l*dd - X*aa2;
        frete = da2./(da2 + gam*dd);
        
        
        
        %%
        
        SaveTraces{segn}.frete(1:length(frete),n)=frete;
        if i==1 && n==1
            frethist(1:length(frete),1)=frete;
        else
            frethist(length(frethist)+1:length(frethist)+length(frete),1)=frete;
        end
        
        %calculate S, averaged over the period for donor excitation
        Stime=[];
        S=[];
        for j=1:length(ddt)
            Stime(ddt(j,1)+1,1)=ddt(j,1);
            Stime(ddt(j,1)+1,3)=curr_da_bsub(j,1);
            Stime(ddt(j,1)+1,2)=curr_dd_bsub(j,1);
            Stime(ddt(j,1)+1,7)=frete(j,1);
        end
        for j=1:length(aat)
            Stime(aat(j,1)+1,1)=aat(j,1);
            Stime(aat(j,1)+1,4)=curr_aa_bsub(j,1);
            %Fill in Aex frames with FRET values from frame before
            %or frame after, for downstream HMM
            if Stime(1,4)==0
                Stime(aat(j,1)+1,7)=Stime(aat(j,1),7);
            elseif Stime(1,4)~=0
                Stime(aat(j,1)+1,7)=Stime(aat(j,1)+2,7);
            end
        end
        
        [Aframes,Acolumn]=find(Stime(:,4));%find where Aex is in Stime MATRIX
        Stime(:,9)=zeros; %to initialize this column, later we fill in with 1 is FRETE is over thresholds
        
        %Calculate S and AveFRETE for each Aex period
        %Asssumes two AA frames are never consecutive
        %Calculate S and AveFRETE for each period
        AveFRETE=[];
        count=0;
        for k=1:nnz(Stime(:,4))
            if k==1 && Stime(1,4)==0
                Stime(Aframes(k,1),8)=(mean(Stime(1:Aframes(k,1)-1,2))+mean(Stime(1:Aframes(k,1)-1,3)))/(mean(Stime(1:Aframes(k,1)-1,2))+mean(Stime(1:Aframes(k,1)-1,3))+Stime(Aframes(k,1),4));
                Stime(Aframes(k,1),5)=mean(Stime(1:Aframes(k,1),1));
                AveFRETE(k,1)=mean(Stime(1:Aframes(k,1)-1,3))/(mean(Stime(1:Aframes(k,1)-1,3))+mean(Stime(1:Aframes(k,1)-1,2)));
                if sum(Stime(1:Aframes(k,1)-1,7)< FretlowerThresh)>0 || sum(Stime(1:Aframes(k,1)-1,7)> FRETupperThresh)>0
                    Stime(Aframes(k,1),9)=1;
                end
            end
            if k==1 && Stime(1,4)~=0%if we start with direct Aex frame,use Dex frame ahead to calc S in this case
                Stime(Aframes(k,1),8)=(mean(Stime(Aframes(k,1)+1,2))+mean(Stime(1:Aframes(k,1)+1,3)))/(mean(Stime(1:Aframes(k,1)+1,2))+mean(Stime(1:Aframes(k,1)+1,3))+Stime(Aframes(k,1),4));
                Stime(Aframes(k,1),5)=mean(Stime(Aframes(k,1),1));
                AveFRETE(k,1)=Stime(1:Aframes(k,1),7);
            end
            if k>1
                Stime(Aframes(k,1),8)=(mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,2))+mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,3)))/(mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,2))+mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,3))+Stime(Aframes(k,1),4));
                Stime(Aframes(k,1),5)=mean(Stime(Aframes(k-1,1)+1:Aframes(k,1),1));
                AveFRETE(k,1)=mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,3))/(mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,3))+mean(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,2)));
                if sum(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,7)< FretlowerThresh)>0 || sum(Stime(Aframes(k-1,1)+1:Aframes(k,1)-1,7)>FRETupperThresh)>0
                    Stime(Aframes(k,1),9)=1;
                end
            end
        end

        if Stime(1,4)~=0%if we start in direct Aex frame, set first time pt in Stime2=0
            Stime2(1,1)=0;
            Stime2(2:1+length(nonzeros(Stime(:,5))),1)=nonzeros(Stime(:,5));
        else
            Stime2=nonzeros(Stime(:,5));
        end
        
        %Fill in S column with S values and 2nd col with whether or not FRETE value is outside thresholds (1 or 0)
        S2=find(Stime(:,4));
        S=Stime(S2(:,1),8:9);
        SaveTraces{segn}.EvS(1:length(S),n)=S(:,1);
        SaveTraces{segn}.AveFRETE(1:length(AveFRETE))=AveFRETE;
        if i==1 && n==1
            EvS(1:length(S),1)=AveFRETE;
            EvS(1:length(S),2)=S(:,1);
        else
            ltemp=length(EvS);
            EvS(ltemp+1:ltemp+length(S),1)=AveFRETE;
            EvS(ltemp+1:ltemp+length(S),2)=S(:,1);
        end
        
        sumtest=sum(sumtest+length(AveFRETE));
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %below are SMC-edits for saving data
        %aat
        [rlength,clength]=size(Stime);
        SaveTraces{segn}.aat(1:length(aat),n)=aat;
        SaveTraces{segn}.curr_aa_bsub(1:length(curr_aa_bsub),n)=curr_aa_bsub;
        % S and aveE
        SaveTraces{segn}.S(1:length(S),n)=S(:,1);
        SaveTraces{segn}.AveFRETE(1:length(AveFRETE),n)=AveFRETE;
        SaveTraces{segn}.STimetrunc(1:length(Stime2),n)=Stime2;
        SaveTraces{segn}.FillFRET(1:rlength,n)=(Stime(:,7));
        %ddt
        SaveTraces{segn}.ddt(1:length(ddt),n)=ddt;
        SaveTraces{segn}.curr_dd_bsub(1:length(curr_dd_bsub),n)=curr_dd_bsub;
        SaveTraces{segn}.curr_da_bsub(1:length(curr_da_bsub),n)=curr_da_bsub;
        SaveTraces{segn}.FRETE(1:length(frete),n)=frete;
    %%    
        %OPTION 3- review traces ('s' to skip through review (key 115 on mac is 's')) and truncate data based on S and E thresholds
        if selectoption==3
            if truncatebleaching==1 %if you want to automatically truncate traces at bleaching events
                ii=1;
                %below while loop look find index ii where any of the S or FRETE thresholds are crossed
                while S(ii,1)<=UpperSthresh && S(ii,1)>=LowerSthresh && S(ii,2)==0 && AveFRETE(ii,1)<=FRETupperThresh && AveFRETE(ii,1)>=FretlowerThresh
                    if ii+1 > length(S)
                        break
                    end
                    ii=ii+1;
                end
                %Is the trace truncated due to bleaching? 1=no, 2=yes
                if ii==length(S)
                    SaveTraces{segn}.Bleach(1,n)=1;
                elseif ii<length(S)
                    SaveTraces{segn}.Bleach(1,n)=2;
                end
                if ii~=1 %to bring the index 1 step (1 period) back for truncation and fill in SaveTraces
                    ii=ii-1;
                    TruncTime=Stime2(ii,1);
                    %aat truncation
                    Truncaat=aat<TruncTime;
                    Taat=find(Truncaat,1,'last');
                    SaveTraces{segn}.aatimeTrunc(1:Taat,n)=aat(1:Taat);
                    SaveTraces{segn}.aaTrunc(1:Taat,n)=curr_aa_bsub(1:Taat);
                    %ddt truncation
                    Truncddt=ddt<TruncTime;
                    Tddt=find(Truncddt,1,'last');
                    SaveTraces{segn}.ddtimeTrunc(1:Tddt,n)=ddt(1:Tddt);
                    SaveTraces{segn}.ddTrunc(1:Tddt,n)=curr_dd_bsub(1:Tddt);
                    SaveTraces{segn}.daTrunc(1:Tddt,n)=curr_da_bsub(1:Tddt);
                    SaveTraces{segn}.FRETEtrunc(1:Tddt,n)=frete(1:Tddt);
                    %S and AveE truncation
                    SaveTraces{segn}.AveFRETEtrunc(1:Taat,n)=AveFRETE(1:Taat);
                    SaveTraces{segn}.Strunc(1:Taat,n)=S(1:Taat,1);
                    SaveTraces{segn}.STimetrunc(1:Taat)=Stime2(1:Taat);
                    SaveTraces{segn}.FillFRETTrunc(1:ddt(Tddt,1),n)=SaveTraces{segn}.FillFRET(1:ddt(Tddt,1),n);
                    %Thumb Image
                    SaveTraces{segn}.ddThumbTrunc{n}=segtraj{segn}.ddthumbs(:,:,1:Tddt,n);
                    SaveTraces{segn}.daThumbTrunc{n}=segtraj{segn}.dathumbs(:,:,1:Tddt,n);
                    SaveTraces{segn}.aaThumbTrunc{n}=segtraj{segn}.aathumbs(:,:,1:Taat,n);
                    %original raw data spit out by CircRovingFRET program--send Raw data to TG for his analysis pipeline 2017 09 19
                    DataSel{segn}.ddtraj(:,n)=st{segn}.ddtraj(:,n);
                    DataSel{segn}.datraj(:,n)=st{segn}.datraj(:,n);
                    DataSel{segn}.aatraj(:,n)=st{segn}.aatraj(:,n);
                    DataSel{segn}.ddback(:,n)=st{segn}.ddback(:,n);
                    DataSel{segn}.daback(:,n)=st{segn}.daback(:,n);
                    DataSel{segn}.aaback(:,n)=st{segn}.aaback(:,n);
                    DataSel{segn}.ddtraj_bpass(:,n)=st{segn}.ddtraj_bpass(:,n);
                    DataSel{segn}.datraj_bpass(:,n)=st{segn}.datraj_bpass(:,n);
                    DataSel{segn}.aatraj_bpass(:,n)=st{segn}.aatraj_bpass(:,n);
                    DataSel{segn}.ddback_bpass(:,n)=st{segn}.ddback_bpass(:,n);
                    DataSel{segn}.daback_bpass(:,n)=st{segn}.daback_bpass(:,n);
                    DataSel{segn}.aaback_bpass(:,n)=st{segn}.aaback_bpass(:,n);
                    DataSel{segn}.offx=st{segn}.offx;
                    DataSel{segn}.offy=st{segn}.offy;
                    DataSel{segn}.p(n,1:2)=st{segn}.p(n,1:2);
                    DataSel{segn}.ap(n,1:2)=st{segn}.ap(n,1:2);
                    DataSel{segn}.dd_xysig=st{segn}.dd_xysig;
                    DataSel{segn}.aa_xysig=st{segn}.aa_xysig;                    
                    DataSel{segn}.dd_fqual=st{segn}.dd_fqual;
                    DataSel{segn}.aa_fqual=st{segn}.aa_fqual;
                    DataSel{segn}.segfirst=st{segn}.segfirst;
                    DataSel{segn}.seglast=st{segn}.seglast;
                    DataSel{segn}.nsegframes=st{segn}.nsegframes;
                    DataSel{segn}.t=st{segn}.t;
                    DataSel{segn}.ph=st{segn}.ph;
     
                    %if the first index checked was not good data or if trace is too short
                elseif ii==1 || length(SaveTraces{segn}.ddtimeTrunc(1:Tddt,n))<=savesize
                    TruncTime=Stime2(ii,1);
                    %Thumb Image, otherwise the length of cell
                    %array could be off with below 3 lines
                    SaveTraces{segn}.ddThumbTrunc{n}=0;
                    SaveTraces{segn}.daThumbTrunc{n}=0;
                    SaveTraces{segn}.aaThumbTrunc{n}=0;
                    %aat truncation
                    Truncaat=aat<TruncTime;
                    Taat=find(Truncaat,1,'last');
                    SaveTraces{segn}.aatimeTrunc(1:Taat,n)=aat(1:Taat);
                    SaveTraces{segn}.aaTrunc(1:Taat,n)=curr_aa_bsub(1:Taat);
                    %ddt truncation
                    Truncddt=ddt<TruncTime;
                    Tddt=find(Truncddt,1,'last');
                    SaveTraces{segn}.ddtimeTrunc(1:Tddt,n)=ddt(1:Tddt);
                    SaveTraces{segn}.ddTrunc(1:Tddt,n)=curr_dd_bsub(1:Tddt);
                    SaveTraces{segn}.daTrunc(1:Tddt,n)=curr_da_bsub(1:Tddt);
                    SaveTraces{segn}.FRETEtrunc(1:Tddt,n)=frete(1:Tddt);
                    %S and AveE truncation
                    SaveTraces{segn}.AveFRETEtrunc(1:Taat,n)=AveFRETE(1:Taat);
                    SaveTraces{segn}.Strunc(1:Taat,n)=S(1:Taat,1);
                    SaveTraces{segn}.STimetrunc(1:Taat)=Stime2(1:Taat);
                    SaveTraces{segn}.FillFRETTrunc(1:ddt(Tddt,1),n)=SaveTraces{segn}.FillFRET(1:ddt(Tddt,1),n);
                    
                    %original raw data spit out by CircRovingFRET program--send Raw data to TG for his analysis pipeline 2017 09 19
                    DataSel{segn}.ddtraj(:,n)=st{segn}.ddtraj(:,n);
                    DataSel{segn}.datraj(:,n)=st{segn}.datraj(:,n);
                    DataSel{segn}.aatraj(:,n)=st{segn}.aatraj(:,n);
                    DataSel{segn}.ddback(:,n)=st{segn}.ddback(:,n);
                    DataSel{segn}.daback(:,n)=st{segn}.daback(:,n);
                    DataSel{segn}.aaback(:,n)=st{segn}.aaback(:,n);
                    DataSel{segn}.ddtraj_bpass(:,n)=st{segn}.ddtraj_bpass(:,n);
                    DataSel{segn}.datraj_bpass(:,n)=st{segn}.datraj_bpass(:,n);
                    DataSel{segn}.aatraj_bpass(:,n)=st{segn}.aatraj_bpass(:,n);
                    DataSel{segn}.ddback_bpass(:,n)=st{segn}.ddback_bpass(:,n);
                    DataSel{segn}.daback_bpass(:,n)=st{segn}.daback_bpass(:,n);
                    DataSel{segn}.aaback_bpass(:,n)=st{segn}.aaback_bpass(:,n);
                    DataSel{segn}.offx=st{segn}.offx;
                    DataSel{segn}.offy=st{segn}.offy;
                    DataSel{segn}.p(n,1:2)=st{segn}.p(n,1:2);
                    DataSel{segn}.ap(n,1:2)=st{segn}.ap(n,1:2);
                    DataSel{segn}.dd_xysig=st{segn}.dd_xysig;
                    DataSel{segn}.aa_xysig=st{segn}.aa_xysig;                    
                    DataSel{segn}.dd_fqual=st{segn}.dd_fqual;
                    DataSel{segn}.aa_fqual=st{segn}.aa_fqual;
                    DataSel{segn}.segfirst=st{segn}.segfirst;
                    DataSel{segn}.seglast=st{segn}.seglast;
                    DataSel{segn}.nsegframes=st{segn}.nsegframes;
                    DataSel{segn}.t=st{segn}.t;
                    DataSel{segn}.ph=st{segn}.ph;
                end
            end
        end
        if truncatebleaching==0 %if you want to keep entire trace and not truncate at bleaching events
            TruncTime=Stime2(end,1); %THIS LINE KEEPS THE ENTIRE TRACE UP TILL THE LAST PERIOD 2017 04 21
            %aat truncation
            Truncaat=aat<TruncTime;
            Taat=find(Truncaat,1,'last');
            SaveTraces{segn}.aatimeTrunc(1:Taat,n)=aat(1:Taat);
            SaveTraces{segn}.aaTrunc(1:Taat,n)=curr_aa_bsub(1:Taat);
            %ddt truncation
            Truncddt=ddt<TruncTime;
            Tddt=find(Truncddt,1,'last');
            SaveTraces{segn}.ddtimeTrunc(1:Tddt,n)=ddt(1:Tddt);
            SaveTraces{segn}.ddTrunc(1:Tddt,n)=curr_dd_bsub(1:Tddt);
            SaveTraces{segn}.daTrunc(1:Tddt,n)=curr_da_bsub(1:Tddt);
            SaveTraces{segn}.FRETEtrunc(1:Tddt,n)=frete(1:Tddt);
            %S and AveE truncation
            SaveTraces{segn}.AveFRETEtrunc(1:Taat,n)=AveFRETE(1:Taat);
            SaveTraces{segn}.Strunc(1:Taat,n)=S(1:Taat,1);
            SaveTraces{segn}.STimetrunc(1:Taat)=Stime2(1:Taat);
            SaveTraces{segn}.FillFRETTrunc(1:ddt(Tddt,1),n)=SaveTraces{segn}.FillFRET(1:ddt(Tddt,1),n);
            %Thumb Image
            SaveTraces{segn}.ddThumbTrunc{n}=segtraj{segn}.ddthumbs(:,:,1:Tddt,n);
            SaveTraces{segn}.daThumbTrunc{n}=segtraj{segn}.dathumbs(:,:,1:Tddt,n);
            SaveTraces{segn}.aaThumbTrunc{n}=segtraj{segn}.aathumbs(:,:,1:Taat,n);
            %original raw data spit out by CircRovingFRET program--send Raw data to TG for his analysis pipeline 2017 09 19
                    DataSel{segn}.ddtraj(:,n)=st{segn}.ddtraj(:,n);
                    DataSel{segn}.datraj(:,n)=st{segn}.datraj(:,n);
                    DataSel{segn}.aatraj(:,n)=st{segn}.aatraj(:,n);
                    DataSel{segn}.ddback(:,n)=st{segn}.ddback(:,n);
                    DataSel{segn}.daback(:,n)=st{segn}.daback(:,n);
                    DataSel{segn}.aaback(:,n)=st{segn}.aaback(:,n);
                    DataSel{segn}.ddtraj_bpass(:,n)=st{segn}.ddtraj_bpass(:,n);
                    DataSel{segn}.datraj_bpass(:,n)=st{segn}.datraj_bpass(:,n);
                    DataSel{segn}.aatraj_bpass(:,n)=st{segn}.aatraj_bpass(:,n);
                    DataSel{segn}.ddback_bpass(:,n)=st{segn}.ddback_bpass(:,n);
                    DataSel{segn}.daback_bpass(:,n)=st{segn}.daback_bpass(:,n);
                    DataSel{segn}.aaback_bpass(:,n)=st{segn}.aaback_bpass(:,n);
                    DataSel{segn}.offx(1,n)=st{segn}.offx(1,n);
                    DataSel{segn}.offy(1,n)=st{segn}.offy(1,n);
                    DataSel{segn}.p(n,1:2)=st{segn}.p(n,1:2);
                    DataSel{segn}.ap(n,1:2)=st{segn}.ap(n,1:2);
                    DataSel{segn}.dd_xysig(n,1:2)=st{segn}.dd_xysig(n,1:2);
                    DataSel{segn}.aa_xysig(n,1:2)=st{segn}.aa_xysig(n,1:2);                    
                    DataSel{segn}.dd_fqual(n,1)=st{segn}.dd_fqual(n,1);
                    DataSel{segn}.aa_fqual(n,1)=st{segn}.aa_fqual(n,1);
                    DataSel{segn}.segfirst=st{segn}.segfirst;
                    DataSel{segn}.seglast=st{segn}.seglast;
                    DataSel{segn}.nsegframes=st{segn}.nsegframes;
                    DataSel{segn}.t=st{segn}.t;
                    DataSel{segn}.ph=st{segn}.ph;
        end
        %option for skipping through figures and let analysis proceed
        if key==115%if we hit 's' to skip through
            n=n+1;
        end
        %         if n+1>npks
        %             break
        %         end
        if key~=115 %hit the 's' key
            
            %Make figure for review
            LineDDT(1:2,1)=TruncTime;
            LineDDT(1,2)=0;
            LineDDT(2,2)=ddscalemax;
            ax1 = subplot(3,2,1);
            hold off;
            plot(ddt,curr_dd_bsub,'-','Color',[0 0.75 0],'LineWidth',1);
            hold on;
            plot(ddt,curr_da_bsub,'r-','LineWidth',1);
            axis([0 inf 0 max(ddscalemax,dascalemax)]);
            hold on
            plot(LineDDT(1:2,1),LineDDT(1:2,2),'color','r','LineWidth',4)
            title([num2str(n) ' of ' num2str(size(ddtraj,2)) ' : ' num2str(annotations(n))],'Color',colors(annotations(n),:))
            wsize = 5;
            
            ax2 = subplot(3,2,2);
            imshow(cat(3,currdathumb,currddthumb,0*currddthumb));
            
            LineAAT(1:2,1)=TruncTime;
            %TruncTime; for testing indexing
            LineAAT(1,2)=0;
            LineAAT(2,2)=aascalemax;
            ax3 = subplot(3,2,3);
            hold off;
            plot(aat,curr_aa_bsub,'r-','LineWidth',1);
            %     axis([0 max(ddt) aascalemin aascalemax]);
            line([0 max(ddt)],[0 0]);
            axis([0 max(ddt) aascalemin aascalemax]);
            hold on
            plot(LineAAT(1:2,1),LineAAT(1:2,2),'color','r','LineWidth',4);
            
            ax4 = subplot(3,2,4);
            imshow(cat(3,curraathumb,0*currddthumb,0*currddthumb));
            
            LineFRETS(1:2,1)=TruncTime;
            LineFRETS(1,2)=0;
            LineFRETS(2,2)=1;
            ax5 = subplot(3,2,5);
            hold off;
            plot(ddt,frete,'b-','LineWidth',1);
            hold on
            plot(Stime2,S(:,1),'r-','LineWidth',1)
            axis([0 max(ddt) 0 1]);
            hold on
            plot(LineFRETS(1:2,1),LineFRETS(1:2,2),'color','r','LineWidth',4);
            
            ax6=subplot(3,2,6);
            hold off
            plot(AveFRETE,S(:,1),'ro')
            axis([0 1 0 1]);
            
            set(ax1,'Position',[0.0500    0.7393    0.4790    0.2134]);
            set(ax3,'Position',[0.0500    0.4396    0.4790    0.2134]);
            set(ax5,'Position',[0.0500    0.1300    0.4790    0.2134]);
            set(ax2,'Position',[0.65    0.7393    0.3347    0.2157]);
            set(ax4,'Position',[0.65    0.4396    0.3347    0.2157]);
            set(ax6,'Position',[0.6    0.05   0.35     0.35]);
            
            if n+1>npks
                n=npks;
            end
            if n<1
                n=1;
            end
            [x,y,key] = ginput(1);
            switch key
                case 29
                    n=n+1;
                case 28
                    n=n-1;
                    
                case 112 % p - play movies
                    for j=1:2:size(ddtraj,1)
                        currframedd = mean(segtraj{segn}.ddthumbs(:,:,j:min(j,size(ddtraj,1)),n),3);
                        currframeda = mean(segtraj{segn}.dathumbs(:,:,j:min(j,size(ddtraj,1)),n),3);
                        currframeaa = mean(segtraj{segn}.aathumbs(:,:,min(ceil(j/2),size(aatraj,1)),n),3);
                        currframedd = scaleim(currframedd,ddthumbmin,ddthumbmax);
                        currframeda = scaleim(currframeda,dathumbmin,dathumbmax);
                        currframeaa = scaleim(currframeaa,aathumbmin,aathumbmax);
                        axes(ax2);
                        imshow(cat(3,currframeda,currframedd,0*currddthumb));
                        axes(ax4);
                        imshow(cat(3,currframeaa,0*currframedd,0*currddthumb));
                        pause(0.001)
                    end
                    
                case 115 %'s' key for skip
                    
            end
        end
    end
end
toc
%% SAVE DATA AND FIGS: Let's get the folder where we want to save data/figs
savedir = uigetdir;
cd(savedir)
savefolder=mkdir(savedir,savename);
cd(savename)


%% Section to look at overall bleaching rates/photostability--2018 01 08
for i=1:numsegs
        %for direct Acceptor excitation
        SumAaIntens=sum(SaveTraces{i}.curr_aa_bsub,2);
        NormSumAaIntens=SumAaIntens/max(SumAaIntens);
        figure(1)
        plot(SaveTraces{i}.aat(1:nnz(NormSumAaIntens),1)*(ExposureTime+TimeDelay),NormSumAaIntens(1:nnz(NormSumAaIntens),1),'r')
        hold on
        %for excitation of Donor
        SumDdIntens=sum(SaveTraces{i}.curr_dd_bsub,2);
        NormSumDdIntens=SumDdIntens/max(SumDdIntens);
        plot(SaveTraces{i}.ddt(1:nnz(NormSumDdIntens),1)*(ExposureTime+TimeDelay),NormSumDdIntens(1:nnz(NormSumDdIntens),1),'g')      
        
        
        xlabel('Time (seconds)') % x-axis label
        ylabel('Normalized Total Fluorescence Intensity') % y-axis label
        title1=strcat('Signal Decay Analysis_',num2str(i));
        title(title1)
        savefig(title1)
        saveas(gcf,title1,'png')

end

 %% SAVE DATA AND FIGS: Let's get the folder where we want to save data/figs
% savedir = uigetdir;
% cd(savedir)
% savefolder=mkdir(savedir,savename);
% cd(savename)

%MAKE FIGURES FOR OVERALL RAW DATA (not truncated)
figure(2)
edges = [-0.2:0.05:1.2];
h1=histogram(frethist,edges);
xlabel('FRET E') % x-axis label
ylabel('Count') % y-axis label
title1=strcat('All FRET Hist___  ',savename,'.fig');
title(title1)
savefig(title1)
saveas(gcf,title1,'png')
%saveas(gcf,title1,'tiff')
%saveas(gcf,title1,'eps')
%
figure(3)
plot(EvS(:,1),EvS(:,2),'o')
axis([0 1 0 1])
xlabel('FRET E') % x-axis label
ylabel('S') % y-axis label
title2=strcat('All E vs S___',savename,'.fig');
title(title2)
savefig(title2)
%saveas(gcf,title2,'png')
% %saveas(gcf,title2,'tiff')
% %saveas(gcf,title2,'eps')
%
% % Below Figure is taking long to generate
figure(4)
edges2(1)={-0.2:0.025:1.2};
edges2(2)={-0.2:0.025:1.2};
hist3(EvS,'Edges',edges2);
set(get(gca,'child'),'FaceColor','interp','CDataMode','auto');
xlabel('FRET E') % x-axis label
ylabel('S') % y-axis label
title3=strcat('All E vs S (Heat)___',savename,'.fig');
title(title3)
savefig(title3)
% saveas(gcf,title3,'png')
% % saveas(gcf,title3,'tiff')
% % saveas(gcf,title3,'eps')

% can we use hist3 to get intensities and then use imagesc to visualize heatmap?????

toc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Now let's go through the truncated/selected data, make figures and sort data
testtotalsize=0;
FRETtraceAve=[];
count2=1;
if selectoption==1 || selectoption==3 %only if we saved truncated datasets
    FRETrs=[];
    Strunc=[];
    FRETavetrunc=[];
    for i=1:numsegs
        SaveTraces{i}.FRETEtraceAve=[];
        %Push zero columns out of SaveTraces variables
        [sz1,sz2]=size(SaveTraces{i}.ddTrunc);
        for jj=sz2:-1:1
            if nnz(SaveTraces{i}.ddTrunc(:,jj))<=savesize
                SaveTraces{i}.FRETEtrunc(:,jj)=[];
                SaveTraces{i}.Strunc(:,jj)=[];
                SaveTraces{i}.AveFRETEtrunc(:,jj)=[];
                SaveTraces{i}.aatimeTrunc(:,jj)=[];
                SaveTraces{i}.aaTrunc(:,jj)=[];
                SaveTraces{i}.ddtimeTrunc(:,jj)=[];
                SaveTraces{i}.ddTrunc(:,jj)=[];
                SaveTraces{i}.daTrunc(:,jj)=[];
                SaveTraces{i}.FillFRETTrunc(:,jj)=[];
                SaveTraces{i}.Bleach(:,jj)=[];
            %Thumb Image
                SaveTraces{i}.ddThumbTrunc(jj) = [];
                SaveTraces{i}.daThumbTrunc(jj) = [];
                SaveTraces{i}.aaThumbTrunc(jj) = [];
                    %original raw data spit out by CircRovingFRET program--send Raw data to TG for his analysis pipeline 2017 09 19
                    DataSel{i}.ddtraj(:,jj)=[];
                    DataSel{i}.datraj(:,jj)=[];
                    DataSel{i}.aatraj(:,jj)=[];
                    DataSel{i}.ddback(:,jj)=[];
                    DataSel{i}.daback(:,jj)=[];
                    DataSel{i}.aaback(:,jj)=[];
                    DataSel{i}.ddtraj_bpass(:,jj)=[];
                    DataSel{i}.datraj_bpass(:,jj)=[];
                    DataSel{i}.aatraj_bpass(:,jj)=[];
                    DataSel{i}.ddback_bpass(:,jj)=[];
                    DataSel{i}.daback_bpass(:,jj)=[];
                    DataSel{i}.aaback_bpass(:,jj)=[];
                    %DataSel{i}.offx(jj)=[];
                    %DataSel{i}.offy(jj)=[];
                    DataSel{i}.p(jj,:)=[];
                    DataSel{i}.ap(jj,:)=[];
                    %DataSel{i}.dd_xysig(jj)=[];
                    %DataSel{i}.aa_xysig(jj)=[];                    
                    %DataSel{i}.dd_fqual(jj)=[];
                    %DataSel{i}.aa_fqual(jj)=[];
                    %DataSel{i}.segfirst=[];
                    %DataSel{i}.seglast=[];
                    %DataSel{i}.nsegframes=[];
                    %DataSel{i}.t=[];
                    %DataSel{i}.ph=[];
            end
        end
        
         
        %all fretetrunc data pts. for Hist
        [mm,nn]=size(SaveTraces{i}.FRETEtrunc);
        [kk,ll]=size(SaveTraces{i}.AveFRETEtrunc);
        if i==1 && ll>0 && nn>0
            FRETrs(1:mm*nn,1)=reshape(SaveTraces{i}.FRETEtrunc,(mm*nn),1);
            Strunc(1:kk*ll,1)=reshape(SaveTraces{i}.Strunc,(kk*ll),1);
            FRETavetrunc(1:kk*ll,1)=reshape(SaveTraces{i}.AveFRETEtrunc,(kk*ll),1);
        elseif ll>0 && nn>0 %only if there were traces that were truncated/saved
            tempFRETrs(1:mm*nn,i)=reshape(SaveTraces{i}.FRETEtrunc,(mm*nn),1);
            FRETrs(length(FRETrs)+1:(length(FRETrs)+(mm*nn)),1)=tempFRETrs(mm*nn,i);
            
            tempStrunc(1:kk*ll,i)=reshape(SaveTraces{i}.Strunc,(kk*ll),1);
            Strunc(length(Strunc)+1:(length(Strunc)+(kk*ll)),1)=tempStrunc(kk*ll,i);
            
            tempFRETEavetrunc(1:kk*ll,i)=reshape(SaveTraces{i}.AveFRETEtrunc,(kk*ll),1);
            FRETavetrunc(length(FRETavetrunc)+1:(length(FRETavetrunc)+(kk*ll)),1)=tempFRETEavetrunc(kk*ll,i);
        end
        
        n=1;
        while n<=ll
            tempvbFRET=[];
            SaveTraces{i}.FRETEtraceAve{i}(1,n)=mean(SaveTraces{i}.FRETEtrunc(:,n));
            FRETtraceAve(1,count2)=mean(SaveTraces{i}.FRETEtrunc(:,n));
            %for FillFRET
            [lA,~]=size(SaveTraces{i}.FillFRETTrunc);
            [zeroA,~] = find(SaveTraces{i}.FillFRETTrunc(:,n),1,'last');
            tempvbFRET(1:lA,11)=SaveTraces{i}.FillFRETTrunc(1:lA,n);
            tempvbFRET(1,12)=SaveTraces{i}.Bleach(1,n);
            %for vbFRET
            %ax1
            [l1,~]=size(SaveTraces{i}.ddTrunc);
            [zero1,~] = find(SaveTraces{i}.ddTrunc(:,n),1,'last');
            tempvbFRET(1:l1,1)=SaveTraces{i}.ddTrunc(1:l1,n); %DexDem
            tempvbFRET(1:l1,2)=SaveTraces{i}.daTrunc(1:l1,n); % DexAem
            tempvbFRET(1:l1,4)=SaveTraces{i}.ddtimeTrunc(1:l1,n); %time
            %ax2
            %ax3
            [l2,~]=size(SaveTraces{i}.aaTrunc);
            [zero3,~] = find(SaveTraces{i}.aatimeTrunc(1:l2,n),1,'last');
            tempvbFRET(1:l2,5)=SaveTraces{i}.aatimeTrunc(1:l2,n); %time
            tempvbFRET(1:l2,6)=SaveTraces{i}.aaTrunc(1:l2,n); %AexAem
            %ax 4
            %ax5
            tempvbFRET(1:l1,3)=SaveTraces{i}.FRETEtrunc(1:l1,n);
            [l3,~]=size(SaveTraces{i}.Strunc);
            [zero5,~] = find(SaveTraces{i}.Strunc(1:l3,n),1,'last');
            tempvbFRET(1:l3,8)=SaveTraces{i}.Strunc(1:l3,n); %Stoich
            tempvbFRET(1:l3,7)=SaveTraces{i}.STimetrunc(1:l3,1); %Time
            %ax6
            [l4,ln]=size(SaveTraces{i}.AveFRETEtrunc);
            [zero6,zeroX] = find(SaveTraces{i}.AveFRETEtrunc(1:l4,n),1,'last');
            tempvbFRET(1:l4,9)=SaveTraces{i}.AveFRETEtrunc(1:l4,n);
            tempvbFRET(1:l4,10)=SaveTraces{i}.Strunc(1:l4,n);


            if zero1>=savesize
                vbLabel=[savename '_seg_' num2str(i) '_mol_'  num2str(n)];
                %FillFRET
                forvbFRET.FillFRET{count2}=tempvbFRET(1:zeroA,11);
                forvbFRET.Bleach{count2}= tempvbFRET(1,12);
                %Ax5
                forvbFRET.FRETdd{count2}=tempvbFRET(1:zero1,3);
                forvbFRET.AllTruncTraceLabels{count2}=vbLabel;
                forvbFRET.meanFRET{count2}=mean(forvbFRET.FRETdd{count2});
                %Ax1
                forvbFRET.FRETtrunctraces{count2}=tempvbFRET(1:zero1,1:2);
                forvbFRET.timeDex{count2}=tempvbFRET(1:zero1,4);
                %Ax2
                %Thumb Image Dex
                forvbFRET.ddThumb{count2}=SaveTraces{i}.ddThumbTrunc{n};
                forvbFRET.daThumb{count2}=SaveTraces{i}.daThumbTrunc{n};
                %Ax3
                forvbFRET.AexAem{count2}=tempvbFRET(1:zero3,5:6);
                %Ax4
                % for thumbs Aex
                forvbFRET.aaThumb{count2}=SaveTraces{i}.aaThumbTrunc{n};
                %Ax5
                forvbFRET.Strace{count2}=tempvbFRET(1:zero5,7:8);
                %Ax6
                forvbFRET.AveFRETs{count2}=tempvbFRET(1:zero6,9);
                forvbFRET.Sscat{count2}=tempvbFRET(1:zero6,10);

                %n=n+1;
                
                
                %original raw data spit out by CircRovingFRET program--send
                %Raw data to TG for his analysis pipeline 2017 09 20
                    DataSel2{1}.ddtraj(1:length(DataSel{i}.ddtraj(:,n)),count2)=DataSel{i}.ddtraj(:,n);
                    DataSel2{1}.datraj(1:length(DataSel{i}.datraj(:,n)),count2)=DataSel{i}.datraj(:,n);
                    DataSel2{1}.aatraj(1:length(DataSel{i}.aatraj(:,n)),count2)=DataSel{i}.aatraj(:,n);
                    DataSel2{1}.ddback(1:length(DataSel{i}.ddback(:,n)),count2)=DataSel{i}.ddback(:,n);
                    DataSel2{1}.daback(1:length(DataSel{i}.daback(:,n)),count2)=DataSel{i}.daback(:,n);
                    DataSel2{1}.aaback(1:length(DataSel{i}.aaback(:,n)),count2)=DataSel{i}.aaback(:,n);
                    DataSel2{1}.ddtraj_bpass(1:length(DataSel{i}.ddtraj_bpass(:,n)),count2)=DataSel{i}.ddtraj_bpass(:,n);
                    DataSel2{1}.datraj_bpass(1:length(DataSel{i}.datraj_bpass(:,n)),count2)=DataSel{i}.datraj_bpass(:,n);
                    DataSel2{1}.aatraj_bpass(1:length(DataSel{i}.aatraj_bpass(:,n)),count2)=DataSel{i}.aatraj_bpass(:,n);
                    DataSel2{1}.ddback_bpass(1:length(DataSel{i}.ddback_bpass(:,n)),count2)=DataSel{i}.ddback_bpass(:,n);
                    DataSel2{1}.daback_bpass(1:length(DataSel{i}.daback_bpass(:,n)),count2)=DataSel{i}.daback_bpass(:,n);
                    DataSel2{1}.aaback_bpass(1:length(DataSel{i}.aaback_bpass(:,n)),count2)=DataSel{i}.aaback_bpass(:,n);
                    DataSel2{1}.offx(count2,1:length(DataSel{i}.offx(1:length(DataSel{i}.offx(1,:)))))=DataSel{i}.offx(1:length(DataSel{i}.offx(1,:)));
                    DataSel2{1}.offy(count2,1:length(DataSel{i}.offy(1:length(DataSel{i}.offx(1,:)))))=DataSel{i}.offy(1:length(DataSel{i}.offx(1,:)));
                    DataSel2{1}.p(count2,1:length(DataSel{i}.p(n,:)))=DataSel{i}.p(n,:);
                    DataSel2{1}.ap(count2,1:length(DataSel{i}.ap(n,:)))=DataSel{i}.ap(n,:);
                    DataSel2{1}.dd_xysig(1:length(DataSel{i}.dd_xysig(:,1:2)),(count2*2)-1:(count2*2))=DataSel{i}.dd_xysig(:,1:2);
                    DataSel2{1}.aa_xysig(1:length(DataSel{i}.aa_xysig(:,1:2)),(count2*2)-1:(count2*2))=DataSel{i}.aa_xysig(:,1:2);
                    DataSel2{1}.dd_fqual(1:length(DataSel{i}.dd_fqual(:,1)),count2)=DataSel{i}.dd_fqual(:,1);
                    DataSel2{1}.aa_fqual(1:length(DataSel{i}.aa_fqual(:,1)),count2)=DataSel{i}.aa_fqual(:,1);
                    DataSel2{1}.segfirst(count2)=DataSel{i}.segfirst;
                    DataSel2{1}.seglast(count2)=DataSel{i}.seglast;
                    DataSel2{1}.nsegframes(count2)=DataSel{i}.nsegframes;
                    DataSel2{1}.t(count2,1:length(DataSel{i}.t))=DataSel{i}.t;
                    DataSel2{1}.ph(1,count2)=DataSel{i}.ph;
                    n=n+1;
                    count2=count2+1;
            elseif zero1<savesize
                n=n+1;
            end
        end
    end
    %Remove what were trailing zeros from the concatenated columns
    FRETrs=FRETrs(FRETrs~=0);
    FRETavetrunc=FRETavetrunc(FRETavetrunc~=0);
    Strunc=Strunc(Strunc~=0);
end

toc

%% Calculate Fraction Joined/Synaptic Complex competent and make figs for Truncated/Selected data

FRETfract=FRETtraceAve>NHEJthresh;
FRETfract=sum(FRETfract)/length(FRETfract);
SaveTraces{1}.FRETfract=FRETfract;

% %Hist for TruncFRETE data
% figure(5)
% edges = [-0.2:0.05:1.2];
% h1=histogram(FRETrs,edges);
% xlabel('FRET E') % x-axis label
% ylabel('Count') % y-axis label
% title4=strcat('Trunc FRET Hist___',savename,'.fig');
% title(title4)
% savefig(title4)
% saveas(gcf,title4,'png')
% % %saveas(gcf,title4,'tiff')
% % %saveas(gcf,title4,'eps')

% % EvS plot
figure(6)
plot(FRETavetrunc,Strunc,'o')
axis([0 1 0 1])
xlabel('FRET E') % x-axis label
ylabel('S') % y-axis label
title5=strcat('Trunc E vs S___',savename,'.fig');
title(title5)
savefig(title5)
saveas(gcf,title5,'png')
% %aveas(gcf,title5,'tiff')
% %saveas(gcf,title5,'eps')



toc

%% Sort forvbFRET cell array so that high-FRET traces and thumbs come up first in
%  subsequent analysis, using mean FRET of entire trunc trace to sort
%also sort SelData2--so we keep original raw data with corresponding
%processed data(forvbFRET)
for i2=1:length(forvbFRET.FRETtrunctraces)
    if i2>1
        while forvbFRET.meanFRET{i2} > forvbFRET.meanFRET{i2-1}
            tempforvbFRETdata=forvbFRET.FRETtrunctraces{i2};
            tempforvbFRETlabels=forvbFRET.AllTruncTraceLabels{i2};
            tempforvbFRETmean=forvbFRET.meanFRET{i2};
            tempforvbFRETdd=forvbFRET.FRETdd{i2};
            tempforvbFRETDex=forvbFRET.timeDex{i2};
            tempforvbFRETAexAem=forvbFRET.AexAem{i2};
            tempforvbFRETS=forvbFRET.Strace{i2};
            tempforvbFRETAveFRETs=forvbFRET.AveFRETs{i2};
            tempforvbFRETSscat=forvbFRET.Sscat{i2};
            tempforvbFRETFillFRET=forvbFRET.FillFRET{i2};
            tempforvbFRETBleach=forvbFRET.Bleach{i2};
            tempforvbFRETddthumb=forvbFRET.ddThumb{i2};
            tempforvbFRETdathumb=forvbFRET.daThumb{i2};
            tempforvbFRETaathumb=forvbFRET.aaThumb{i2};
                %raw data sorting for saving
                    tempddtraj=DataSel2{1}.ddtraj(:,i2);
                    tempdatraj=DataSel2{1}.datraj(:,i2);
                    tempaatraj=DataSel2{1}.aatraj(:,i2);
                    tempddback=DataSel2{1}.ddback(:,i2);
                    tempdaback=DataSel2{1}.daback(:,i2);
                    tempaaback=DataSel2{1}.aaback(:,i2);
                    tempddtraj_bpass=DataSel2{1}.ddtraj_bpass(:,i2);
                    tempdatraj_bpass=DataSel2{1}.datraj_bpass(:,i2);
                    tempaatraj_bpass=DataSel2{1}.aatraj_bpass(:,i2);
                    tempddback_bpass=DataSel2{1}.ddback_bpass(:,i2);
                    tempdaback_bpass=DataSel2{1}.daback_bpass(:,i2);
                    tempaaback_bpass=DataSel2{1}.aaback_bpass(:,i2);
                    tempoffx=DataSel2{1}.offx(i2,:);
                    tempoffy=DataSel2{1}.offy(i2,:);
                    tempp=DataSel2{1}.p(i2,:);
                    tempap=DataSel2{1}.ap(i2,:);
                    tempdd_xysig=DataSel2{1}.dd_xysig(i2);
                    tempaa_xysig=DataSel2{1}.aa_xysig(i2);                  
                    tempdd_fqual=DataSel2{1}.dd_fqual(:,i2);
                    tempaa_fqual=DataSel2{1}.aa_fqual(:,i2);
                    tempsegfirst=DataSel2{1}.segfirst(i2);
                    tempseglast=DataSel2{1}.seglast(i2);
                    tempnsegframes=DataSel2{1}.nsegframes(i2);
                    tempt=DataSel2{1}.t(i2,:);
                    tempph=DataSel2{1}.ph(1,i2);
            
            
            forvbFRET.FRETtrunctraces{i2}=forvbFRET.FRETtrunctraces{i2-1};
            forvbFRET.AllTruncTraceLabels{i2}=forvbFRET.AllTruncTraceLabels{i2-1};
            forvbFRET.meanFRET{i2}=forvbFRET.meanFRET{i2-1};
            forvbFRET.FRETdd{i2}=forvbFRET.FRETdd{i2-1};
            forvbFRET.timeDex{i2}=forvbFRET.timeDex{i2-1};
            forvbFRET.AexAem{i2}=forvbFRET.AexAem{i2-1};
            forvbFRET.Strace{i2}=forvbFRET.Strace{i2-1};
            forvbFRET.AveFRETs{i2}=forvbFRET.AveFRETs{i2-1};
            forvbFRET.Sscat{i2}=forvbFRET.Sscat{i2-1};
            forvbFRET.FillFRET{i2}=forvbFRET.FillFRET{i2-1};
            forvbFRET.ddThumb{i2}=forvbFRET.ddThumb{i2-1};
            forvbFRET.daThumb{i2}=forvbFRET.daThumb{i2-1};
            forvbFRET.aaThumb{i2}=forvbFRET.aaThumb{i2-1};
            forvbFRET.Bleach{i2}=forvbFRET.Bleach{i2-1};
                    %raw data sorting for saving
                    DataSel2{1}.ddtraj(:,i2)=DataSel2{1}.ddtraj(:,i2-1);
                    DataSel2{1}.datraj(:,i2)=DataSel2{1}.datraj(:,i2-1);
                    DataSel2{1}.aatraj(:,i2)=DataSel2{1}.aatraj(:,i2-1);
                    DataSel2{1}.ddback(:,i2)=DataSel2{1}.ddback(:,i2-1);
                    DataSel2{1}.daback(:,i2)=DataSel2{1}.daback(:,i2-1);
                    DataSel2{1}.aaback(:,i2)=DataSel2{1}.aaback(:,i2-1);
                    DataSel2{1}.ddtraj_bpass(:,i2)=DataSel2{1}.ddtraj_bpass(:,i2-1);
                    DataSel2{1}.datraj_bpass(:,i2)=DataSel2{1}.datraj_bpass(:,i2-1);
                    DataSel2{1}.aatraj_bpass(:,i2)=DataSel2{1}.aatraj_bpass(:,i2-1);
                    DataSel2{1}.ddback_bpass(:,i2)=DataSel2{1}.ddback_bpass(:,i2-1);
                    DataSel2{1}.daback_bpass(:,i2)=DataSel2{1}.daback_bpass(:,i2-1);
                    DataSel2{1}.aaback_bpass(:,i2)=DataSel2{1}.aaback_bpass(:,i2-1);
                    DataSel2{1}.offx(i2,:)=DataSel2{1}.offx(i2-1,:);
                    DataSel2{1}.offy(i2,:)=DataSel2{1}.offy(i2-1,:);
                    DataSel2{1}.p(i2,:)=DataSel2{1}.p(i2-1,:);
                    DataSel2{1}.ap(i2,:)=DataSel2{1}.ap(i2-1,:);
                    DataSel2{1}.dd_xysig(i2)=DataSel2{1}.dd_xysig(i2-1);
                    DataSel2{1}.aa_xysig(i2)=DataSel2{1}.aa_xysig(i2-1);                  
                    DataSel2{1}.dd_fqual(:,i2)=DataSel2{1}.dd_fqual(:,i2-1);
                    DataSel2{1}.aa_fqual(:,i2)=DataSel2{1}.aa_fqual(:,i2-1);
                    DataSel2{1}.segfirst(i2)=DataSel2{1}.segfirst(i2-1);
                    DataSel2{1}.seglast(i2)=DataSel2{1}.seglast(i2-1);
                    DataSel2{1}.nsegframes(i2)=DataSel2{1}.nsegframes(i2-1);
                    DataSel2{1}.t(i2,:)=DataSel2{1}.t(i2-1,:);
                    DataSel2{1}.ph(1,i2)=DataSel2{1}.ph(1,i2-1);        
            
            
            forvbFRET.FRETtrunctraces{i2-1}=tempforvbFRETdata;
            forvbFRET.AllTruncTraceLabels{i2-1}=tempforvbFRETlabels;
            forvbFRET.meanFRET{i2-1}=tempforvbFRETmean;
            forvbFRET.FRETdd{i2-1}=tempforvbFRETdd;
            forvbFRET.timeDex{i2-1}=tempforvbFRETDex;
            forvbFRET.AexAem{i2-1}=tempforvbFRETAexAem;
            forvbFRET.Strace{i2-1}=tempforvbFRETS;
            forvbFRET.AveFRETs{i2-1}=tempforvbFRETAveFRETs;
            forvbFRET.Sscat{i2-1}=tempforvbFRETSscat;
            forvbFRET.FillFRET{i2-1}=tempforvbFRETFillFRET;
            forvbFRET.ddThumb{i2-1}=tempforvbFRETddthumb;
            forvbFRET.daThumb{i2-1}=tempforvbFRETdathumb;
            forvbFRET.aaThumb{i2-1}=tempforvbFRETaathumb;
            forvbFRET.Bleach{i2-1}=tempforvbFRETBleach;
                                %raw data sorting for saving
                    DataSel2{1}.ddtraj(:,i2-1)=tempddtraj;
                    DataSel2{1}.datraj(:,i2-1)=tempdatraj;
                    DataSel2{1}.aatraj(:,i2-1)=tempaatraj;
                    DataSel2{1}.ddback(:,i2-1)=tempddback;
                    DataSel2{1}.daback(:,i2-1)=tempdaback;
                    DataSel2{1}.aaback(:,i2-1)=tempaaback;
                    DataSel2{1}.ddtraj_bpass(:,i2-1)=tempddtraj_bpass;
                    DataSel2{1}.datraj_bpass(:,i2-1)=tempdatraj_bpass;
                    DataSel2{1}.aatraj_bpass(:,i2-1)=tempaatraj_bpass;
                    DataSel2{1}.ddback_bpass(:,i2-1)=tempddback_bpass;
                    DataSel2{1}.daback_bpass(:,i2-1)=tempdaback_bpass;
                    DataSel2{1}.aaback_bpass(:,i2-1)=tempaaback_bpass;
                    DataSel2{1}.offx(i2-1,:)=tempoffx;
                    DataSel2{1}.offy(i2-1,:)=tempoffy;
                    DataSel2{1}.p(i2-1,:)=tempp;
                    DataSel2{1}.ap(i2-1,:)=tempap;
                    DataSel2{1}.dd_xysig(i2-1)=tempdd_xysig;
                    DataSel2{1}.aa_xysig(i2-1)=tempaa_xysig;                  
                    DataSel2{1}.dd_fqual(:,i2-1)=tempdd_fqual;
                    DataSel2{1}.aa_fqual(:,i2-1)=tempaa_fqual;
                    DataSel2{1}.segfirst(i2-1)=tempsegfirst;
                    DataSel2{1}.seglast(i2-1)=tempseglast;
                    DataSel2{1}.nsegframes(i2-1)=tempnsegframes;
                    DataSel2{1}.t(i2-1,:)=tempt;
                    DataSel2{1}.ph(1,i2-1)=tempph;  
            
            i2=i2-1;
            if i2==1
                break
            end
        end
    end
end


%% %SELECT TRACES FOR DWELL TIME ANALYSIS
%loop to generate min and max values for thumbnails, couldn't figure out
%another way
ddmin=[];
ddmax=[];
damin=[];
damax=[];
aamin=[];
aamax=[];
for n=1:length(forvbFRET.timeDex)
    ddmin(n,1) = mean(forvbFRET.ddThumb{n}(1,1,1));
    ddmax(n,1) = quantile(forvbFRET.ddThumb{n}(5,5,1),0.8);
    damin(n,1) = mean(forvbFRET.daThumb{n}(1,1,1,:));
    damax(n,1) = quantile(forvbFRET.daThumb{n}(5,5,1,:),0.8);
    aamin(n,1) = mean(forvbFRET.aaThumb{n}(1,1,1,:));
    aamax(n,1) = quantile(forvbFRET.aaThumb{n}(5,5,1,:),0.8);
end
ddthumbmin = mean(ddmin);
ddthumbmax = quantile(ddmax,0.8);
dathumbmin = mean(damin);
dathumbmax = quantile(damax,0.8);
aathumbmin = mean(aamin);
aathumbmax = quantile(aamax,0.8);


savecount=1;
count2low=1;
count2high=1;
allhist=zeros(1,1);
n=1;
h7=figure
TGdwellHigh=[];%for dwell time analysis
TGdwellLow=[];%for dwell time analysis
TGdwellHighA=0;%for traces we select as having high FRET using 'a'
TGdwellHighB=0;%for all traces
countc=1;
State1m=[];
State3m=[];
TransTimeHist=[];

%loop through all good data/traces selected or truncated for selection/analysis
while n<=length(forvbFRET.FRETtrunctraces)
    if max(max(forvbFRET.AexAem{n}(:,2)))<=0
        n=n+1;
    end
    %update thumbnail image
    currddthumb = scaleim(mean(forvbFRET.ddThumb{n}(:,:,:),3),ddthumbmin,ddthumbmax);
    currdathumb = scaleim(mean(forvbFRET.ddThumb{n}(:,:,:),3),dathumbmin,dathumbmax);
    curraathumb = scaleim(mean(forvbFRET.ddThumb{n}(:,:,:),3),aathumbmin,aathumbmax);
    %Make figure for review/selection
    ax1 = subplot(3,2,1);
    hold off;
    plot(forvbFRET.timeDex{n}(:,1),forvbFRET.FRETtrunctraces{n}(:,1),'-','Color',[0 0.75 0],'LineWidth',1);
    hold on;
    plot(forvbFRET.timeDex{n}(:,1),forvbFRET.FRETtrunctraces{n}(:,2),'r-','LineWidth',1);
    axis([0 inf min(min(forvbFRET.FRETtrunctraces{n})) max(max(forvbFRET.FRETtrunctraces{n}))]);
    title([num2str(n) ' of ' num2str(length(forvbFRET.AllTruncTraceLabels))])
    wsize = 5;
    ylabel({'Dex Dem Aem',''},'FontWeight','bold');
    
    ax2 = subplot(3,2,2);
    imshow(cat(3,currdathumb,currddthumb,0*currddthumb));
    
    ax3 = subplot(3,2,3);
    hold off;
    plot(forvbFRET.AexAem{n}(:,1),forvbFRET.AexAem{n}(:,2),'r-','LineWidth',1);
    ylabel('AexAem','FontWeight','bold');
    
    %     axis([0 max(ddt) aascalemin aascalemax]);
    line([0 inf],[0 0]);
    axis([0 inf 0 max(max(forvbFRET.AexAem{n}(:,2)))]);
    
    ax4 = subplot(3,2,4);
    imshow(cat(3,curraathumb,0*currddthumb,0*currddthumb));
    
    ax5=subplot(3,2,6);
    hold off
    plot(forvbFRET.AveFRETs{n}(:,1),forvbFRET.Sscat{n},'ro')
    axis([0 1 0 1]);
    xlabel('FRET E','FontWeight','bold');
    ylabel('S','FontWeight','bold');
    
    ax6 = subplot(3,2,5);
    hold off;
    plot(forvbFRET.timeDex{n}(:,1),forvbFRET.FRETdd{n},'b-','LineWidth',1);
    hold on
    plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
    axis([0 inf -0.2 1.2]);
    xlabel('Time','FontWeight','bold');
    ylabel('FRET E','FontWeight','bold');
    hold on
    
    set(ax1,'Position',[0.0500    0.7393    0.4790    0.2134]);
    set(ax3,'Position',[0.0500    0.4396    0.4790    0.2134]);
    set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
    %set(ax2,'Position',[0.65    0.7393    0.3347    0.2157]);
    %set(ax4,'Position',[0.65    0.4396    0.3347    0.2157]);
    set(ax5,'Position',[0.6    0.05   0.35     0.35]);
    
%     
% % %   %2017 11 07 for extracting data to use for plotting nice trace
% % examples for paper, edited on 2017 12 14
% % PLOT RAW INTENSITY DATA
%     figure(1)
%     ax1 = subplot(3,1,1);
%     hold off;
%     plot(forvbFRET.timeDex{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.FRETtrunctraces{n}(:,1),'-','Color',[0 0.75 0],'LineWidth',1);
%     hold on;
%     plot(forvbFRET.timeDex{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.FRETtrunctraces{n}(:,2),'r-','LineWidth',1);
%     axis([0 inf min(min(forvbFRET.FRETtrunctraces{n})) max(max(forvbFRET.FRETtrunctraces{n}))]);
%     title([num2str(n) ' of ' num2str(length(forvbFRET.AllTruncTraceLabels))])
%     wsize = 5;
%     ylabel({'Dex Dem Aem',''},'FontWeight','bold');
%     
%     ax3 = subplot(3,1,2);
%     hold off;
%     plot(forvbFRET.AexAem{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.AexAem{n}(:,2),'r-','LineWidth',1);
%     ylabel('AexAem','FontWeight','bold');
%     line([0 inf],[0 0]);
%     %axis([0 inf 0 max(max(forvbFRET.AexAem{n}(:,2)))]);
%     axis([0 inf min(min(forvbFRET.FRETtrunctraces{n})) max(max(forvbFRET.FRETtrunctraces{n}))]);
% 
%     ax6 = subplot(3,1,3);
%     hold off;
%     plot(forvbFRET.timeDex{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.FRETdd{n},'b-','LineWidth',1);
%     axis([0 inf -0.2 1.2]);
%     xlabel('Time','FontWeight','bold');
%     ylabel('FRET E','FontWeight','bold');
%     %
%     
% % PLOT NORMALIZED DATA 2017 12 14
% % have to play around with normalization factors and axes limits here. 
%     figure(1)
%     ax1 = subplot(3,1,1);
%     hold off;
%     plot(forvbFRET.timeDex{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.FRETtrunctraces{n}(:,1)/(2*10^5),'-','Color',[0 0.75 0],'LineWidth',1);%set 2*10^5 = 1
%     hold on;
%     plot(forvbFRET.timeDex{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.FRETtrunctraces{n}(:,2)/(2*10^5),'r-','LineWidth',1);
%     axis([0 inf -0.2 1.6]);
%     title([num2str(n) ' of ' num2str(length(forvbFRET.AllTruncTraceLabels))])
%     wsize = 5;
%     ylabel({'Dex Dem Aem',''},'FontWeight','bold');
%     
%     ax3 = subplot(3,1,2);
%     hold off;
%     plot(forvbFRET.AexAem{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.AexAem{n}(:,2)/(mean(forvbFRET.AexAem{n}(:,2))),'r-','LineWidth',1); %set ave Cy5 intensity = 1
%     ylabel('AexAem','FontWeight','bold');
%     line([0 inf],[0 0]);
%     %axis([0 inf 0 max(max(forvbFRET.AexAem{n}(:,2)))]);
%     axis([0 inf -0.2 2]);
% 
%     ax6 = subplot(3,1,3);
%     hold off;
%     plot(forvbFRET.timeDex{n}(:,1)*(ExposureTime+TimeDelay),forvbFRET.FRETdd{n},'b-','LineWidth',1);
%     axis([0 inf -0.2 1.2]);
%     xlabel('Time','FontWeight','bold');
%     ylabel('FRET E','FontWeight','bold');
%     %
    
    
%     close 
%     
    Sdwell=0;
    [x,y,key] = ginput(1);
    switch key
        case 29
            delete(findall(gcf,'Tag','fdelete'));%to delete any remaining annotations
            n = n+1;
        case 28
            delete(findall(gcf,'Tag','fdelete'));
            n = n-1;
            if n < 1
                n = 1;
            end
        case 'g' % g, goto to traj num ' ' within current segment
            n=inputdlg(['Enter particle number between 1 and ' num2str(npks)]);
            n = num2str(n{1});
            n=str2double(n);
        case 112 % p - play movies (truncated/selected movies)
            for j=1:2:size(forvbFRET.timeDex{n},1)
                currframedd = mean(forvbFRET.ddThumb{n}(:,:,j:min(j,size(forvbFRET.timeDex{n},1))),3);
                currframeda = mean(forvbFRET.daThumb{n}(:,:,j:min(j,size(forvbFRET.timeDex{n},1))),3);
                currframeaa = mean(forvbFRET.aaThumb{n}(:,:,min(ceil(j/2),size(forvbFRET.AexAem{n},1))),3);
                currframedd = scaleim(currframedd,ddthumbmin,ddthumbmax);
                currframeda = scaleim(currframeda,dathumbmin,dathumbmax);
                currframeaa = scaleim(currframeaa,aathumbmin,aathumbmax);
                axes(ax2);
                imshow(cat(3,currframeda,currframedd,0*currddthumb));
                axes(ax4);
                imshow(cat(3,currframeaa,0*currframedd,0*currddthumb));
                pause(0.001)
            end
        case 'a' %to save a trace in forvbFRET for downstream HMM
            forvbFRET.data{savecount}=forvbFRET.FRETtrunctraces{n};
            forvbFRET.labels{savecount}=forvbFRET.AllTruncTraceLabels{n};
            savecount=savecount+1;
            allhist(length(allhist)+1:length(allhist)+length(forvbFRET.FRETdd{n}),1)=forvbFRET.FRETdd{n};
            %TGdwellHighA=TGdwellHighA+sum(forvbFRET.FRETdd{n}>NHEJthresh);
            Goodtrace=Goodtrace+1;
            
        case 'e' %to save original data of a trace (2017 09 22 for TG Cy5maleimide analysis)
            %raw data sorting for saving
            DataSel3{SelDCount}.ddtraj=nonzeros(DataSel2{1}.ddtraj(:,n));
            DataSel3{SelDCount}.datraj=nonzeros(DataSel2{1}.datraj(:,n));
            DataSel3{SelDCount}.aatraj=nonzeros(DataSel2{1}.aatraj(:,n));
            DataSel3{SelDCount}.ddback=nonzeros(DataSel2{1}.ddback(:,n));
            DataSel3{SelDCount}.daback=nonzeros(DataSel2{1}.daback(:,n));
            DataSel3{SelDCount}.aaback=nonzeros(DataSel2{1}.aaback(:,n));
            DataSel3{SelDCount}.ddtraj_bpass=nonzeros(DataSel2{1}.ddtraj_bpass(:,n));
            DataSel3{SelDCount}.datraj_bpass=nonzeros(DataSel2{1}.datraj_bpass(:,n));
            DataSel3{SelDCount}.aatraj_bpass=nonzeros(DataSel2{1}.aatraj_bpass(:,n));
            DataSel3{SelDCount}.ddback_bpass=nonzeros(DataSel2{1}.ddback_bpass(:,n));
            DataSel3{SelDCount}.daback_bpass=nonzeros(DataSel2{1}.daback_bpass(:,n));
            DataSel3{SelDCount}.aaback_bpass=nonzeros(DataSel2{1}.aaback_bpass(:,n));
            endind= find(DataSel2{1}.offx(n,:),1,'last'); %find last nonzero element for each trace to use for getting rid of trailing zeros
            DataSel3{SelDCount}.offx=DataSel2{1}.offx(n,1:endind);
            endind2= find(DataSel2{1}.offy(n,:),1,'last'); %find last nonzero element for each trace to use for getting rid of trailing zeros
            DataSel3{SelDCount}.offy=DataSel2{1}.offy(n,1:endind2);
            DataSel3{SelDCount}.p=DataSel2{1}.p(n,1:2);
            DataSel3{SelDCount}.ap=DataSel2{1}.ap(n,1:2);
            DataSel3{SelDCount}.dd_xysig(:,1)=nonzeros(DataSel2{1}.dd_xysig(:,(n*2)-1));
            DataSel3{SelDCount}.dd_xysig(:,2)=nonzeros(DataSel2{1}.dd_xysig(:,(n*2)));
            DataSel3{SelDCount}.aa_xysig(:,1)=nonzeros(DataSel2{1}.aa_xysig(:,(n*2)-1));
            DataSel3{SelDCount}.aa_xysig(:,2)=nonzeros(DataSel2{1}.aa_xysig(:,(n*2)));
            DataSel3{SelDCount}.dd_fqual=nonzeros(DataSel2{1}.dd_fqual(:,n));
            DataSel3{SelDCount}.aa_fqual=nonzeros(DataSel2{1}.aa_fqual(:,n));
            DataSel3{SelDCount}.segfirst=DataSel2{1}.segfirst(1,n);
            DataSel3{SelDCount}.seglast=DataSel2{1}.seglast(1,n);
            DataSel3{SelDCount}.nsegframes=DataSel2{1}.nsegframes(1,n);
            DataSel3{SelDCount}.t(1,1:length(nonzeros(DataSel2{1}.t(n,:))))=nonzeros(DataSel2{1}.t(n,:));
            DataSel3{SelDCount}.ph=DataSel2{1}.ph(1,n);
            SelDCount=SelDCount+1;
        case 'u' %to undo selection of a trace/event or transition
            savecount=savecount-1;
            Goodtrace=Goodtrace-1;
            TGdwellHighA=TGdwellHighA-sum(forvbFRET.FRETdd{n}>NHEJthresh);
            allhist=allhist(1:length(allhist)-length(forvbFRET.FRETdd{n}),1);
            for dc=1:countf
                if dc==1 && countf==1 % if there were no transitions in trace
                    if mean(forvbFRET.FRETdd{n}(1:end,1))<=NHEJthresh%lowFRET
                        count2low=count2low-1; %reset count indexes for storing dwell times
                        TGdwellLow(count2low,:)=[];%delete the data stored from the most recent trace selected
                    end
                    if mean(forvbFRET.FRETdd{n}(1:end,1))>NHEJthresh%highFRET
                        count2high=count2high-1;
                        TGdwellHigh(count2high,:)=[];
                    end
                end
                if countf==2% if there is one transition within trace
                    if dc==1
                        if mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1)))<=NHEJthresh%lowFRET
                            count2low=count2low-1;
                            TGdwellLow(count2low,:)=[];
                        end
                        if mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1)))>NHEJthresh%highFRET
                            count2high=count2high-1;
                            TGdwellHigh(count2high,:)=[];
                        end
                    end
                    if dc==2
                        if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1))<=NHEJthresh%lowFRET
                            count2low=count2low-1;
                            TGdwellLow(count2low,:)=[];
                        end
                        if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1))>NHEJthresh%highFRET
                            count2high=count2high-1;
                            TGdwellHigh(count2high,:)=[];
                        end
                    end
                end
                if countf>2 % if we have more than one transition within a trace
                    if dc==1
                        if mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1))<=NHEJthresh%lowFRET
                            count2low=count2low-1;
                            TGdwellLow(count2low,:)=[];
                        end
                        if mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1))>NHEJthresh%lowFRET
                            count2high=count2high-1;
                            TGdwellHigh(count2high,:)=[];
                        end
                    end
                    if dc==countf %last segment in trace
                        if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1))<=NHEJthresh%lowFRET
                            count2low=count2low-1;
                            TGdwellLow(count2low,:)=[];
                        end
                        if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1))>NHEJthresh%lowFRET
                            count2high=count2high-1;
                            TGdwellHigh(count2high,:)=[];
                        end
                    end
                    if dc>1 && dc<countf %states with transitions into and out of that state
                        if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1))<=NHEJthresh%lowFRET
                            count2low=count2low-1;
                            TGdwellLow(count2low,:)=[];
                        end
                        if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1))>NHEJthresh%lowFRET
                            count2high=count2high-1;
                            TGdwellHigh(count2high,:)=[];
                        end
                    end
                end
                
            end
            %textbox to let user know that data has been deleted
            gcf
            dim = [.62 .69 .3 .3];
            str = 'Hasta la vista, baby!';
            tbox=annotation('textbox',dim,'Color','red','String',str,'FitBoxToText','on','Tag','fdelete');
            
            
            
            
            
            
        case 'c' %for selecting the beginning and end points of slow transitions
            forvbFRET.data{savecount}=forvbFRET.FRETtrunctraces{n};
            forvbFRET.labels{savecount}=forvbFRET.AllTruncTraceLabels{n};
            forvbFRET.time{savecount}=forvbFRET.timeDex{n};
            savecount=savecount+1;
            allhist(length(allhist)+1:length(allhist)+length(forvbFRET.FRETdd{n}),1)=forvbFRET.FRETdd{n};
            Goodtrace=Goodtrace+1;
            
            button2=1;
            plotransStr=[];
            plotransEnd=[];
            countf2=1;
            while button2==1 %if only mouse clicks have been used, push any key to move on
                Sdwell2=1;
                [x2,~,button2]=ginput(2);%click close to the transition
                if button2~=1%press a key to move on
                    break
                end
                %Find data pt on our frete time/frame# axis that is closest
                %to click pt.
                [x1v,x1ind]=min(abs(x2(1,1)-forvbFRET.timeDex{n}));
                [x2v,x2ind]=min(abs(x2(2,1)-forvbFRET.timeDex{n}));
                
                %find transition point (largest difference for running aves surrounding the click on x-axis)
                TransPts=[];
                mintrans=[];
                countrans=1;
                
                % COMMENTED BLOCK IS AN IN-PROGRESS ATTEMPT TO AUTOMATICALLY DETECT TRANSITIONS, THIS IS HARD FOR SLOW/LONG TRANSITIONS
                %                 h1=[];
                %                 h2=[];
                % %
                %                 f=x1ind-TranScan;
                %                 f2=x2ind-TranScan;
                %                 fend=x1ind+TranScan;
                %                 f2end=x2ind+TranScan;
                %                 while f<=fend %from x frames below to x frames above click pt on x axis
                %                     if f<1 % we click too close to zero
                %                         f=1+AveScan;
                %                     elseif fend>length(forvbFRET.FRETdd{n}(:,1))-AveScan%if we click to close to end of trace
                %                         fend=length(forvbFRET.FRETdd{n}(:,1))-AveScan;
                %                         f=fend-AveScan;
                %                     end
                %                         %[h,p,ci,stats] =ttest2(forvbFRET.FRETdd{n}(f-AveScan:f-1,1),forvbFRET.FRETdd{n}(f+1:f+AveScan,1),'Tail','both','Alpha',0.05,'Vartype','unequal')
                %                         h1(1,countrans)=ttest2(forvbFRET.FRETdd{n}(f-AveScan:f-1,1),forvbFRET.FRETdd{n}(f+1:f+AveScan,1),'Tail','both','Alpha',0.05,'Vartype','unequal');
                %                         h1(2,countrans)=f;
                %                         countrans=countrans+1;
                %                         f=f+1;
                %                 end
                %
                %
                %                 while f2<=f2end %from x frames below to x frames above click pt on x axis
                %                     if f2<1 % we click too close to zero
                %                         f2=1+AveScan;
                %                     elseif f2end>length(forvbFRET.FRETdd{n}(:,1))-AveScan%if we click to close to end of trace
                %                         f2end=length(forvbFRET.FRETdd{n}(:,1))-AveScan;
                %                         f2=f2end-AveScan;
                %                     end
                %                         h2(1,countrans)=ttest2(forvbFRET.FRETdd{n}(f2-AveScan:f2-1,1),forvbFRET.FRETdd{n}(f2+1:f2+AveScan,1),'Tail','both','Alpha',0.05,'Vartype','unequal');
                %                         h2(2,countrans)=f2;
                %                         countrans=countrans+1;
                %                         f2=f2+1;
                %                 end
                %
                %                         % [h,p,ci,stats] =ttest2(forvbFRET.FRETdd{n}(f-AveScan:f-1,1),forvbFRET.FRETdd{n}(f+1:f+AveScan,1),'Tail','both','Alpha',0.05,'Vartype','unequal')
                %
                %
                %Finds closest time pt to click
                StrInd1=forvbFRET.timeDex{n}(x1ind,1);
                EndInd1=forvbFRET.timeDex{n}(x2ind,1);
                %Then finds corresponding index
                StrInd1i=find(forvbFRET.timeDex{n}==StrInd1);
                EndInd1i=find(forvbFRET.timeDex{n}==EndInd1);
                
                %sort of assumes two-ish states one transition
                %save data from 0:start of trans
                State1=forvbFRET.FRETdd{n}(1:StrInd1i);
                %save data from start of trans:end of trans
                State2=forvbFRET.FRETdd{n}(StrInd1i:EndInd1i);
                %save data from start of end of trans:end of trace
                State3=forvbFRET.FRETdd{n}(EndInd1i:end);
                %transition time in # of frames
                TransTime=EndInd1i-StrInd1i;
                
                %save some of these variables
                forvbFRET.TransTime{n}(countf2,1)=TransTime;
                forvbFRET.mTransStr{n}(countf2,1)=mean(State1);
                forvbFRET.mTransEnd{n}(countf2,1)=mean(State3);
                
                forvbFRET.State1{n}=State1;
                forvbFRET.State2{n}=State2;
                forvbFRET.State3{n}=State3;
                
                State1m(countc,1)=mean(State1);
                State3m(countc,1)=mean(State3);
                TransTimeHist(countc,1)=TransTime;
                
                plotransStr(countf2,1:2)=StrInd1;
                plotransEnd(countf2,1:2)=EndInd1;
                
                ax6 = subplot(3,2,5);
                hold off;
                plot(forvbFRET.timeDex{n},forvbFRET.FRETdd{n},'b-','LineWidth',1);
                hold on
                plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
                axis([0 inf -0.2 1.2]);
                xlabel('Time','FontWeight','bold');
                ylabel('FRET E','FontWeight','bold');
                hold on
                set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
                
                hold on
                for ff=1:length(plotransStr(:,1))
                    plot(plotransStr(ff,1:2),-0.2:1.4:1.2,'m-','LineWidth',4)
                    hold on
                    plot(plotransEnd(ff,1:2),-0.2:1.4:1.2,'m-','LineWidth',4)
                    hold on
                end
                figure(h7)
                %new selection or move on
                [x2,~,button2]=ginput(1);%click to re-pick the transition or button to move on without it
                countf2=countf2+1;
                %x2last=x2;%to store to compare against next x2
                countc=countc+1;
            end
            
            
            
        case 'o' %Click to select FRET onset point
            %also let's save the traces of interest forvbFRET for downstream HMM
            allhist(length(allhist)+1:length(allhist)+length(forvbFRET.FRETdd{n}),1)=forvbFRET.FRETdd{n};
            Goodtrace=Goodtrace+1;
            [x2,~,button2]=ginput(1);%click close to the transition
            while button2==1 %if only mouse clicks have been used, push any key to move on
                if button2~=1%press a key to move on
                    break
                end
                
                %Find data pt on our frete time/frame# axis that is closest
                %to clcik pt.
                [x1v,x1ind]=min(abs(x2(1,1)-forvbFRET.timeDex{n}));
                %find transition point (largest difference for running aves surrounding the click on x-axis)
                TransPts=[];
                mintrans=[];
                countrans=1;
                countf=1;
                f=x1ind-TranScan;
                fend=x1ind+TranScan;
                while f<=fend %from x frames below to x frames above click pt on x axis
                    if f<1 % we click too close to zero
                        f=1+AveScan;
                    elseif fend>length(forvbFRET.FRETdd{n}(:,1))-AveScan%if we click to close to end of trace
                        fend=length(forvbFRET.FRETdd{n}(:,1))-AveScan;
                        f=fend-AveScan;
                    end
                    TransPts(1,countrans)=abs(mean(forvbFRET.FRETdd{n}(f-AveScan:f-1,1))-mean(forvbFRET.FRETdd{n}(f+1:f+AveScan,1)));
                    TransPts(2,countrans)=f;
                    countrans=countrans+1;
                    f=f+1;
                end
                
                [transval,transind]=max(TransPts(1,:));%find max difference or the point of transition
                TimeInd=forvbFRET.timeDex{n}(TransPts(2,transind),1);
                plotrans(countf,1:2)=TimeInd;
                TransInds(countf,1)=TransPts(2,transind);
                ax6 = subplot(3,2,5);
                hold off;
                plot(forvbFRET.timeDex{n},forvbFRET.FRETdd{n},'b-','LineWidth',1);
                hold on
                plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
                axis([0 inf -0.2 1.2]);
                xlabel('Time','FontWeight','bold');
                ylabel('FRET E','FontWeight','bold');
                hold on
                set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
                
                hold on
                %for ff=1:length(plotrans(:,1))
                plot(plotrans(1,1:2),-0.2:1.4:1.2,'m-','LineWidth',4)
                hold on
                %end
                figure(h7)
                [x2,~,button2]=ginput(1);%click close to the transition
                FRETonset=[];
                AexAemonset=[];
                FRETonset(:,1)=forvbFRET.timeDex{n}-TimeInd; %set selected fret onset to 0
                FRETonset(:,2)=forvbFRET.FRETdd{n}; %set selected fret onset to 0
                AexAemonset(:,1)=forvbFRET.AexAem{n}(:,1)-TimeInd;
                AexAemonset(:,2)=forvbFRET.AexAem{n}(:,2);
                
                forvbFRET2.AexAem{savecount}=forvbFRET.AexAem{n};
                forvbFRET2.data{savecount}=forvbFRET.FRETtrunctraces{n};
                forvbFRET2.labels{savecount}=forvbFRET.AllTruncTraceLabels{n};
                forvbFRET2.AexAemonset{savecount}=AexAemonset;
                forvbFRET2.FRETonset{savecount}=FRETonset;
                forvbFRET2.plotrans{savecount}=plotrans;
                forvbFRET2.timeDex{savecount}=forvbFRET.timeDex{n};
                forvbFRET2.FRET{savecount}=forvbFRET.FRETdd{n};
                forvbFRET2.Cy5onset{savecount}=AexAemonset;
                forvbFRET2.FRETonset{savecount}=FRETonset;
                forvbFRET2.Cy3Cy5sig{savecount}=forvbFRET.FRETtrunctraces{n};
                forvbFRET2.onsetlabels{savecount}=forvbFRET.AllTruncTraceLabels{n};
                forvbFRET2.ddThumb{savecount}=forvbFRET.ddThumb{n};
                forvbFRET2.daThumb{savecount}=forvbFRET.daThumb{n};
                forvbFRET2.aaThumb{savecount}=forvbFRET.aaThumb{n};
                forvbFRET2.aaThumb{savecount}=forvbFRET.aaThumb{n};
                forvbFRET2.ddthumbmin{savecount}=ddthumbmin;
                forvbFRET2.ddthumbmax{savecount}=ddthumbmax;
                forvbFRET2.dathumbmin{savecount}=dathumbmin;
                forvbFRET2.dathumbmax{savecount}=dathumbmax;
                forvbFRET2.aathumbmin{savecount}=aathumbmin;
                forvbFRET2.aathumbmax{savecount}=aathumbmax;
                
                
                
                savecount=savecount+1;
            end
            
            
            
            
            
            
        case 'n' %select high and low states and dwells by clicking
            %also let's save the traces of interest forvbFRET for downstream HMM
            forvbFRET.data{savecount}=forvbFRET.FRETtrunctraces{n}; %these may need to be addressed in 'u' undo option
            forvbFRET.labels{savecount}=forvbFRET.AllTruncTraceLabels{n};
            forvbFRET.time{savecount}=forvbFRET.timeDex{n};
            
            TraceSave.Cy3{savecount}=forvbFRET.FRETtrunctraces{n}(:,1);
            TraceSave.Cy5{savecount}=forvbFRET.FRETtrunctraces{n}(:,2);
            TimeAdjusted=forvbFRET.timeDex{n}*(ExposureTime+TimeDelay);
            TraceSave.DexTime{savecount}=TimeAdjusted;
            TraceSave.AexTime{savecount}=forvbFRET.AexAem{n}(:,1)*(ExposureTime+TimeDelay);
            TraceSave.Cy5ex{savecount}=forvbFRET.AexAem{n}(:,2);
            TraceSave.FRETE{savecount}=forvbFRET.FRETdd{n};
            TraceSave.TraceNum(savecount,1)=n;
            
            
            savecount=savecount+1;
            allhist(length(allhist)+1:length(allhist)+length(forvbFRET.FRETdd{n}),1)=forvbFRET.FRETdd{n};
            TGdwellHighA=TGdwellHighA+sum(forvbFRET.FRETdd{n}>NHEJthresh);
            Goodtrace=Goodtrace+1;
            
            button2=1;
            plotrans=[];
            countf=1;
            TransInds=[];%edit 2017 09 26, I think extra Inds were being carried over because var was never re-initiated.
            while button2==1 %if only mouse clicks have been used, push any key to move on
                Sdwell=1;
                [x2,~,button2]=ginput(1);%click close to the transition
                if button2~=1%press a key to move on
                    break
                end
                %for undoing/deselecting the last transition clicked/selected
                %if both this click and last click are within a close range (set by TransScan)
                if isempty(plotrans)==0 %if we have already selected a transition
                    if abs(x2-x2last)<=TranScan
                        [ptL,~]=size(plotrans);
                        if ptL==1
                            plotrans=[];
                            countf=countf-1;
                        elseif ptL>=2
                            plotrans=plotrans(1:countf-1,:);
                            countf=countf-1;
                        end
                        %                         %replot without last selection
                        ax6 = subplot(3,2,5);
                        hold off;
                        plot(forvbFRET.timeDex{n},forvbFRET.FRETdd{n},'b-','LineWidth',1);
                        hold on
                        plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
                        axis([0 inf -0.2 1.2]);
                        xlabel('Time','FontWeight','bold');
                        ylabel('FRET E','FontWeight','bold');
                        hold on
                        set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
                        hold on
                        if ptL>=2 %if there were previous selections before the one we deselected
                            for ff=1:length(plotrans(:,1))
                                plot(plotrans(ff,1:2),-0.2:1.4:1.2,'m-','LineWidth',4)
                                hold on
                            end
                        end
                        figure(h7)
                        %new selection or move on
                        [x2,~,button2]=ginput(1);%click to re-pick the transition or button to move on without it
                    end
                end
                %click on outside of right side of plot to collect entire trace
                if x2>forvbFRET.timeDex{n}(end,1)
                    figure(h7)
                    plot(forvbFRET.timeDex{n},forvbFRET.FRETdd{n},'b-','LineWidth',1);
                    hold on
                    plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
                    axis([0 inf -0.2 1.2]);
                    xlabel('Time','FontWeight','bold');
                    ylabel('FRET E','FontWeight','bold');
                    hold on
                    set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
                    plot([0,0],-0.2:1.4:1.2,'m-','LineWidth',4)%time zero
                    plot([forvbFRET.timeDex{n}(end,1),forvbFRET.timeDex{n}(end,1)],-0.2:1.4:1.2,'m-','LineWidth',4)%time at end of trace
                    countf=0; %use this unique assignment for filling in TGdwells and annotating below.

                elseif x2<=forvbFRET.timeDex{n}(1,1) %if we click to the left of the plot for things starting in HighFRET
                    x2=0;
                    ax6 = subplot(3,2,5);
                    hold off;
                    plot(forvbFRET.timeDex{n},forvbFRET.FRETdd{n},'b-','LineWidth',1);
                    hold on
                    plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
                    axis([0 inf -0.2 1.2]);
                    xlabel('Time','FontWeight','bold');
                    ylabel('FRET E','FontWeight','bold');
                    hold on
                    set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
                    plotrans(1,1:2)=0;
                    hold on
                    for ff=1:length(plotrans(:,1))
                        plot(plotrans(ff,1:2),-0.2:1.4:1.2,'m-','LineWidth',4)
                        hold on
                    end
                    figure(h7)
                    countf=countf+1;
                    x2last=x2;%to store to compare against next x2
                    
                elseif x2<=forvbFRET.timeDex{n}(end,1) %if we clicked somewhere between start and end of trace
                    %Find data pt on our frete time/frame# axis that is closest
                    %to clcik pt.
                    [x1v,x1ind]=min(abs(x2(1,1)-forvbFRET.timeDex{n}));
                    %find transition point (largest difference for running aves surrounding the click on x-axis)
                    TransPts=[];
                    mintrans=[];
                    countrans=1;
                    f=x1ind-TranScan;
                    fend=x1ind+TranScan;
                    while f<=fend %from x frames below to x frames above click pt on x axis
                        if f<=TranScan % we click too close to zero
                            f=1+AveScan; 
                        elseif fend>length(forvbFRET.FRETdd{n}(:,1))-AveScan%if we click to close to end of trace
                            fend=length(forvbFRET.FRETdd{n}(:,1))-AveScan;
                            f=fend-AveScan;
                        end
                        TransPts(1,countrans)=abs(mean(forvbFRET.FRETdd{n}(f-AveScan:f-1,1))-mean(forvbFRET.FRETdd{n}(f+1:f+AveScan,1)));
                        TransPts(2,countrans)=f;
                        countrans=countrans+1;
                        f=f+1;
                    end
                    
                    [transval,transind]=max(TransPts(1,:));%find max difference or the point of transition
                    TimeInd=forvbFRET.timeDex{n}(TransPts(2,transind),1);
                    plotrans(countf,1:2)=TimeInd;
                    TransInds(countf,1)=TransPts(2,transind);
                    ax6 = subplot(3,2,5);
                    hold off;
                    plot(forvbFRET.timeDex{n},forvbFRET.FRETdd{n},'b-','LineWidth',1);
                    hold on
                    plot(forvbFRET.Strace{n}(:,1),forvbFRET.Strace{n}(:,2),'r-','LineWidth',1)
                    axis([0 inf -0.2 1.2]);
                    xlabel('Time','FontWeight','bold');
                    ylabel('FRET E','FontWeight','bold');
                    hold on
                    set(ax6,'Position',[0.0500    0.1300    0.4790    0.2134]);
                    
                    hold on
                    for ff=1:length(plotrans(:,1))
                        plot(plotrans(ff,1:2),-0.2:1.4:1.2,'m-','LineWidth',4)
                        hold on
                    end
                    figure(h7)
                    countf=countf+1;
                    x2last=x2;%to store to compare against next x2
                end
            end
                %if we have saved some dwell times/states for analysis
                if Sdwell==1 %we can now segment up the traces and place them into high or low FRET based on ave FRET of each trace segment
                    if countf==0 %if we selected entire trace, left censored data included here
                        TGdwellHigh(count2high,1)=forvbFRET.timeDex{n}(end,1);%end of trace
                        TGdwellHigh(count2high,3)=n;%mol # as arragned here post-high FRET sorting
                        TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(1:end,1)); %ave FRET over region of interest
                        if forvbFRET.Bleach{n}==1 %Left censored and Not truncated by bleaching
                            TGdwellHigh(count2high,2)=4;
                        elseif forvbFRET.Bleach{n}==2
                            TGdwellHigh(count2high,2)=5;%left censored and yes photobleaching
                        end
                        count2high=count2high+1;
                        
                    elseif countf>0
                        for dc=1:countf; %default value
                            %for dc=1:countf-1; %EDIT 2017 09 30, default value for countf is 1, a selection changes it to 2
                            %0=not censored
                            %1=end-censored by FOV change
                            %2=start-censored by FOV change
                            %3=end-censored by photobleaching
                            %4=start and end-censored by FOV change
                            %5=start censored by FOV change and end-censored by photobleaching
                            
                            
                            %Edit 2017 09 30--save/pickup only first click-last click as HighDwell Time, or First click to end of traj
                            %Commented code below automatically bins into high or low FRET based on Ave across traj, not working so well. Picking up noise-false high FRET
                            if dc==2 && countf==2%one click
                                TGdwellHigh(count2high,1)=forvbFRET.timeDex{n}(end,1)-plotrans(dc-1,1);%end of trace-pt of trans selected
                                TGdwellHigh(count2high,3)=n;
                                TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1));
                                if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                                    TGdwellHigh(count2high,2)=1;
                                elseif forvbFRET.Bleach{n}==2
                                    TGdwellHigh(count2high,2)=3;%yes photobleaching
                                end
                                count2high=count2high+1;
                            end
                            if countf>2%If we made more than 1 click in traj
                                if dc==countf && mod(countf,2)==0   % even number(1click=countf==2) and last segment in trace
                                    TGdwellHigh(count2high,1)=forvbFRET.timeDex{n}(end,1)-plotrans(dc-1,1);
                                    TGdwellHigh(count2high,3)=n;
                                    TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1));
                                    if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                                        TGdwellHigh(count2high,2)=1;
                                    elseif forvbFRET.Bleach{n}==2
                                        TGdwellHigh(count2high,2)=3;%yes photobleaching
                                    end
                                    count2high=count2high+1;
                                end
                                if dc>1 && dc<countf && mod(dc,2)==0%states with transitions into and out of that state. Count by 2s here to skip region in between feach 2 click selection
                                    if plotrans(dc-1,1)==0%if we picked the first time pt because the trajectory is 'left-censored', we start in highFRET
                                        TGdwellHigh(count2high,1)=plotrans(dc,1); %from 0-end of event
                                        TGdwellHigh(count2high,2)=2; %left censored, started in high FRET, but caight 'off event'
                                        TGdwellHigh(count2high,3)=n;
                                        TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1));%^from first data pt
                                        count2high=count2high+1;
                                    elseif plotrans(dc-1,1)~=forvbFRET.timeDex{n}(1,1)
                                        TGdwellHigh(count2high,1)=plotrans(dc,1)-plotrans(dc-1,1);
                                        TGdwellHigh(count2high,2)=0; %not censored
                                        TGdwellHigh(count2high,3)=n;
                                        TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1));
                                        count2high=count2high+1;
                                    end
                                end
                            
                            end
                            
                            
                            %
                            %
                            %                     %if there are no transitions observed in the trace
                            %                     if dc==1 && countf==1
                            %                         if mean(forvbFRET.FRETdd{n}(1:end,1))<=NHEJthresh%lowFRET
                            %                             TGdwellLow(count2low,1)=forvbFRET.timeDex{n}(end,1);
                            %                             TGdwellLow(count2low,3)=n;
                            %                             TGdwellLow(count2low,4)=mean(forvbFRET.FRETdd{n}(1:end,1));
                            %                             if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                 TGdwellLow(count2low,2)=4;
                            %                             elseif forvbFRET.Bleach{n}==2 %yes photobleaching
                            %                                 TGdwellLow(count2low,2)=5;
                            %                             end
                            %                             count2low=count2low+1;
                            %                         elseif mean(forvbFRET.FRETdd{n}(1:end,1))>NHEJthresh %highFRET
                            %                             TGdwellHigh(count2high,1)=forvbFRET.timeDex{n}(end,1);
                            %                             TGdwellHigh(count2high,3)=n;
                            %                             TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(1:end,1));
                            %                             if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                 TGdwellHigh(count2high,2)=4;
                            %                             elseif forvbFRET.Bleach{n}==2
                            %                                 TGdwellHigh(count2high,2)=5;%yes photobleaching
                            %                             end
                            %                             count2high=count2high+1;
                            %                         end
                            %                     end
                            %
                            %                     %if there is only 1 transition in trace
                            %                     if countf==2
                            %                         if dc==1
                            %                             if mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1)))<=NHEJthresh%lowFRET
                            %                                 TGdwellLow(count2low,1)=plotrans(dc,1);
                            %                                 TGdwellLow(count2low,3)=n;
                            %                                 TGdwellLow(count2low,4)=mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1)));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellLow(count2low,2)=2;
                            %                                 elseif forvbFRET.Bleach{n}==2 %yes photobleaching
                            %                                     TGdwellLow(count2low,2)=2;
                            %                                 end
                            %                                 count2low=count2low+1;
                            %                             elseif mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1)))>NHEJthresh %highFRET
                            %                                 TGdwellHigh(count2high,1)=plotrans(dc,1);
                            %                                 TGdwellHigh(count2high,3)=n;
                            %                                 TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1)));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellHigh(count2high,2)=2;
                            %                                 elseif forvbFRET.Bleach{n}==2
                            %                                     TGdwellHigh(count2high,2)=2;%yes photobleaching
                            %                                 end
                            %                                 count2high=count2high+1;
                            %                             end
                            %                         end
                            %                         if dc==2
                            %                             if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1))<=NHEJthresh%lowFRET
                            %                                 TGdwellLow(count2low,1)=forvbFRET.timeDex{n}(end,1)-plotrans(dc-1,1);
                            %                                 TGdwellLow(count2low,3)=n;
                            %                                 TGdwellLow(count2low,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellLow(count2low,2)=1;
                            %                                 elseif forvbFRET.Bleach{n}==2 %yes photobleaching
                            %                                     TGdwellLow(count2low,2)=3;
                            %                                 end
                            %                                 count2low=count2low+1;
                            %                             elseif mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1))>NHEJthresh %highFRET
                            %                                 TGdwellHigh(count2high,1)=forvbFRET.timeDex{n}(end,1)-plotrans(dc-1,1);
                            %                                 TGdwellHigh(count2high,3)=n;
                            %                                 TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):end,1));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellHigh(count2high,2)=1;
                            %                                 elseif forvbFRET.Bleach{n}==2
                            %                                     TGdwellHigh(count2high,2)=3;%yes photobleaching
                            %                                 end
                            %                                 count2high=count2high+1;
                            %                             end
                            %                         end
                            %                     end
                            %
                            %                     %if there are 2 or more transitions in trace
                            %                     if countf>2
                            %                         if dc==1
                            %                             if mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1))<=NHEJthresh%lowFRET
                            %                                 TGdwellLow(count2low,1)=plotrans(dc,1);
                            %                                 TGdwellLow(count2low,3)=n;
                            %                                 TGdwellLow(count2low,4)=mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellLow(count2low,2)=2;
                            %                                 elseif forvbFRET.Bleach{n}==2 %yes photobleaching
                            %                                     TGdwellLow(count2low,2)=2;
                            %                                 end
                            %                                 count2low=count2low+1;
                            %                             elseif mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1))>NHEJthresh %highFRET
                            %                                 TGdwellHigh(count2high,1)=plotrans(dc,1);
                            %                                 TGdwellHigh(count2high,3)=n;
                            %                                  TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(1:TransInds(dc,1),1));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellHigh(count2high,2)=2;
                            %                                 elseif forvbFRET.Bleach{n}==2
                            %                                     TGdwellHigh(count2high,2)=2;%yes photobleaching
                            %                                 end
                            %                                 count2high=count2high+1;
                            %                             end
                            %                         end
                            %                         if dc==countf %last segment in trace
                            %                             if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1))<=NHEJthresh%lowFRET
                            %                                 TGdwellLow(count2low,1)=forvbFRET.timeDex{n}(end,1)-plotrans(dc-1,1);
                            %                                 TGdwellLow(count2low,3)=n;
                            %                                 TGdwellLow(count2low,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellLow(count2low,2)=1;
                            %                                 elseif forvbFRET.Bleach{n}==2 %yes photobleaching
                            %                                     TGdwellLow(count2low,2)=3;
                            %                                 end
                            %                                 count2low=count2low+1;
                            %                             elseif mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1))>NHEJthresh %highFRET
                            %                                 TGdwellHigh(count2high,1)=forvbFRET.timeDex{n}(end,1)-plotrans(dc-1,1);
                            %                                 TGdwellHigh(count2high,3)=n;
                            %                                 TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(end,1),1));
                            %                                 if forvbFRET.Bleach{n}==1 %Not truncated by bleaching
                            %                                     TGdwellHigh(count2high,2)=1;
                            %                                 elseif forvbFRET.Bleach{n}==2
                            %                                     TGdwellHigh(count2high,2)=3;%yes photobleaching
                            %                                 end
                            %                                 count2high=count2high+1;
                            %                             end
                            %                         end
                            %                         if dc>1 && dc<countf %states with transitions into and out of that state
                            %                             if mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1))<=NHEJthresh%lowFRET
                            %                                 TGdwellLow(count2low,1)=plotrans(dc,1)-plotrans(dc-1,1);
                            %                                 TGdwellLow(count2low,2)=0;%not censored
                            %                                 TGdwellLow(count2low,3)=n;
                            %                                 TGdwellLow(count2low,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1));
                            %                                 count2low=count2low+1;
                            %                             elseif mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1))>NHEJthresh %highFRET
                            %                                 TGdwellHigh(count2high,1)=plotrans(dc,1)-plotrans(dc-1,1);
                            %                                 TGdwellHigh(count2high,2)=0; %not censored
                            %                                 TGdwellHigh(count2high,3)=n;
                            %                                 TGdwellHigh(count2high,4)=mean(forvbFRET.FRETdd{n}(TransInds(dc-1,1):TransInds(dc,1),1));
                            %                                 count2high=count2high+1;
                            %                             end
                            %                         end
                            %                     end
                        end
                    end
                end
    end
end
%Save data for further analysis
%save('DataSel3.mat','DataSel3')

%% Produce FRETE hist of S and E-based truncated data
FREThisttrunc=[];
AExHist=[];
for i=1:length(forvbFRET.FRETdd)
    FREThisttrunc=vertcat(FREThisttrunc,forvbFRET.FRETdd{i});
    AExHist=vertcat(AExHist,forvbFRET.AexAem{i}(:,2));
end
    %TGdwellHigh Hist
    figure(14)
    histogram(FREThisttrunc)
    title14=strcat('trunc FRETE Hist_',savename);
    title(title14)
    savefig(title14)
    saveas(gcf,title14,'png')   
    
    %Hist of Truncated AexAem data
    figure(20)
    %histogram(AExHist)
    histogram(AExHist,-100000:2000:600000) 
    title20=strcat('trunc AexAem Hist_',savename);
    title(title20)
    savefig(title20)
    saveas(gcf,title20,'png') 

    
%     
%     
% FRETonsetAll=[];
% for i=1:length(forvbFRET2.FRETonset)
%     %FRETonsetAll=vertcat(FRETonsetall,forvbFRET.FRETdd{i});
% end
%     %TGdwellHigh Hist
%     figure(14)
%     histogram(FREThisttrunc)
%     title14=strcat('trunc FRETE Hist_',savename);
%     title(title14)
%     savefig(title14)
%     saveas(gcf,title14,'png') 
%     


% Get overall fraction of available Time spent in high FRET state(framewise)
n=1;
%first get the total number of frames
AllTime=0;
while n<=length(forvbFRET.FRETtrunctraces)
    %AllTime=AllTime+(forvbFRET.timeDex{n}(end,1)*(ExposureTime+TimeDelay));
    AllTime=AllTime+(forvbFRET.timeDex{n}(end,1)*(ExposureTime+TimeDelay));%get # all frames acquired, in units of time here (seconds)
    TGdwellHighB=TGdwellHighB+(sum(forvbFRET.FRETdd{n}>NHEJthresh)*(ExposureTime+TimeDelay));%get # of frames above NHEJ thresh (SRC) and adjust to convert to time units (seconds)
    n=n+1;
end
%TGdwellHighB=0;
% while n<=length(FRETtrunctraces)
%     %AllTime=AllTime+(forvbFRET.timeDex{n}(end,1)*(ExposureTime+TimeDelay));
%     AllTime=AllTime+(timeDex{n}(end,1)*(ExposureTime+TimeDelay));%get # all frames acquired, in units of time here (seconds)
%     TGdwellHighB=TGdwellHighB+(sum(FRETdd{n}>NHEJthresh)*(ExposureTime+TimeDelay));%get # of frames above NHEJ thresh (SRC) and adjust to convert to time units (seconds)
%     n=n+1;
% end
LowTime=AllTime-TGdwellHighB;%Time spent in FRET negative state across all data collected. 

HighRateB=TGdwellHighB/AllTime; %High FRET rate for all traces based on NHEJ thresh, not just those selected using 'a' or 'r'
forvbFRET.HighRateB=HighRateB;

if TGdwellHighA ~=0 %get frame-based rate based on thresholding and selecting 'a'
    HighRateA=TGdwellHighA/AllTime;
    data=forvbFRET.data;
    labels=forvbFRET.labels;
    %time=forvbFRET.TimeDex;
    save('vbFRET','data','labels')
    forvbFRET.HighRateA=HighRateA;
end

if isempty(TGdwellHigh)==0%get frame-based rate from selecting dwells/states using 'r'    
    HighRate=sum(TGdwellHigh(:,1)/(AllTime));%Fraction of time spent in HighFRET
    FRETonRate=length(TGdwellHigh(:,1))/(LowTime);%measure of FRET-on events captured/unit time where transition to HighFRET is possible.
    FRETonStr=num2str(FRETonRate);
    RateStr=num2str(HighRate);
    piefracts=[];
    piefracts(1,1)=sum(TGdwellHigh(:,2) == 0);
    piefracts(2,1)=sum(TGdwellHigh(:,2) == 1);
    piefracts(3,1)=sum(TGdwellHigh(:,2) == 2);
    piefracts(4,1)=sum(TGdwellHigh(:,2) == 3);
    piefracts(5,1)=sum(TGdwellHigh(:,2) == 4);
    piefracts(6,1)=sum(TGdwellHigh(:,2) == 5);
    piefracts(:,2)=piefracts(:,1)/sum(piefracts(:,1));
    %uniqTGdwellhigh=unique(TGdwellHigh(:,2));
    %[countD,valD]=hist(TGdwellHigh(:,2),unique(TGdwellHigh(:,2)));
    %fractDwells=countD/sum(countD);
    fractlabels=round(piefracts(:,2),2);
    fractlabels=fractlabels*100;
    figure(8)
    lb1=strcat(num2str(fractlabels(1,1)),'%__Not Censored');
    lb2=strcat(num2str(fractlabels(2,1)),'%__End-Censored by FOV change');
    lb3=strcat(num2str(fractlabels(3,1)),'%__Start-Censored by FOV change');
    lb4=strcat(num2str(fractlabels(4,1)),'%__End-Censored by PhotoBleaching');
    lb5=strcat(num2str(fractlabels(5,1)),'%__Start and End-Censored by FOV change');
    lb6=strcat(num2str(fractlabels(6,1)),'%__S-Cens by FOV chng and E-Cens by PhotoBlch');
    pie(piefracts(:,2),{lb1,lb2,lb3,lb4,lb5,lb6})
    numtraces=num2str(length(forvbFRET.FRETdd));
    lenwidth=size(TGdwellHigh);
    numdwells=num2str(lenwidth(1));
    title8=strcat('NumTraces=',numtraces,'__FractHigh=',RateStr,'___NumDwells_=',numdwells,'_OnRate=_',FRETonStr,'.fig');
    savetitle='Pie';
    title(title8)
    savefig(savetitle)
    saveas(gcf,'Pie','png')
     
    KPdwellHigh=[];
    %EDIT 2017 10 30, loop through and mark whether pt is right censored or non-censored data for Kaplan Meier estimator
    count3=1;
    [i1,i2]=size(TGdwellHigh);
    for i=1:i1
        if TGdwellHigh(i,2)==0 || TGdwellHigh(i,2)==1 || TGdwellHigh(i,2)==3 || TGdwellHigh(i,2)==4 || TGdwellHigh(i,2)==5 || TGdwellHigh(i,2)==2
            KPdwellHigh(count3,1)=TGdwellHigh(i,1);
            if TGdwellHigh(i,2)==0 || TGdwellHigh(i,2)==2 %if we are not end censored %data for cens argument needed for censored survivial analysis using ecdf
                KPdwellHigh(count3,2)=0;
            elseif TGdwellHigh(i,2)==1 || TGdwellHigh(i,2)==3 || TGdwellHigh(i,2)==4 || TGdwellHigh(i,2)==5 %if we are end-truncated/censored
                KPdwellHigh(count3,2)=1;
            end
            count3=count3+1;
        end
    end
    TGdwellHighadj=[];
    TGdwellHighadj=TGdwellHigh(:,1)*(ExposureTime+TimeDelay); %times adjeusted for time delays and/or exp times. All 'Time' up to this point is in frames
    %TGdwellLowadj=TGdwellLow(:,1)*(ExposureTime+TimeDelay);
    %For ecdf 
    KPdwellHighadj=[];
    KPdwellHighadj(:,1)=KPdwellHigh(:,1)*(ExposureTime+TimeDelay); %times adjeusted for time delays and/or exp times. All 'Time' up to this point is in frames
    KPdwellHighadj(:,2)=KPdwellHigh(:,2); %carry along censor notations

    
    %ecdf (KAPLAN-MEIER w/ Censored data)
    y = KPdwellHighadj(:,1);
    cens = KPdwellHighadj(:,2);
    figure(9)
    ecdf(y,'censoring',cens,'function','survivor');
    [ff,xx]=ecdf(KPdwellHighadj(:,1),'censoring',KPdwellHighadj(:,2),'function','survivor');
%    ecdf(ff,'censoring',xx,'function','survivor');
    title9=strcat('KaplanMeierSurvival',savename);
    title(title9)
    savefig(title9)
    saveas(gcf,title9,'png')
       
    
    y = KPdwellHighadj(:,1);
    figure(10)
    ecdf(y,'function','survivor');
    [ff,xx]=ecdf(KPdwellHighadj(:,1),'function','survivor');


    %ecdf all high dwells
    [fff,xxx]=ecdf(TGdwellHighadj,'function','survivor');
    figure(13)
    plot(xxx,fff)
    title13=strcat('All Dwells Survival',savename);
    title(title13)
    savefig(title13)
    saveas(gcf,title13,'png')
    
    %ecdf with log10 y axis    ffff=log10(ff);
    figure(15)
    stairs(xxx,log10(fff))
    hold on

    title10=strcat('Log10 KaplanMeierSurvival',savename);
    title(title10)
    savefig(title10)
    saveas(gcf,title10,'png')
    
    
    %TGdwellHigh Hist
    figure(11)
    histogram(TGdwellHighadj,15)
    title11=strcat('Dwell High Hist',savename);
    title(title11)
    savefig(title11)
    saveas(gcf,title11,'png') 
    
    %KPdwellHigh Hist
    figure(12)
    histogram(KPdwellHighadj(:,1),15)
    title12=strcat('KP Dwell High Hist',savename);
    title(title12)
    savefig(title12)
    saveas(gcf,title12,'png')    
   
    %save('DwellTimes','TGdwellHigh','TGdwellLow','TGdwellLowadj','TGdwellHighadj','HighRate','xx','ff','KPdwellHighadj')
    save('DwellTimes','TGdwellHigh','TGdwellHighadj','HighRate','xx','ff','KPdwellHighadj','FRETonRate','LowTime','piefracts')
    
end

if isempty(TransTimeHist)==0
    %Histogram of Transition Times
    figure(13)
    histogram(TransTimeHist,15)
    title13=strcat('Transition Time Hist',savename);
    title(title13)
    savefig(title13)
    saveas(gcf,title13,'png')     
    
    
    %Scatter plot of Transition start and end fret values
    figure(14)
    scatter(State1m,State3m)
    axis([0 inf -0.2 1.2]);
    xlabel('Initial FRET','FontWeight','bold');
    ylabel('Final FRET','FontWeight','bold');
    title14=strcat('ScatterInitialFinalFRET',savename);
    title(title14)
    savefig(title14)
    saveas(gcf,title14,'png')       
    
    
    
    
    
end






toc

%% Saving Data
save('workspaceVars','-v7.3')
%save the above input parameters
save('inputparam.mat','selectoption','savesize','usebpass','boxwidth','period','LowerSthresh','UpperSthresh','FRETupperThresh','FretlowerThresh','NHEJthresh','TranScan','AveScan','TimeDelay','ExposureTime')
%Save data for further analysis
save('SaveTraces.mat','SaveTraces')
%selected traces for replotting later
save('TraceSave.mat','TraceSave')
%save('forvbFRET.mat','forvbFRET');
save ('forvbFRET.mat','-struct', 'forvbFRET');
%save('forvbFRET2.mat','forvbFRET');
save ('forvbFRET2.mat','-struct', 'forvbFRET2');



%%
%2017 11 01 for plotting comparisons
[f,x]=hist(WT25,60);%# create histogram from a normal distribution.
%#METHOD 2: DIVIDE BY AREA
figure(1)
stairs(x,f/trapz(x,f));hold on
figure(2)
stairs(x,f);hold on

WT4=[];
K104E02=[];%[0,0.5,0.5]
TG02=[];
count1=1;
for i =1:length(TGdwellHigh_WT4)
    if TGdwellHigh_WT4(i,2)==0 || TGdwellHigh_WT4(i,2)==2
        WT4(count1,1)=TGdwellHigh_WT4(i,1);
        count1=count1+1;
    end
end
        
    
    y = WT4(:,1);
    figure(3)
    ecdf(y,'function','survivor','bounds','on');
    [ff,xx,lwBound,upBound]=ecdf(WT4(:,1),'function','survivor');
    hold on 
    figure(4)
    stairs(xx,log10(ff),'Color',[0,0.5,0.5])
    hold on
    area
      
 %% FRETonset analysis

     
 Cy5onsetCat=[];
 for n=2:1:length(forvbFRET2.onsetlabels)
     Cy5onsetCat=vertcat(Cy5onsetCat,forvbFRET2.Cy5onset{n});
 end
 
 [sortval, sortorder]=sort(Cy5onsetCat); 
 
 for i=1:length(sortval)
     sortval(i,2)=Cy5onsetCat(sortorder(i,1),2);
 end
 Cy5onsetSort=sortval;
 
 normfactor=40000;
 normCy5=Cy5onsetSort(:,2)/normfactor;
 for i=length(Cy5onsetSort):-1:2
     if Cy5onsetSort(i,1)==Cy5onsetSort(i-1,1)
         Cy5onsetSort(i-1,2)=(Cy5onsetSort(i-1,2)+Cy5onsetSort(i,2))/2;
         Cy5onsetSort(i,:)=[];
         normCy5(i-1,1)=(normCy5(i-1,1)+normCy5(i,1))/2;
         normCy5(i,:)=[];
     end
 end
 
 
 figure
 scatter(sortval(:,1),sortval(:,2))
 hold on
 plot(Cy5onsetSort(:,1),Cy5onsetSort(:,2))

   figure
   
   plot(Cy5onsetSort(:,1),normCy5(:,1)) 
    
    
    
