#include <TMB.hpp>
template<class Type>
Type objective_function<Type>::operator() ()
{
  using namespace R_inla;
  using namespace density;
  using namespace Eigen;
  
  // Input Data
  
  DATA_INTEGER(nHFs);
  DATA_INTEGER(nMonths);

  DATA_MATRIX(Nmic); // [dim: nHFs x 72]
  DATA_MATRIX(Ntot); // [dim: nHFs x 72]
  DATA_MATRIX(temporal_spline_matrix); // [dim: 3 x 72]
  
  // Parameters
  
  PARAMETER(mean_intercept);
  PARAMETER_VECTOR(mean_spline_slopes); // [length: 3]
  PARAMETER(log_shrinkage_sd);
  PARAMETER_VECTOR(local_spline_intercepts); // [length: nHFs]
  PARAMETER_ARRAY(local_spline_slopes); // [dim: nHfs x 3]

  // Parameter Transforms

  Type shrinkage_sd = exp(log_shrinkage_sd);
  matrix<Type> splines(nHFs,nMonths);
  for (int i=0; i<nHFs; i++) {
    for (int j=0; j<nMonths; j++) {
      splines(i,j) = local_spline_intercepts[i] + mean_intercept;
      for (int k=0; k<3; k++) {
        splines(i,j) = splines(i,j) + (local_spline_slopes(i,k)+mean_spline_slopes[k])*temporal_spline_matrix(k,j);
      }
      splines(i,j) = invlogit(splines(i,j));
    }
  }
  
  // // Priors

  Type nll = 0.0;

  nll -= dnorm(log_shrinkage_sd,Type(-1.0),Type(1.0));
  nll -= (dnorm(local_spline_intercepts,Type(0),shrinkage_sd,true)).sum();
  for (int i=0; i<nHFs; i++) {
    for (int j=0; j<3; j++) {
      nll -= dnorm(local_spline_slopes(i,j),Type(0),shrinkage_sd,true);
    }
  }
  

  // Likelihood

  for (int i=0; i<nHFs; i++) {
    for (int j=0; j<nMonths; j++) {
      if (Ntot(i,j)>0) {
        nll -= dbinom(Nmic(i,j),Ntot(i,j),splines(i,j),true);
      }
    }
  }
  
  // Reporting

  REPORT(splines);

  return nll;
}
