close all;
clear all;
clc;

bin_width=10;
edges=0:bin_width:260;

source_path = uigetdir(pwd,'Choose source directory');
dest_path = uigetdir(pwd,'Choose destination directory');

input_filename = dir(source_path);
input_filename = input_filename(3:end,1);

if mod(size(input_filename,1),4)~=0
    warningMessage = sprintf('Error: Missing masks. Check that all images have 3 masks');
	uiwait(warndlg(warningMessage));
    fprintf(1, 'Finished running batch_histogram.m.\n');
	return;
end
j=1;
k=1;
m=1;
n=1;
for i = 1 : size(input_filename,1)
    if contains(input_filename(i).name,'_ftsA.tif')
        ftsA_filenames{j}=[source_path,'\',input_filename(i).name];
        j=j+1;
    elseif contains(input_filename(i).name,'_ftsZ.tif')
        ftsZ_filenames{k}=[source_path,'\',input_filename(i).name];
        k=k+1;
    elseif contains(input_filename(i).name,'_membrane.tif')
        membrane_filenames{m}=[source_path,'\',input_filename(i).name];
        m=m+1;
    else
        base_filenames{n}=[source_path,'\',input_filename(i).name];
        n=n+1;
    end  
end

ftsA_counts=zeros(size(base_filenames,2),size(edges,2)-1);
ftsZ_counts=zeros(size(base_filenames,2),size(edges,2)-1);
membrane_counts=zeros(size(base_filenames,2),size(edges,2)-1);

for i = 1 : size(base_filenames,2)
    if contains(ftsA_filenames{i},base_filenames{i}(1:end-4)) && contains(ftsZ_filenames{i},base_filenames{i}(1:end-4)) && contains(membrane_filenames{i},base_filenames{i}(1:end-4))
        ftsA_mask=imread(ftsA_filenames{i});
        ftsZ_mask=imread(ftsZ_filenames{i});
        membrane_mask=imread(membrane_filenames{i});
        ftsA_mask_bw=imbinarize(ftsA_mask(:,:,1));
        ftsZ_mask_bw=imbinarize(ftsZ_mask(:,:,1));
        membrane_mask_bw=imbinarize(membrane_mask(:,:,1));

        I=imread(base_filenames{i});
        I=I(:,:,1);
        ftsA_filter=I(ftsA_mask_bw);
        ftsZ_filter=I(ftsZ_mask_bw);
        membrane_filter=I(membrane_mask_bw);
        
        ftsA_start=regexpi(ftsA_filenames{i},'[^\\]+$','match');
        ftsZ_start=regexpi(ftsZ_filenames{i},'[^\\]+$','match');
        membrane_start=regexpi(membrane_filenames{i},'[^\\]+$','match');
        
        imwrite(I+200*uint8(ftsA_mask_bw),[dest_path,'\',ftsA_start{1}])
        imwrite(I+200*uint8(ftsZ_mask_bw),[dest_path,'\',ftsZ_start{1}])
        imwrite(I+200*uint8(membrane_mask_bw),[dest_path,'\',membrane_start{1}])
        [ftsA_counts(i,:),~]=histcounts(ftsA_filter,edges);
        [ftsZ_counts(i,:),~]=histcounts(ftsZ_filter,edges);
        [membrane_counts(i,:),~]=histcounts(membrane_filter,edges);
    else
        warningMessage = sprintf('Error: filename mismatch.');
        uiwait(warndlg(warningMessage));
        fprintf(1, 'Finished running batch_histogram.m.\n');
        return;
    end  
end

ftsA_sheet=cat(2,ftsA_filenames',num2cell(ftsA_counts));
ftsZ_sheet=cat(2,ftsZ_filenames',num2cell(ftsZ_counts));
membrane_sheet=cat(2,membrane_filenames',num2cell(membrane_counts));

xlswrite([dest_path,'\output.xlsx'],ftsA_sheet,1);
xlswrite([dest_path,'\output.xlsx'],ftsZ_sheet,2);
xlswrite([dest_path,'\output.xlsx'],membrane_sheet,3);

