close all;
clear all;
clc;

source_path = uigetdir(pwd,'Choose source directory');
dest_path = uigetdir(pwd,'Choose destination directory');

input_filename = dir(source_path);
input_filename = input_filename(3:end,1);

if mod(size(input_filename,1),6)~=0
    warningMessage = sprintf('Error: Missing masks. Check that all images have 5 masks');
	uiwait(warndlg(warningMessage));
    fprintf(1, 'Finished running batch_histogram.m.\n');
	return;
end
j=1;
k=1;
m=1;
n=1;
c=1;
p=1;
for i = 1 : size(input_filename,1)
    if contains(input_filename(i).name,'_ftsA.tif')
        ftsA_filenames{j}=[source_path,'\',input_filename(i).name];
        j=j+1;
    elseif contains(input_filename(i).name,'_ftsZ.tif')
        ftsZ_filenames{k}=[source_path,'\',input_filename(i).name];
        k=k+1;
    elseif contains(input_filename(i).name,'_membrane.tif')
        membrane_filenames{m}=[source_path,'\',input_filename(i).name];
        m=m+1;
    elseif contains(input_filename(i).name,'_cytoplasm.tif')
        cytoplasm_filenames{c}=[source_path,'\',input_filename(i).name];
        c=c+1;
    elseif contains(input_filename(i).name,'_PG.tif')
        pg_filenames{p}=[source_path,'\',input_filename(i).name];
        p=p+1;
    else
        base_filenames{n}=[source_path,'\',input_filename(i).name];
        n=n+1;
    end  
end

ftsA_counts=NaN(size(base_filenames,2),6000);
ftsZ_counts=NaN(size(base_filenames,2),6000);
membrane_counts=NaN(size(base_filenames,2),6000);
cytoplasm_counts=NaN(size(base_filenames,2),6000);
pg_counts=NaN(size(base_filenames,2),6000);

for i = 1 : size(base_filenames,2)
    if contains(ftsA_filenames{i},base_filenames{i}(1:end-4)) && contains(ftsZ_filenames{i},base_filenames{i}(1:end-4)) && contains(membrane_filenames{i},base_filenames{i}(1:end-4)) && contains(cytoplasm_filenames{i},base_filenames{i}(1:end-4)) && contains(pg_filenames{i},base_filenames{i}(1:end-4))
        ftsA_mask=imread(ftsA_filenames{i});
        ftsZ_mask=imread(ftsZ_filenames{i});
        membrane_mask=imread(membrane_filenames{i});
        cytoplasm_mask=imread(cytoplasm_filenames{i});
        pg_mask=imread(pg_filenames{i});
        ftsA_mask_bw=imbinarize(ftsA_mask(:,:,1));
        ftsZ_mask_bw=imbinarize(ftsZ_mask(:,:,1));
        membrane_mask_bw=imbinarize(membrane_mask(:,:,1));
        cytoplasm_mask_bw=imbinarize(cytoplasm_mask(:,:,1));
        pg_mask_bw=imbinarize(pg_mask(:,:,1));

        I=imread(base_filenames{i});
        I=I(:,:,1);
        ftsA_filter=I(ftsA_mask_bw);
        ftsZ_filter=I(ftsZ_mask_bw);
        membrane_filter=I(membrane_mask_bw);
        cytoplasm_filter=I(cytoplasm_mask_bw);
        pg_filter=I(pg_mask_bw);
        
        ftsA_start=regexpi(ftsA_filenames{i},'[^\\]+$','match');
        ftsZ_start=regexpi(ftsZ_filenames{i},'[^\\]+$','match');
        membrane_start=regexpi(membrane_filenames{i},'[^\\]+$','match');
        cytoplasm_start=regexpi(cytoplasm_filenames{i},'[^\\]+$','match');
        pg_start=regexpi(pg_filenames{i},'[^\\]+$','match');
        
        imwrite(I+200*uint8(ftsA_mask_bw),[dest_path,'\',ftsA_start{1}])
        imwrite(I+200*uint8(ftsZ_mask_bw),[dest_path,'\',ftsZ_start{1}])
        imwrite(I+200*uint8(membrane_mask_bw),[dest_path,'\',membrane_start{1}])
        imwrite(I+200*uint8(cytoplasm_mask_bw),[dest_path,'\',cytoplasm_start{1}])
        imwrite(I+200*uint8(pg_mask_bw),[dest_path,'\',pg_start{1}])
        ftsA_counts(i,1:length(ftsA_filter))=ftsA_filter';
        ftsZ_counts(i,1:length(ftsZ_filter))=ftsZ_filter';
        membrane_counts(i,1:length(membrane_filter))=membrane_filter';
        cytoplasm_counts(i,1:length(cytoplasm_filter))=cytoplasm_filter';
        pg_counts(i,1:length(pg_filter))=pg_filter';
    else
        warningMessage = sprintf('Error: filename mismatch.');
        uiwait(warndlg(warningMessage));
        fprintf(1, 'Finished running batch_analyze.m.\n');
        return;
    end  
end

ftsA_sheet=cat(2,ftsA_filenames',num2cell(ftsA_counts));
ftsZ_sheet=cat(2,ftsZ_filenames',num2cell(ftsZ_counts));
membrane_sheet=cat(2,membrane_filenames',num2cell(membrane_counts));
cytoplasm_sheet=cat(2,cytoplasm_filenames',num2cell(cytoplasm_counts));
pg_sheet=cat(2,pg_filenames',num2cell(pg_counts));

xlswrite([dest_path,'\output.xlsx'],ftsA_sheet,1);
xlswrite([dest_path,'\output.xlsx'],ftsZ_sheet,2);
xlswrite([dest_path,'\output.xlsx'],membrane_sheet,3);
xlswrite([dest_path,'\output.xlsx'],cytoplasm_sheet,4);
xlswrite([dest_path,'\output.xlsx'],pg_sheet,5);

