close all;
clear all;
clc;

source_path = uigetdir(pwd,'Choose source directory');
dest_path = uigetdir(pwd,'Choose destination directory');


input_filename = dir(source_path);
input_filename = input_filename(3:end,1);

R_sheet=cell(400,length(input_filename));
G_sheet=cell(400,length(input_filename));
bin_sheet=cell(400,length(input_filename));
C_sheet=cell(400,2*length(input_filename));
c=1;
for i = 1 : length(input_filename)
    filename = [source_path,'\',char(input_filename(i).name)];
    I=imread(filename,1);
    R=I(:,:,1);
    G=I(:,:,2);
    B=I(:,:,3);
    R_num=sum(R,2);
    G_num=sum(G,2);
    G_tot=sum(G_num);
    bin_num= 1 : length(R_num);
    bin_num=bin_num/length(bin_num);
    R_sheet{1,i}=filename;
    G_sheet{1,i}=filename;
    bin_sheet{1,i}=filename;
    C_sheet{1,c}=filename;
    C_sheet{1,c+1}=filename;
    for j = 1 : length(R_num)
        R_sheet{j+1,i}=R_num(j);
        G_sheet{j+1,i}=G_num(j);
        bin_sheet{j+1,i}=bin_num(j);
        C_sheet{j+1,c}=bin_num(j);
        C_sheet{j+1,c+1}=G_num(j)/G_tot;
    end
    c=c+2;
end

xlswrite([dest_path,'\output.xlsx'],R_sheet,1);
xlswrite([dest_path,'\output.xlsx'],G_sheet,2);
xlswrite([dest_path,'\output.xlsx'],bin_sheet,3);
xlswrite([dest_path,'\output.xlsx'],C_sheet,4);

