% This M-file plots Figure 1 - Figure Supplement 1 panel C in the paper:
%
% Thalamus and claustrum control parallel layer 1 circuits in retrosplenial
% cortex by Ellen KW Brennan, Izabela Jedrasiak-Cape, Sameer Kailasa,
% Sharena P Rice, Shyam Kumar Sudhakar, and Omar J Ahmed.
% 
% Notes:
% - This script requires Matlab 2019a or later versions
% - This script requires Figure 1 - Source data 1 file
%   figure1_sourcedata_Rin.xlsx to be present in the same folder as
%   this script.



%% Reading input resistance values for each cell type from source data excel file

data=readmatrix('figure1_sourcedata_Rin.xlsx');   %insert source data file name here

LR = rmmissing(data(1, :));    %defines LR values as the first row in the source data file, ignoring empty cells
L3RS = rmmissing(data(2, :));  %defines L3 RS values as the second row in the source data file, ignoring empty cells
L5RS = rmmissing(data(3, :));  %defines L5 RS values as the third row in the source data file, ignoring empty cells

%% Calculate Mean and Standard Error of the Mean for each Cell Type
meanLR = mean(LR);
meanL3RS = mean(L3RS);
meanL5RS = mean(L5RS);
SEMLR = std(LR)/sqrt(length(LR));
SEML3RS = std(L3RS)/sqrt(length(L3RS));
SEML5RS = std(L5RS)/sqrt(length(L5RS));

%% Plot Data

figure;
hold on;

bar(1, mean(LR), 'FaceColor', '#ad71b4');       % plot mean input resistance for LR cells
errorbar(1, mean(LR), SEMLR, 'Color', 'k');     % plot SEM for LR cells

bar(2, mean(L3RS), 'FaceColor', '#89d1ff');     % plot mean input resistance for L3 RS cells
errorbar(2, mean(L3RS), SEML3RS, 'Color', 'k'); % plot SEM for L3 RS cells

bar(3, mean(L5RS), 'FaceColor', '#004d8a');     % plot mean input resistance for L5 RS cells
errorbar(3, mean(L5RS), SEML5RS, 'Color', 'k'); % plot SEM for L5 RS cells

xlim([0.5 3.5]);
set(gca,'Xtick',[1 2 3],'Xticklabel',{'LR', 'L3RS', 'L5RS'}); % X axis Cell Type Labels
ylabel('Input Resistance (MOhm)'); % Y axis label
