*MapSan Primary outcome effect analysis
*Table 2 source code
*Jackie Knee
*Stata 16
*created 23-Feb-2021
*last update:

*Purpose: To get main effect estimates for the pre-defined outcomes and exploratory outcomes using the main analysis (all children) and the two sub-group analyses

set rmsg on /* turn on timer for commands */
import excel "C:\Users\lshjk5.ADS\OneDrive - London School of Hygiene and Tropical Medicine\Georgia Tech One Drive\MapSan EL data\data analysis\stata\exported data\Table 2 source data 1.xlsx", firstrow  clear /* import Table 2 source code data 1 dataset into stata and clear out any other data from memory. */

*xtset with panelvar=compID (compound level clustering)
xtset compID

*Format string variables as numeric
destring gpp_coInf_noSal gpp_prim_noSal povNormal age_days age_sampDays , replace force

********************************************************************************
****** Outcome Descriptive Stats - main analyses (Table 2) *********************
********************************************************************************
 

* For pre-defined outcomes 
foreach x of varlist gpp_prim_noSal Kkany diarrhea {
tab `x' if phase_ml==0 & studyArm_b==0
tab `x' if phase_ml==0 & studyArm_b==1
}

foreach x of varlist gpp_prim_noSal Kkany diarrhea {
tab `x' if phase_ml==1 & studyArm_b==0
tab `x' if phase_ml==1 & studyArm_b==1
}

foreach x of varlist gpp_prim_noSal Kkany diarrhea {
tab `x' if phase_m24==1 & studyArm_b==0
tab `x' if phase_m24==1 & studyArm_b==1
}

* for all outcomes 
foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec gpp_yers gpp_chol gpp_par gpp_giar gpp_cryp gpp_enta gpp_vir gpp_noro gpp_aden gpp_rota gpp_coInf_noSal Kkany KKtrc Kkasc kk_coinf  {
tab `x' if phase_ml==0 & studyArm_b==0
tab `x' if phase_ml==0 & studyArm_b==1
}

foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec gpp_yers gpp_chol gpp_par gpp_giar gpp_cryp gpp_enta gpp_vir gpp_noro gpp_aden gpp_rota gpp_coInf_noSal Kkany KKtrc Kkasc kk_coinf  {
tab `x' if phase_ml==1 & studyArm_b==0
tab `x' if phase_ml==1 & studyArm_b==1
}

foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec gpp_yers gpp_chol gpp_par gpp_giar gpp_cryp gpp_enta gpp_vir gpp_noro gpp_aden gpp_rota gpp_coInf_noSal Kkany KKtrc Kkasc kk_coinf  {
tab `x' if phase_m24==1 & studyArm_b==0
tab `x' if phase_m24==1 & studyArm_b==1
}

********************************************************************************
****** DiD Analysis - 12M Main Analysis - all children *************************
********************************************************************************

*** pre-defined outcomes RISK RATIO ********************************************


*Univariable - 12M analysis
foreach x of varlist gpp_prim_noSal Kkany diarrhea {
xtgee `x' i.phase_ml_analysis##i.studyArm_binary, family(poisson) link(log) vce(robust) eform nolog 
}

*Multivariable - 12M analysis - predefined outcomes

*Primary outcome

xtgee gpp_prim_noSal i.phase_ml_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU, family(poisson) link(log) vce(robust) eform nolog 

*KKany outcomes

xtgee Kkany i.phase_ml_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU, family(poisson) link(log) vce(robust) eform nolog 

*Diarrhea
xtgee diarrhea i.phase_ml_analysis##i.studyArm_binary age_days female  povNormal carerEDU bl_hh_drophole_cover bl_hh_drinkwat_binary, family(poisson) link(log) vce(robust) eform nolog 

*** All outcomes RISK RATIO ****************************************************

*Univariable - 12M analysis
foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec   gpp_par gpp_giar gpp_cryp  gpp_vir gpp_noro gpp_aden  gpp_coInf_noSal  KKtrc Kkasc kk_coinf  {
xtgee `x' i.phase_ml_analysis##i.studyArm_binary, family(poisson) link(log) vce(robust) eform nolog 
}

* Multivariable - 12M analysis - all outcomes
*GPP
foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec   gpp_par gpp_giar gpp_cryp  gpp_vir gpp_noro gpp_aden  gpp_coInf_noSal {
xtgee `x' i.phase_ml_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU, family(poisson) link(log) vce(robust) eform nolog 
}

*KK outcomes
foreach x of varlist   KKtrc Kkasc kk_coinf  {
xtgee `x;' i.phase_ml_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU , family(poisson) link(log) vce(robust) eform nolog 
}

********************************************************************************
****** DiD Analysis - 24M Main Analysis - all children *************************
********************************************************************************


*** pre-defined outcomes RISK RATIO ********************************************

*Univariable - 24M analysis
foreach x of varlist gpp_prim_noSal Kkany diarrhea {
xtgee `x' i.phase_m24_analysis##i.studyArm_binary, family(poisson) link(log) vce(robust) eform nolog 
}
*Multivariable - 24M analysis - predefined outcomes

*Primary outcome
xtgee gpp_prim_noSal i.phase_m24_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU, family(poisson) link(log) vce(robust) eform nolog 

*KKany outcomes
xtgee Kkany i.phase_m24_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU , family(poisson) link(log) vce(robust) eform nolog 

*Diarrhea
xtgee diarrhea i.phase_m24_analysis##i.studyArm_binary age_days female  povNormal carerEDU bl_hh_drophole_cover bl_hh_drinkwat_binary, family(poisson) link(log) vce(robust) eform nolog 

*** All outcomes RISK RATIO ****************************************************

*Univariable - 24M analysis
foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec   gpp_par gpp_giar gpp_cryp  gpp_vir gpp_noro gpp_aden  gpp_coInf_noSal  KKtrc Kkasc kk_coinf  {
xtgee `x' i.phase_m24_analysis##i.studyArm_binary, family(poisson) link(log) vce(robust) eform nolog 
}

* Multivariable - 24M analysis - all outcomes
*GPP
foreach x of varlist gpp_prim_noSal gpp_bac_noSal gpp_shig gpp_etec gpp_camp gpp_cdif gpp_o157 gpp_stec   gpp_par gpp_giar gpp_cryp  gpp_vir gpp_noro gpp_aden  gpp_coInf_noSal {
xtgee `x' i.phase_m24_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU, family(poisson) link(log) vce(robust) eform nolog 
}

*KK outcomes
foreach x of varlist   KKtrc Kkasc kk_coinf  {
xtgee `x;' i.phase_m24_analysis##i.studyArm_binary age_sampDays female  povNormal carerEDU, family(poisson) link(log) vce(robust) eform nolog 
}
