*MapSan Primary outcome effect analysis
*Table 1 source code
*Jackie Knee
*Stata 16
*created 1-Mar-2021
*last update:

*Purpose: Produce descriptive statistics of baseline characteristics stratified by arm for Table 1. 

set rmsg on /* turn on timer for commands */
import excel "C:\Users\lshjk5.ADS\OneDrive - London School of Hygiene and Tropical Medicine\Georgia Tech One Drive\MapSan EL data\data analysis\stata\exported data\Table 1 source data 1.xlsx", firstrow  clear /* import Table 1 source code data 1 dataset into stata and clear out any other data from memory. */

*Format string variables as numeric
destring phase_ml studyArm_b totHHid compID female ch_respmom momalive carerEDU breast ch_exclbreast ch_diaper saferFeces age_sampDays age_days rainfall_sample drophole ventpipe pedestal drinkWat personsPerRoomCat hhCement hh_walls Hhsize  hhrooms persons_room povNormal latWall compElec compWatStand compWasteStand compAnyAnimal compDog compFowl compCat  compOtherAnimal compPoop compFlood compLat watPoint hl_den persons_latrine households_latrine persons_waterpoint CompPop numHH persons_latrine households_latrine , replace force


****** 1. Child-level variables ************************************************

*$tab
foreach x of varlist female ch_respmom momalive carerEDU breast ch_exclbreast ch_diaper saferFeces { 
tab `x' if phase_ml==0 & studyArm_b==0
}
foreach x of varlist female ch_respmom momalive carerEDU breast ch_exclbreast ch_diaper saferFeces { 
tab `x' if phase_ml==0 & studyArm_b==1
}

*$sum
foreach x of varlist age_sampDays age_days rainfall_sample {
sum `x' if phase_ml==0 & studyArm_b==0
}
foreach x of varlist age_sampDays age_days rainfall_sample {
sum `x' if phase_ml==0 & studyArm_b==1
}


****** 2. Household-level variables ********************************************

*Collapse data into HH-level variables
collapse compID phase_ml studyArm_binary drophole ventpipe pedestal drinkWat personsPerRoomCat hhCement hh_walls Hhsize  hhrooms persons_room povNormal latWall compElec compWatStand compWasteStand compAnyAnimal compDog compFowl compCat  compOtherAnimal compPoop compFlood compLat watPoint hl_den persons_latrine households_latrine persons_waterpoint CompPop numHH if phase_ml==0, by(totHHid)

*$tab
foreach x of varlist  drophole ventpipe pedestal drinkWat personsPerRoomCat hhCement hh_walls { 
tab `x' if phase_ml==0 & studyArm_b==0
}
foreach x of varlist  drophole ventpipe pedestal drinkWat personsPerRoomCat hhCement hh_walls { 
tab `x' if phase_ml==0 & studyArm_b==1
}

*$sum
foreach x of varlist Hhsize  hhrooms persons_room povNormal   {
sum `x' if phase_ml==0 & studyArm_b==0
}
foreach x of varlist Hhsize  hhrooms persons_room povNormal   {
sum `x' if phase_ml==0 & studyArm_b==1
}

 ****** 2. Compound-level variables ********************************************

*collapse data into compound-level variables
collapse phase_ml studyArm_binary latWall compElec compWatStand compWasteStand compAnyAnimal ///
compDog compFowl compCat  compOtherAnimal compPoop compFlood compLat watPoint hl_den persons_latrine ///
households_latrine persons_waterpoint CompPop numHH ///
if phase_ml==0, by(compID)

 *$tab
foreach x of varlist  latWall compElec compWatStand compWasteStand compAnyAnimal compDog compFowl compCat  compOtherAnimal compPoop compFlood { 
tab `x' if phase_ml==0 & studyArm_b==0
}
foreach x of varlist  latWall compElec compWatStand compWasteStand compAnyAnimal compDog compFowl compCat  compOtherAnimal compPoop compFlood { 
tab `x' if phase_ml==0 & studyArm_b==1
}

*$sum
foreach x of varlist compLat watPoint hl_den persons_latrine households_latrine persons_waterpoint CompPop numHH persons_latrine households_latrine {
sum `x' if phase_ml==0 & studyArm_b==0
}
 foreach x of varlist compLat watPoint hl_den persons_latrine households_latrine persons_waterpoint CompPop numHH persons_latrine  households_latrine {
sum `x' if phase_ml==0 & studyArm_b==1
}

 
 
 

