function model_state_xplot_200712_submit

% primitive state value model for dynamic choice task
% average multiple conditions to plot x-plot
% condition was optimized using behavior in 4 mix

% actual errors, short RT 33.6%, 
% short RT with choice 19.6%, with no choice 14.0%
% multiple/no poke 4.1%, total valid 62.1%
% choice error 8.8%, short water poke 0.49% (5.9% in error)

%state:ITI, all odor 1 2 odor port 1 2 3 4 5 water port 1 2 3 4 5 water
%action:odor poke, odor stay1-6, choice, water stay 1-5

%% adding perceptual noise

V_ChoiceB_odor_before = [];
V_ChoiceS_odor_before = [];
V_ChoiceB_odor_after = [];
V_ChoiceS_odor_after = [];

    odor_noise = 18; tau = 0.22; %best for softmax
%       odor_noise = 21; ep = 0; %best for deterministic
%     odor_noise = 16; %best for matching
%       odor_noise = 20; ep = 0.01;  %best for e-greedy
 
Norm = [];
figure
subplot(1,3,1)
xx = -100:5:200;
odorA = [0 35 65 100];
for i = 1:length(odorA)
norm = normpdf(xx,odorA(i),odor_noise); %mean and std
sum_norm = sum(norm(1:end));
norm = norm/sum_norm;

plot(xx,norm,'Linewidth',2)
% hold on
Norm = [Norm;norm];
end
xlabel('odor plus noise (%odorA)')
title('adding perceptual noise')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',10)
set(gcf,'color','w')
camroll(90)

correctL = (Norm(3,:)+Norm(4,:))./sum(Norm); %fraction of correct left for each subjective odor
subplot(1,3,2)
plot(correctL,'o-','markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = 20:10:40;
h.XTickLabel = {0:50:100};
xlabel('odor plus noise (%odorA)')
title('%L correct')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',10)
set(gcf,'color','w')


%% value and RPE function

x = correctL;

% RB = 1^0.7; %equal water
% RM = 1^0.7;
% RS = 1^0.7;

RB = 2.2^0.7; %different water amounts
RM = .8^0.7;
RS = .2^0.7;

VB_short = x*(RB+RM)/2;
VS_short = (1-x)*(RS+RM)/2;
choice_VB_short = VB_short./(VB_short + VS_short);
choice_VS_short = VS_short./(VB_short + VS_short);
V_short = 0.5*choice_VB_short.*VB_short + 0.5*choice_VS_short.*VS_short;

%short RT 34% (0.97^5 = 0.86), shortRT with no choice 14%
%short RT with choice 20% in all trial,22.7% in choice trials, multiple poke 4%, valid 62%

VB_wait_water5 = 0.8*x*(RB+RM)/2;
VB_wait_water4 = VB_wait_water5;
VB_wait_water3 = VB_wait_water4;
VB_wait_water2 = VB_wait_water3;
VB_wait_water1 = VB_wait_water2;
VS_wait_water5 = 0.8*(1-x)*(RS+RM)/2;
VS_wait_water4 = VS_wait_water5;
VS_wait_water3 = VS_wait_water4;
VS_wait_water2 = VS_wait_water3;
VS_wait_water1 = VS_wait_water2;

choice_softmax = softmax([(VB_wait_water5./(VB_wait_water5+VS_wait_water5))/tau;...
    (VS_wait_water5./(VB_wait_water5+VS_wait_water5))/tau]) %softmax normalized
choice_VB = choice_softmax(1,:);

% choice_VB = VB_wait_water5./(VB_wait_water5 + VS_wait_water5); %matching

% ind = find(VB_wait_water5>=VS_wait_water5);
% choice_VB = ep*ones(1,length(x));
% choice_VB(ind) = 1-ep; %epsilon-greedy strategy

choice_VS = 1-choice_VB;

V_wait_odor5 = 0.96*(choice_VB.*VB_wait_water1 + choice_VS.*VS_wait_water1);
V_wait_odor4 = 0.97*V_wait_odor5;
V_wait_odor3 = 0.97*V_wait_odor4;
V_wait_odor2 = 0.97*V_wait_odor3;
V_wait_odor1 = 0.97*V_wait_odor2;
V_all2 = 0.97*sum(sum(Norm).*(V_wait_odor1)/sum(sum(Norm))); %before identification of odor
V_all1 = V_all2; %before identification of odor
V_ITI = 0;

%medium time steps
V_choiceB = [zeros(length(x),1),V_all1*ones(length(x),1),V_wait_odor4',V_wait_odor5',...
    VB_wait_water1',VB_wait_water3',RM*ones(length(x),1)];
    
V_choiceS = [zeros(length(x),1),V_all1*ones(length(x),1),V_wait_odor4',V_wait_odor5',...
    VS_wait_water1',VS_wait_water3',RM*ones(length(x),1)];


autumnColors = colormap(autumn(6));
winterColors = colormap(winter(6));
plotColors = {winterColors(1,:),winterColors(2,:),winterColors(3,:),winterColors(4,:),winterColors(5,:),winterColors(6,:),...
    autumnColors(5,:),autumnColors(5,:),autumnColors(4,:),autumnColors(3,:),autumnColors(2,:),autumnColors(1,:)};

XTick_label = {'ITI','odor','port','water'};


%% map back onto experimenter odor

choiceL_eachOdor = Norm.*choice_VB; 
choiceR_eachOdor = Norm.*(1-choice_VB);
choiceL = sum(choiceL_eachOdor');
choiceR = sum(choiceR_eachOdor');

figure
subplot(1,4,1)
xx = -100:5:200;
for i = 1:length(odorA)
norm = normpdf(xx,odorA(i),odor_noise); %mean and std
sum_norm = sum(norm(1:end));
norm = norm/sum_norm;
plot(xx,norm,'k-','Linewidth',2)
hold on
end
h=gca;
h.YTick = [];
xlabel('odor plus noise (% odor big)')
title('adding perceptual noise')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',10)
set(gcf,'color','w')

subplot(1,4,2)
plot(100*correctL,'ko-','markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = 20:10:40;
h.XTickLabel = {0:50:100};
h.YTick = 0:50:100;
h.XTickLabel = {0:50:100};
axis([20 40 0 100])
xlabel('odor plus noise (% odor big)')
ylabel('choice big (%)')
title('correct choice for each subjective odor')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',10)
set(gcf,'color','w')

subplot(1,4,3)
plot(100*choice_VB,'ko-','markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = 20:10:40;
h.XTickLabel = {0:50:100};
h.YTick = 0:50:100;
h.XTickLabel = {0:50:100};
axis([20 40 0 100])
xlabel('odor plus noise (% odor big)')
ylabel('choice big (%)')
title('choice for each subjective odor')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',10)
set(gcf,'color','w')

xxx = 100*ones(1,length(odorA));
beta_choiceL = glmfit(odorA, [100*choiceL' xxx'], 'binomial', 'logit');
x = 0:100;
yfit_choiceL = glmval(beta_choiceL, x, 'logit');
subplot(1,4,4)
plot(odorA,100*choiceL,'ko','markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
plot(x,100*yfit_choiceL,'k-','Linewidth',2)
h=gca;
h.XTick = 0:50:100;
h.XTickLabel = {0:50:100};
h.YTick = 0:50:100;
h.XTickLabel = {0:50:100};
xlabel('odor (%odor big)')
ylabel('choice big (%)')
title('choice for each odor')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',10)
set(gcf,'color','w')

n_odor = length(odorA);
outcome1 = [zeros(n_odor/2,1);RM*ones(n_odor/2,1)];
outcome2 = [RM*ones(n_odor/2,1);zeros(n_odor/2,1)];
outcomeB = [zeros(n_odor/2,1);RB*ones(n_odor/2,1)];
outcomeS = [RS*ones(n_odor/2,1);zeros(n_odor/2,1)];
outcomeMB = [zeros(n_odor/2,1);(RB+RM)*ones(n_odor/2,1)/2];
outcomeMS = [(RM+RS)*ones(n_odor/2,1)/2;zeros(n_odor/2,1)];

V_choiceB_odor = [];
for i = 1:length(odorA)
V_choiceB_odor = [V_choiceB_odor;sum(V_choiceB.*choiceL_eachOdor(i,:)')/choiceL(i)];
end

V_choiceB_odor_waterB = [V_choiceB_odor(:,1:(end-1)),outcomeMB,outcomeB];
V_choiceB_odor_waterM = [V_choiceB_odor(:,1:(end-1)),outcomeMB,outcome1];
V_choiceB_odor = [V_choiceB_odor(:,1:(end-1)),outcomeMB,outcomeMB];

V_choiceS_odor = [];
for i = 1:length(odorA)
V_choiceS_odor = [V_choiceS_odor;sum(V_choiceS.*choiceR_eachOdor(i,:)')/choiceR(i)];
end

V_choiceS_odor_waterS = [V_choiceS_odor(:,1:(end-1)),outcomeMS,outcomeS];
V_choiceS_odor_waterM = [V_choiceS_odor(:,1:(end-1)),outcomeMS,outcome2];
V_choiceS_odor = [V_choiceS_odor(:,1:(end-1)),outcomeMS,outcomeMS];

plotColors = {winterColors(1,:),winterColors(3,:),winterColors(4,:),winterColors(6,:),...
    autumnColors(5,:),autumnColors(4,:),autumnColors(3,:),autumnColors(1,:)};
XTick_label2 = {'ITI','odor','','','port','','water',''};

%state value
scrsz = get(groot,'ScreenSize');
figure('Position',[1 scrsz(4)/1.5 scrsz(3)/1.5 scrsz(4)/1.5])
subplot(3,2,1)
for i = 1:size(V_choiceB_odor,1)
plot(1:size(V_choiceB_odor,2),V_choiceB_odor(i,:),'o-','Color',plotColors{n_odor+1-i},'markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
end
h=gca;
h.XTick = [1:size(V_choiceB_odor,2)];
h.XTickLabel = XTick_label2;
title('state value choice big')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

subplot(3,2,2)
for i = 1:size(V_choiceB_odor,1)
plot(1:size(V_choiceB_odor,2),[0,diff(V_choiceB_odor(i,:))],'o-','Color',plotColors{n_odor+1-i},'markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
end
h=gca;
h.XTick = [1:size(V_choiceB_odor,2)];
h.XTickLabel = XTick_label2;
title('state value prediction error')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

subplot(3,2,3)
for i = 1:size(V_choiceS_odor,1)
plot(1:size(V_choiceS_odor,2),V_choiceS_odor(i,:),'o-','Color',plotColors{2*n_odor+1-i},'markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
end
h=gca;
h.XTick = [1:size(V_choiceS_odor,2)];
h.XTickLabel = XTick_label2;
title('state value choice small')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

subplot(3,2,4)
for i = 1:size(V_choiceS_odor,1)
plot(1:size(V_choiceS_odor,2),[0,diff(V_choiceS_odor(i,:))],'o-','Color',plotColors{2*n_odor+1-i},'markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
end
h=gca;
h.XTick = [1:size(V_choiceS_odor,2)];
h.XTickLabel = XTick_label2;
title('state value prediction error')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

subplot(3,2,5)
plot(1:size(V_choiceS_odor,2),V_choiceB_odor(4,:),'o-','Color',plotColors{1},'markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
plot(1:size(V_choiceS_odor,2),V_choiceS_odor(1,:),'o-','Color',plotColors{8},'markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = [1:size(V_choiceS_odor,2)];
h.XTickLabel = XTick_label2;
title('state value')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

subplot(3,2,6)
plot(1:size(V_choiceS_odor,2),[0,diff(V_choiceB_odor(4,:))],'o-','Color',plotColors{1},'markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
plot(1:size(V_choiceS_odor,2),[0,diff(V_choiceS_odor(1,:))],'o-','Color',plotColors{8},'markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = [1:size(V_choiceS_odor,2)];
h.XTickLabel = XTick_label2;
title('state value prediction error')
legend('choice big easy','choice small easy')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')


%% response versus odor evidence

figure
subplot(1,2,1)
plot(1:n_odor,diff(V_choiceB_odor(:,[1,3])'),'bo-','markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
plot(1:n_odor,diff(V_choiceS_odor(:,[1,3])'),'ro-','markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = 1:n_odor;
h.XTickLabel = odorA;
legend('choice big','choice small')
title('before choice')
xlabel('odor Big (%)')
ylabel('TD error')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

subplot(1,2,2)
plot(1:n_odor,diff(V_choiceB_odor(:,4:5)'),'bo-','markersize',10,'markerfacecolor','w','Linewidth',2)
hold on
plot(1:n_odor,diff(V_choiceS_odor(:,4:5)'),'ro-','markersize',10,'markerfacecolor','w','Linewidth',2)
h=gca;
h.XTick = 1:n_odor;
h.XTickLabel = odorA;
legend('choice big','choice small')
title('after choice')
xlabel('odor Big (%)')
ylabel('TD error')
box off
set(gca,'tickdir','out')
set(gca,'TickLength',2*(get(gca,'TickLength')))
set(gca,'FontSize',15)
set(gcf,'color','w')

V_ChoiceB_odor_before = [V_ChoiceB_odor_before; diff(V_choiceB_odor(:,[1,3])')];
V_ChoiceS_odor_before = [V_ChoiceS_odor_before; diff(V_choiceS_odor(:,[1,3])')];
V_ChoiceB_odor_after = [V_ChoiceB_odor_after; diff(V_choiceB_odor(:,4:5)')];
V_ChoiceS_odor_after = [V_ChoiceS_odor_after; diff(V_choiceS_odor(:,4:5)')];


end

