%%% To compute spike rate change due to SSFO stimulation.
close all
clear all

%%
data_path = ('X:\'); % modify to local path.

string_MDPFC_rate_data = strcat(data_path, 'Figure_1_source_data_1'); % MDPFC data location.
MDPFC_rate_data = load(string_MDPFC_rate_data);

string_MGBA1_rate_data = strcat(data_path, 'Figure_1_source_data_2'); % MGBA1 data location.
MGBA1_rate_data = load(string_MGBA1_rate_data);


%% Rate results for figure 1.
%%% Pool over data.
MDPFC_rate_data.RS_SSFO_rate_all = [MDPFC_rate_data.RS_SSFO_rate{1}; MDPFC_rate_data.RS_SSFO_rate{2}; MDPFC_rate_data.RS_SSFO_rate{3}; MDPFC_rate_data.RS_SSFO_rate{4}; MDPFC_rate_data.RS_SSFO_rate{5}];
MDPFC_rate_data.RS_base_rate_all = [MDPFC_rate_data.RS_base_rate{1}; MDPFC_rate_data.RS_base_rate{2}; MDPFC_rate_data.RS_base_rate{3}; MDPFC_rate_data.RS_base_rate{4}; MDPFC_rate_data.RS_base_rate{5}];
MDPFC_rate_data.FS_SSFO_rate_all = [MDPFC_rate_data.FS_SSFO_rate{1}; MDPFC_rate_data.FS_SSFO_rate{2}; MDPFC_rate_data.FS_SSFO_rate{3}; MDPFC_rate_data.FS_SSFO_rate{4}; MDPFC_rate_data.FS_SSFO_rate{5}];
MDPFC_rate_data.FS_base_rate_all = [MDPFC_rate_data.FS_base_rate{1}; MDPFC_rate_data.FS_base_rate{2}; MDPFC_rate_data.FS_base_rate{3}; MDPFC_rate_data.FS_base_rate{4}; MDPFC_rate_data.FS_base_rate{5}];

%%% Compute normalized rate change.
MDPFC_rate_data.RS_SSFO_normalized_rate_change = 100.* (MDPFC_rate_data.RS_SSFO_rate_all - MDPFC_rate_data.RS_base_rate_all)./MDPFC_rate_data.RS_base_rate_all; % [%] Across all animals.
MDPFC_rate_data.FS_SSFO_normalized_rate_change = 100.* (MDPFC_rate_data.FS_SSFO_rate_all - MDPFC_rate_data.FS_base_rate_all)./MDPFC_rate_data.FS_base_rate_all; % [%] Across all animals.
MDPFC_rate_data.MD_SSFO_normalized_rate_change = 100.* (MDPFC_rate_data.MD_SSFO_rate - MDPFC_rate_data.MD_base_rate)./MDPFC_rate_data.MD_base_rate; % [%] Across all animals.


%%% Pool over data.
MGBA1_rate_data.RS_SSFO_rate_all = [MGBA1_rate_data.RS_SSFO_rate{1}; MGBA1_rate_data.RS_SSFO_rate{2}; MGBA1_rate_data.RS_SSFO_rate{3}; MGBA1_rate_data.RS_SSFO_rate{4}; MGBA1_rate_data.RS_SSFO_rate{5}];
MGBA1_rate_data.RS_base_rate_all = [MGBA1_rate_data.RS_base_rate{1}; MGBA1_rate_data.RS_base_rate{2}; MGBA1_rate_data.RS_base_rate{3}; MGBA1_rate_data.RS_base_rate{4}; MGBA1_rate_data.RS_base_rate{5}];
MGBA1_rate_data.FS_SSFO_rate_all = [MGBA1_rate_data.FS_SSFO_rate{1}; MGBA1_rate_data.FS_SSFO_rate{2}; MGBA1_rate_data.FS_SSFO_rate{3}; MGBA1_rate_data.FS_SSFO_rate{4}; MGBA1_rate_data.FS_SSFO_rate{5}];
MGBA1_rate_data.FS_base_rate_all = [MGBA1_rate_data.FS_base_rate{1}; MGBA1_rate_data.FS_base_rate{2}; MGBA1_rate_data.FS_base_rate{3}; MGBA1_rate_data.FS_base_rate{4}; MGBA1_rate_data.FS_base_rate{5}];

%%% Compute normalized rate change.
MGBA1_rate_data.RS_SSFO_normalized_rate_change = 100.* (MGBA1_rate_data.RS_SSFO_rate_all - MGBA1_rate_data.RS_base_rate_all)./MGBA1_rate_data.RS_base_rate_all; % [%] Across all animals.
MGBA1_rate_data.FS_SSFO_normalized_rate_change = 100.* (MGBA1_rate_data.FS_SSFO_rate_all - MGBA1_rate_data.FS_base_rate_all)./MGBA1_rate_data.FS_base_rate_all; % [%] Across all animals.
MGBA1_rate_data.MGB_SSFO_normalized_rate_change = 100.* (MGBA1_rate_data.MGB_SSFO_rate - MGBA1_rate_data.MGB_base_rate)./MGBA1_rate_data.MGB_base_rate; % [%] Across all animals.


writematrix(MDPFC_rate_data.RS_SSFO_normalized_rate_change, 'PFCRS_delta_rate_all_animals.xlsx')
writematrix(MDPFC_rate_data.FS_SSFO_normalized_rate_change, 'PFCFS_delta_rate_all_animals.xlsx')
writematrix(MDPFC_rate_data.MD_SSFO_normalized_rate_change, 'MD_delta_rate_all_animals.xlsx')
writematrix(MGBA1_rate_data.RS_SSFO_normalized_rate_change, 'A1RS_delta_rate_all_animals.xlsx')
writematrix(MGBA1_rate_data.FS_SSFO_normalized_rate_change, 'A1FS_delta_rate_all_animals.xlsx')
writematrix(MGBA1_rate_data.MGB_SSFO_normalized_rate_change, 'MGB_delta_rate_all_animals.xlsx')


%% Rate results for figure 1-S1.
n_animals=5;
% Same as above, but separated for each animal.
for i = 1:n_animals
    eval(strcat(sprintf('MDPFC_rate_data.RS_SSFO_normalized_rate_change_M%d',i), '= (MDPFC_rate_data.RS_SSFO_rate{i} - MDPFC_rate_data.RS_base_rate{i})./MDPFC_rate_data.RS_base_rate{i}'));
    eval(strcat(sprintf('MDPFC_rate_data.FS_SSFO_normalized_rate_change_M%d',i), '= (MDPFC_rate_data.FS_SSFO_rate{i} - MDPFC_rate_data.FS_base_rate{i})./MDPFC_rate_data.FS_base_rate{i}'));
    eval(strcat(sprintf('writematrix(MDPFC_rate_data.RS_SSFO_normalized_rate_change_M%d',i), ',',  sprintf('"PFCRS_delta_rate_M%d.xlsx")',i)));
    eval(strcat(sprintf('writematrix(MDPFC_rate_data.FS_SSFO_normalized_rate_change_M%d',i), ',',  sprintf('"PFCFS_delta_rate_M%d.xlsx")',i)));

    eval(strcat(sprintf('MGBA1_rate_data.RS_SSFO_normalized_rate_change_M%d',i), '= (MGBA1_rate_data.RS_SSFO_rate{i} - MGBA1_rate_data.RS_base_rate{i})./MGBA1_rate_data.RS_base_rate{i}'));
    eval(strcat(sprintf('MGBA1_rate_data.FS_SSFO_normalized_rate_change_M%d',i), '= (MGBA1_rate_data.FS_SSFO_rate{i} - MGBA1_rate_data.FS_base_rate{i})./MGBA1_rate_data.FS_base_rate{i}'));
    eval(strcat(sprintf('writematrix(MGBA1_rate_data.RS_SSFO_normalized_rate_change_M%d',i), ',',  sprintf('"A1RS_delta_rate_M%d.xlsx")',i)));
    eval(strcat(sprintf('writematrix(MGBA1_rate_data.FS_SSFO_normalized_rate_change_M%d',i), ',',  sprintf('"A1FS_delta_rate_M%d.xlsx")',i)));

end






















