function [PP,dt,TI] = Puls_V1(diffusion)

% This is a function, delivering all the pulse information which is needed 
% to simulate traces with software of the MakroSim- or SingleSim-family
% diffusion==1 is the flag, that diffusion is taken into account

np = 3;             % number of pulses 

dt = 0.1;           % constant timestep in all pulses in ms

PM = zeros(4,np);   % pulsmatrix PM
                    % number of columns equals the number of pulses

% in the first row of PM are the durations of each pulse
PM(1,1) = 100;    % duration 1. puls in ms
PM(1,2) = 500;    % duration 2. puls in ms
PM(1,3) = 1000;   % duration 3. puls in ms

% in the second row of PM are the voltages of each pulse
PM(2,1) = 0.0;      % voltage 1. puls in mV
PM(2,2) = 130;      % voltage 2. puls in mV
PM(2,3) = 0.0;      % voltage 3. puls in mV

% in the third row of PM are the ligand-concentrations of each pulse
PM(3,1) = 0.0;      % conzentration 1. puls in M (molar)
PM(3,2) = 2e6;      % conzentration 2. puls in M (molar)
PM(3,3) = 0.0;      % conzentration 3. puls in M (molar)

% in the fourth row of PM are the diffusion time-constants in ms
PM(4,1) = 0.0;      % first jump always zero
PM(4,2) = 5.0;      % jump from 1. to 2. pulse
PM(4,3) = 3.0;      % jump from 2. to 3. pulse

% Matrix TI for time-intervalls, only for SingleSim useful, if histograms
% are calculated in different time-intervals
TI = [];

% if diffusion is taken into account for concentration jumps
% approximation c = c0*(1-exp(t/tau))
% algorithm must be improved ...
if diffusion==1
    PP(:,1) = PM(:,1);                  % 1. puls unchainged    
    for i=2:np
        tau     = PM(4,i);
        U       = PM(2,i);
        Dauer   = PM(1,i);
        if tau~=0
            c_0     = PM(3,i-1);
            c_1     = PM(3,i);
            delta_c = c_1-c_0;
            L  = 10;                      %10 sub-pulses
            Lp = (0:0.1:1);
            Lp = Lp.^1.5;                 %not equidistant
            Lp = round(Lp*10*tau/dt);     %integer point numbers
            tp = Lp*dt;                         %starttimes of sub-pulses
            td = diff(tp);                      %duration of sub-pulses
            for j=1:L
                tm = (tp(j)+tp(j+1))/2;         %mean-time in sub-pulse
                c = c_0+delta_c*(1-exp(-tm/tau));  % mean concentration
                PP=[PP,[td(j);U;c;tau]];        % add sub-pulse
            end
            PP = [PP,[Dauer-tp(end);U;c_1;tau]]; % add remaining pulse
            
        else
            PP = [PP,PM(:,i)];      % this pulse without diffusion effect
        end   
    end    
else
    PP = PM;        % all pulses without diffusion effets
end
PP = PP(1:3,:);     % only rows 1 to 3 are transfered to main program

    
    


