function varargout = MakroSim_V46uint32(varargin)
% MAKROSIM_V46UINT32 MATLAB code for MakroSim_V46uint32.fig
%      MAKROSIM_V46UINT32, by itself, creates a new MAKROSIM_V46UINT32 or raises the existing
%      singleton*.
%
%      H = MAKROSIM_V46UINT32 returns the handle to a new MAKROSIM_V46UINT32 or the handle to
%      the existing singleton*.
%
%      MAKROSIM_V46UINT32('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MAKROSIM_V46UINT32.M with the given input arguments.
%
%      MAKROSIM_V46UINT32('Property','Value',...) creates a new MAKROSIM_V46UINT32 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before MakroSim_V46uint32_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to MakroSim_V46uint32_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help MakroSim_V46uint32

% Last Modified by GUIDE v2.5 02-Mar-2022 14:04:39

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @MakroSim_V46uint32_OpeningFcn, ...
                   'gui_OutputFcn',  @MakroSim_V46uint32_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before MakroSim_V46uint32 is made visible.
function MakroSim_V46uint32_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to MakroSim_V46uint32 (see VARARGIN)

% Choose default command line output for MakroSim_V46uint32

handles.output = hObject;
set(handles.AnzahlSimulationen,'String','1');
set(handles.AnzahlKanaele,'String','100');
handles.k = str2double(get(handles.AnzahlSimulationen,'String'));
handles.N = str2double(get(handles.AnzahlKanaele,'String'));
handles.plotfarbe=1;
title(handles.axes1,'mean open probability Po'); 
title(handles.axes2,'mean binding degree Bi');
title(handles.axes3,'sem open probability Po');
title(handles.axes4,'sem binding degree Bi');

guidata(hObject, handles);   % handles.fh1 wird in handles struktur aufgenommen
                
% UIWAIT makes MakroSim_V46uint32 wait for user response (see UIRESUME)
uiwait(handles.figure1);



% --- Outputs from this function are returned to the command line.
function varargout = MakroSim_V46uint32_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
delete(hObject); 


% --- Executes on button press in Zeitschritt_fest.
function Zeitschritt_fest_Callback(hObject, eventdata, handles)
% hObject    handle to Zeitschritt_fest (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Zeitschritt_fest

% Die handles-struktur aktualisieren
guidata(hObject, handles);
  
  

% --- Executes on button press in glatt.
function glatt_Callback(hObject, eventdata, handles)
% hObject    handle to glatt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of glatt


% --- Executes on button press in automatisch.
function automatisch_Callback(hObject, eventdata, handles)
% hObject    handle to automatisch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of automatisch


% --- Executes on button press in Zeitschritt_variabel.
function Zeitschritt_variabel_Callback(hObject, eventdata, handles)
% hObject    handle to Zeitschritt_variabel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Zeitschritt_variabel


% --- Executes on button press in Start.
function Start_Callback(hObject, eventdata, handles)
% hObject    handle to Start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%strommatrix=[];%zum Sammeln der Spaltenvektoren des Stromes jeder einzelnen Iteration Th.E.
userData.stop = false; %reset for next time
moreWork = true;
set(handles.Start,'BackgroundColor','red'); % START-BUTTON gedrckt ndert die Farbe auf rot
set(handles.figure1,'UserData',userData);

if get(handles.ueberschreiben,'Value')==false
    cla(handles.axes1); % Lscht (falls vorhanden) alle Grafiken im axes1
    cla(handles.axes2);
    cla(handles.axes3);
    cla(handles.axes4);
end

Puls = handles.Puls;

ns =  handles.ns;        % Anzahl Zustnde
nb =  handles.nb;        % max. Zahl Liganden
ubg=  handles.ubg;        % Zeilenvektor Bindungen
uc =  handles.uc;        % Zeilenvektor offene Zustnde
MV =  handles.MV;        % Array Spannungen
MK =  handles.MK;        % Array konzentrationsabhngig
MC =  handles.MC;        % Array Ratekonstanten
N_ch = handles.N;        % number of channels in the patch
N_it = handles.k;        % number of iterations to do
ub   = ubg/nb;

df = 0;                  % Diffusions-Flag: df=0 fr keine Diffusion 
if get(handles.cb_diff,'Value')==true % wenn Diffusion ausgewhlt
    df = 1;
end

[PP,dt,ZB] = feval(Puls,df);     % Pulse unter Beachtung ob Diffusion
set(handles.ed_dt,'string',num2str(dt));
AnzMP =  PP(1,:)/dt;             % Anzahl Messpunkte in Pulsen
np = length(PP(1,:));            % Anzahl Pulse
TimeMP =  PP(1,:);               % Zeitdauern der Pulse
AnzMP  =  TimeMP/dt;             % Anzahl Messpunkte in Pulsen
TimeMPkum = [0,cumsum(TimeMP)];  % kum. Pulzeiten ab NUll !
AnzMPkum  = cumsum(AnzMP);       % kumulative Messpunktzahlen


% Speicherplatz reservieren
STc = zeros(AnzMPkum(np),1);	% theor. Einzelkanalstrom
SMc = zeros(AnzMPkum(np),1);	% Summe der makroskopischen Strme
SQc = zeros(AnzMPkum(np),1);    % Summe der quadrierten makro Strme
STb = zeros(AnzMPkum(np),1);    % theor. Einzelkanalfluoreszenz
SMb = zeros(AnzMPkum(np),1);    % Summe der makroskopischen Fluoreszenzen
SQb = zeros(AnzMPkum(np),1);    % Summe der quadrierten makro Fluoros
STQc = zeros(AnzMPkum(np),1);
STQb = zeros(AnzMPkum(np),1);


if (N_ch==0&&N_it==0)
       warndlg('Please enter the number of channels N and the number of simulations k');
end

nMK = ones(ns,ns)- MK;          % Matrixwerte ohne Konzentrationen
CC  = zeros(ns,ns,np);          % Besetzung des CC - Arrays
ev3 = zeros(ns,ns,np);          % Besetzung des Eigenvektor-Arrays
ew3 = zeros(ns,np);             % Besetzung des Eigenwerte -Arrays
for pu = 1:np
    volt = PP(2,pu)*10^-3;            % Spannung im Puls in Volt
    konz = PP(3,pu)*10^-6;            % Konzentration im Puls in M
    C = (konz*MK.*MC+nMK.*MC).*exp(MV*volt);    % Ratekonstanten C-Matrix
    for i=1:ns                  % Hauptdiagonale von C berechnen
        C(i,i)=0;
        element=0;
        for j=1:ns
            element=element-C(j,i);
        end
        C(i,i)=element;
    end
    CC(:,:,pu) = C;              % alle C-Matrizen
    [ev,ew]   = eig(C);         % Eigenvektoren und Eigenwerte
    ev3(:,:,pu)= ev;            % np Matrizen mit Eigenvektoren
    ew3(:,pu)  = diag(ew);      % np Spalten mit Eigenwerten
end

GGWB = zeros(ns,np);            % Gleichgewichtsbesetzung fr jeden Puls
b = [zeros(ns-1,1);1];          % b-Vektor mit [0; 0; ...; 0; 1]
for pu = 1:np
    CG = CC(:,:,pu);            % C-Matrix des Pulses Nr. pu
    CG(end,:) = 1;
    GGWB(:,pu) = CG\b;          % Zustandsvektor im GGW des Pulses als Spaltenvektor
end

% Berechnung der theor. Kurven
% Besetzung erster Puls
nMP = PP(1,1)/dt;
zust = ones(ns,nMP);
for i = 1:nMP
    zust(:,i) = GGWB(:,1);
end
% Zustandsbesetzung in den weiteren Pulsen
x0 = GGWB(:,1);          % Anfang 2. Puls entspricht Ende des 1. Pulses
for pu = 2:np
    nMP = PP(1,pu)/dt;
    CG = CC(:,:,pu);
    t = (1:nMP)*dt;
    [ev,ew] = eig(CG);
    z = ev*(((ev\x0)*ones(1,nMP)).*exp(diag(ew)*t));
    zust = [zust,z];
    x0 = z(:,end);
end    
STc = (uc*zust)';                   % theoretischer Strom
STb = (ub*zust)';                   % theoretische Fluoreszenz
t     = (dt*(1:length(STc)))';
handles.STc  = STc;
handles.STb  = STb;
handles.STQc = sqrt(STc.*(1-STc)/N_ch/N_it);
handles.STQb = sqrt((((ub.*ub)*zust)'-STb.*STb)/N_ch/N_it);
handles.t    = t;
guidata(hObject,handles);


% Falls fester Zeitschritt gewhlt
 if get(handles.Zeitschritt_fest,'Value')==true 
    
    E = eye(ns);         % Einheitsmatrix, Spaltenvektoren sind Anfangszustnde
    D = ones(ns)-tril(ones(ns));  % obere Dreiecksmatrix mit Einsen belegt
    B = [];              % sicherheitshalber;
    % Berechnet fr jeden Puls und jeden mglichen Ausgangszustand (k)
    % die Matrix B.pmat
    for pu = 1:np
        EV = ev3(:,:,pu);    % Matrix der Eigenvektoren in Array
        for k = 1:ns
            Anf_Besetzung = E(:,k);                      % nur Zustand k besetzt
            B(pu,k).pmat  = EV*(diag(EV\Anf_Besetzung)); % .pmat von typ und k
        end
    end
    % Berechnung u. Speicherung der bergangswahrscheinlichkeitsmatrizen
    for pu =1:np    
       EW = ew3(:,pu);
       for k = 1:ns                       % k ist ein bestimmter Anfangszustand
         probl = B(pu,k).pmat*exp(EW*dt); % Wahrscheinlichkeiten nach dt
         TIS(pu).sprobl(:,k) = D*probl;   % summierte Wahrscheinlichkeiten 
       end
    end
    
    m=0;                                  % Zhler Anzahl der Messungen
    while (moreWork && m<N_it)
        m = m+1;
        set(handles.Zaehler,'String', m); %Zhler fr Simulationen
        drawnow;                          % Zhlerstand gleich anzeigen
        zust_0 = zeros(ns,AnzMPkum(np));
        zust_s = zeros(ns,AnzMPkum(np));  % Summe der Einzelstrme
        nr = 0;                           % Zhler fr Anzahl Einzelkanle
        while (moreWork && nr<N_ch)   
            %check if user hit STOP button
            userData = get(handles.figure1, 'UserData');
            if userData.stop == true
                userData.stop = false; %reset for next time
                set(handles.figure1,'UserData',userData);
                moreWork = false; %to stop the loop
            else
                nr = nr+1;
                set(handles.ZaehlerN,'String',nr); %Zhler fr Anzahl Kanle
                drawnow;                           % Zhlerstand gleich anzeigen
                zust = zust_0;                     % Nullmatrix fr Zustnde  
                sBesetzung = D*GGWB(:,1);          % summierte Besetzungswahrscheinlichkeiten
                a = rand(1,AnzMPkum(np)+1);        % Zufallsvektor  
                rz = find(sBesetzung<=a(end),1);   % Anfangsbesetzung (letzte Zufallszahl a noch frei ...) 
                j = 0;                             % Index fr gesamte Anzahl Messpunkte
                for pu = 1:np         
                    for i=1:AnzMP(pu)
                        j = j+1;
                        sBesetzung = TIS(pu).sprobl(:,rz); 
                        rz = find(sBesetzung<=a(j),1);
                        zust(:,j) = zust(:,j) + E(:,rz);
                    end
                end
                zust_s = zust_s + zust;
            end
        end % innere while schleife  
        zust = zust_s / N_ch;
        strom = (uc*zust)';
        fluor = (ub*zust)';
        SMc = SMc + strom;
        SQc = SQc + strom.*strom;
        SMb = SMb + fluor;
        SQb = SQb + fluor.*fluor;
        
    end % uere while schleife
end % Zeitschritt fest    
       
% Falls Zeitschritt variabel ausgewhlt
if get(handles.Zeitschritt_variabel,'Value')==true
    
    % Berechnung des zuflligen Anfangszustands im 1. Puls
    D = triu(ones(ns));    % obere (upper) Dreiecksmatrix mit Einsen belegt
    
    % Vor-Besetzung / wie nun richtig ???
    % Berechnung der voraussichtlichen Anzahl an Zustandsnderungen pro Puls
    NN = zeros(1,np);
    for pu = 1:np
        NN(pu) = round( -dt*AnzMP(pu)*(GGWB(:,pu)'*diag(CC(:,:,pu))) );
    end
    Ca_Anz_ges = sum(NN);
    Ca_Anz_ges = Ca_Anz_ges + 2.5*sqrt(Ca_Anz_ges);
    Ca_Anz_ges = round(2+Ca_Anz_ges);   % ungefhre Maximalzahl an Zustandsnderungen + 2

    m=0;                                  % Zhler Anzahl der Messungen
    while (moreWork && (m<N_it))
        m = m+1;
        set(handles.Zaehler,'String', m); %Zhler fr Simulationen
        drawnow;                          % Zhlerstand gleich anzeigen
        strom16 = uint32(zeros(AnzMPkum(np),1));  % leerer Einzelkanalstrom
        fluor16 = uint32(zeros(AnzMPkum(np),1));  % leere Einzelkanalfluoreszenz
        nr = 0;                           % Index fr Anzahl Einzelkanle
        while (moreWork && (nr<N_ch))   
            %check if user hit STOP button
            TiV = zeros(Ca_Anz_ges,1);         % Speicherplatzreservierung
            ZuV = int16(zeros(Ca_Anz_ges,1));  % Speicherplatzreservierung
            userData = get(handles.figure1, 'UserData');
            if userData.stop == true
                userData.stop = false; %reset for next time
                set(handles.figure1,'UserData',userData);
                moreWork = false; %to stop the loop
            else
                nr = nr+1;
                set(handles.ZaehlerN,'String',nr); %Zhler fr Anzahl Kanle
                drawnow;                           % gleich anzeigen
                
                % pulsweise Berechnung der Zustandsbesetzungen 
                sBesetzung = D*GGWB(:,1);       % summierte Besetzungswahrscheinlichkeiten
                % rz = find(sBesetzung <= rand,1);   % Anfangsbesetzung (letzte Zufallszahl a noch frei ...) 
                rz = max(find(sBesetzung>rand));     % zuflliger Zustand in
                
                
                i = 0;                             % Index der Verweilzeit
                t_ges = 0.;                        % kumulierte Gesamtzeit
                
                for pu = 1:np

                    t_pu_end = dt*AnzMPkum(pu);    % Zeitpunkt Ende Puls
                    Q = CC(:,:,pu)';            % transponierte C-Matrix von Puls pu ist Q-Matrix
                    VW = -abs(1./diag(Q));            % negative mittlere Verweildauern
                    Kum = Q - diag(diag(Q));    % erst Hauptdiagonale zu Null
                    Sum = sum(Kum,2);
                    Kum = (Kum>0).*cumsum(Kum,2);    % kumulative Summe in der Zeile

                    c=0;
                    while (moreWork && (t_ges < t_pu_end))    %check if user hit STOP button
                        userData = get(handles.figure1, 'UserData');
                        drawnow;
                        if userData.stop == true
                            userData.stop = false; %reset for next time
                            set(handles.figure1,'UserData',userData);
                            moreWork = false; %to stop the loop
                            c=1;
                        else
                            i  = i+1;
                            ZuV(i) = rz;                 % Nummer des Zustands eintragen
                            t_verw = VW(rz)*log(rand);   % Verweilzeit in Zustand rz
                            t_ges = t_ges+t_verw;        % kumulative Zeit
                            TiV(i)= t_ges;               % kumulative Zeit eintragen
                            z = rand*Sum(rz);                               % Zufallszahl zwischen 0 und Sum(zus)
                            rz = find(Kum(rz,:)>=z,1,'first');              % nchster Zustand
                        end  %if
                    end  %while-Schleife bis berschreitung Pulsdauer 

                    t_ges = t_pu_end;       % kumulative Zeit ist Pulsende
                    TiV(i)= t_ges;          % Pulsende eintragen
                    rz = ZuV(i);            % neuer Zustand ist weiterhin alter Zustand rz

                    if c==1
                        c=0;
                    else
                        %b=get(handles.ed_tges,'String');
                                      %  set(handles.ed_MomTime,'String',b); %Zhler fr Gesamtzeit
                    end
                end % alle Pulse abgearbeitet - es gibt i Werte in einem Einzelkanaltrace
                ZuV = ZuV(1:i);  % Falls zu langer Vektor reserviert
                TiV = TiV(1:i);  % Falls zu langer Vektor reserviert
                % Verweildauern an Pulsbergngen zusammenfhren
                % (dort gibt es i.a. zwei kum. Zeitwerte mit der selben Zustandsnummer rz)
                ZuV1 = [ZuV(2:end);0];
                ZuV1 = ZuV-ZuV1;
                ZuV  = ZuV(ZuV1~=0);
                TiV  = TiV(ZuV1~=0);
                
                % Berechnung der Stromdaten
                B  =  zeros(size(ZuV));      % reserviert fr die Plotdaten
                col=find(uc==1);    % Gibt Positionen wo in uc eine 1 steht als Zeilenvektor aus
                for l=1:length(col)
                    B(ZuV==col(l))=1; % Die Zustandsnummern der geffneten Zustnde werden durch 1 ersetzt,
                    %die der geschlossenen Zustnde bleiben auf Null 0
                end
                if sum(B)~=0
                    % Zusammenfhren von mehrfachen Zeiten 
                    ZuV1 = [B(2:end);0];
                    ZuV1 = B-ZuV1;
                    ZuV1(end) = 1;      % Letzter Punkt der Simulation ist auch Ende einer Verweildauer
                    ZuVc  = B(ZuV1~=0);
                    TiVc  = TiV(ZuV1~=0);
                    strom16 = strom16 + abtast1V10(ZuVc,TiVc,dt);
                end
                
                % Berechnung der Fluoreszenzdaten
                B  =  zeros(size(ZuV));      % reserviert fr die Plotdaten
                for i=1:nb          % durchluft alle Ligandenzahlen von 1 beginnend
                    col=find(ubg==i); % Gibt Positionen wo in ubg ein i steht als Zeilenvektor aus
                    for l=1:length(col)
                        B(ZuV==col(l))=i;  %schreibt die entsprechende ganz Zahl i in B rein
                    end
                end
                if sum(B)~=0
                    % Zusammenfhren von mehrfachen Zeiten 
                    ZuV1 = [B(2:end);0];
                    ZuV1 = B-ZuV1;
                    ZuV1(end) = 1;      % Letzter Punkt der Simulation ist auch Ende einer Verweildauer
                    ZuVc  = B(ZuV1~=0);
                    TiVc  = TiV(ZuV1~=0);
                    fluor16 = fluor16 + abtast1V10(ZuVc,TiVc,dt);
                end
            end
        end % innere while Schleife
        strom = double(strom16)/N_ch;
        % strommatrix=[strommatrix strom];%Anhngen des neu simulierten Strom-Spaltenvektors
        SMc = SMc + strom;
        SQc = SQc + strom.*strom;
        fluor = double(fluor16)/N_ch/nb;
        SMb = SMb + fluor;
        SQb = SQb + fluor.*fluor;
        
    end % uere while Schleife
end % Zeitschritt variabel 

% Die richtigen Daten zum Plotten eintragen
if get(handles.glatt,'Value')==true
    SMc = STc;
    SMb = STb;
    SQc = STQc;
    SQb = STQb;
else     
    if N_it==1
            SQc = zeros(AnzMPkum(np),1);
            SQb = zeros(AnzMPkum(np),1);
    else
            SQc = (SQc-SMc.*SMc/N_it);
                        
            SQc = sqrt(SQc/(N_it-1)/N_it);	 % Standardabweichung mittlerer Makro-Trace
            SMc = SMc/N_it;						    % das sind jetzt die Mittelwerte Strom
            SQb = sqrt((SQb-SMb.*SMb/N_it)/(N_it-1)/N_it);	 % Standardabweichung mittlerer Makro-Trace
            SMb = SMb/N_it;                         % das sind jetzt die Mittelwerte Fluor
    end
end
% handles-Daten zum Plotten
handles.SMc = SMc;
handles.SQc = SQc;
handles.SMb = SMb;
handles.SQb = SQb;
guidata(hObject, handles);

handles = plotten4(handles);               % Simulationen in alle 4 axes plotten
if get(handles.mit_glatterKurve,'Value')==true 
    handles = plotten_glatt_neu(handles);    % ggf. glatte Kurven plotten
end
set(handles.Start,'BackgroundColor','green'); % wechselt die Farbe wieder auf grn 

%if get(handles.automatisch,'Value')==true    
%end   

% Die handles-struktur aktualisieren
%xlswrite('C:\Thomas Eick\Temp\strommatrix',strommatrix);%Th.E.
guidata(hObject, handles);



% --- Executes on button press in Stop.
function Stop_Callback(hObject, eventdata, handles)
% hObject    handle to Stop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
userData = get(handles.figure1, 'UserData');
userData.stop = true;
set(handles.figure1,'UserData',userData);


function AnzahlKanaele_Callback(hObject, eventdata, handles)
% hObject    handle to AnzahlKanaele (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AnzahlKanaele as text
%        str2double(get(hObject,'String')) returns contents of AnzahlKanaele as a double

 handles.N = str2double(get(hObject,'String'));  % Variable N=Anzahl Kanle
 
 % Die handles-struktur aktualisieren
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function AnzahlKanaele_CreateFcn(hObject,eventdata, handles)
% hObject    handle to AnzahlKanaele (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function AnzahlSimulationen_Callback(hObject, eventdata, handles)
% hObject    handle to AnzahlSimulationen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AnzahlSimulationen as text
%        str2double(get(hObject,'String')) returns contents of AnzahlSimulationen as a double

handles.k = str2double(get(hObject,'String'));  % Variable k=Anzahl Simulationen
 
 % Die handles-struktur aktualisieren
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function AnzahlSimulationen_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AnzahlSimulationen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%-----------------------------------------------------------------------
function Zaehler_Callback(hObject, eventdata, handles)
% hObject    handle to Zaehler (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Zaehler as text
%        str2double(get(hObject,'String')) returns contents of Zaehler as a double


%-----------------------------------------------------------------------

% --- Executes during object creation, after setting all properties.
function Zaehler_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Zaehler (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%-----------------------------------------------------------------------

% --- Executes on button press in close.
    function close_Callback(hObject, eventdata, handles)
% hObject    handle to close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isfield(handles,'N')==1
    Abfrage = questdlg('save?','title','yes','no','no'); 
    % hier 2mal 'Nein' um ein zweites Element (DEFAULT='Nein') hinzuzufgen
    if strcmp(Abfrage, 'yes') 
        warndlg('Please use the options in the menue bar');     
    else
        close(handles.figure1);         %Fenster schlieen
    end

end




% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
uiresume(handles.figure1);


% --- Executes during object creation, after setting all properties.
function axes1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes1


% --- Executes during object creation, after setting all properties.
function axes2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes2


% --- Executes during object creation, after setting all properties.
function axes3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes3


% --- Executes during object creation, after setting all properties.
function axes4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes4


% --- Executes on button press in mit_glatterKurve.
function mit_glatterKurve_Callback(hObject, eventdata, handles)
% hObject    handle to mit_glatterKurve (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of mit_glatterKurve

handles = plotten_glatt(handles);
guidata(hObject, handles);




% --------------------------------------------------------------------

% --------------------------------------------------------------------
function load_model_Callback(hObject, eventdata, handles)
% hObject    handle to load_model (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    

% --------------------------------------------------------------------
function Pulsprotokoll_Callback(hObject, eventdata, handles)
% hObject    handle to Pulsprotokoll (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
 

% --------------------------------------------------------------------
function EXCEL_abspeichern_Callback(hObject, eventdata, handles)
% hObject    handle to EXCEL_abspeichern (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
  


% --------------------------------------------------------------------
function Pulsprotokoll_neu_laden_Callback(hObject, eventdata, handles)
% hObject    handle to Pulsprotokoll_neu_laden (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
 [FileNameP,PathNameP]=uigetfile('*.m');
    if FileNameP~=0      % Nur wenn ein file ausgewhlt wurde
        FilePathP=fullfile(PathNameP,FileNameP);
        set(handles.Pulsname,'String',FileNameP);
         Pulsname=get(handles.Pulsname, 'String');
    handles.Puls=Pulsname(1:end-2);
    Spannung_Konzentration(hObject,handles);
    end
% Die handles-struktur aktualisieren
guidata(hObject, handles);
    
    
function Spannung_Konzentration(hObject,handles)
a=0;
if get(handles.cb_diff,'Value')==true % wenn Diffusion ausgewhlt
    a=1;
end
[PP,dt,ZB] = feval(handles.Puls,a);

n=[];
C=[];
U=[];

set(handles.ed_dt,'string',num2str(dt));  % Zeitschritt eintragen

c= PP(3,:); % Konzentration
i=length(c);
for m=1:i
    C=[C,c(m),c(m)];
end

u= PP(2,:); %Spannung
i=length(u);
for m=1:i
    U=[U,u(m),u(m)];
end

%fr das Darstellen der Zeit
a=PP(1,:);
b=length(a);
i=b-1;   % letzten Wert weg schneiden
a=cumsum(a);
for m=1:i
    n=[n,a(m),a(m)];
end
x=[0,n,a(i+1)];

axes(handles.axes5);   % Axes 5 ausgewhlt
ymin = min(U)-0.1*(max(U)-min(U));
ymax = max(U)+0.1*(max(U)-min(U));
if ymin==ymax
    if ymin==0
        ymin=-1;
        ymax=1;
    else
        a=ymin;
        b=abs(a);
        ymin=a-0.5*b;
        ymax=a+0.5*b;
    end
end    
xmin=min(x);
xmax=max(x);
plot(x,U); %Spannung plotten
hold on;
plot(x,zeros(size(x)),':k');
hold off;
axis([xmin, xmax, ymin, ymax]);
xlabel('t in ms');
ylabel('U in mV');

axes(handles.axes7);   % Axes 7 ausgewhlt
ymin = min(C)-0.1*(max(C)-min(C));
ymax = max(C)+0.1*(max(C)-min(C));
if ymin==ymax
    if ymin==0
        ymin=-1;
        ymax=1;
    else
        a=ymin;
        b=abs(a);
        ymin=a-0.5*b;
        ymax=a+0.5*b;
    end
end    
xmin=min(x);
xmax=max(x);
plot(x,C); %Konzentration plotten
hold on;
plot(x,zeros(size(x)),':k');
hold off;
axis([xmin, xmax, ymin, ymax]);
xlabel('t in ms');
ylabel('c in M');
% Die handles-struktur aktualisieren
guidata(hObject, handles);
    
% --------------------------------------------------------------------
function Modell_neu_laden_Callback(hObject, eventdata, handles)
% hObject    handle to Modell_neu_laden (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileNameM,PathNameM]=uigetfile('*.m');
    if FileNameM~=0      % Nur wenn ein file ausgewhlt wurde
        FilePathM=fullfile(PathNameM,FileNameM);
        set(handles.Modellname,'String',FileNameM);
     end
    Modellname=get(handles.Modellname, 'String');
    Modell=Modellname(1:end-2);  
    
    Modell();  % Modelldaten einlesen
    y=nargout(Modell);

 if y==6
      [MC,MK,MV,uc,ubg,nb] = feval(Modell);  % Modelldaten einlesen   
 else
      [MC,MK,uc,ubg,nb] = feval(Modell);  % Modelldaten einlesen
      MV = zeros(length(MC(1,:)));
 end
 
    handles.ns  = length(MC(1,:));         % Anzahl Zustnde
    handles.nb  = nb;                      % max. Zahl Liganden  
    handles.ubg = ubg;                      % Zeilenvektor Bindungen
    handles.uc  = uc;                      % Zeilenvektor offene Zustnde
    handles.MV  = MV;                      % Array Spannungen
    handles.MK  = MK;                      % Array konzentrationsabhngig?
    handles.MC  = MC;                      % Array Ratekonstanten
    handles.Modell=Modell;
    % Die handles-struktur aktualisieren
guidata(hObject, handles);



% --------------------------------------------------------------------
function Verschiebehand_OffCallback(hObject, eventdata, handles)
% hObject    handle to Verschiebehand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
pan off;


% --------------------------------------------------------------------
function Verschiebehand_OnCallback(hObject, eventdata, handles)
% hObject    handle to Verschiebehand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h = pan;
set(h,'Motion','both','Enable','on');


% --------------------------------------------------------------------
function Data_Cursor_OffCallback(hObject, eventdata, handles)
% hObject    handle to Data_Cursor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
datacursormode off

% --------------------------------------------------------------------
function Data_Cursor_OnCallback(hObject, eventdata, handles)
% hObject    handle to Data_Cursor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
datacursormode on


% --------------------------------------------------------------------
function Zoom_in_OffCallback(hObject, eventdata, handles)
% hObject    handle to Zoom_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function Zoom_in_OnCallback(hObject, eventdata, handles)
% hObject    handle to Zoom_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h = zoom;
set(h,'Motion','both','Enable','on','Direction', 'in');
% zoom in direction:both aber auch 'horizontal'|'vertical' mglich

% --------------------------------------------------------------------
function zoom_OUT_OffCallback(hObject, eventdata, handles)
% hObject    handle to zoom_OUT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h = zoom;
set(h,'Motion','horizontal','Enable','off','Direction', 'out');

% --------------------------------------------------------------------
function zoom_OUT_OnCallback(hObject, eventdata, handles)
% hObject    handle to zoom_OUT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h = zoom;
set(h,'Motion','both','Enable','on','Direction', 'out');



function ZaehlerN_Callback(hObject, eventdata, handles)
% hObject    handle to ZaehlerN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ZaehlerN as text
%        str2double(get(hObject,'String')) returns contents of ZaehlerN as a double


% --- Executes during object creation, after setting all properties.
function ZaehlerN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ZaehlerN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function mit_glatterKurve_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mit_glatterKurve (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes on button press in cb_diff.
function cb_diff_Callback(hObject, eventdata, handles)
% hObject    handle to cb_diff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of cb_diff
Pulsname=get(handles.Pulsname,'String');
if (strcmp(Pulsname(end-1:end),'.m'))% wenn Pulsprotokoll geladen
    Spannung_Konzentration(hObject,handles); 
else
    warndlg('Please load pulse file')      
end

%-------------------------------------------------------------------------
function SV = abtast1V10(ZuV,TiV,dt)

% in der Matrix M gibt es zwei Spalten
% erste Spalte: Zustand ein(1) bzw. aus(0)
% zweite Spalte: kumulierte Zeit einschlielich Endzeit !

Zu = uint32(ZuV);      %Signal/Zustand aus der 2.Spalte der M-Matrix
te = TiV(end);
tg = TiV/dt;           %Zeitpunkte mit Zustandsnderung in gespreizter
L  = te/dt + 1;           %Lnge quidistanter Zeitvektor
SV = uint32(zeros(L,1));  %Signal-Vektor in qudistanten Zeitschritten    

j=1;                      % Index j ist fr tg- und Zu-Vektor
                          % Index i ist fr qidistanten Vektor SV
for i=1:L;
    while tg(j) < i-1
        j = j+1;
    end
    SV(i)=Zu(j);
end
SV(1)=[];


%-------------------------------------------------------------------------

% --- Executes on button press in ueberschreiben.
function ueberschreiben_Callback(hObject, eventdata, handles)
% hObject    handle to ueberschreiben (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ueberschreiben


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



function handles=plotten4(handles)

t  = handles.t;
y1 = handles.SMc;
y2 = handles.SMb;
y3 = handles.SQc;
y4 = handles.SQb;

xmin = min(t);
xmax = max(t); %Maximum x-Achse

if get(handles.ueberschreiben,'Value')==true
   handles.plotfarbe=handles.plotfarbe+1;
else
   handles.plotfarbe=1;
end

handles.plotfarbe = mod(handles.plotfarbe-1,5)+1;

if handles.plotfarbe==1
    farbe='b'; % 1.Kurve: blau
end
if handles.plotfarbe==2
    farbe='g'; % 2.Kurve: grn 
end
if handles.plotfarbe==3
    farbe='y'; % 3.Kurve: gelb
end
if handles.plotfarbe==4
    farbe=[0 0.9 1]; % 4.Kurve: hellblau 
end
if handles.plotfarbe==5
    farbe=[0.8 0 0];% 5.Kurve: weinrot
end


axes(handles.axes1);
if get(handles.ueberschreiben,'Value')==false
    plot(t,y1,'b');
else
    hold(handles.axes1,'on');
    plot(t,y1,'Color',farbe);
    hold(handles.axes1,'off');
end  

ymax = max(y1);
ymin = 0.0 - 0.1*ymax;
ymax = 1.1*ymax;
if (ymin<ymax)
    set(gca,'xlim',[xmin,xmax],'ylim',[ymin, ymax]);
end
 
   
axes(handles.axes2);
if get(handles.ueberschreiben,'Value')==false
    plot(t,y2,'b');
else
    hold(handles.axes2,'on');
    plot(t,y2,'Color',farbe);
    hold(handles.axes2,'off');
end    
ymax = max(y2);
ymin = 0.0 - 0.1*ymax;
ymax = 1.1*ymax;
if (ymin<ymax)
    set(gca,'xlim',[xmin,xmax],'ylim',[ymin, ymax]);
end
   
axes(handles.axes3);
if get(handles.ueberschreiben,'Value')==false
    plot(t,y3,'b');
else
    hold(handles.axes3,'on');
    plot(t,y3,'Color',farbe);
    hold(handles.axes3,'off');
end    
ymax = max(y3);
ymin = 0.0 - 0.1*ymax;
ymax = 1.1*ymax;
if (ymin<ymax)
    set(gca,'xlim',[xmin,xmax],'ylim',[ymin, ymax]);
end

axes(handles.axes4);
if get(handles.ueberschreiben,'Value')==false
    plot(t,y4,'b');
else
    hold(handles.axes4,'on');
    plot(t,y4,'Color',farbe);
    hold(handles.axes4,'off');
end    
ymax = max(y4);
ymin = 0.0 - 0.1*ymax;
ymax = 1.1*ymax;
if (ymin<ymax)
    set(gca,'xlim',[xmin,xmax],'ylim',[ymin, ymax]);
end

    
title(handles.axes1,'mean open probability Po');
title(handles.axes2,'mean binding degree Bi');
title(handles.axes3,'sem open probability Po');
title(handles.axes4,'sem binding degree Bi');


%------------------------------------------------------------------------
%-----------------------------------------------------------------------
function handles = plotten_glatt(handles)
    
if get(handles.mit_glatterKurve,'Value')==true 
    t  = handles.t;
    y1 = handles.STc;
    y2 = handles.STb;
    y3 = handles.STQc;
    y4 = handles.STQb;
    hold(handles.axes1,'on');
    handles.a1=plot(handles.axes1,t,y1,'r');
    hold(handles.axes1,'off');
    hold(handles.axes2,'on');
    handles.a2=plot(handles.axes2,t,y2,'r');
    hold(handles.axes2,'off');
    hold(handles.axes3,'on');
    handles.a3=plot(handles.axes3,t,y3,'r');
    hold(handles.axes3,'off');
    hold(handles.axes4,'on');
    handles.a4=plot(handles.axes4,t,y4,'r');
    hold(handles.axes4,'off');
else
    if isfield(handles,'a1')
            delete(handles.a1);
            delete(handles.a2);
            delete(handles.a3);
            delete(handles.a4);
    end    
end 


function handles = plotten_glatt_neu(handles)
    
t  = handles.t;
y1 = handles.STc;
y2 = handles.STb;
y3 = handles.STQc;
y4 = handles.STQb;
hold(handles.axes1,'on');
handles.a1=plot(handles.axes1,t,y1,'r');
hold(handles.axes1,'off');
hold(handles.axes2,'on');
handles.a2=plot(handles.axes2,t,y2,'r');
hold(handles.axes2,'off');
hold(handles.axes3,'on');
handles.a3=plot(handles.axes3,t,y3,'r');
hold(handles.axes3,'off');
hold(handles.axes4,'on');
handles.a4=plot(handles.axes4,t,y4,'r');
hold(handles.axes4,'off');

%----------------------------------------------------------------------

%EXCEL
% --------------------------------------------------------------------
function simulierte_Strom_Mittelwerte_Callback(hObject, eventdata, handles)
% hObject    handle to simulierte_Strom_Mittelwerte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true 
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Strom_MW','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end
            
            %**********************************************
            %Hier Eckis Programm abgewandelt:
            %Eine Matrix (Zeiten,mittlere Stromwerte), bestehend aus zwei
            %Spalten, wird als mat-File mit dem Namen
            %"strommittelwerte" im aktuellen Matlabverzeichnis abgespeichert
            %(unabhngig davon, was fr ein Pfad und Name fr die
            %abzuspeichernde Excel-Datei gewhlt wird.
            %strommittelwerte=[handles.t,handles.SMc];
            %save('strommittelwerte','strommittelwerte');
            %Wenn ursprnglicher Zustand von Eckis Programm
            %wieder hergestellt werden soll, dann alles zwischen den
            %**** Befindliche entfernen oder auskommentieren
            %und den Befehl xlswrite wieder einkommentieren
            %*****************************************************
            xlswrite (FilePath,[handles.t,handles.SMc]);
        end
    end

   if get(handles.glatt,'Value')==true
     DefaultName = ['Strom_Glatt','.xls'];
     [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        xlswrite(FilePath,handles.STc');
     end
   end
end



% --------------------------------------------------------------------
function simulierte_Standardabweichungen_Stroeme_Callback(hObject, eventdata, handles)
% hObject    handle to simulierte_Standardabweichungen_Stroeme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Strom_SAW','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.SQc]);
        end
    end

   
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end

% --------------------------------------------------------------------
function theoretische_Strom_Werte_Callback(hObject, eventdata, handles)
% hObject    handle to theoretische_Strom_Werte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Strom_Werte','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.STc]);
        end
    end

   if get(handles.glatt,'Value')==true
     DefaultName = ['Strom_Glatt','.xls'];
     [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        xlswrite(FilePath,handles.STc);
     end
   end
end

% --------------------------------------------------------------------
function theoretische_Standardabweichungen_Stroeme_Callback(hObject, eventdata, handles)
% hObject    handle to theoretische_Standardabweichungen_Stroeme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Strom_SAW','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.STQc]);
        end
    end

      
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end

% --------------------------------------------------------------------
function simulierte_Fluoreszenz_Mittelwerte_Callback(hObject, eventdata, handles)
% hObject    handle to simulierte_Fluoreszenz_Mittelwerte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Fluor_MW','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.SMb]);
        end
    end

   if get(handles.glatt,'Value')==true
     DefaultName = ['Fluor_Glatt','.xls'];
     [FileName,PathName]=uiputfile('*.xls','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        xlswrite(FilePath,handles.STb);
     end
   end
end



% --------------------------------------------------------------------
function simulierte_Standardabweichungen_Fluoreszenz_Callback(hObject, eventdata, handles)
% hObject    handle to simulierte_Standardabweichungen_Fluoreszenz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Fluor_SAW','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.SQb]);
        end
    end

   
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end




% --------------------------------------------------------------------
function theoretische_Fluoreszenz_Werte_Callback(hObject, eventdata, handles)
% hObject    handle to theoretische_Fluoreszenz_Werte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Fluor_Werte','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.STb]);
        end
    end

   if get(handles.glatt,'Value')==true
     DefaultName = ['Fluor_Glatt','.xls'];
     [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        xlswrite(FilePath,handles.STb);
     end
   end
end

% --------------------------------------------------------------------
function theoretische_Standardabweichungen_Fluoreszenz_Callback(hObject, eventdata, handles)
% hObject    handle to theoretische_Standardabweichungen_Fluoreszenz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


if isfield(handles,'N')==1
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Flour_SAW','.xls'];
        [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);

            %wenn Datei schon vorhanden
            if exist(FileName, 'file') == 2

                %ffne Excel-File "xfile" via ActiveX
                xobject = actxserver('Excel.Application');
                xworkbook = xobject.workbooks.Open(FilePath);
                xworksheets = xobject.sheets;

                h2=1;
                try
                    %Alle Zellen whlen und lschen
                    range = get(xworksheets.Item(h2),'Range','A1','IV65536');
                    set(range, 'Value',{''});
                catch
                    %Warnung, falls "xsheet" nicht gefunden wird
                    warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

                end
                %Schliee Excel-File
                xworkbook.Save;
                xworkbook.Close(false);
                xobject.Quit;
                delete(xobject);
            end

            xlswrite (FilePath,[handles.t,handles.STQb]);
        end
    end

      
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end



%CSV
% ----------------------------------------------------------------------------
% ----------------------------------------------------------------------------

function csv_abspeichern_Callback(hObject, eventdata, handles)
% hObject    handle to csv_abspeichern (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function csv_simulierte_Strom_Mittelwerte_Callback(hObject, eventdata, handles)
% hObject    handle to csv_simulierte_Strom_Mittelwerte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     
    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
     N=handles.N;
     k=handles.k; 
     DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Strom_MW','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.SMc);
     end
   end
   
    if get(handles.glatt,'Value')==true
     DefaultName = ['Strom_Glatt','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.STc);
     end
   end
end

% --------------------------------------------------------------------
function csv_simulierte_Standardabweichungen_Stroeme_Callback(hObject, eventdata, handles)
% hObject    handle to csv_simulierte_Standardabweichungen_Stroeme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     
    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
     N=handles.N;
     k=handles.k; 
     DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Strom_SAW','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.SQc);
     end
   end
   
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end
% --------------------------------------------------------------------
function csv_theoretische_Strom_Werte_Callback(hObject, eventdata, handles)
% hObject    handle to csv_theoretische_Strom_Werte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     
    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
     N=handles.N;
     k=handles.k; 
     DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Strom_Werte','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.STc);
     end
   end
   
    if get(handles.glatt,'Value')==true
     DefaultName = ['Fluor_Glatt','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.STc);
     end
   end
end

% --------------------------------------------------------------------
function csv_theoretische_Standardabweichungen_Stroeme_Callback(hObject, eventdata, handles)
% hObject    handle to csv_theoretische_Standardabweichungen_Stroeme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     
    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
     N=handles.N;
     k=handles.k; 
     DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Strom_SAW','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.STQc);
     end
   end
   
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end

% --------------------------------------------------------------------
function csv_simulierte_Fluoreszenz_Mittelwerte_Callback(hObject, eventdata, handles)
% hObject    handle to csv_simulierte_Fluoreszenz_Mittelwerte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
    
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Fluor_MW','.csv'];
        [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);
            csvwrite(FilePath,handles.SMb);
        end
    end
    
    if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
    end
end

% --------------------------------------------------------------------
function csv_simulierte_Standardabweichungen_Fluoreszenz_Callback(hObject, eventdata, handles)
% hObject    handle to csv_simulierte_Standardabweichungen_Fluoreszenz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     
    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
     N=handles.N;
     k=handles.k; 
     DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_Fluor_SAW','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.SQb);
     end
   end
   
   if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
   end
end
% --------------------------------------------------------------------
function csv_theoretische_Fluoreszenz_Werte_Callback(hObject, eventdata, handles)
% hObject    handle to csv_theoretische_Fluoreszenz_Werte (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
    
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Fluor_Werte','.csv'];
        [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);
            csvwrite(FilePath,handles.STb);
        end
    end
    
    if get(handles.glatt,'Value')==true
     DefaultName = ['Strom_Glatt','.csv'];
     [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        csvwrite(FilePath,handles.STb);
     end
    end
end

% --------------------------------------------------------------------
function csv_theoretische_Standardabweichungen_Fluoreszenz_Callback(hObject, eventdata, handles)
% hObject    handle to csv_theoretische_Standardabweichungen_Fluoreszenz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
    
     if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        N=handles.N;
        k=handles.k;
        DefaultName = [num2str(k),'_Sim_N_',num2str(N),'_theor_Fluor_SAW','.csv'];
        [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);
            csvwrite(FilePath,handles.STQb);
        end
    end
    
    if get(handles.glatt,'Value')==true
        warndlg('Achtung hier ist die Standardabweichung gleich Null');
    end
end

% --------------------------------------------------------------------
function csv_alles_speichern_Callback(hObject, eventdata, handles)
% hObject    handle to csv_alles_speichern (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1

    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        DefaultName = [num2str(handles.k),'_Sim_N_',num2str(handles.N)];
        [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);
            csvwrite (FilePath,[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb]);
        end
    end
        if get(handles.glatt,'Value')==true
            DefaultName = ['GlattSim'];
            [FileName,PathName]=uiputfile('*.csv','save EXCEL-file',DefaultName);
            if FileName~=0      % Nur wenn ein file ausgewhlt wurde
                FilePath=fullfile(PathName,FileName);
                %csvwrite (FilePath,[handles.t,handles.STc,handles.STQc,handles.STb,handles.STQb]);
                csvwrite (FilePath,[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb]);
            end
        end      
end



% --------------------------------------------------------------------
function alles_speichern_Callback(hObject, eventdata, handles)
% hObject    handle to alles_speichern (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isfield(handles,'N')==1
     
    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
     N  = handles.N;
     k  = handles.k; 
     DefaultName = [num2str(k),'_Sim_N_',num2str(N)];
     [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
     if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        
        %wenn Datei schon vorhanden
        if exist(FileName, 'file') == 2

        %ffne Excel-File "xfile" via ActiveX 
        xobject = actxserver('Excel.Application'); 
        xworkbook = xobject.workbooks.Open(FilePath); 
        xworksheets = xobject.sheets; 

        h2=1;
        try
            %Alle Zellen whlen und lschen
            range = get(xworksheets.Item(h2),'Range','A1','IV65536');
            set(range, 'Value',{''});
        catch
            %Warnung, falls "xsheet" nicht gefunden wird
            warndlg(['Achtung: Blatt "' xsheet '" nicht gefunden!'],'Fehler');

        end 
       %Schliee Excel-File 
        xworkbook.Save; 
        xworkbook.Close(false); 
        xobject.Quit; 
        delete(xobject); 
        end    
        
        if get(handles.mit_glatterKurve,'Value')==true
             xlswrite (FilePath,[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb]);
         end
        end
   end
end   

if get(handles.glatt,'Value')==true
    DefaultName = ['GlattSim'];
    [FileName,PathName]=uiputfile('*.xls','save EXCEL-file',DefaultName);
    if FileName~=0      % Nur wenn ein file ausgewhlt wurde
        FilePath=fullfile(PathName,FileName);
        xlswrite (FilePath,[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb]);
    end
end 


% --------------------------------------------------------------------
function Daten_laden_Callback(hObject, eventdata, handles)
% hObject    handle to Daten_laden (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% --------------------------------------------------------------------
function matfile_speichern_Callback(hObject, eventdata, handles)
% hObject    handle to matfile_speichern (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isfield(handles,'N')==1

    if get(handles.Zeitschritt_fest,'Value')==true || get(handles.Zeitschritt_variabel,'Value')==true
        DefaultName = [num2str(handles.k),'_Sim_N_',num2str(handles.N)];
        [FileName,PathName]=uiputfile('*.csv','save ASCII-file',DefaultName);
        if FileName~=0      % Nur wenn ein file ausgewhlt wurde
            FilePath=fullfile(PathName,FileName);
            csvwrite (FilePath,[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb]);
        end
    end
        if get(handles.glatt,'Value')==true
            DefaultName = ['GlattSim'];
            [FileName,PathName]=uiputfile('*.csv','save EXCEL-file',DefaultName);
            if FileName~=0      % Nur wenn ein file ausgewhlt wurde
                FilePath=fullfile(PathName,FileName);
                %csvwrite (FilePath,[handles.t,handles.STc,handles.STQc,handles.STb,handles.STQb]);
                csvwrite (FilePath,[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb]);
            end
        end
       
        Test.Daten=[handles.t,handles.SMc,handles.SQc,handles.STc,handles.STQc,handles.SMb,handles.SQb,handles.STb,handles.STQb];
        Test.Modellname=handles.Modell;
        Test.Pulsdatei=handles.Puls;
        Test.mitglatterKurve=''; %da nicht immer Hkchen gesetzt wird
        Test.diff=''; 
        Test.k=handles.k;
        Test.N=handles.N;
        
        if get(handles.Zeitschritt_fest,'Value')==true
            Test.Einstellungen1='fest';
        end
        if  get(handles.Zeitschritt_variabel,'Value')==true
            Test.Einstellungen1='variabel';
        end
        if  get(handles.glatt,'Value')==true
            Test.Einstellungen1='glatt';
        end
        if get(handles.automatisch,'Value')==true
            Test.Einstellungen1='auto';
        end
        if get(handles.mit_glatterKurve,'Value')==true
            Test.mitglatterKurve='mit_glatter_Kurve';
        end
        if get(handles.cb_diff,'Value')==true
            Test.diff='Diffusion';
        end

        DefaultName = [FilePath(1:end-4),'.mat'];
        save(DefaultName,'Test')
      
end


% --------------------------------------------------------------------
function matfile_lesen_Callback(hObject, eventdata, handles)
% hObject    handle to matfile_lesen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
cla(handles.axes1); % Lscht (falls vorhanden) alle Grafiken im axes1
cla(handles.axes2);
cla(handles.axes3);
cla(handles.axes4);

[FileName,PathName]=uigetfile('*.mat','select mat-file'); %Fenster ffnet sich zum auswhlen der Datei
load([FileName(1:end-4),'.mat'])

set(handles.Modellname,'String',[Test.Modellname '.m']);  % ist jetzt neu
set(handles.Pulsname,'String',[Test.Pulsdatei '.m']);     % ist jetzt neu

Modell=Test.Modellname;
handles.Puls=Test.Pulsdatei;
Modell();  % Modelldaten einlesen
y=nargout(Modell);


if y==6
    [MC,MK,MV,uc,ubg,nb] = feval(Modell);  % Modelldaten einlesen
else
    [MC,MK,uc,ubg,nb] = feval(Modell);  % Modelldaten einlesen
    MV = zeros(length(MC(1,:)));
end

handles.ns  = length(MC(1,:));         % Anzahl Zustnde
handles.nb  = nb;                      % max. Zahl Liganden
handles.ubg = ubg;                      % Zeilenvektor Bindungen
handles.uc  = uc;                      % Zeilenvektor offene Zustnde
handles.MV  = MV;                      % Array Spannungen
handles.MK  = MK;                      % Array konzentrationsabhngig?
handles.MC  = MC;                      % Array Ratekonstanten

if  strcmp(Test.Einstellungen1,'fest')
    set(handles.Zeitschritt_fest,'Value',1);
end
if  strcmp(Test.Einstellungen1,'variabel')
    set(handles.Zeitschritt_variabel,'Value',1)
end
if  strcmp(Test.Einstellungen1,'glatt')
    set(handles.glatt,'Value',1);
end
if strcmp(Test.Einstellungen1,'auto')
    set(handles.automatisch,'Value',1);
end
if strcmp( Test.mitglatterKurve,'mit_glatter_Kurve')
    set(handles.mit_glatterKurve,'Value',1);
else
     set(handles.mit_glatterKurve,'Value',0);
end
if strcmp(Test.diff,'Diffusion')
    set(handles.cb_diff,'Value',1);
else
    set(handles.cb_diff,'Value',0); 
end

set(handles.ueberschreiben,'Value',0); %kein Hkchen bei "berschreiben" 


handles.k=Test.k;
handles.N=Test.N;
set(handles.AnzahlSimulationen,'String',handles.k);
set(handles.AnzahlKanaele,'String',handles.N);
set(handles.Zaehler,'String',handles.k);
set(handles.ZaehlerN,'String',handles.N);

FileName=([FileName(1:end-4),'.csv']);
fid = fopen(FileName);
Anz_zeilen=0;
i=1;
while ~feof(fid)
    fgetl(fid);
    if i==1
    tline = fgetl(fid);%erste Zeile einlesen
    end
    Anz_zeilen = Anz_zeilen + 1; %Anzahl Zeilen ermitteln
    i=0;
end

n=(strfind(tline,','));
n=length(n);

if n==8 %wenn in der ersten Zeile 8 Trennzeichen Stehen also 9 Spalten  
    % Einlesen der Zeilen 0-9999 und der Spalten 0-8
    m=dlmread(FileName, ',',[0 0 Anz_zeilen 8]);
    handles.t=m(:,1);
    handles.SMc=m(:,2);
    handles.SQc=m(:,3);
    handles.STc=m(:,4);
    handles.STQc=m(:,5);
    handles.SMb=m(:,6);
    handles.SQb=m(:,7);
    handles.STb=m(:,8);
    handles.STQb=m(:,9);
    
    % Update handles structure
    guidata(hObject, handles);
    
    fclose(fid);
    handles=plotten4(handles);               % Simulationen in alle 4 axes plotten
    if get(handles.mit_glatterKurve,'Value')==true 
        handles = plotten_glatt_neu(handles);    % ggf. glatte Kurven plotten
    end
else
    warndlg('there are not 9 columns')
end
% Update handles structure
guidata(hObject, handles);
Spannung_Konzentration(hObject,handles);

%-------------------------------------------------------------------------
          
function [MC,MK,MV,uc,ubg,nb] = Lang_zu_Kurz(S_model)
%   Diese Funktion berechnet die wesentlichen Modellparameter
%   MC,MK,MV,uc,ubg,nb aus einer langen Modelldefinition

Verbindungen = S_model.link;
V1 = Verbindungen(:,2);
V2 = Verbindungen(:,1);

ns = S_model.no_states;
p = S_model.parameter;

lr = S_model.no_rateconst;
r = zeros(lr,1);

if isfield(S_model,'modelconst')
    K = S_model.modelconst;
else
    K = 0;
end

MV = zeros(ns,ns);

if isfield(S_model.dep, 'V') && S_model.dep.V
    r1 = zeros(lr,1);
    
    kb = 0; %8.6173324e-5; % Boltzmannkonstante nach Gau, Einheit: eV/K (e... Elementarladung)
    T = 0; %infos(3);
    for i = 1 : lr
        if iscellstr(S_model.dep.relation(i))
            voltage = str2func(S_model.dep.relation{i});
            U = 1; % Einheit: von mV nach V!
            r1(i) = voltage(p,K,U,kb,T);
            U = 0;
            r(i) = voltage(p,K,U,kb,T);
        end
    end
    % mikroskopische Reversibilitt
    
    if isfield(S_model.dep,'micro_rev')
        MR = S_model.dep.micro_rev;
        lmr = length(MR);
        for i = 1:lmr
            lm = length(MR{i}(1,:));
            k = MR{i}(1);   % erster Eintrag gibt die Nummer der Ratekonstante, die ausgedrckt werden soll
            nenner = 1;
            zaehler = 1;
            nenner1 = 1;
            zaehler1 = 1;
            for j=2:lm
                index = MR{i}(1,j);
                zahl = r(index);
                nenner = nenner*zahl;
                zahl1 = r1(index);
                nenner1 = nenner1*zahl1;
            end
            for j=1:lm
                index = MR{i}(2,j);
                zahl = r(index);
                zaehler = zaehler*zahl;
                zahl1 = r1(index);
                zaehler1 = zaehler1*zahl1;
            end
            r(k) = zaehler/nenner;
            r1(k) = zaehler1/nenner1;
        end
    end
    rv = log(r1./r);
    CV = sparse(V1,V2,rv,ns,ns);
    MV = CV*eye(ns);
    
else
    for i = 1 : lr
        if iscellstr(S_model.dep.relation(i))
            nonlin = str2func(S_model.dep.relation{i});
            r(i) = nonlin(p,K);
        end
    end
    
    % mikroskopische Reversibilitt
    
    if isfield(S_model.dep,'micro_rev')
        MR = S_model.dep.micro_rev;
        lmr = length(MR);
        for i = 1:lmr
            lm = length(MR{i}(1,:));
            k = MR{i}(1);   % erster Eintrag gibt die Nummer der Ratekonstante, die ausgedrckt werden soll
            nenner = 1;
            zaehler = 1;
            for j=2:lm
                index = MR{i}(1,j);
                zahl = r(index);
                nenner = nenner*zahl;
            end
            for j=1:lm
                index = MR{i}(2,j);
                zahl = r(index);
                zaehler = zaehler*zahl;
            end
            r(k) = zaehler/nenner;
        end
    end
end
C1 = sparse(V1,V2,r,ns,ns);
MC = C1*eye(ns);

C1 = sparse(V1,V2,S_model.dep.ligand_concentration,ns,ns);
MK = C1*eye(ns);


uc = S_model.pass;
ubg = S_model.ligand_no;   % ub ist Zeilenvektor mit abs. Anzahl Liganden
nb = max([ubg,1]);


%------------------------------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --------------------------------------------------------------------
function Lang_model_load_Callback(hObject, eventdata, handles)
% hObject    handle to Lang_model_load (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[FileNameM,PathNameM]=uigetfile('*.mat');
if FileNameM~=0      % Nur wenn ein file ausgewhlt wurde
    FilePathM=fullfile(PathNameM,FileNameM);
    set(handles.Modellname,'String',FileNameM);

Modellname=get(handles.Modellname, 'String');
Modell=Modellname();  
load(Modellname);

[MC,MK,MV,uc,ubg,nb] = Lang_zu_Kurz(S_model);

    handles.ns = length(MC(1,:));         % Anzahl Zustnde
    handles.nb = nb;                      % max. Zahl Liganden  
    handles.ubg = ubg;                      % Zeilenvektor Bindungen
    handles.ub = ubg/nb;
    handles.uc = uc;                      % Zeilenvektor offene Zustnde
    handles.MV = MV;                      % Array Spannungen
    handles.MK = MK;                      % Array konzentrationsabhngig?
    handles.MC = MC;                      % Array Ratekonstanten
end
guidata(hObject, handles);

%-----------------------------------------------------------------------


% --- Executes on button press in cb_korrel.
function cb_korrel_Callback(hObject, eventdata, handles)
% hObject    handle to cb_korrel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of cb_korrel



function ed_dt_Callback(hObject, eventdata, handles)
% hObject    handle to ed_dt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ed_dt as text
%        str2double(get(hObject,'String')) returns contents of ed_dt as a double


% --- Executes during object creation, after setting all properties.
function ed_dt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ed_dt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ed_Korr_dT_Callback(hObject, eventdata, handles)
% hObject    handle to ed_Korr_dT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ed_Korr_dT as text
%        str2double(get(hObject,'String')) returns contents of ed_Korr_dT as a double


% --- Executes during object creation, after setting all properties.
function ed_Korr_dT_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ed_Korr_dT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ed_KorrSize_Callback(hObject, eventdata, handles)
% hObject    handle to ed_KorrSize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ed_KorrSize as text
%        str2double(get(hObject,'String')) returns contents of ed_KorrSize as a double


% --- Executes during object creation, after setting all properties.
function ed_KorrSize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ed_KorrSize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ed_KorrAnf_Callback(hObject, eventdata, handles)
% hObject    handle to ed_KorrAnf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ed_KorrAnf as text
%        str2double(get(hObject,'String')) returns contents of ed_KorrAnf as a double


% --- Executes during object creation, after setting all properties.
function ed_KorrAnf_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ed_KorrAnf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb_korrel.
function pb_korrel_Callback(hObject, eventdata, handles)
% hObject    handle to pb_korrel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on mouse press over axes background.
function axes7_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axes7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------


% --- Executes on mouse press over figure background.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on mouse press over figure background.
function figure1_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on mouse press over figure background.
function figure1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
