function [MC,MK,MV,uc,ubg,nb] = Mod_3C1O_V1

% stellt eine MC-Matrix und eine MK-Matrix her
% uc ist der Vektor der Offenzustnde
% ubg ist der Vektor der Bindungsgrade

ns = 4;         % Anzahl Zustnde gleich 4

uc =  [0 0 0 1];     % Vektor der offenen Zustnde - Strom fliet (current)
ubg = [0 1 2  2];     % Vektor der gebundenen Liganden - Fluoreszenz 
nb  = 2;                 % maximale Ligandenzahl
            
% Vordefinierte Konstanten

% Po0 = 0.0;          % wird hier nicht bentigt 

% vorgegebene Parameter, die i.a. aus dem Fitprogramm stammen

p(1)  = 1.2;
p(2)  = 0.1;
p(3)  = 0.3;
p(4)  = 0.5;
p(5)  = 0.05;
p(6)  = 0.01;

% Ratekonstanten, werden aus den Parametern und/oder vordefinierten
% Konstanten berechnet

k12 = p(1);
k21 = p(2);
k23 = p(3);
k32 = p(4);
k34 = p(5);
k43 = p(6);

% MC - Matrix, in welcher die Ratekonstanten stehen - sonst Nullen  

MC = zeros(ns,ns);
MK = zeros(ns,ns);
MV = zeros(ns,ns);

MC(1,2)=k21;    % bekommt 1 von 2
MC(2,1)=k12;    % bekommt 2 von 1

MC(2,3)=k32;    % bekommt 3 von 4
MC(3,2)=k23;    % bekommt 4 von 3

MC(3,4)=k43;    % bekommt 2  von 4
MC(4,3)=k34;    % bekommt 4 von 2

% MK - Matrix, mit 1 wenn zugehrige Ratekonstante kozentrationsabhngig
% - sonst Nullen

MK(2,1) = 1;    % bergang "bekommt 1 von 2" ist konzentrationsabhngig
MK(3,2) = 1;    % bergang "bekommt 3 von 4" ist konzentrationsabhngig

