function [MC,MK,MV,uc,ubg,nb] = Mod_CCCFFO_V1

% stellt eine MC-Matrix und eine MK-Matrix her
% uc ist der Vektor der Offenzustnde
% ubg ist der Vektor der Bindungsgrade


ns = 6;         % Anzahl Zustnde gleich 4

uc =  [0 0 0 0 0 1];     % Vektor der offenen Zustnde - Strom fliet (current)
ubg = [0 1 2 1 2 2];     % Vektor der gebundenen Liganden - Fluoreszenz 
nb  = 2;                 % maximale Ligandenzahl
            
% Vordefinierte Konstanten

% Po0 = 0.0;          % wird hier nicht bentigt 

% vorgegebene Parameter, die i.a. aus dem Fitprogramm stammen

p(1)  = 1.2;
p(2)  = 0.6;
p(3)  = 0.6;
p(4)  = 1.2;
p(5)  = 0.1;
p(6)  = 0.1;
p(7)  = 0.05;
p(8)  = 0.01;
p(9)  = 0.6;
p(10) = 0.24;
p(11) = 0.2;
p(12) = 0.01;


% Ratekonstanten, werden aus den Parametern und/oder vordefinierten
% Konstanten berechnet

k12 = p(1);
k21 = p(2);
k23 = p(3);
k32 = p(4);
k24 = p(5);
k42 = p(6);
k35 = p(7);
k53 = p(8);
k45 = p(9);
k54 = p(10);
k56 = p(11);
k65 = p(12);


% MC - Matrix, in welcher die Ratekonstanten stehen - sonst Nullen  

MC = zeros(ns,ns);
MK = zeros(ns,ns);
MV = zeros(ns,ns);

MC(1,2)=k21;    % bekommt 1 von 2
MC(2,1)=k12;    % bekommt 2 von 1

MC(2,3)=k32;    % bekommt 3 von 4
MC(3,2)=k23;    % bekommt 4 von 3

MC(2,4)=k42;    % bekommt 2  von 4
MC(4,2)=k24;    % bekommt 4 von 2

MC(3,5)=k53;    % bekommt 1 von 3
MC(5,3)=k35;    % bekommt 3 von 1

MC(4,5)=k54;    % bekommt 2  von 4
MC(5,4)=k45;    % bekommt 4 von 2

MC(5,6)=k65;    % bekommt 1 von 3
MC(6,5)=k56;    % bekommt 3 von 1

% MK - Matrix, mit 1 wenn zugehrige Ratekonstante kozentrationsabhngig
% - sonst Nullen

MK(2,1) = 1;    % bergang "bekommt 1 von 2" ist konzentrationsabhngig
MK(3,2) = 1;    % bergang "bekommt 3 von 4" ist konzentrationsabhngig
MK(5,4) = 1;    % bergang "bekommt 3 von 4" ist konzentrationsabhngig

