install.packages("devtools")
devtools::install_github("SexGenomicsToolkit/sgtr")
library(sgtr)
setwd("/path to folder containing all PSASS output file and chromsome file")


#Generating manhathan plot
backgrounds = rep(c("white", "grey80"), 13)
backgrounds[24] <- "orange"

plot_manhattan("./Muskie_MSS_window.tsv",
               tracks = list(single_metric_track("Fst",
                                                 point_size = 1.2,alpha = 0.5,
                                                 colors = c("grey10", "grey50")),
                              single_metric_track("Snps_females",
                                              color = c("red", "firebrick3")),
                              single_metric_track("Snps_males",
                                                 point_size = 1.2,alpha = 0.8,
                                                 color = c("blue", "darkblue"),
                                                 bg_colors = backgrounds)),
               chromosomes_file = "Muskie_chromosomes.tsv",
               chromosomes_as_numbers = TRUE)

#Plot male and female-specific SNPs for LG24 
region <- plot_region("Muskie_MSS_window.tsv",
                      "Chr24:0-2500000",
                      tracks = list( multi_metrics_track(c("Snps_males", "Snps_females"),
                                                         label = "SNP",
                                                         colors = c("red", "blue"),
                                                         type = "ribbon")),
                      chromosomes_file = "Muskie_chromosomes.tsv",
                      output_file = "region_MSS_SNP.png",
                      width = 12,
                      track_height = 4,
                      res = 500)
region

#Plot coverage on a determined region on LG24. 
region <- plot_region("Muskie_coverage_1k_window.tsv",
                      "Chr24:380000-405000",
                      tracks = list( multi_metrics_track(c("Rel_depth_males", "Rel_depth_females"),
                                                         label = "relative reads depth",
                                                         colors = c("red", "blue"),
                                                         type = "ribbon")),
                      chromosomes_file = "Muskie_chromosomes.tsv",
                      output_file = "region_1kb_cov_amhby.png",
                      width = 12,
                      track_height = 4,
                      res = 1000)
#