library(sgtr)
library(ggplot2)
library(cowplot)

setwd("path to file containing all RADSex output files")

dallia <- radsex_distrib("Dpectoralis_distrib_10.tsv",
                         groups = c("M", "F"),
                         group_labels = c("Males", "Females"),
                         significance_thickness = 0.75)

novumbra <- radsex_distrib("Nhubbsi_distrib_10.tsv",
                           groups = c("M", "F"),
                           group_labels = c("Males", "Females"),
                           significance_thickness = 0.75)

umbra <- radsex_distrib("Upygmaea_distrib_10.tsv",
                        groups = c("M", "F"),
                        group_labels = c("Males", "Females"),
                        significance_thickness = 0.75)

Muskie_pop1 <- radsex_distrib("Emasquinongy_1_distrib_10.tsv",
                              groups = c("M", "F"),
                              group_labels = c("Males", "Females"),
                              significance_thickness = 0.75)

Muskie_pop2 <- radsex_distrib("Emasquinongy_2_distrib_10.tsv",
                              groups = c("M", "F"),
                              group_labels = c("Males", "Females"),
                              significance_thickness = 0.75)

legend <- get_legend(dallia)

combined <- plot_grid(Muskie_pop1 + theme(axis.title.y = element_blank(), plot.margin = margin(30, 5, 5, 25)),
                      Muskie_pop2 + theme(axis.title.y = element_blank(), plot.margin = margin(30, 5, 5, 25)),
                      novumbra + theme(legend.position = "none", plot.margin = margin(30, 5, 5, 5)),
                      dallia + theme(legend.position = "none", axis.title.y = element_blank(),
                                     plot.margin = margin(30, 5, 5, 25)),
                      umbra + theme(axis.title.y = element_blank(), plot.margin = margin(30, 5, 5, 25)),
                     
                      ncol = 5,
                      rel_widths = c(1, 1, 1.2),
                      align = "hv",
                      labels = c("A", "B", "C","D","E"),
                      label_size = 24,
                      label_fontface = "bold",
                      label_y = 1,
                      label_x = 0)




