#For figures for poolseq of NA pike and EU Northen pike
devtools::update_packages("sgtr")
library(cowplot)
library(ggplot2)
setwd("path to folder containg PSASS output for EU pop and NA pop of esox lucius")
region = "Chr24:750000-1250000"
chromosomes_file = "Esox_lucius_chromosomes.tsv"

#comparing NA and EU coverage on LG24
region_NA_LG24 <- plot_region("NA_pop_Elucius_coverage_1k_window.tsv",
                              region = region,
                              tracks = list( multi_metrics_track(c("Abs_depth_males", "Abs_depth_females"),
                                                                 label = "NA pool depth",
                                                                 metric_labels = c("Male depth", "Female depth"),
                                                                 colors = c("blue", "red"),
                                                                 type = "ribbon",
                                                                 alpha = 0.4,
                                                                 legend_position = "none")),
                              chromosomes_file = chromosomes_file,
                              default_ylim = c(0,150))
region_EU_LG24 <- plot_region("EU_pop_Elucius_coverage_1k_window.tsv",
                              region = region,
                              tracks = list( multi_metrics_track(c("Abs_depth_females", "Abs_depth_males"),
                                                                 label = "EU pool depth",
                                                                 metric_labels = c("Female depth", "Male depth"),
                                                                 colors = c("red", "blue"),
                                                                 type = "ribbon",
                                                                 alpha = 0.4,
                                                                 legend_position = c(0.07, 0.8))),
                              chromosomes_file = chromosomes_file,
                              default_ylim = c(0,150))

combined <- plot_grid(region_EU_LG24[[1]] +
                        theme(axis.title.x = element_blank()),
                      region_NA_LG24[[1]],
                      align = "hv",
                      ncol = 1)
combined


#comparing NA and EU MSS on LG24

region_NA_LG24 <- plot_region("NA_pop_Elucius_MSS_window.tsv",
                              region = "Chr24",
                              tracks = list(single_metric_track("Snps_males",
                                                                label = "NA Male-specific Snps",
                                                                colors = "blue",
                                                                type = "ribbon",
                                                                alpha = 0.4,
                                                                legend_position = c(0.1, 0.7))),
                              chromosomes_file = chromosomes_file,
                              default_ylim = c(0,220))

region_EU_LG24 <- plot_region("EU_pop_Elucius_MSS_window.tsv",
                              region = "Chr24",
                              tracks = list(single_metric_track("Snps_males",
                                                                label = "EU Male-specific Snps",
                                                                colors = "blue",
                                                                type = "ribbon",
                                                                alpha = 0.4,
                                                                legend_position = c(0.1, 0.7))),
                              chromosomes_file = chromosomes_file,
                              default_ylim = c(0,220))

combined <- plot_grid(region_EU_LG24[[1]] +
                        theme(axis.title.x = element_blank()),
                      region_NA_LG24[[1]],
                      align = "hv",
                      ncol = 1)
combined
