######cell count from 'Figure3-FigureSupplement1.xlsx'
rm(list=ls())
library(dplyr)
library(readxl)
library(tidyr)
library(ggplot2)
countD = readxl::read_excel("./Figure3-FigureSupplement1.xlsx", sheet = 1) %>%
  dplyr::filter(Marker != "KI67_SFTPC") %>%
  tidyr::spread(key = "Marker", value = "Counts") %>%
  tidyr::gather(key = "cellMarker", value = "cellCount", -MouseID, -MeasureID, -DAPI) %>%
  dplyr::mutate(ratio = cellCount / DAPI, 
                cellMarker = case_when(cellMarker == "KI67" ~ "Proliferating cells(KI67)",
                                       cellMarker == "FOXF1" ~ "Endothelial cells(FOXF1)",
                                       cellMarker == "SFTPC" ~ "AT2 cells(SFTPC)") ) %>%
  dplyr::mutate(cellMarker = factor(cellMarker, levels = c("Endothelial cells(FOXF1)", "AT2 cells(SFTPC)", "Proliferating cells(KI67)")) )
##the average cell percentage within each biological replicate
mcountD = dplyr::group_by(countD, MouseID, cellMarker) %>%
  dplyr::summarise( mratio = mean(ratio) ) %>%
  as.data.frame() %>%
  dplyr::mutate(grp = gsub("\\d+", "", MouseID) ) %>%
  dplyr::mutate(grp = factor(grp, levels = c("Control", "IH") )) %>%
  dplyr::select(-MouseID)
##the average cell percentage of biological replicates within each group
avgD = dplyr::group_by(mcountD, grp, cellMarker) %>%
  dplyr::summarise(sdratio = sd(mratio), mratio = mean(mratio))
p <- ggplot(avgD, aes(x=cellMarker, y=mratio, fill=grp)) +
  geom_bar(stat="identity", color="black", position=position_dodge(), width = 0.85) +
  geom_errorbar(aes(ymin=mratio - sdratio, ymax=mratio + sdratio), width=.2, position=position_dodge(.9)) +
  #geom_point(data = mcountD, aes(x=cellMarker, y=mratio, fill = grp), position = position_dodge(width = .9)) +
  scale_fill_manual(values=c( "Control" = '#999999', "IH" = '#E69F00')) +
  labs(y = "Cell percentage") +
  guides(fill = guide_legend(reverse = FALSE, override.aes = list(size = 0.5)) ) + 
  theme_classic() +
  theme(axis.title.x = element_blank(),
        legend.title = element_blank(),
        axis.text.y = element_text(size = 11.6),
        axis.text.x = element_text(size = 10.6, angle = 60, hjust = 1),
        legend.text = element_text(size = 9.6),
        legend.position = c(0.8, 0.8),
        legend.key.size = unit(0.8,"line"),
        plot.margin = unit(c(0.3,0.15,0.1,0.15), "in"),   ##top, right, bottom, left
        axis.title.y = element_text(size = 11.6) )
ggsave(p, file = "Figure3-FigureSupplement1.pdf", width = 2, height = 3.99)

######do statistical test on the percentage difference
library(purrr)
library(compositions)
###compute on the mean ratio
avgE = dplyr::select(countD, MouseID, cellMarker, ratio) %>%
  group_by(cellMarker, MouseID) %>%
  dplyr::summarise( avgRatio = mean(ratio) ) %>%
  tidyr::spread( key = "MouseID", value = "avgRatio")
##the remaining cells as one composition group
unknownD = apply(avgE[,-1], 2, function(z) {return(1-sum(z))} ) %>%
  as.data.frame() %>% t() %>% as.data.frame() %>%
  dplyr::mutate(cellMarker = "unknown")
avgE = bind_rows(avgE, unknownD[,colnames(avgE)])
##Centered log ratio transform
cratioD = apply(avgE[,-1], 2, function(z) {return(clr(z))} ) %>%
  t() %>% as.data.frame()
colnames(cratioD) = gsub("\\s+", "", unlist(avgE[,1]) )
cratioD = dplyr::mutate(cratioD, group = gsub("\\d+", "", rownames(cratioD))) %>%
  dplyr::select(group, colnames(cratioD))
###t test for each cell type
ratioS = cratioD[,-1] %>%
  purrr::map(function(z) {
    z = unlist(z)
    tepv = t.test(z[1:4], z[5:8])
    return(data.frame(statistic = tepv$statistic, pva = tepv$p.value))
  }) %>% bind_rows() %>%
  dplyr::mutate(cellType = colnames(cratioD)[-1]) %>%
  dplyr::mutate(bhq = p.adjust(pva, method = "BH")) %>%
  dplyr::select(cellType, statistic, pva, bhq) %>%
  dplyr::arrange(pva)
write.csv(ratioS, file = "Figure3-FigureSupplement1_StatisticalTest.csv", row.names = FALSE)


######Alveolar area/wall thickness figure
rm(list=ls())
library(dplyr)
library(readxl)
library(tidyr)
library(ggplot2)
areaD = readxl::read_excel("./Figure3-FigureSupplement2AB.xlsx", sheet = 1) %>%
  dplyr::mutate(area = `Area [µm²]`, mferet=`MaxFeret90 [µm]`) %>% 
  dplyr::mutate(grp = gsub("\\d+", "", MouseID)) %>% 
  dplyr::mutate(MouseID = factor(MouseID, levels = c("Control1", "Control2", "IH2", "IH4")),
                grp = factor(grp, levels = c("Control", "IH") ) ) 
##get the average value of MaxFeret90 and Area
areaM = areaD %>% group_by(grp) %>% 
  dplyr::summarise(marea=mean(area), mmferet=mean(mferet))
##draw the figure
gplotA <- ggplot(areaD, aes(x=MouseID, y=log10(mferet), col = grp)) +
  geom_boxplot(notch = TRUE) +
  #geom_jitter(width = 0.1, alpha=0.6) +
  labs(title="", x="", y="Log10(Alveolar MaxFeret90 [µm])") +
  scale_color_manual(values=c( "Control" = '#999999', "IH" = '#E69F00')) +
  theme_bw() + theme(axis.text.x=element_text(angle=60, hjust=1, size=11.6),
        axis.text.y=element_text(size=11.6),
        legend.position = "none",
        legend.title = element_blank(),
        strip.text = element_text(size = 13.6, face = "bold"),
        axis.title = element_text(size = 11.6, face = "bold") )
gplotB <- ggplot(areaD, aes(x=MouseID, y=log10(area), col = grp)) +
  geom_boxplot(notch = TRUE) +
  #geom_jitter(width = 0.1, alpha=0.6) +
  labs(title="", x="", y="Log10(Alveolar area [µm²])") +
  scale_color_manual(values=c( "Control" = '#999999', "IH" = '#E69F00')) +
  theme_bw() + theme(axis.text.x=element_text(angle=60, hjust=1, size=11.6),
                     axis.text.y=element_text(size=11.6),
                     legend.position = "none",
                     legend.title = element_blank(),
                     strip.text = element_text(size = 13.6, face = "bold"),
                     axis.title = element_text(size = 11.6, face = "bold") )
#######the Alveolar Wall Thickness
thickD = readxl::read_excel("./Figure3-FigureSupplement2C.xlsx", sheet = 1) %>%
  dplyr::mutate(MouseID = factor(MouseID, levels = c("Control1", "Control2", "IH2", "IH4")),
                grp = gsub("\\d+", "", MouseID)) %>% 
  dplyr::mutate(grp = factor(grp, levels = c("Control", "IH")))
##get the average value of wall thickness
thickM = thickD %>% group_by(grp) %>% 
  dplyr::summarise(mthick = mean(Thickness) )
##draw the figure
gplotC <- ggplot(thickD, aes(x=MouseID, y=Thickness, col = grp)) +
  geom_boxplot(notch = TRUE) +
  #geom_jitter(width = 0.1, alpha=0.6) +
  labs(title="", x="", y="Alveolar wall thickness [µm]") +
  scale_color_manual(values=c( "Control" = '#999999', "IH" = '#E69F00')) +
  theme_bw() + theme(axis.text.x=element_text(angle=60, hjust=1, size=11.6),
                     axis.text.y=element_text(size=11.6),
                     legend.position = "none",
                     legend.title = element_blank(),
                     strip.text = element_text(size = 13.6, face = "bold"),
                     axis.title = element_text(size = 11.6, face = "bold") )
##draw the sub-figures together
gplot <- gridExtra::arrangeGrob(gplotA, gplotB, gplotC, ncol = 3, nrow = 1, widths=c(1.66, 1.66, 1.66), heights=c(3.65), layout_matrix = cbind(c(1), c(2), c(3)))
fplot <- ggpubr::as_ggplot(gplot)  + cowplot::draw_plot_label(label = c("A", "B", "C"), size = 13.6,  x = c(0, 0.33, 0.66), y = c(1, 1, 1))
ggplot2::ggsave(filename = "Figure3-FigureSupplement2.pdf", plot = fplot, width = 4.98, height = 3.9, units = "in")
