% build Figures for Lee&Daunizeau (2020)

clear all
close all

%% load all data and analysis results
% raw data
lo0 = load('FCP3_data');

% full model inversion with all choice outcome features
flags = '111';
thisdate = '12-Jan-2021';
fsn = ['results_MCD_',thisdate,'_wobias_',flags,'_V100_Dcert.mat'];
lo = load(fsn);
close all
% out-of-sample effort-related variables
fsnxval = ['results_MCD_',thisdate,'_wobias_',flags,'_V100_Dcert_xVal.mat'];
lox = load(fsnxval);
close all
% out-of-sample decision-related variables
fsnxval = ['results_MCD_',thisdate,'_wobias_',flags,'_V100_Dcert_xVal2.mat'];
lox2 = load(fsnxval);
close all
% model inversion without beta
flags = '101';
fsn = ['results_MCD_',thisdate,'_wobias_',flags,'_V100_Dcert.mat'];
lobe = load(fsn);
close all
% model inversion without gamma
flags = '110';
fsn = ['results_MCD_',thisdate,'_wobias_',flags,'_V100_Dcert.mat'];
loga = load(fsn);
close all
% model inversion with exponentially decaying type #2 effort efficacy
thisdate = '18-Jan-2021';
fsn = ['results_MCD_',thisdate,'_wobias_111_V100_Dcert_expEfficacy.mat'];
loexp = load(fsn);
close all
% DDM fit
thisdate = '21-Jan-2021';
fsn = ['results_DDM_',thisdate,'_V100_logRT_all.mat'];
loddm = load(fsn);
close all
% only-RT MCD fit
thisdate = '18-Jan-2021';
fsn = ['results_MCD_',thisdate,'_wobias_111_V100_Dcert_onlyRT.mat'];
loort = load(fsn);
close all
% model inversion with extended MCD (with biases)
thisdate = '18-Jan-2021';
fsn = ['results_MCD_',thisdate,'_wobias_111_V100_Dcert_extended.mat'];
loext = load(fsn);
close all
% extended MCD: out-of-sample effort-related variables
fsn = ['results_MCD_',thisdate,'_wobias_111_V100_Dcert_extended_xVal.mat'];
loext_x = load(fsn);
close all
% extended MCD: out-of-sample decision-related variables
fsn = ['results_MCD_',thisdate,'_wobias_111_V100_Dcert_extended_xVal2.mat'];
loext_x2 = load(fsn);
close all


%% model-free RFX analysis
nSubs=length(lo.subs);
znames = {'choice confidence','spreading of alternatives','reaction time','change of mind','effort ratings','precision gain'};
regnames = {'(cst)','dVR0','VCR0','cons','pena'};
% extract within-subject design matrices
includeConds = 0;
if ~includeConds
    subok = 1:nSubs;
else
    subok = [];
end
for sub=1:nSubs
    if includeConds && length(unique(lo.penalty{sub}))>1 && length(unique(lo.consequential{sub}))>1
        subok = [subok;sub];
    end
    nt = size(lo.X,1);
    X0 = [ones(nt,1),lo.X(:,sub),lo.Y(:,sub)];
    if includeConds
        Xc = [zscore(lo.consequential{sub}(:)),zscore(lo.penalty{sub}(:))];
        Xreg{sub} = [X0,Xc];
    else
        Xreg{sub} = X0;
    end
end
% run multi-subject GLM and RFX
hf = figure('name','Fig 0: RFX data analysis');
for i=1:length(lo.Z)
    Y = lo.Z{i};
    [b(:,:,i)] = multiSubjectGLM(Y,Xreg);
    bi = b(:,subok,i);
    mbi = mean(bi,2);
    vbi = var(bi,[],2)./nSubs;
    [pv] = GLM_contrast(ones(length(subok),1),bi',1,'F',0);
    nregs = size(Xreg{sub},2);
    for j=1:nregs
        disp([znames{i},': ',regnames{j},...
            ': p=',num2str(pv(j),3),...
            ', E[B]=',num2str(mbi(j),3),...
            ', sem[B]=',num2str(sqrt(vbi(j)),3)])
    end
    ha(i) = subplot(3,2,i,'parent',hf,'nextplot','add');
    plotUncertainTimeSeries(mbi,vbi,[],ha(i));
    set(ha(i),'xlim',[0,nregs+1],'xtick',1:nregs,'xticklabel',regnames)
    title(ha(i),znames{i})
end
% summarize the relationship btwn effort and dVR0
N = 5;
clear qrt qef qez qrt2 qef2 qez2
dvr0all = [];
vcr0all = [];
for sub=1:nSubs
    dvr0all = [dvr0all;(lo.ease{sub}(:))];
    vcr0all = [vcr0all;(lo.cert{sub}(:))];
end
% quantiles of dVR0
p = [0:N]./N; % quantiles
qdvr0 = quantile(dvr0all,p);
qvcr0 = quantile(vcr0all,p);
for sub=1:nSubs
    rt = zscore(lo.RT{sub});
    ef = zscore(lo.EF{sub});
    Ez = loort.outSUB{sub}.suffStat.gx(3,:);
    % binned dependent variables
    dvr0 = (lo.ease{sub}(:));
    vcr0 = (lo.cert{sub}(:));
    for i=1:N
        % bin according to dVR0
        iq = find(dvr0>=qdvr0(i)&dvr0<=qdvr0(i+1));
        qrt(i,sub) = nanmean(rt(iq));
        qef(i,sub) = nanmean(ef(iq));
        qez(i,sub) = nanmean(Ez(iq));
        % bin according to VCR0
        iq2 = find(vcr0>=qvcr0(i)&vcr0<=qvcr0(i+1));
        qrt2(i,sub) = nanmean(rt(iq2));
        qef2(i,sub) = nanmean(ef(iq2));
        qez2(i,sub) = nanmean(Ez(iq2));
    end
end

hf = figure('name','Effort vs dVR0: median-split on betas');
logalpha = lo.Ps(1,:);
loggamma = lo.Ps(3,:);
logratio = loggamma-logalpha;
il = find(logratio<=median(logratio));
iu = find(logratio>=median(logratio));

ha = subplot(2,2,1,'parent',hf);
mrt = nanmean(qrt(:,il),2);
vrt = nanvar(qrt(:,il),[],2)./length(il);
mef = nanmean(qef(:,il),2);
vef = nanvar(qef(:,il),[],2)./length(il);
mEz = nanmean(qez(:,il),2);
vEz = nanvar(qez(:,il),[],2)./length(il);
plotUncertainTimeSeries(mrt',vrt',[],ha,[],'b')
plotUncertainTimeSeries(mef',vef',[],ha,[],'g')
plotUncertainTimeSeries(mEz',vEz',[],ha,[],'k')
title(ha,'gamma/alpha: 0-50% quantile')
xlabel(ha,'dVR0')
ylabel(ha,'effort-related variables')
ha = subplot(2,2,2,'parent',hf);
mrt = nanmean(qrt(:,iu),2);
vrt = nanvar(qrt(:,iu),[],2)./length(iu);
mef = nanmean(qef(:,iu),2);
vef = nanvar(qef(:,iu),[],2)./length(iu);
mEz = nanmean(qez(:,iu),2);
vEz = nanvar(qez(:,iu),[],2)./length(iu);
plotUncertainTimeSeries(mrt',vrt',[],ha,[],'b')
plotUncertainTimeSeries(mef',vef',[],ha,[],'g')
plotUncertainTimeSeries(mEz',vEz',[],ha,[],'k')
title(ha,'gamma/alpha: 50-100% quantile')
xlabel(ha,'dVR0')
ylabel(ha,'effort-related variables')
loggamma = lo.Ps(3,:);
il = find(logratio<=median(logratio));
iu = find(logratio>=median(logratio));
ha = subplot(2,2,3,'parent',hf);
mrt = nanmean(qrt2(:,il),2);
vrt = nanvar(qrt2(:,il),[],2)./length(il);
mef = nanmean(qef2(:,il),2);
vef = nanvar(qef2(:,il),[],2)./length(il);
mEz = nanmean(qez2(:,il),2);
vEz = nanvar(qez2(:,il),[],2)./length(il);
plotUncertainTimeSeries(mrt',vrt',[],ha,[],'b')
plotUncertainTimeSeries(mef',vef',[],ha,[],'g')
plotUncertainTimeSeries(mEz',vEz',[],ha,[],'k')
title(ha,'gamma/alpha: 0-50% quantile')
xlabel(ha,'VCR0')
ylabel(ha,'effort-related variables')
ha = subplot(2,2,4,'parent',hf);
mrt = nanmean(qrt2(:,iu),2);
vrt = nanvar(qrt2(:,iu),[],2)./length(iu);
mef = nanmean(qef2(:,iu),2);
vef = nanvar(qef2(:,iu),[],2)./length(iu);
mEz = nanmean(qez2(:,iu),2);
vEz = nanvar(qez2(:,iu),[],2)./length(iu);
plotUncertainTimeSeries(mrt',vrt',[],ha,[],'b')
plotUncertainTimeSeries(mef',vef',[],ha,[],'g')
plotUncertainTimeSeries(mEz',vEz',[],ha,[],'k')
title(ha,'gamma/alpha: 50-100% quantile')
xlabel(ha,'VCR0')
ylabel(ha,'effort-related variables')


%% test postdiction/prediction accuracy of extended MCD model (with biases)
% MCD postdiction/prediction accuracies
hf = figure('name','Fig 1: MCD prediction accuracies');
haf = axes('parent',hf,'nextplot','add');
hb = bar(haf,lo.mr,'parent',haf);
set(hb,'xdata',1:4:24,'facecolor',0.8*[1,1,1],'barwidth',0.3);
hb = bar(haf,lox.mr,'parent',haf);
set(hb,'xdata',2:4:24,'facecolor','b','barwidth',0.3);
hb = bar(haf,lox2.mr,'parent',haf);
set(hb,'xdata',3:4:24,'facecolor','r','barwidth',0.3);
[haf,hf,hp] = plotUncertainTimeSeries(lo.mr,lo.vr,[],haf);
set(hf,'xdata',1:4:24)
set(hp,'xdata',1:4:24,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(lox.mr,lox.vr,[],haf,[],'b');
set(hf,'xdata',2:4:24)
set(hp,'xdata',2:4:24,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(lox2.mr,lox2.vr,[],haf,[],'r');
set(hf,'xdata',3:4:24)
set(hp,'xdata',3:4:24,'barwidth',0.3)
set(haf,'xtick',2:4:24,'xticklabel',{'Pc','SoA','Qcom','Cert. gain','RT','Eff. rat.'})
ylabel(haf,'trial-by-trial correlation (%)')
box(haf,'off')
legend(haf,{'full data fit','only decision-related','only effort-related'})

% test out-of-sample effort-related correlations
znames = {'choice confidence','spreading of alternatives','change of mind','precision gain','reaction time','effort ratings'};
[pv,stat,df,all] = GLM_contrast(ones(lox.nSubs,1),lox.rs',1,'t',0);
ind = 5:6;
for i=1:length(ind)
    mc = lox.mr(ind(i));
    cs = sqrt(lox.vr(ind(i)));
    t = stat(ind(i));
    p = pv(ind(i));
    disp(['out-of-sample ',znames{ind(i)},' prediction: corr(data,model)=',num2str(mc,2),'% +/-',num2str(cs,2),'%, pval=',num2str(p,3),', t=',num2str(t,3),', dof=',num2str(round(df))])
end
disp(['out-of-sample effort prediction: corr(data,model)=',num2str(mc,2),'% +/-',num2str(cs,2),'%, pval=',num2str(p,3),', t=',num2str(t,3),', dof=',num2str(round(df))])
% test out-of-sample decision-related correlations
[pv,stat,df,all] = GLM_contrast(ones(lox.nSubs,1),lox2.rs',1,'t',0);
ind = 1:4;
for i=1:length(ind)
    mc = lox2.mr(ind(i));
    cs = sqrt(lox2.vr(ind(i)));
    t = stat(ind(i));
    p = pv(ind(i));
    disp(['out-of-sample ',znames{ind(i)},' prediction: corr(data,model)=',num2str(mc,2),'% +/-',num2str(cs,2),'%, pval=',num2str(p,3),', t=',num2str(t,3),', dof=',num2str(round(df))])
end


%% compare parameter estimates
for sub=lo.subs
    P(:,sub) = lo.posteriorSUB{sub}.muPhi(1:5);
    Px(:,sub) = lox.posteriorSUB{sub}.muPhi(1:5);
    Px2(:,sub) = lox2.posteriorSUB{sub}.muPhi(1:5);
end
hf = figure('name','Fig3: parameter estimates');
ha = axes('parent',hf,'nextplot','add');
cols = 'bgrcy';
for i=1:size(A,1)
    hp(i) = plot(ha,P(i,:),Px(i,:),'.','color',cols(i));
end
for i=1:size(A,1)
    out = addBestLinearPredictor(hp(i),0);
    rp = sqrt(out.R2)*100;
    disp(['phi',num2str(i),': corr(P,P[out-of-sample])=',num2str(rp,2),'%, pval=',num2str(out.pv,3)])
end
xlabel(ha,'full data fit')
ylabel(ha,'out-of-sample RT and effort')
legend(ha,{'\phi_1','\phi_2','\phi_3','\phi_4','\phi_5'})

% test parameters
subok = [];
for sub=lo.subs
    if length(unique(lo.penalty{sub}))==1||length(unique(lo.consequential{sub}))==1
    % remove subject
    else
        subok = [subok;sub];
    end
end
GLM_contrast(ones(length(subok),1),Px2(4:5,subok)',1,'t',1,{'cst'},{'cons','pen'})


%% plot data, postdictions and predictions
N = 2;
i2ind = [1,2,4,6,3,5];
znames = {'choice confidence','spreading of alternatives','RT','change of mind','effort ratings','precision gain'};
hf = figure('name','Fig 4: model prediction/postdictions');
for i=1:length(lo.Z) % loop over choice output features (Z={CC,SP,RT,COM,EF})
    Z0i = []; % data
    Zi = cell(2,1); % model predictions and postdictions
    ind = find(i2ind==i);
    for sub=lo.subs % concatenate data over subjects
        Z0i = [Z0i,zscore(vec(lo.Z{i}{sub}))]; % i^th choice feature
        Zi{1} = [Zi{1},vec(lo.outSUB{sub}.suffStat.gx(i,:))]; % postdictions
        if ismember(i,[1,2,4,6]) % use predictions from effort-related variable fit
            zsf = lox2.mr(ind)/100;
            Zi{2} = [Zi{2},zsf*zscore(vec(lox2.outSUB{sub}.suffStat.gx(i,:)))];
        else % use predictions from decision-related variable fit
            zsf = lox.mr(ind)/100; % rs(ind,sub)/100;%
            Zi{2} = [Zi{2},zsf*zscore(vec(lox.outSUB{sub}.suffStat.gx(i,:)))];
        end
    end
    ha(i) = subplot(3,2,i,'parent',hf,'nextplot','add');
    handles = MCD_plot(Z0i,Zi,lo.X,lo.Y,N,ha(i));
    title(ha(i),znames{i})
end


%% compare models with and without beta- and gamma-efficiencies
% MCD prediction accuracies (w/wo x-validation of RT& eff)
cols = 'bgr';
los = {lo,lobe,loga};
hf = figure('name','Fig 5: fit accuracies of reduced models');
haf = axes('parent',hf,'nextplot','add');
for i=1:3
    tmp = los{i};
    hb = bar(haf,tmp.mr,'parent',haf);
    set(hb,'xdata',i:4:24,'facecolor',cols(i),'barwidth',0.3);
end
for i=1:3
    tmp = los{i};
    [haf,hf,hp] = plotUncertainTimeSeries(tmp.mr,tmp.vr,[],haf);
    set(hf,'xdata',i:4:24,'color',cols(i))
    set(hp,'xdata',i:4:24,'barwidth',0.3,'facecolor',cols(i))
end
set(haf,'xtick',2:4:24,'xticklabel',{'Pc','SoA','Qcom','Cert. gain','RT','Eff. rat.'})
ylabel(haf,'trial-by-trial correlation (%)')
box(haf,'off')
legend(haf,{'full model','beta=0','gamma=0'})



%% compare models with and without exponential type #2 effort efficacy
hf = figure('name','Fig 6: linear VS saturating type gamma-effect');
haf = axes('parent',hf,'nextplot','add');
hb = bar(1:3:18,lo.mr,'parent',haf);
set(hb,'facecolor',0.8*[1,1,1],'barwidth',0.1);
hb = bar(2:3:18,loexp.mr,'parent',haf);
set(hb,'facecolor','b','barwidth',0.3);
[haf,hf,hp] = plotUncertainTimeSeries(lo.mr,lo.vr,[],haf);
set(hf,'xdata',1:3:18)
set(hp,'xdata',1:3:18,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(loexp.mr,loexp.vr,[],haf,[],'b');
set(hf,'xdata',2:3:18)
set(hp,'xdata',2:3:18,'barwidth',0.3)
set(haf,'xtick',1.5:3:20,'xticklabel',{'Pc','SoA','Qcom','Cert. gain','RT','Eff. rat.'})
ylabel(haf,'trial-by-trial correlation (%)')
box(haf,'off')
legend(haf,{'linear efficacy','saturating efficacy'})

Fs = NaN(nSubs,2);
for sub=lo.subs % loop over subjects
    Fs(sub,1) = lo.outSUB{sub}.F(end);
    Fs(sub,2) = loexp.outSUB{sub}.F(end);
end
iok = find(~isnan(sum(Fs,2)));
L = Fs(iok,:)';
[posterior,out] = VBA_groupBMC(L);


%% compare RT predictions: MCD vs DDM
hf0 = figure('name','Fig 7: MCD vs DDM');
% plot RT postdictions
haf = subplot(2,2,1,'parent',hf0,'nextplot','add');
hb = bar(1,loort.mr(5),'parent',haf);
set(hb,'facecolor',0.8*[1,1,1],'barwidth',0.3);
hb = bar(2:3,loddm.mr(2:3),'parent',haf);
set(hb,'facecolor','b','barwidth',0.3);
[haf,hf,hp] = plotUncertainTimeSeries(loort.mr(5),loort.vr(5),[],haf);
set(hf,'xdata',1)
set(hp,'xdata',1,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(loddm.mr(2:3),loddm.vr(2:3),[],haf,[],'b');
set(hf,'xdata',2:3)
set(hp,'xdata',2:3,'barwidth',0.3)
set(haf,'xtick',1:3,'xticklabel',{'MCD','DDM1','DDM2'})
ylabel(haf,'trial-by-trial RT correlation (%)')
box(haf,'off')
title(haf,'RT postdictions')
% plot DDM-postdictions of RT data
N = 2;
i2ind = [1,2,4,6,3,5];
ha = subplot(2,2,2,'parent',hf0,'nextplot','add');
Zi = cell(2,1);
Z0i = [];
for sub=1:nSubs % concatenate data over subjects
    Z0i = [Z0i,zscore(vec(lo.RT{sub}))]; % RT
    for i=1:2
        Zi{i} = [Zi{i},vec(loddm.outSUB{i+1,sub}.suffStat.gx)];
    end
end
handles = MCD_plot(Z0i,Zi,lo.X,lo.Y,N,ha);
% extract DDM-prediction of P(change-of-mind)
Qddm = cell(3,1);
com = [];
for sub=1:nSubs % concatenate data over subjects
    data = zscore(vec(lo.COM{sub}));
    com = [com,data]; % change-of-mind
    for i=1:3
        model = DDM_getQ0(loddm.posteriorSUB{i,sub},loddm.outSUB{i,sub});
        rddm(i,sub) = corr(data,model);
        Qddm{i} = [Qddm{i},zscore(model)];
    end
end
mrddm = nanmean(100*rddm,2);
vrddm = nanvar(100*rddm,[],2)./nSubs;
% plot P(change-of-mind) predictions
haf = subplot(2,2,3,'parent',hf0,'nextplot','add');
hb = bar(1,loort.mr(3),'parent',haf);
set(hb,'facecolor',0.8*[1,1,1],'barwidth',0.3);
hb = bar(2:3,mrddm(2:3),'parent',haf);
set(hb,'facecolor','b','barwidth',0.3);
[haf,hf,hp] = plotUncertainTimeSeries(loort.mr(3),loort.vr(3),[],haf);
set(hf,'xdata',1)
set(hp,'xdata',1,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(mrddm(2:3),vrddm(2:3),[],haf,[],'b');
set(hf,'xdata',2:3)
set(hp,'xdata',2:3,'barwidth',0.3)
set(haf,'xtick',1:3,'xticklabel',{'MCD','DDM1','DDM2'})
ylabel(haf,'trial-by-trial RT correlation (%)')
box(haf,'off')
title(haf,'P(com) predictions')
% display P(com) as a function dVR0 and VCR0 
for i=1:3
    Qddm{i} = mrddm(i)*Qddm{i}/100;
end
N = 2;
ha = subplot(2,2,4,'parent',hf0,'nextplot','add');
handles = MCD_plot(com,Qddm(2:3),lo.X,lo.Y,N,ha);

% test postdiction/prediction accuracy differences
dcrt = repmat(loort.rs(5,:),2,1) - loddm.rs(2:3,:);
[pv,stat,df,all] = GLM_contrast(ones(nSubs,1),dcrt',1,'F',1,{'cst'},{'DDM1','DDM2'});
set(all.handles.hf,'name','RT postdictions: MCD-DDM')
dcPcom = repmat(loort.rs(3,:),2,1) - rddm(2:3,:);
[pv,stat,df,all] = GLM_contrast(ones(nSubs,1),dcPcom',1,'F',1,{'cst'},{'DDM1','DDM2'});
set(all.handles.hf,'name','Pcom predictions: MCD-DDM')

%% test postdiction/prediction accuracy of extended MCD model (with biases)
disp(' ')
disp('___________________________')
disp('Extended MCD (with biases!)')
% MCD prediction accuracies (w/wo x-validation of RT& eff)
hf = figure('name','Extended MCD prediction accuracies');
haf = axes('parent',hf,'nextplot','add');
hb = bar(haf,loext.mr,'parent',haf);
set(hb,'xdata',1:4:24,'facecolor',0.8*[1,1,1],'barwidth',0.3);
hb = bar(haf,loext_x.mr,'parent',haf);
set(hb,'xdata',2:4:24,'facecolor','b','barwidth',0.3);
hb = bar(haf,loext_x2.mr,'parent',haf);
set(hb,'xdata',3:4:24,'facecolor','r','barwidth',0.3);
[haf,hf,hp] = plotUncertainTimeSeries(loext.mr,loext.vr,[],haf);
set(hf,'xdata',1:4:24)
set(hp,'xdata',1:4:24,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(loext_x.mr,loext_x.vr,[],haf,[],'b');
set(hf,'xdata',2:4:24)
set(hp,'xdata',2:4:24,'barwidth',0.3)
[haf,hf,hp] = plotUncertainTimeSeries(loext_x2.mr,loext_x2.vr,[],haf,[],'r');
set(hf,'xdata',3:4:24)
set(hp,'xdata',3:4:24,'barwidth',0.3)
set(haf,'xtick',2:4:24,'xticklabel',{'Pc','SoA','Qcom','Cert. gain','RT','Eff. rat.'})
hb = plot(1:4:24,lo.mr,'k','marker','diamond','linestyle','none','parent',haf);
hb = plot(2:4:24,lox.mr,'k','marker','diamond','linestyle','none','parent',haf);
hb = plot(3:4:24,lox2.mr,'k','marker','diamond','linestyle','none','parent',haf);

ylabel(haf,'trial-by-trial correlation (%)')
box(haf,'off')
legend(haf,{'full data fit','only decision-related','only effort-related'})


% test out-of-sample effort-related correlations
znames = {'choice confidence','spreading of alternatives','change of mind','precision gain','reaction time','effort ratings'};
[pv,stat,df,all] = GLM_contrast(ones(lox.nSubs,1),loext_x.rs',1,'t',0);
ind = 5:6;
for i=1:length(ind)
    mc = loext_x.mr(ind(i));
    cs = sqrt(loext_x.vr(ind(i)));
    t = stat(ind(i));
    p = pv(ind(i));
    disp(['out-of-sample ',znames{ind(i)},' prediction: corr(data,model)=',num2str(mc,2),'% +/-',num2str(cs,2),'%, pval=',num2str(p,3),', t=',num2str(t,3),', dof=',num2str(round(df))])
end
disp(['out-of-sample effort prediction: corr(data,model)=',num2str(mc,2),'% +/-',num2str(cs,2),'%, pval=',num2str(p,3),', t=',num2str(t,3),', dof=',num2str(round(df))])
% test out-of-sample decision-related correlations
[pv,stat,df,all] = GLM_contrast(ones(lox.nSubs,1),loext_x2.rs',1,'t',0);
ind = 1:4;
for i=1:length(ind)
    mc = loext_x2.mr(ind(i));
    cs = sqrt(loext_x2.vr(ind(i)));
    t = stat(ind(i));
    p = pv(ind(i));
    disp(['out-of-sample ',znames{ind(i)},' prediction: corr(data,model)=',num2str(mc,2),'% +/-',num2str(cs,2),'%, pval=',num2str(p,3),', t=',num2str(t,3),', dof=',num2str(round(df))])
end


% test parameters
for sub=1:nSubs
    Pe(:,sub) = loext.posteriorSUB{sub}.muPhi(1:11);
    Pex(:,sub) = loext_x.posteriorSUB{sub}.muPhi(1:11);
    Pex2(:,sub) = loext_x2.posteriorSUB{sub}.muPhi(1:11);
end
GLM_contrast(ones(nSubs,1),Pe',1,'F',1)


% plot data, postdictions and predictions
N = 2;
i2ind = [1,2,4,6,3,5];
znames = {'choice confidence','spreading of alternatives','RT','change of mind','effort ratings','precision gain'};
hf = figure('name','Fig 4: model prediction/postdictions');
for i=1:length(lo.Z) % loop over choice output features (Z={CC,SP,RT,COM,EF})
    Z0i = []; % data
    Zi = cell(2,1); % model predictions and postdictions
    ind = find(i2ind==i);
    for sub=lo.subs % concatenate data over subjects
        Z0i = [Z0i,zscore(vec(lo.Z{i}{sub}))]; % i^th choice feature
        Zi{1} = [Zi{1},vec(lo.outSUB{sub}.suffStat.gx(i,:))]; % postdictions
        if ismember(i,[1,2,4,6]) % use predictions from effort-related variable fit
            zsf = lox2.mr(ind)/100;
            Zi{2} = [Zi{2},zsf*zscore(vec(lox2.outSUB{sub}.suffStat.gx(i,:)))];
        else % use predictions from decision-related variable fit
            zsf = lox.mr(ind)/100; % rs(ind,sub)/100;%
            Zi{2} = [Zi{2},zsf*zscore(vec(lox.outSUB{sub}.suffStat.gx(i,:)))];
        end
    end
    ha(i) = subplot(3,2,i,'parent',hf,'nextplot','add');
    handles = MCD_plot(Z0i,Zi,lo.X,lo.Y,N,ha(i));
    title(ha(i),znames{i})
end
