function handles = MCD_plot(Z0,Z,X,Y,N,ha)
% compares model predictions/postdictions and data
% function hf = MCD_plot(dataSUB,outSUB,N)
% This function plots fitted and empirical data against 2 variables X and
% Y, which are partitioned within subjects into N bins.
% IN:
%   - Z0: a ntxnSubs array of dependent data
%   - Z: a px1 cell array of ntxnSubs model predictions/postdictions
%   - X,Y: ntxnSubs array of independent variables
%   - N: the number of bins
% OUT:
%   - handles: a structure containing the handle of graphical objects

try,N;catch,N=2;end
try,ha;catch,ha=[];end

if ~isempty(ha) && ishandle(ha) && isequal(get(ha,'type'),'axes')
    handles.hf = get(ha,'parent');
    handles.ha = ha;
    set(handles.ha,'nextplot','add');
else
    handles.hf = figure('color',[1 1 1]);
    handles.ha = axes('parent',handles.hf,'nextplot','add');
end
    

p = length(Z); % nb of model predictions to plot (max = 3)
if p > 3
    disp('MCD_plot: error: length(Z) >3 !!')
    handles = [];
    return
end

col = 'bgrc';


% 2D-binning of data
os = smart2DbinPlot(X,Y,Z0,N,0);
EZs = os.EZxy;
VZs = os.VZxy;
Ns = os.nxy;
dx = 0.5./N;
for j=1:N
    handles.he(j) = errorbar((j-N/2)*dx+[1:N],EZs(:,j),sqrt(VZs(:,j)./Ns(:,j)),'parent',handles.ha,...
        'marker','.','linestyle','-','linewidth',2,'markersize',24,'color',col(j));
    strx{j} = [num2str(round(100*(j-1)/N)),'-',num2str(round(100*j/N)),'%'];
    strl{j} = ['VCR0 percentile: ',strx{j}];
end
% 2D-binning of DDM model fits
markers = {'diamond','p','*'};
linestyles = {'--',':','-.'};
for i=1:p
    Zi = Z{i};
    out = smart2DbinPlot(X,Y,Zi,N,0);
    EZs = out.EZxy;
    for j=1:N
        handles.he2(j,i) = plot((j-N/2)*dx+[1:N],EZs(:,j),'parent',handles.ha,...
            'marker',markers{i},'linestyle',linestyles{i},'linewidth',1,'markersize',12,'color',col(j));
    end
end
xlabel(handles.ha,'dVR0 percentile')
set(handles.ha,'xtick',1:N,'xticklabel',strx,'xlim',0.5+[0,N])
legend(handles.ha,strl)
getSubplots


