function R2s0 = MCDfit_H0()
% MCD model predictive power under the null
% This function feeds random data to the MCD inversion scheme. This then
% serves to evaluate the expected amount of variance explained under the
% null.

% set inversion options
dim.n = 0;
dim.n_phi = 22;
dim.n_theta = 0;
options.priors.SigmaPhi = 1e2.*eye(dim.n_phi);
options.priors.muPhi = zeros(dim.n_phi,1);
options.verbose = 1;
options.DisplayWin = 0;
g_fname = @g_MCD;
nt = 74; % nb of decision trials

Nmc = 1e2; % number of Monte-Carlo simulations
R2s0 = NaN(5,Nmc);
for imc = 1:Nmc
    imc
    % simulate random data (under the null)
    data = zscore(randn(nt,5))';
    input = 0.01+0.98*rand(3,nt);
    [posterior,out] = VBA_NLStateSpaceModel(data,input,[],g_fname,dim,options);
    R2s0(:,imc) = getR2s(out);
end
