% performs simple model comparison on variant of MCD model

% close all
% clear all

switchFlags = [[1;1;1],[1;0;1],[1;1;0]]; % model variants
thisdate = '12-Jan-2021';
nSubs = 41;
Fs = NaN(nSubs,3);
for i=1:3 % loop over models
    % load model inversion results
    flags = [];
    for j=1:3
        flags = [flags,num2str(switchFlags(j,i))];
    end
    fsn = ['results_MCD_',thisdate,'_wobias_',flags,'_V100_Dcert.mat'];
    lo = load(fsn);
    close all
    % get log-evidences
    for sub=lo.subs
        Fs(sub,i) = lo.outSUB{sub}.F(end);
        rs(:,i,sub) = lo.rs(:,sub);
    end
end
% flags = '111';
% fsn = ['results_MCD_',thisdate,'_wobias_',flags,'_V10_Dcert.mat'];
% lo = load(fsn);
% close all
% % get log-evidences
% for sub=lo.subs
%     Fs(sub,4) = lo.outSUB{sub}.F(end);
%     rs(:,4,sub) = lo.rs(:,sub);
% end
% fsn = ['results_MCD_',thisdate,'_wobias_',flags,'_V1_Dcert.mat'];
% lo = load(fsn);
% close all
% % get log-evidences
% for sub=lo.subs
%     Fs(sub,5) = lo.outSUB{sub}.F(end);
%     rs(:,5,sub) = lo.rs(:,sub);
% end

iok = find(~isnan(sum(Fs,2)));
L = Fs(iok,:)';

[posterior,out] = VBA_groupBMC(L);

mr = nanmean(rs,3);
sr = nanstd(rs,[],3)./sqrt(length(lo.subs));
hf = figure('color',[1,1,1]);
ha = axes('parent',hf,'nextplot','add');
cc = 'brgcy';
for i=1:size(mr,2)
    hb(i) = bar(mr(:,i),'parent',ha);
    xx = i:(size(mr,2)+1):((size(mr,2)+1)*size(mr,1));
    set(hb(i),'facecolor',cc(i),'xdata',xx,'barwidth',0.2);
    he = errorbar(xx,mr(:,i),sr(:,i),'color',cc(i)','linestyle','none','parent',ha);
end
ynames = {'Pc','SoA','Qcom','iV gain','RT','Eff'};
set(ha,'xtick',(size(mr,2)/2):(size(mr,2)+1):((size(mr,2)+1)*size(mr,1)),'xticklabel',ynames)