% demo for VBA inversion of MCD model
% This demo first simulates data under the MCD model (choice confidence,
% SOA, response time, change of mind, subjective effort). Then the data is
% zscored and sent to VBA for parameter estimation. Results are displayed,
% as well as summary statistics oft he simulated and fitted data.

clear all
close all


% set dim and option structures
dim.n_theta = 0;
dim.n = 0;
dim.n_phi = 22;
dim.p = 6;
dim.n_t = 3e2; % nb of trials
options.dim = dim;
g_fname = @g_MCD; % this is where it all happens :)

% simulation params
ease = abs(randn(1,dim.n_t));
cert = abs(rand(1,dim.n_t));
input = [ease;cert;zeros(2,dim.n_t)];
sigma = Inf;%1e3;
phi = randn(dim.n_phi,1);
phi(1) = mean(phi(2:3))-4; % for 
phi(8:11) = 1;


% Simulate time series of hidden states and observations
[y,x,x0,eta,e] = simulateNLSS(dim.n_t,[],g_fname,[],phi,input,[],sigma,options);
data = zscore(y')';



options.priors.SigmaPhi = 1e0.*eye(dim.n_phi);
% options.priors.SigmaPhi(4,4) = 0;
options.priors.muPhi = zeros(dim.n_phi,1); %[0,0,1,0,0,-10,0]'; % 
options.verbose = 1;
options.DisplayWin = 1;

[posterior,out] = VBA_NLStateSpaceModel(data,input,[],g_fname,dim,options);

% Display results
displayResults(posterior,out,y,[],[],[],phi,[],sigma)


% display data summary
znames = {'choice confidence','spreading of alternatives','effort rating','change of mind'};
Xs = cell(4,1);
Ys = cell(4,1);
EZs = cell(4,1);
VZs = cell(4,1);
N = 4;
for i=1:4
    tmp = {data(i,:)',out.suffStat.gx(i,:)'};
    type = {'data','model'};
    for j=1:2
        os = smart2DbinPlot(input(1,:)',input(2,:)',tmp{j},N,0);
        EZs{i,j} = os.EZxy;
        VZs{i,j} = os.VZxy;
        Ns{i,j} = os.nxy;
        Xs{i,j} = os.Xxy;
        Ys{i,j} = os.Yxy;
    end
    
end



hf = figure('name','fit accuracy');
for i=1:4
    ha = subplot(2,2,i,'parent',hf,'nextplot','add');
    he = errorbar(EZs{i,1},sqrt(VZs{i,1}),'parent',ha,'marker','.');%,'linestyle','none');
    plot(EZs{i,2},'--')
    title(ha,znames{i})
    xlabel(ha,'choice ease percentile')
    for il=1:N
        strx{il} = [num2str(round(100*(il-1)/N)),'-',num2str(round(100*il/N)),'%'];
        strl{il} = ['certainty: ',strx{il}];
    end
    set(ha,'xtick',1:N,'xticklabel',strx)
    legend(ha,strl)
end



