function R2s = getR2s(out)
% get channel-specific percentage of  explained variance
% function R2s = getR2s(out)
% IN:
%   - out: VBA output structure (see VBA_NLStateSpaceModel.m)
% OUT:
%   - R2s: px1 vector of percentage of explained variance, where p is th
%   enumber of data channels.

p = out.dim.p;
R2s = NaN(p,1);
for i=1:p
    gi = out.suffStat.gx(i,:);
    yi = out.y(i,:);
    SSreg = sum((yi-gi).^2);
    SStot = sum((yi-mean(yi)).^2);
    R2s(i) = 1-SSreg/SStot;
end