function [b] = multiSubjectGLM(Y,X)
% loops over subject to perform a GLM and reports standardized reg coeff
% function [b] = multiSubjectGLM(Y,X)
% IN:
%   - Y: nSubsx1 cell array of dependent variable
%   - X: nSubsx1 cell array of p regressors
% OUT:
%   - b: pxnSubs matrix of within-subject regressors

nSubs = length(Y);
for sub=1:nSubs
    y = Y{sub}(:);
    my = mean(y);
    y = zscore(y) + my;
    iX = pinv(X{sub}'*X{sub})*X{sub}';
    b(:,sub) = iX*y;
end
