clear all
close all

% original.filename = 'Analysis new experiments.xlsx';
% original.foldername = 'C:\Users\dehmelt\Dropbox\Desk\20181125 Ergebnisse Clara\';
% original.foldername = ['\\172.25.250.112\arrenberg_data\shared\MS_SphereArena\Resources\', ...
%   'ContributionClara\190604_forFD_foldersCSfromAA\postBachelor_flippedscreens_181125'];

% original.filename = 'Reanalysis.xlsx';
original.filename = 'Reanalysis_FD20190606.xlsx';
original.foldername = ['\\172.25.250.112\arrenberg_data\shared\MS_SphereArena\Resources\', ...
                  'ContributionClara\190604_forFD_foldersCSfromAA\181009\'];
flippedscreen.filename = 'Analysis new experiments.xlsx';
flippedscreen.foldername = ['\\172.25.250.112\arrenberg_data\shared\MS_SphereArena\Resources\', ...
                  'ContributionClara\190604_forFD_foldersCSfromAA\postBachelor_flippedscreens_181125\'];
                

% type 1: left eye BLANK
% type 2: right eye BLANK
% type 3: moving stimulus for both eyes
% type 4: left eye STATIONARY
% type 5: right eye STATIONARY
% type 6: STATIONARY stimulus for both eyes
% type 7: left eye SHIELDED
% type 8: right eye SHIELDED
% type 9: BLANK stimulus for both eyes
% Eyes not mentioned were always exposed to a moving stimulus.
labelstring = [{'LE blank', 'RE blank', 'binocular stim.', 'LE stationary', 'RE stationary', ...
               'both stationary', 'LE shielded', 'RE shielded', 'both blank',}, ...
               cell(1,13),{'binocular stim.*'},cell(1,3),{'LE shielded*','RE shielded*'}];

% Interesting comparisons: 3 vs. 7 and 8, 3 vs. 4 and 5, 3 vs. 1 and 2, 1 vs. 7 and 2 vs. 8
% To use new data with flipped screens, prefix a "2", e.g., "28" for new type 8.
% comparison = {[3 7 8], [3 4 5], [3 1 2], [1 7 2 8]};
% comparison = {[23 27 28], [23 4 5], [23 1 2], [1 27 2 28]};
comparison = {[23 4 5], [23 1 2], [23 27 28], [1 27 2 28]};

% Read and process data:
for stimtype = 1:9
  fieldstr = ['type',num2str(stimtype)];
  no1 = num2str(stimtype+2);       % row of single-digit stimtype (e.g. ST4),  first half of fish
  no2 = num2str(stimtype+2+9);     % row of double-digit stimtype (e.g. ST13), first half of fish
  no3 = num2str(stimtype+2+24);    % row of single-digit stimtype (e.g. ST4),  second half of fish
  no4 = num2str(stimtype+2+9+24);  % row of double-digit stimtype (e.g. ST13), second half of fish
  data.(fieldstr).rawdata = ...
    [xlsread([original.foldername,original.filename],'Raw data FD20190606',['B',no1,':W',no1]), ...
     xlsread([original.foldername,original.filename],'Raw data FD20190606',['B',no3,':W',no3]), ...
     xlsread([original.foldername,original.filename],'Raw data FD20190606',['B',no2,':W',no2]), ...
     xlsread([original.foldername,original.filename],'Raw data FD20190606',['B',no4,':W',no4])];
  data.(fieldstr).left.raw  = data.(fieldstr).rawdata(1:2:end);
  data.(fieldstr).right.raw = data.(fieldstr).rawdata(2:2:end);
  data.(fieldstr).left.mean  = nanmean(data.(fieldstr).left.raw);
  data.(fieldstr).right.mean = nanmean(data.(fieldstr).right.raw);
  data.(fieldstr).left.std  = nanstd(data.(fieldstr).left.raw);
  data.(fieldstr).right.std = nanstd(data.(fieldstr).right.raw);
  data.(fieldstr).left.sem  = nanstd(data.(fieldstr).left.raw) / ...
                              sqrt(numel(~isnan(data.(fieldstr).left.raw)));
  data.(fieldstr).right.sem = nanstd(data.(fieldstr).right.raw) / ...
                              sqrt(numel(~isnan(data.(fieldstr).right.raw)));
end

% Read and process revised data:
% type 3: moving stimulus for both eyes (here type 23 to distinguish from original type 3)
data.type23.left.mean = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','B3');
data.type23.left.std  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','B4');
data.type23.left.sem  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','B5');
data.type23.right.mean = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','D3');
data.type23.right.std  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','D4');
data.type23.right.sem  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','D5');
% type 7: left eye shielded (here type 27 to distinguish from original type 7)
data.type27.left.mean = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','B15');
data.type27.left.std  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','B16');
data.type27.left.sem  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','B17');
data.type27.right.mean = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','D15');
data.type27.right.std  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','D16');
data.type27.right.sem  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','D17');
% type 8: right eye shielded (here type 28 to distinguish from original type 8)
data.type28.left.mean = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','E15');
data.type28.left.std  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','E16');
data.type28.left.sem  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','E17');
data.type28.right.mean = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','G15');
data.type28.right.std  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','G16');
data.type28.right.sem  = xlsread([flippedscreen.foldername,flippedscreen.filename],'RESULTS','G17');


% Plot:
for choice = 1:numel(comparison)
  
  % Basic plots:
  hd = barfigure(data,comparison{choice},labelstring);

  % Display panel lettering:
  hd = letterfigure(hd,choice);
  
end

% figure(101)
% hold on
% bar(1:4,[data.type4.left.mean,data.type4.right.mean,data.type5.left.mean,data.type5.right.mean])
% hold off




function hd = letterfigure(hd,choice)

  hd.clara.ax(3,1) = axes;
  hd.clara.ax(3,1).Color = 'none';
  hd.clara.ax(3,1).Position = [0 0 1 1];
  hd.clara.ax(3,1).Units = 'pixels';
  hd.clara.ax(3,1).Visible = 'off';
  hold on
  hd.clara.lt(1) = text(hd.clara.ax(1,1).Position(1) - 85, ...
                        hd.clara.ax(1,1).Position(2) + hd.clara.ax(1,1).Position(4) + 20, ...
                        char(96+2*(choice-1)+1), 'Units', 'pixels');
  hd.clara.lt(2) = text(hd.clara.ax(2,1).Position(1) - 85, ...
                        hd.clara.ax(1,1).Position(2) + hd.clara.ax(1,1).Position(4) + 20, ...
                        char(96+2*(choice-1)+2), 'Units', 'pixels');
  hold off
  [hd.clara.lt(:).FontSize] = deal(15);
  [hd.clara.lt(:).FontWeight] = deal('bold');



  [hd.clara.ax(1,:).LabelFontSizeMultiplier, ...
   hd.clara.ax(1,:).TitleFontSizeMultiplier] = deal(1);

end



function hd = barfigure(data,stimlist,labelstring)

  % Create basic figure and axes:
  hd.clara.fg = figure();
  hd.clara.fg.Color = [1 1 1];
  hd.clara.fg.Name = 'Supplementary Figure: Clara''s controls';

  hd.clara.ax(1,1) = axes();
  hd.clara.ax(2,1) = axes();

  [hd.clara.fg.Units, hd.clara.ax(:,:).Units] = deal('pixels');
  [hd.clara.ax(:,:).FontSize] = deal(15);
  [hd.clara.ax(:,:).TitleFontSizeMultiplier, ...
   hd.clara.ax(:,:).LabelFontSizeMultiplier] = deal(1);
  [hd.clara.ax(:,:).TitleFontWeight] = deal('normal');

  hd.clara.fg.Position = [50 500 900 450];
  hd.clara.ax(1,1).Position = [110 120 280 280];
  hd.clara.ax(2,1).Position = [580 120 280 280];
  
  % Define yoking index:
  yoking = @(a,b) (a-b)./(a+b);
  
  % Data collection:
  % barxpos = [1 3.5 2 4.5];
  if numel(stimlist) == 3
    barxpos = [1 2 3 4.5 5.5 6.5];
    greenindex = [1 numel(stimlist)+1];
  elseif numel(stimlist) == 4
    barxpos = [1 2 3.25 4.25 6 7 8.25 9.25];
    greenindex = [1 1 1 1] + [0 1 2 3]/2*numel(stimlist);
  else
    barxpos = 1:numel(stimlist);
    greenindex = NaN;
%     greenindex = [1 numel(stimlist)+1];
  end

  greyindex = setdiff(1:numel(barxpos), greenindex);
  
  if numel(stimlist) < 4
    
    [greenmean,greenstd,greensem,greymean,greystd,greysem] = deal(NaN(1, numel(barxpos)));

    % data for green bars
    greenmean(greenindex) = [data.(['type',num2str(stimlist(1))]).left.mean, ...
                             data.(['type',num2str(stimlist(1))]).right.mean];
    greenstd(greenindex)  = [data.(['type',num2str(stimlist(1))]).left.std, ...
                             data.(['type',num2str(stimlist(1))]).right.std];
    greensem(greenindex)  = [data.(['type',num2str(stimlist(1))]).left.sem, ...
                             data.(['type',num2str(stimlist(1))]).right.sem];
                           
    % data for grey bars
    [meancollection,stdcollection,semcollection] = deal([]);
    for stimindex = 2:numel(stimlist)
      meancollection = [meancollection, data.(['type',num2str(stimlist(stimindex))]).left.mean, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.mean];
      stdcollection  = [stdcollection,  data.(['type',num2str(stimlist(stimindex))]).left.std, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.std];
      semcollection  = [semcollection,  data.(['type',num2str(stimlist(stimindex))]).left.sem, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.sem];
    end
    greymean(greyindex) = [meancollection(1:2:end),meancollection(2:2:end)];
    greystd(greyindex)  = [stdcollection(1:2:end),stdcollection(2:2:end)];
    greysem(greyindex)  = [semcollection(1:2:end),semcollection(2:2:end)];
    
  elseif numel(stimlist) >= 4
    
    [greenmean,greenstd,greensem,greymean,greystd,greysem] = deal(NaN(1, numel(barxpos)));

    % data for green bars
    [meancollection,stdcollection,semcollection] = deal([]);
    for stimindex = 1:2:numel(stimlist)
      meancollection = [meancollection, data.(['type',num2str(stimlist(stimindex))]).left.mean, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.mean];
      stdcollection  = [stdcollection,  data.(['type',num2str(stimlist(stimindex))]).left.std, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.std];
      semcollection  = [semcollection,  data.(['type',num2str(stimlist(stimindex))]).left.sem, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.sem];
    end
    greenmean(greenindex) = [meancollection(1:2:end),meancollection(2:2:end)];
    greenstd(greenindex)  = [stdcollection(1:2:end),stdcollection(2:2:end)];
    greensem(greenindex)  = [semcollection(1:2:end),semcollection(2:2:end)];
    
    % data for grey bars                    
    [meancollection,stdcollection,semcollection] = deal([]);
    for stimindex = 2:2:numel(stimlist)
      meancollection = [meancollection, data.(['type',num2str(stimlist(stimindex))]).left.mean, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.mean];
      stdcollection  = [stdcollection,  data.(['type',num2str(stimlist(stimindex))]).left.std, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.std];
      semcollection  = [semcollection,  data.(['type',num2str(stimlist(stimindex))]).left.sem, ...
                                        data.(['type',num2str(stimlist(stimindex))]).right.sem];
    end
    greymean(greyindex) = [meancollection(1:2:end),meancollection(2:2:end)];
    greystd(greyindex)  = [stdcollection(1:2:end),stdcollection(2:2:end)];
    greysem(greyindex)  = [semcollection(1:2:end),semcollection(2:2:end)];
    
  end
  
  % The actual plotting:  
  axes(hd.clara.ax(1,1));
  hold on
  hd.clara.ba(1,1,1) = bar(barxpos, greenmean);
  hd.clara.er(1,1,1) = errorbar(barxpos, greenmean, greensem);
  hd.clara.ba(1,1,2) = bar(barxpos, greymean);
  hd.clara.er(1,1,2) = errorbar(barxpos, greymean, greysem);
  hold off

  axes(hd.clara.ax(2,1));
  hold on
  hd.clara.ba(2,1,1) = bar(barxpos(1:end/2), yoking(greenmean(1:end/2),greenmean(end/2+1:end)));
  % hd.clara.er(2,1,1) = errorbar(barxpos(1:2), ...
  hd.clara.ba(2,1,2) = bar(barxpos(1:end/2), yoking(greymean(1:end/2),greymean(end/2+1:end)));
  % hd.clara.er(2,1,2) = errorbar(barxpos(3:4), ...
  hold off
  
  % Improve figure appearance:
  [hd.clara.er(:).LineStyle] = deal('none');
  [hd.clara.er(:).LineWidth] = deal(1.25);
  [hd.clara.er(:).Color] = deal(.1*[1 1 1]);
  [hd.clara.ba(1,:,:).BarWidth] = deal(.8);
  [hd.clara.ba(2,:,:).BarWidth] = deal(.8);
  if numel(stimlist) < 4
    [hd.clara.ba(:,:,1).FaceColor] = deal([.2 .7 .4]);
  else
    [hd.clara.ba(:,:,1).FaceColor] = deal(.4*[1 1 1]);
  end
  [hd.clara.ba(:,:,2).FaceColor] = deal(.7*[1 1 1]);
  [hd.clara.ba(:).EdgeColor] = deal('none');

  [hd.clara.ax(1,1).XLim] = deal([0 max(barxpos)+.75]);
%   [hd.clara.ax(2,1).XLim] = deal([.25 3.5]);
%   [hd.clara.ax(2,1).YLim] = deal([-.12 .12]);
  [hd.clara.ax(2,1).XLim] = deal([.25 max(barxpos(1:end/2))+.75]);
  [hd.clara.ax(2,1).YLim] = deal([-.3 .3]);

  hd.clara.ax(1,1).XTick = unique(barxpos);
  hd.clara.ax(2,1).XTick = unique(barxpos(1:end/2));
  [hd.clara.ax(:,1).XTickLabelRotation] = deal(40);
  [hd.clara.ax(1,1).XTickLabel] = deal({labelstring{[stimlist,stimlist]}});
  [hd.clara.ax(2,1).XTickLabel] = deal({labelstring{stimlist}});

  hd.clara.ax(1,1).YLabel.String = 'mean OKR gain';
  hd.clara.ax(2,1).YLabel.String = 'yoking index Y';
  for panel = 1:2
    hd.clara.ax(panel,1).YLabel.Units = 'pixels';
    hd.clara.ax(panel,1).YLabel.Position(1) = hd.clara.ax(panel,1).YLabel.Position(1) - 15;
  end

  hd.clara.ax(1,1).Title.String = {'   left eye gain,  right eye gain'};
  hd.clara.ax(2,1).Title.String = {'Y = (g_L - g_R)/(g_L + g_R)'};
  
  axes(hd.clara.ax(1,1));
  hold on
  plot(get(gca,'XLim'),[0 0],'-k','LineWidth',.25)
  hold off
  axes(hd.clara.ax(2,1));
  hold on
  plot(get(gca,'XLim'),[0 0],'-k','LineWidth',.25)
  hold off

end
