function [coefficientIndividual,observationvariance,residual,coefficientvariance, ...
          designMultivariate,coefficientShared] = asymmetryRegression
  
  regularset.file =  'result_20180110_125537.mat';
  regularset.folder = ['\\172.25.250.112\arrenberg_data\shared\MS_SphereArena\Resources\', ...
    'ContributionFlorian\Analysis pipeline\Data D Series (neue Experimente)\'];
%   regularset.folder = ['C:\Users\dehmelt\Dropbox\Documents\MATLAB\201812 Sphere Analysis\', ...
%                  'Analysis pipeline 20181217\Data D Series (neue Experimente)\'];
  rotatedset.file = 'result_20181001_114504.mat';
  rotatedset.folder = ['\\172.25.250.112\arrenberg_data\shared\MS_SphereArena\Resources\', ...
    'ContributionFlorian\Analysis pipeline\Control Data Rotation (arena flip)\'];
%   rotatedset.folder = ['C:\Users\dehmelt\Dropbox\Documents\MATLAB\201812 Sphere Analysis\', ...
%                  'Analysis pipeline 20181217\Control Data Rotation (arena flip)\'];
  upsidedown.file = 'result_20180913_151415.mat';
  upsidedown.folder = ['\\172.25.250.112\arrenberg_data\shared\MS_SphereArena\Resources\', ...
    'ContributionFlorian\Analysis pipeline\Control Data Upside Down (Kontrolle ventral)\'];
%   upsidedown.folder = ['C:\Users\dehmelt\Dropbox\Documents\MATLAB\201812 Sphere Analysis\', ...
%                  'Analysis pipeline 20181217\Control Data Upside Down (Kontrolle ventral)\'];
          
  regularset.structure = load([regularset.folder,regularset.file],'result');
  rotatedset.structure = load([rotatedset.folder,rotatedset.file],'result');
  upsidedown.structure = load([upsidedown.folder,upsidedown.file],'result');
  regularset.result = regularset.structure.result;
  rotatedset.result = rotatedset.structure.result;
  upsidedown.result = upsidedown.structure.result;
  
  % Discard unwanted trials, based on .xlsx documenting manual assessment.
  regularset.result = discardTrial(regularset.result,regularset.folder);
  rotatedset.result = discardTrial(rotatedset.result,rotatedset.folder);
  upsidedown.result = discardTrial(upsidedown.result,upsidedown.folder);
  
  % Pool gain data in various ways (this is a significant subfunction!).
  regularset.gain = poolGainData(regularset.result);
  rotatedset.gain = poolGainData(rotatedset.result);
  upsidedown.gain = poolGainData(upsidedown.result);
  
  % Crucial settings!
  stimselectionnew = 7 + (1:38); % disk stimuli; stimulus indices from 1, not row numbers
  stimselectionold = 1:36;       % disk stimuli; stimulus indices from 1, not row numbers
  cutoff = 0; % Ignore gains in the bottom fraction of each fish (.7 = remove bottom 70%).
  
  regularset.stimulusfile = 'Stimulus.xlsx';
  [~,regularset.tableconvention,~] = xlsread([regularset.folder,regularset.stimulusfile],'C1:C1');
  regularset.azimuth = xlsread([regularset.folder,regularset.stimulusfile], ...
                             ['C',num2str(1+stimselectionnew(1)),':C',num2str(1+stimselectionnew(end))]);
  regularset.elevation = xlsread([regularset.folder,regularset.stimulusfile], ...
                             ['D',num2str(1+stimselectionnew(1)),':D',num2str(1+stimselectionnew(end))]);

  rotatedset.stimulusfile = 'Stimulus.xlsx';
  [~,rotatedset.tableconvention,~] = xlsread([rotatedset.folder,rotatedset.stimulusfile],'C1:C1');
  rotatedset.azimuth = xlsread([rotatedset.folder,rotatedset.stimulusfile], ...
                             ['C',num2str(1+stimselectionnew(1)),':C',num2str(1+stimselectionnew(end))]);
  rotatedset.elevation = xlsread([rotatedset.folder,rotatedset.stimulusfile], ...
                             ['D',num2str(1+stimselectionnew(1)),':D',num2str(1+stimselectionnew(end))]);
 
  upsidedown.stimulusfile = 'Stimulus.xlsx';
  [~,upsidedown.tableconvention,~] = xlsread([upsidedown.folder,upsidedown.stimulusfile],'C1:C1');
  upsidedown.azimuth = xlsread([upsidedown.folder,upsidedown.stimulusfile], ...
                             ['C',num2str(1+stimselectionold(1)),':C',num2str(1+stimselectionold(end))]);
  upsidedown.elevation = xlsread([upsidedown.folder,upsidedown.stimulusfile], ...
                             ['D',num2str(1+stimselectionold(1)),':D',num2str(1+stimselectionold(end))]);
 
  reg.body.left  = find(regularset.azimuth < 0);
  reg.body.right = find(regularset.azimuth > 0);
  rot.body.left  = find(rotatedset.azimuth < 0);
  rot.body.right = find(rotatedset.azimuth > 0);
  ups.body.left  = find((upsidedown.azimuth < 0) .* (upsidedown.azimuth > -180));
  ups.body.right = find((upsidedown.azimuth > 0) .* (upsidedown.azimuth < +180));
%   arena.left = 1:19;
%   arena.right = 20:38;
  reg.arena.left  = reg.body.left;
  reg.arena.right = reg.body.right;
  rot.arena.left  = rot.body.right;
  rot.arena.right = rot.body.left;
  ups.arena.left  = ups.body.right;
  ups.arena.right = ups.body.left;
  
  regulardata = regularset.gain.mean.ER;
  rotateddata = rotatedset.gain.mean.ER;
  flippeddata = upsidedown.gain.mean.ER;
  
  num.fishregular = numel(regulardata);
  num.fishrotated = numel(rotateddata);
  num.fishflipped = numel(flippeddata);
  num.stimtypenew = numel(stimselectionnew);
  num.stimtypeold = numel(stimselectionold);
  
  num.fish = num.fishregular + num.fishrotated + num.fishflipped;
  num.sample = (num.fishregular+num.fishrotated)*num.stimtypenew + num.fishflipped*num.stimtypeold;

  observation = [];
  for fish = 1:num.fishregular
    singlefishdata = regulardata{fish}(stimselectionnew);
    sorted = sort(singlefishdata);
    singlefishdata(singlefishdata < sorted(max([1,round(numel(sorted)*cutoff)]))) = NaN;
    observation = [observation; singlefishdata]; %#ok<AGROW>
  end
  for fish = 1:num.fishrotated
    singlefishdata = rotateddata{fish}(stimselectionnew);
    sorted = sort(singlefishdata);
    singlefishdata(singlefishdata < sorted(max([1,round(numel(sorted)*cutoff)]))) = NaN;
    observation = [observation; singlefishdata]; %#ok<AGROW>
  end
  for fish = 1:num.fishflipped
    singlefishdata = flippeddata{fish}(stimselectionold);
    sorted = sort(singlefishdata);
    singlefishdata(singlefishdata < sorted(max([1,round(numel(sorted)*cutoff)]))) = NaN;
    observation = [observation; singlefishdata]; %#ok<AGROW>
  end
  

  designBivariate    = zeros(num.sample, 2);
  designBivariate    = filldesignmatrix(designBivariate,num.fishregular,num.stimtypenew,reg);
  designBivariate    = filldesignmatrix(designBivariate,num.fishrotated,num.stimtypenew,rot);
  designBivariate    = filldesignmatrix(designBivariate,num.fishflipped,num.stimtypeold,ups);
  
  designMultivariate = zeros(num.sample, 2+num.fish);
  designMultivariate = filldesignmatrix(designMultivariate,num.fishregular,num.stimtypenew,reg);
  designMultivariate = filldesignmatrix(designMultivariate,num.fishrotated,num.stimtypenew,rot);
  designMultivariate = filldesignmatrix(designMultivariate,num.fishflipped,num.stimtypeold,ups);
  
  designShared = designBivariate;
  designIndividual = designMultivariate(:,3:end);
  
  
  
  % Alternative averaging across groups of "same-side" stimuli of the same fish, 
  % e.g., across all left-side and all right-side stimuli, respectively:
  [uniqueIndividual,groupspecimen,group] = unique(designIndividual,'stable','rows');
  uniqueShared = designShared(groupspecimen,:);
%   rownotnan = find(~isnan(sum(uniqueIndividual,2)));
  for groupindex = unique(group)'
    groupmember = find(group==groupindex);
    membergain = observation(groupmember);
%     meanobservation(groupindex,:) = nanmean(membergain);
    meanobservation(groupindex,:) = nanmedian(membergain);
  end

  
  
  [coefficientShared,~,~,~] = ...
    mvregress(designShared,observation);
  
  [coefficientIndividual,observationvariance,residual,coefficientvariance] = ...
    mvregress(designIndividual,observation - designShared*coefficientShared);
  
%   figure(1),bar([coefficientShared;coefficientIndividual])
%   figure(2),hist(coefficientIndividual)

  
  
  [coefficientSharedMean,~,~,~] = ...
    mvregress(uniqueShared,meanobservation);
  
  [coefficientIndividualMean,observationvarianceMean,residualMean,coefficientvarianceMean] = ...
    mvregress(uniqueIndividual,meanobservation - uniqueShared*coefficientSharedMean);
  
%   figure(3),bar([coefficientSharedMean;coefficientIndividualMean])
%   figure(4),hist(coefficientIndividualMean)
  
  hd = barfigure([coefficientSharedMean;coefficientIndividualMean]);
  hd = letterfigure(hd);

  
end





function design = filldesignmatrix(design,fishnumber,stimnumber,datatype)

  leftarena  = datatype.arena.left;
  rightarena = datatype.arena.right;
  leftbody   = datatype.body.left;
  rightbody  = datatype.body.right;
    
  rowoffset    = find(~sum(abs(design(:,3:end)),2),1) - 1;  % find uppermost empty (all-zero) row
  columnoffset = find(~sum(abs(design(:,3:end)),1),1) - 1;  % find uppermost empty (all-zero) column
 
  for fish = 1:fishnumber
    fishindex = fish;
    if size(design,2) == 2
      secondindex = 2;        
    else
      secondindex = [2 2+fishindex+columnoffset];
    end
    for stimtype = 1:stimnumber
      sampleindex = stimtype + (fishindex-1)*stimnumber + rowoffset;
      if ismember(stimtype,leftarena)
        design(sampleindex,1) = -1;            % bias towards LEDs not on hemisphere R
      elseif ismember(stimtype,rightarena)
        design(sampleindex,1) = +1;            % bias towards LEDs on hemisphere R
      else
        design(sampleindex,:) = 0;           % do not consider stimuli along prime meridian
      end
      if ismember(stimtype,leftbody)
        design(sampleindex,secondindex) = -1;  % bias towards not-right side of body
      elseif ismember(stimtype,rightbody)
        design(sampleindex,secondindex) = +1;  % bias towards right side of body
      else
        design(sampleindex,:) = 0;           % do not consider stimuli along prime meridian
      end
%     design
    end
  end

end



function gain = poolGainData(result)
%POOLGAINDATA converts a raw result structure into plottable data by
%pooling OKR gain data in various ways, and storing those results in a new
%structure called "gain".

  % Pool data in various ways (e.g., .FR = pooled across all [F]ish and
  % all [R]epetitions, but with a separate array for each [E]ye).
  for stimtype = 1:size(result,3)

    gainpool(stimtype).FER = [result(:,:,stimtype,:).gain];

    for eye = 1:size(result,2)
      gainpool(stimtype).FR{eye} = [result(:,eye,stimtype,:).gain];
    end

    for fish = 1:size(result,1)
      gainpool(stimtype).ER{fish} = [result(fish,:,stimtype,:).gain];
    end

    for repetition = 1:size(result,4)
      gainpool(stimtype).FE{repetition} = [result(:,:,stimtype,repetition).gain];
    end

    for fish = 1:size(result,1)
      for eye = 1:size(result,2)
        gainpool(stimtype).R{fish,eye} = [result(fish,eye,stimtype,:).gain];
      end
    end
    
  end

  % Make sure that in following section, if a stimulus type is not present,
  % the array contain a NaN at that position, instead of a zero.
  nantemplate = NaN(numel(gainpool),1);

  gain.mean  .FER = nantemplate;
  gain.median.FER = nantemplate;
  gain.std   .FER = nantemplate;
  gain.sem   .FER = nantemplate;

  for eye = 1:size(result,2)
    gain.mean  .FR{eye} = nantemplate;
    gain.median.FR{eye} = nantemplate;
    gain.std   .FR{eye} = nantemplate;
    gain.sem   .FR{eye} = nantemplate;
  end

  for fish = 1:size(result,1)
    gain.mean  .ER{fish} = nantemplate;
    gain.median.ER{fish} = nantemplate;
    gain.std   .ER{fish} = nantemplate;
    gain.sem   .ER{fish} = nantemplate;
  end

  for fish = 1:size(result,1)
    for eye = 1:size(result,2)
      gain.mean  .R{fish,eye} = nantemplate;
      gain.median.R{fish,eye} = nantemplate;
      gain.std   .R{fish,eye} = nantemplate;
      gain.sem   .R{fish,eye} = nantemplate;
    end
  end

  % mean, median, stdev, sem across all pooled data, one per stimulus type
  for stimtype = 1:numel(gainpool)

    selection = gainpool(stimtype).FER;
    gain.mean  .FER(stimtype) = mean(selection);
    gain.median.FER(stimtype) = median(selection);
    gain.std   .FER(stimtype) = std(selection);
    gain.sem   .FER(stimtype) = std(selection)/sqrt(numel(selection));

    for eye = 1:size(result,2)
      selection = gainpool(stimtype).FR{eye};
      gain.mean  .FR{eye}(stimtype) = mean(selection);
      gain.median.FR{eye}(stimtype) = median(selection);
      gain.std   .FR{eye}(stimtype) = std(selection);
      gain.sem   .FR{eye}(stimtype) = std(selection)/sqrt(numel(selection));
    end

    for fish = 1:size(result,1)
      selection = gainpool(stimtype).ER{fish};
      gain.mean  .ER{fish}(stimtype) = mean(selection);
      gain.median.ER{fish}(stimtype) = median(selection);
      gain.std   .ER{fish}(stimtype) = std(selection);
      gain.sem   .ER{fish}(stimtype) = std(selection)/sqrt(numel(selection));
    end

    for fish = 1:size(result,1)
      for eye = 1:size(result,2)
        selection = gainpool(stimtype).R{fish,eye};
        gain.mean  .R{fish,eye}(stimtype) = mean(selection);
        gain.median.R{fish,eye}(stimtype) = median(selection);
        gain.std   .R{fish,eye}(stimtype) = std(selection);
        gain.sem   .R{fish,eye}(stimtype) = std(selection)/sqrt(numel(selection));
      end
    end
  end

end



function [retained,original] = discardTrial(original,folderstring)
% DISCARDTRIAL removes data obtained from trials consider "poorly fit" etc.
%
% This function takes a "result" structure as its only input argument, and
% requires an XLSX file containing the indices of trials to be discarded.
% It then removes those bad trials, and returns a reduced structure as its
% primary output argument, "retained". For easy access, it also returns its
% original input.
%
% This function can safely be executed multiple times, as "discarded"
% trials are in fact just set to empty, so their array indices are not 
% reassigned to other trials.
%
% Written by Florian Alexander Dehmelt, Tuebingen University, in 2018.


  % Identify and load an Excel file containing the indices of all unwanted
  % trials to be discarded. This file must contain four columns of numbers
  % (from left to right: fish no., eye no., stimulus type, and repetition.
  % It may contain as many text comments as desired; these will be ignored.
  folder.badtrial = folderstring;
%   folder.badtrial = 'C:\Users\fdehmelt\Dropbox\ThinkPad Dropbox\MATLAB\201808 SphereAnalysis\Sample Data\D series\';
  regularset.badtrial = 'DiscardTrial.xlsx';
  badtrial = xlsread([folder.badtrial,regularset.badtrial]);
  
  % The "retained" structure is the same as the "original" one...
  retained = original;
  
  % ...except that unwanted trials are overwritten by empty values.
  % They thus appear the same way as non-existent trials already did.
  for trial = 1:size(badtrial,1)
    
    % Find the position of the bad trial within the structure.
    fish       = badtrial(trial,1);
    eye        = badtrial(trial,2);
    stimtype   = badtrial(trial,3) + 1; % The +1 converts index >=0 to >=1.
    repetition = badtrial(trial,4);
    
    % Overwrite all field entries with "[]".
    fieldname = fieldnames(retained);
    for field = 1:numel(fieldname)
      retained(fish,eye,stimtype,repetition).(fieldname{field}) = [];
    end
  
  end
  
end



function [altered,original] = zeroTrial(original,folderstring)
% ZEROTRIAL sets gains to zero based on visual inspection of trials.
%
% This function takes a "result" structure as its only input argument, and
% requires an XLSX file containing the indices of trials to be set to zero.
% It then adjusts those gains, and returns an altered structure as its
% primary output argument, "retained". For easy access, it also returns its
% original input.
%
% This function can safely be executed multiple times, as "altered"
% trials are in fact just set to zero, so their array indices are not 
% reassigned to other trials.
%
% Written by Florian Alexander Dehmelt, Tuebingen University, in 2018.


  % Identify and load an Excel file containing the indices of all unwanted
  % trials to be discarded. This file must contain four columns of numbers
  % (from left to right: fish no., eye no., stimulus type, and repetition.
  % It may contain as many text comments as desired; these will be ignored.
  folder.badtrial = folderstring;
%   folder.badtrial = 'C:\Users\fdehmelt\Dropbox\ThinkPad Dropbox\MATLAB\201808 SphereAnalysis\Sample Data\D series\';
  regularset.badtrial = 'ZeroTrial.xlsx';
  badtrial = xlsread([folder.badtrial,regularset.badtrial]);
  
  % The "altered" structure is the same as the "original" one...
  altered = original;
  
  % ...except that gains of visually identified trials are set to zero.
  % They thus appear the same way as non-existent trials already did.
  for trial = 1:size(badtrial,1)
    
    % Find the position of the bad trial within the structure.
    fish       = badtrial(trial,1);
    eye        = badtrial(trial,2);
    stimtype   = badtrial(trial,3) + 1; % The +1 converts index >=0 to >=1.
    repetition = badtrial(trial,4);
    
    % Overwrite the gain field entries with "0", retain all other values.
    altered(fish,eye,stimtype,repetition).gain = 0;
  
  end
  
end





function hd = letterfigure(hd)

  choice = 1;
  
  hd.regress.ax(3,1) = axes;
  hd.regress.ax(3,1).Color = 'none';
  hd.regress.ax(3,1).Position = [0 0 1 1];
  hd.regress.ax(3,1).Units = 'pixels';
  hd.regress.ax(3,1).Visible = 'off';
  hold on
  hd.regress.lt(1) = text(hd.regress.ax(1,1).Position(1) - 85, ...
                        hd.regress.ax(1,1).Position(2) + hd.regress.ax(1,1).Position(4) + 20, ...
                        char(96+2*(choice-1)+1), 'Units', 'pixels');
  hd.regress.lt(2) = text(hd.regress.ax(2,1).Position(1) - 85, ...
                        hd.regress.ax(1,1).Position(2) + hd.regress.ax(1,1).Position(4) + 20, ...
                        char(96+2*(choice-1)+2), 'Units', 'pixels');
  hold off
  [hd.regress.lt(:).FontSize] = deal(15);
  [hd.regress.lt(:).FontWeight] = deal('bold');



  [hd.regress.ax(1,:).LabelFontSizeMultiplier, ...
   hd.regress.ax(1,:).TitleFontSizeMultiplier] = deal(1);

end



function hd = barfigure(data)

  for parameter = 1:numel(data)
    if parameter < 3
      labelstring{parameter,:} = ['b_',num2str(parameter)];
    else
      labelstring{parameter,:} = ['b_{3,',num2str(parameter-2),'}'];
    end
  end

  % Create basic figure and axes:
  hd.regress.fg = figure();
  hd.regress.fg.Color = [1 1 1];
  hd.regress.fg.Name = 'Supplementary Figure: asymmetry';

  hd.regress.ax(1,1) = axes();
  hd.regress.ax(2,1) = axes();

  [hd.regress.fg.Units, hd.regress.ax(:,:).Units] = deal('pixels');
  [hd.regress.ax(:,:).FontSize] = deal(15);
  [hd.regress.ax(:,:).TitleFontSizeMultiplier, ...
   hd.regress.ax(:,:).LabelFontSizeMultiplier] = deal(1);
  [hd.regress.ax(:,:).TitleFontWeight] = deal('normal');

  hd.regress.fg.Position = [50 500 1000 410];
  hd.regress.ax(1,1).Position = [110 90 520 280];
  hd.regress.ax(2,1).Position = [750 90 225 280];
  
  barxpos = [[1 2],.5+(3:numel(data))];
  greenindex = 1:2;
  greyindex = setdiff(1:numel(barxpos), greenindex);
  [greendata,greydata] = deal(NaN(size(barxpos)));
  greendata(greenindex) = data(greenindex);
  greydata(greyindex) = data(greyindex);
    
  % The actual plotting:  
  axes(hd.regress.ax(1,1));
  hold on
  hd.regress.ba(1,1,1) = bar(barxpos, greendata);
%   hd.regress.er(1,1,1) = errorbar(barxpos, greendata, greensem);
  hd.regress.ba(1,1,2) = bar(barxpos, greydata);
%   hd.regress.er(1,1,2) = errorbar(barxpos, greydata, greysem);
  hold off

  axes(hd.regress.ax(2,1));
  hold on
%   hd.regress.ba(2,1,1) = bar(barxpos(greenindex), hist(greendata));
  % hd.regress.er(2,1,1) = errorbar(barxpos(1:2), ...
  [histy,histx] = hist(greydata);
  hd.regress.ba(2,1,2) = bar(histx,histy);
  % hd.regress.er(2,1,2) = errorbar(barxpos(3:4), ...
  hold off
  
  % Improve figure appearance:
%   [hd.regress.er(:).LineStyle] = deal('none');
%   [hd.regress.er(:).LineWidth] = deal(1.25);
%   [hd.regress.er(:).Color] = deal(.1*[1 1 1]);
  [hd.regress.ba(1,:,:).BarWidth] = deal(.8);
  [hd.regress.ba(2,1,2).BarWidth] = deal(.8);
  [hd.regress.ba(1,1,1).FaceColor] = deal([.2 .7 .4]);
  [hd.regress.ba(:,:,2).FaceColor] = deal(.7*[1 1 1]);
  [hd.regress.ba(1,:,:).EdgeColor, hd.regress.ba(2,1,2).EdgeColor] = deal('none');

%   [hd.regress.ax(1,1).XLim] = deal([0 max(barxpos)+.75]);
% %   [hd.regress.ax(2,1).XLim] = deal([.25 3.5]);
% %   [hd.regress.ax(2,1).YLim] = deal([-.12 .12]);
%   [hd.regress.ax(2,1).XLim] = deal([.25 max(barxpos(1:end/2))+.75]);
%   [hd.regress.ax(2,1).YLim] = deal([-.3 .3]);

  hd.regress.ax(1,1).XTick = unique(barxpos);
%   hd.regress.ax(2,1).XTick = unique(barxpos(1:end/2));
  [hd.regress.ax(1,1).XTickLabelRotation] = deal(90);
  hd.regress.ax(1,1).XTickLabel = labelstring;
%   hd.regress.ax(2,1).XTickLabel = labelstring{3:end};

  hd.regress.ax(1,1).XLabel.String = 'asymmetry coefficient';
  hd.regress.ax(1,1).YLabel.String = 'best regression';
  hd.regress.ax(2,1).XLabel.String = 'individual bias b_{3,k}';
  hd.regress.ax(2,1).YLabel.String = 'occurrence';
  for panel = 1:2
    hd.regress.ax(panel,1).YLabel.Units = 'pixels';
    hd.regress.ax(panel,1).YLabel.Position(1) = hd.regress.ax(panel,1).YLabel.Position(1) - 15;
  end

%   hd.regress.ax(1,1).Title.String = {'asymmetry coefficients'};
%   hd.regress.ax(2,1).Title.String = {'histogram of parameters b_{3,k}'};
  
  axes(hd.regress.ax(1,1));
  hold on
  plot(get(gca,'XLim'),[0 0],'-k','LineWidth',.25)
  hold off
  axes(hd.regress.ax(2,1));
  hold on
  plot(get(gca,'XLim'),[0 0],'-k','LineWidth',.25)
  hold off

end