clear all
close all

% GENERAL SETTINGS
warning('off','MATLAB:interp1:UsePCHIP')
% The line above deactivates the following cbrewer warning:
% Warning: INTERP1(...,'CUBIC') will change in a future release. Use INTERP1(...,'PCHIP') instead. 
% > In interp1>sanitycheckmethod (line 265)
%   In interp1>parseinputs (line 401)
%   In interp1 (line 80)
%   In interpolate_cbrewer (line 31)
%   In cbrewer (line 101)
%   In heatmap20180823 (line 21)
  

[positiondistribution.left,statistics.left] = beatingField('left eye only');
[positiondistribution.right,statistics.right] = beatingField('right eye only');

hd.beat.fg = figure();
hd.beat.fg.Name = 'Sphere manuscript (Suppl Fig); beating field';
hd.beat.fg.Color = [1 1 1];
hd.beat.fg.Position = [0 32 1700 900];


% % Populate the combined figure from previously generated partial figures...
hd.beat.ax(1,1) = copyobj(get(positiondistribution.left.diskviolin.fg,'Children'), hd.beat.fg);
hd.beat.ax(2,1) = copyobj(get(positiondistribution.left.areaviolin.fg,'Children'), hd.beat.fg);
hd.beat.ax(3,1) = copyobj(get(positiondistribution.left.freqviolin.fg,'Children'), hd.beat.fg);
hd.beat.ax(4,1) = copyobj(get(positiondistribution.right.diskviolin.fg,'Children'), hd.beat.fg);
hd.beat.ax(5,1) = copyobj(get(positiondistribution.right.areaviolin.fg,'Children'), hd.beat.fg);
hd.beat.ax(6,1) = copyobj(get(positiondistribution.right.freqviolin.fg,'Children'), hd.beat.fg);
% hd.beat.ax(5,1) = axes;

...get rid of the partial figures once pillaged...
close([1 2 3 4 5 6])

% ...then adjust the size, position and other properties of those objects.

% % [get(gcf,'Children').Units] = deal('pixels');
[hd.beat.ax(:,:).Units] = deal('pixels');
hd.beat.ax(1,1).Position = [ 110 70 350/2 780];
hd.beat.ax(2,1).Position = [ 620 70 350/2 780];
hd.beat.ax(3,1).Position = [1130 70 525/2 780];
hd.beat.ax(4,1).Position = [ 110+200 70 350/2 780];
hd.beat.ax(5,1).Position = [ 620+200 70 350/2 780];
hd.beat.ax(6,1).Position = [1130+290 70 525/2 780];


leftkids.disk = hd.beat.ax(1,1).Children;
leftkids.area = hd.beat.ax(2,1).Children;
leftkids.freq = hd.beat.ax(3,1).Children;
patches.disk = leftkids.disk(end*3/4+1:end);
patches.area = leftkids.area(end*3/4+1:end);
patches.freq = leftkids.freq(end*3/4+1:end);
leftquartiles.disk = leftkids.disk(1:end*3/4);
leftquartiles.area = leftkids.area(1:end*3/4);
leftquartiles.freq = leftkids.freq(1:end*3/4);
[patches.disk.FaceColor, patches.area.FaceColor, patches.freq.FaceColor] = deal(.3*[1 1 1]);
[leftquartiles.disk.Color, leftquartiles.area.Color, leftquartiles.freq.Color] = deal([.2 .8 .6]);

rightkids.disk = hd.beat.ax(4,1).Children;
rightkids.area = hd.beat.ax(5,1).Children;
rightkids.freq = hd.beat.ax(6,1).Children;
patches.disk = rightkids.disk(end*3/4+1:end);
patches.area = rightkids.area(end*3/4+1:end);
patches.freq = rightkids.freq(end*3/4+1:end);
rightquartiles.disk = rightkids.disk(1:end*3/4);
rightquartiles.area = rightkids.area(1:end*3/4);
rightquartiles.freq = rightkids.freq(1:end*3/4);
[patches.disk.FaceColor, patches.area.FaceColor, patches.freq.FaceColor] = deal(.3*[1 1 1]);
[rightquartiles.disk.Color, rightquartiles.area.Color, rightquartiles.freq.Color] = deal([1 .5 .5]);



[hd.beat.ax(:,:).FontSize] = deal(15);
[hd.beat.ax(:,:).TitleFontSizeMultiplier, ...
 hd.beat.ax(:,:).LabelFontSizeMultiplier] = deal(1);
[hd.beat.ax(:,:).TitleFontWeight] = deal('normal');


% re-format y axis labels (disk stimuli)
hd.beat.ax(1,1).YTick = [1,7, 8,17,26, 27,36,45];
oldlabel = hd.beat.ax(1,1).YTickLabel;
for entry = 1:numel(oldlabel)
  if str2num(oldlabel{entry}) < 8
    newlabel{entry} = ['H',num2str(str2num(oldlabel{entry})-1)];
  else
    newlabel{entry} = ['D',num2str(str2num(oldlabel{entry})-7)];
  end
end
hd.beat.ax(1,1).YTickLabel = newlabel;

% re-format y axis labels (area stimuli)
hd.beat.ax(2,1).YTick = unique([1:7:42,7:7:42]);
oldlabel = hd.beat.ax(2,1).YTickLabel;
for entry = 1:numel(oldlabel)
%   newlabel{entry} = ['A',num2str(mod(str2num(oldlabel{entry})-1,7)+1)];
  newlabel{entry} = ['A',oldlabel{entry}];
end
hd.beat.ax(2,1).YTickLabel = newlabel;

% re-format y axis labels (frequency stimuli)
hd.beat.ax(3,1).YTick = unique([1:7:42,7:7:42]);
oldlabel = hd.beat.ax(3,1).YTickLabel;
for entry = 1:numel(oldlabel)
  newlabel{entry} = ['F',oldlabel{entry}];
end
hd.beat.ax(3,1).YTickLabel = newlabel;


for panel = 4:6
  hd.beat.ax(panel,1).YTick = hd.beat.ax(panel-3,1).YTick;
end

% hide y axes for right eye
for panel = 4:6
%   hd.beat.ax(panel,1).YAxis.Visible = 'off';
  hd.beat.ax(panel,1).YTickLabel = [];
  hd.beat.ax(panel,1).YLabel.Visible = 'off';
end


minorstep = 15;
majorstep = 30;
[hd.beat.ax(:,1).XGrid, hd.beat.ax(:,1).YGrid, hd.beat.ax(:,1).Box] = deal('on');
[hd.beat.ax(1:3,1).XTick] = deal((-90:minorstep:90)-90);
[hd.beat.ax(4:6,1).XTick] = deal((-90:minorstep:90)+90);
for panel = 1:6
  [hd.beat.ax(panel,1).XTickLabel] = deal(num2cell(hd.beat.ax(panel,1).XTick)');
end
[hd.beat.ax(1:2,1).XLim] = deal([-50 50]-90);
[hd.beat.ax(:,1).TickLength] = deal([0 0]);
hd.beat.ax(3,1).XLim = -50-90 + [0, +1.5*diff(hd.beat.ax(1,1).XLim)];
hd.beat.ax(3,1).XLim = +50-90 + [-1.5*diff(hd.beat.ax(1,1).XLim),0];
for panel = 4:6
  hd.beat.ax(panel,1).XLim = -fliplr(hd.beat.ax(panel-3,1).XLim);
end
for panel = 1:6
  for tick = 1:numel(hd.beat.ax(panel,1).XTickLabel)
    if mod(str2num(hd.beat.ax(panel,1).XTickLabel{tick}), majorstep)
      hd.beat.ax(panel,1).XTickLabel{tick} = '';
    end
  end
end
axes(hd.beat.ax(3,1));
hold on
plot([1 1]*min(hd.beat.ax(1,1).XLim), hd.beat.ax(3,1).YLim, '--k','LineWidth',1)
hold off
axes(hd.beat.ax(6,1));
hold on
plot([1 1]*max(hd.beat.ax(4,1).XLim), hd.beat.ax(6,1).YLim, '--k','LineWidth',1)
hold off

for panel = 1:3
  hd.beat.ax(panel,1).YLabel.Units = 'pixels';
  hd.beat.ax(panel,1).YLabel.Position(1) = hd.beat.ax(panel,1).YLabel.Position(1) - 8;
end




% Display panel lettering:
hd.beat.ax(7,1) = axes;
hd.beat.ax(7,1).Color = 'none';
hd.beat.ax(7,1).Position = [0 0 1 1];
hd.beat.ax(7,1).Units = 'pixels';
hd.beat.ax(7,1).Visible = 'off';
hold on
hd.beat.lt(1) = text(hd.beat.ax(1,1).Position(1) - 90 , ...
                        hd.beat.ax(1,1).Position(2) + hd.beat.ax(1,1).Position(4) + 30, ...
                        'a', 'Units', 'pixels');
hd.beat.lt(2) = text(hd.beat.ax(2,1).Position(1) - 90, ...
                        hd.beat.ax(2,1).Position(2) + hd.beat.ax(2,1).Position(4) + 30, ...
                        'b', 'Units', 'pixels');
hd.beat.lt(3) = text(hd.beat.ax(3,1).Position(1) - 90, ...
                        hd.beat.ax(3,1).Position(2) + hd.beat.ax(3,1).Position(4) + 30, ...
                        'c', 'Units', 'pixels');
% hd.beat.lt(4) = text(hd.beat.ax(4,1).Position(1) + 35, ...
%                         hd.beat.ax(4,1).Position(2) + hd.beat.ax(4,1).Position(4) - 10, ...
%                         'd', 'Units', 'pixels');
% hd.beat.lt(5) = text(hd.beat.ax(5,1).Position(1) + 35, ...
%                         hd.beat.ax(5,1).Position(2) + hd.beat.ax(5,1).Position(4) - 10, ...
%                         'e', 'Units', 'pixels');
% hd.beat.lt(6) = text(hd.beat.ax(6,1).Position(1) + 35, ...
%                         hd.beat.ax(6,1).Position(2) + hd.beat.ax(6,1).Position(4) - 10, ...
%                         'f', 'Units', 'pixels');
hold off
[hd.beat.lt(:).FontSize] = deal(15);
[hd.beat.lt(:).FontWeight] = deal('bold');


% statistics.left.disk
% statistics.left.area
% statistics.left.freq
% statistics.right.disk
% statistics.right.area
% statistics.right.freq

meanofmedians.left.disk = mean(statistics.left.disk.median);
meanofmedians.left.area = mean(statistics.left.area.median);
meanofmedians.left.freq = mean(statistics.left.freq.median);
stdofmedians.left.disk = std(statistics.left.disk.median);
stdofmedians.left.area = std(statistics.left.area.median);
stdofmedians.left.freq = std(statistics.left.freq.median);
meanofmedians.right.disk = mean(statistics.right.disk.median);
meanofmedians.right.area = mean(statistics.right.area.median);
meanofmedians.right.freq = mean(statistics.right.freq.median);
stdofmedians.right.disk = std(statistics.right.disk.median);
stdofmedians.right.area = std(statistics.right.area.median);
stdofmedians.right.freq = std(statistics.right.freq.median);

meanofmedians.left
stdofmedians.left
meanofmedians.right
stdofmedians.right




function [hd,stat] = beatingField(eyestring)
  
  conventionforplot = 'CW';
  
  disk.file.result = 'result_20180110_125537.mat';
  disk.file.folder = 'C:\Users\dehmelt\Dropbox\Documents\MATLAB\201812 Sphere Analysis\Analysis pipeline 20181217\Data D Series (neue Experimente)\';
  load([disk.file.folder,disk.file.result],'result')
  disk.result = result;
  clearvars result

  freq.file.result = 'result_20180305_124441.mat';
  freq.file.folder = 'C:\Users\dehmelt\Dropbox\Documents\MATLAB\201812 Sphere Analysis\Analysis pipeline 20181217\Data V Series (V-Serie)\';
  load([freq.file.folder,freq.file.result],'result')
  freq.result = result;
  clearvars result

  area.file.result = 'result_20180228_090646.mat';
  area.file.folder = 'C:\Users\dehmelt\Dropbox\Documents\MATLAB\201812 Sphere Analysis\Analysis pipeline 20181217\Data A Series (A-Series)\';
  load([area.file.folder,area.file.result],'result')
  area.result = result;
  clearvars result

  % convert eye position relative to mediolateral axis to eye position relative
  % to body axis, i.e., geographic azimuth
  switch eyestring
    case 'left eye only'
      position.disk = -90 - poolPosition(disk.result,eyestring);
      position.area = -90 - poolPosition(area.result,eyestring);
      position.freq = -90 - poolPosition(freq.result,eyestring);
    case 'right eye only'
      position.disk = +90 - poolPosition(disk.result,eyestring);
      position.area = +90 - poolPosition(area.result,eyestring);
      position.freq = +90 - poolPosition(freq.result,eyestring);
    case 'both eyes'
      error('Not implemented.')
    otherwise
      error('Invalid choice of eyes.')
  end

  switch conventionforplot
    case 'CCW'
      position.disk = -position.disk;
      position.area = -position.area;
      position.freq = -position.freq;
  end
  
  hd.diskviolin.fg = figure();
  hd.diskviolin.fg.Color = [1 1 1];
  hd.diskviolin.fg.Name = 'disk stimuli,  field';
  hd.diskviolin.fg.Position = [1620 500 300 200];
  % letter indicate pooling across F = fish, E = eye, T = type, R = repetition
  keeptype = permute(position.disk,[1 2 3 5 4]);  % type = 4th index, move to back, ...
  szkeeptype = size(keeptype);
  pooledposition.disk.FER = reshape(keeptype, [numel(keeptype)/szkeeptype(end),szkeeptype(end)]);

%   hold on
  distributionPlot(pooledposition.disk.FER,'showMM',6,'xyOri','flipped')
%   defaultxlim = get(gca,'XLim');
%   ylevel = [7.5 26.5 45.5];
%   for divider = 1:numel(ylevel)
%     plot(defaultxlim, ylevel(divider)*[1 1],'-k')
%   end
%   hold off
  
  switch eyestring
    case 'left eye only'
      titlestring = 'left eye position';
    case 'right eye only'
      titlestring = 'right eye position';
    case 'both eyes'
      titlestring = 'both eyes pooled';
    otherwise
      error('Invalid choice of eye.')
  end
  
%   title('horizontal beating field')
	title(titlestring)
  xlabel('azimuth  (deg)')
  ylabel('stimulus type  (disk stimuli)')

  
  hd.areaviolin.fg = figure();
  hd.areaviolin.fg.Color = [1 1 1];
  hd.areaviolin.fg.Name = 'area stimuli, beating field';
  hd.areaviolin.fg.Position = [1620 500 300 200];
  % letter indicate pooling across F = fish, E = eye, T = type, R = repetition
  keeptype = permute(position.area,[1 2 3 5 4]);  % type = 4th index, move to back, ...
  szkeeptype = size(keeptype);
  pooledposition.area.FER = reshape(keeptype, [numel(keeptype)/szkeeptype(end),szkeeptype(end)]);

  distributionPlot(pooledposition.area.FER,'showMM',6,'xyOri','flipped')

  title(titlestring)
  xlabel('azimuth  (deg)')
  ylabel('stimulus type  (area stimuli)')
  
  
  hd.freqviolin.fg = figure();
  hd.freqviolin.fg.Color = [1 1 1];
  hd.freqviolin.fg.Name = 'frequency stimuli, beating field';
  hd.freqviolin.fg.Position = [1620 500 300 200];
  % letter indicate pooling across F = fish, E = eye, T = type, R = repetition
  keeptype = permute(position.freq,[1 2 3 5 4]);  % type = 4th index, move to back, ...
  szkeeptype = size(keeptype);
  pooledposition.freq.FER = reshape(keeptype, [numel(keeptype)/szkeeptype(end),szkeeptype(end)]);
  
  distributionPlot(pooledposition.freq.FER,'showMM',6,'xyOri','flipped')

  title(titlestring)
  xlabel('azimuth  (deg)')
  ylabel('stimulus type  (frequency stimuli)')
  
  stat.disk.mean = nanmean(pooledposition.disk.FER,1);
  stat.area.mean = nanmean(pooledposition.area.FER,1);
  stat.freq.mean = nanmean(pooledposition.freq.FER,1);
  stat.disk.median = nanmedian(pooledposition.disk.FER,1);
  stat.area.median = nanmedian(pooledposition.area.FER,1);
  stat.freq.median = nanmedian(pooledposition.freq.FER,1);
  stat.disk.std = nanstd(pooledposition.disk.FER,[],1);
  stat.area.std = nanstd(pooledposition.area.FER,[],1);
  stat.freq.std = nanstd(pooledposition.freq.FER,[],1);
  stat.disk.sem = nanstd(pooledposition.disk.FER,[],1) / numel(pooledposition.disk.FER);
  stat.area.sem = nanstd(pooledposition.area.FER,[],1) / numel(pooledposition.area.FER);
  stat.freq.sem = nanstd(pooledposition.freq.FER,[],1) / numel(pooledposition.freq.FER);
  stat.disk.numfish = size(disk.result,1);
  stat.area.numfish = size(area.result,1);
  stat.freq.numfish = size(freq.result,1);

end



function rawpos = poolPosition(result,eyestring)

  switch eyestring
    case 'left eye only'
      eyerange = 1;
    case 'right eye only'
      eyerange = 2;
    case 'both eyes'
      eyeindex = 1:2;
    otherwise
      error('Invalid choice of eye.')
%     otherwise
%       eyerange = 1:size(result,2);
  end
  
  maxnumdatapoint = 0;
  for fish = 1:size(result,1)
    for eye = eyerange
      for type = 1:size(result,3)
        for repetition = 1:size(result,4)  
          maxnumdatapoint = max(maxnumdatapoint, numel(result(fish,eye,type,repetition).y_raw));
        end
      end
    end
  end
  
  rawpos = NaN([maxnumdatapoint, size(result)]);
  for fish = 1:size(result,1)
%     for eye = 1:size(result,2)
    for eye = eyerange
      for type = 1:size(result,3)
        for repetition = 1:size(result,4)
          if ~isempty(result(fish,eye,type,repetition).y_raw)
            numdatapoint = numel(result(fish,eye,type,repetition).y_raw);
            rawpos(1:numdatapoint,fish,eye,type,repetition) = result(fish,eye,type,repetition).y_raw;
%             realpos{fish,eye,type,repetition} = rawpos(~isnan(rawpos));
          end
        end
      end
    end
  end
  
end



function [maxpos,minpos,meanpos,medianpos,stdpos,sempos] = analysePosition(result)

  [maxpos,minpos,meanpos,medianpos,stdpos,sempos] = deal(NaN(size(result)));

  for fish = 1:size(result,1)
    for eye = 1:size(result,2)
      for type = 1:size(result,3)
        for repetition = 1:size(result,4)

          if ~isempty(result(fish,eye,type,repetition).y_raw)

            rawpos = result(fish,eye,type,repetition).y_raw;
            realpos = rawpos(~isnan(rawpos));
            maxpos(fish,eye,type,repetition)    = max(realpos);
            minpos(fish,eye,type,repetition)    = min(realpos);
            meanpos(fish,eye,type,repetition)   = mean(realpos);
            medianpos(fish,eye,type,repetition) = median(realpos);
            stdpos(fish,eye,type,repetition)    = std(realpos);
%             sempos(fish,eye,type,repetition)    = std(realpos) / sqrt(numel(realpos));

          end

        end
      end
    end
  end

end
