clear all
close all

datafilename = 'data_handmade.xlsx';
datafoldername = 'C:\Users\dehmelt\Desktop\';
% UUB, upside-up, angle relative to body axis
% UUH, upside-up, angle relative to horizon
% UDB, upside-down, angle relative to body axis
% UDH, upside-down, angle relative to horizon
datarange.UUB = 'A7:AM67';
datarange.UDB = 'A88:AM148';
datarange.UUH = 'A9:AM69';
datarange.UDH = 'A88:AM148';

rawdata.UUB = xlsread([datafoldername,datafilename],datarange.UUB);
rawdata.UDB = xlsread([datafoldername,datafilename],datarange.UDB);
rawdata.UUH = xlsread([datafoldername,datafilename],datarange.UUH);
rawdata.UDH = xlsread([datafoldername,datafilename],datarange.UDH);
rawdata.UUB = flipud(rawdata.UUB);  % so frameindex = MATLAB index, not running backwards
rawdata.UDB = flipud(rawdata.UDB);
rawdata.UUH = flipud(rawdata.UUH);
rawdata.UDH = flipud(rawdata.UDH);
% frameindex = rawdata(1:4:end);

numfish.UUB = ceil(size(rawdata.UUB,2)/4);
numfish.UDB = ceil(size(rawdata.UDB,2)/4);
numfish.UUH = ceil(size(rawdata.UUH,2)/4);
numfish.UDH = ceil(size(rawdata.UDH,2)/4);

eyeposition.UUB(:,:,2) = rawdata.UUB(:,2:4:end);  % right eye position
eyeposition.UUB(:,:,1) = rawdata.UUB(:,3:4:end);   % left eye position
eyeposition.UDB(:,:,2) = -rawdata.UDB(:,2:4:end);  % right eye position
eyeposition.UDB(:,:,1) = -rawdata.UDB(:,3:4:end);   % left eye position
eyeposition.UUH(:,:,2) = rawdata.UUH(:,2:4:end);  % right eye position
eyeposition.UUH(:,:,1) = rawdata.UUH(:,3:4:end);   % left eye position
eyeposition.UDH(:,:,2) = -rawdata.UDH(:,2:4:end);  % right eye position
eyeposition.UDH(:,:,1) = -rawdata.UDH(:,3:4:end);   % left eye position

% mean, std, sem across frames (one value per fish and eye)
meanposition.UUB = mean(eyeposition.UUB,1,'omitnan');
meanposition.UDB = mean(eyeposition.UDB,1,'omitnan');
meanposition.UUH = mean(eyeposition.UUH,1,'omitnan');
meanposition.UDH = mean(eyeposition.UDH,1,'omitnan');
stdposition.UUB  = std(eyeposition.UUB,1,'omitnan');
stdposition.UDB  = std(eyeposition.UDB,1,'omitnan');
stdposition.UUH  = std(eyeposition.UUH,1,'omitnan');
stdposition.UDH  = std(eyeposition.UDH,1,'omitnan');
semposition.UUB  = stdposition.UUB / sqrt(numfish.UUB);
semposition.UDB  = stdposition.UDB / sqrt(numfish.UDB);
semposition.UUH  = stdposition.UUH / sqrt(numfish.UUH);
semposition.UDH  = stdposition.UDH / sqrt(numfish.UDH);

% then, take the mean, std, sem across fish (losing information on intra-fish variability)
meanmeanposition.UUB = mean(meanposition.UUB);
meanmeanposition.UDB = mean(meanposition.UDB);
meanmeanposition.UUH = mean(meanposition.UUH);
meanmeanposition.UDH = mean(meanposition.UDH);
stdmeanposition.UUB  = std(meanposition.UUB);
stdmeanposition.UDB  = std(meanposition.UDB);
stdmeanposition.UUH  = std(meanposition.UUH);
stdmeanposition.UDH  = std(meanposition.UDH);
semmeanposition.UUB  = stdmeanposition.UUB / sqrt(numfish.UUB);
semmeanposition.UDB  = stdmeanposition.UDB / sqrt(numfish.UDB);
semmeanposition.UUH  = stdmeanposition.UUH / sqrt(numfish.UUH);
semmeanposition.UDH  = stdmeanposition.UDH / sqrt(numfish.UDH);

hd.vertical.fg = figure();
hd.vertical.fg.Color = [1 1 1];
hd.vertical.fg.Name = 'Supplementary Figure: Vertical eye position (upright vs. upside-down)';

hd.vertical.ax(1,1) = axes();
hd.vertical.ax(2,1) = axes();

[hd.vertical.fg.Units, hd.vertical.ax(:,:).Units] = deal('pixels');
[hd.vertical.ax(:,:).FontSize] = deal(15);
[hd.vertical.ax(:,:).TitleFontSizeMultiplier, ...
 hd.vertical.ax(:,:).LabelFontSizeMultiplier] = deal(1);
[hd.vertical.ax(:,:).TitleFontWeight] = deal('normal');

hd.vertical.fg.Position = [50 500 900 450];
hd.vertical.ax(1,1).Position = [110 90 280 280];
hd.vertical.ax(2,1).Position = [540 90 300 280];


barxpos = [1 3.5 2 4.5];

axes(hd.vertical.ax(1,1));
hold on
hd.vertical.ba(1,1,1) = bar(barxpos(1:2), ...
                            [meanmeanposition.UUB(:,:,1);meanmeanposition.UUB(:,:,2)]');
hd.vertical.er(1,1,1) = errorbar(barxpos(1:2), ...
                                 [meanmeanposition.UUB(:,:,1);meanmeanposition.UUB(:,:,2)], ...
                                 [semmeanposition.UUB(:,:,1);semmeanposition.UUB(:,:,2)]);
hd.vertical.ba(1,1,2) = bar(barxpos(3:4), ...
                            [meanmeanposition.UDB(:,:,1);meanmeanposition.UDB(:,:,2)]');
hd.vertical.er(1,1,2) = errorbar(barxpos(3:4), ...
                                 [meanmeanposition.UDB(:,:,1);meanmeanposition.UDB(:,:,2)], ...
                                 [semmeanposition.UDB(:,:,1);semmeanposition.UDB(:,:,2)]);
hold off

axes(hd.vertical.ax(2,1));
hold on
hd.vertical.ba(2,1,1) = bar(barxpos(1:2), ...
                            [meanmeanposition.UUH(:,:,1);meanmeanposition.UUH(:,:,2)]');
hd.vertical.er(2,1,1) = errorbar(barxpos(1:2), ...
                                 [meanmeanposition.UUH(:,:,1);meanmeanposition.UUH(:,:,2)], ...
                                 [semmeanposition.UUH(:,:,1);semmeanposition.UUH(:,:,2)]);
hd.vertical.ba(2,1,2) = bar(barxpos(3:4), ...
                            [meanmeanposition.UDH(:,:,1);meanmeanposition.UDH(:,:,2)]');
hd.vertical.er(2,1,2) = errorbar(barxpos(3:4), ...
                                 [meanmeanposition.UDH(:,:,1);meanmeanposition.UDH(:,:,2)], ...
                                 [semmeanposition.UDH(:,:,1);semmeanposition.UDH(:,:,2)]);
hold off


% axes(hd.vertical.ax(1,1));
% hold on
% hd.vertical.ba(1,1,1) = bar(barxpos(1:2), ...
%                             [meanmeanposition.UUB(:,:,1);meanmeanposition.UDB(:,:,1)]');
% hd.vertical.er(1,1,1) = errorbar(barxpos(1:2), ...
%                                  [meanmeanposition.UUB(:,:,1);meanmeanposition.UDB(:,:,1)], ...
%                                  [semmeanposition.UUB(:,:,1);semmeanposition.UDB(:,:,1)]);
% hd.vertical.ba(1,1,2) = bar(barxpos(3:4), ...
%                             [meanmeanposition.UUB(:,:,2);meanmeanposition.UDB(:,:,2)]');
% hd.vertical.er(1,1,2) = errorbar(barxpos(3:4), ...
%                                  [meanmeanposition.UUB(:,:,2);meanmeanposition.UDB(:,:,2)], ...
%                                  [semmeanposition.UUB(:,:,2);semmeanposition.UDB(:,:,2)]);
% hold off
% 
% axes(hd.vertical.ax(2,1));
% hold on
% hd.vertical.ba(2,1,1) = bar(barxpos(1:2), ...
%                                  [meanmeanposition.UUH(:,:,1);meanmeanposition.UDH(:,:,1)]');
% hd.vertical.er(2,1,1) = errorbar(barxpos(1:2), ...
%                                  [meanmeanposition.UUH(:,:,1);meanmeanposition.UDH(:,:,1)], ...
%                                  [semmeanposition.UUH(:,:,1);semmeanposition.UDH(:,:,1)]);
% hd.vertical.ba(2,1,2) = bar(barxpos(3:4), ...
%                             [meanmeanposition.UUH(:,:,2);meanmeanposition.UDH(:,:,2)]');
% hd.vertical.er(2,1,2) = errorbar(barxpos(3:4), ...
%                                  [meanmeanposition.UUH(:,:,2);meanmeanposition.UDH(:,:,2)], ...
%                                  [semmeanposition.UUH(:,:,2);semmeanposition.UDH(:,:,2)]);
% hold off



[hd.vertical.er(:).LineStyle] = deal('none');
[hd.vertical.er(:).LineWidth] = deal(1.25);
[hd.vertical.er(:).Color] = deal(.1*[1 1 1]);
[hd.vertical.ba(:).BarWidth] = deal(.3);
[hd.vertical.ba(:,:,1).FaceColor] = deal([.2 .8 .4]);
[hd.vertical.ba(:,:,2).FaceColor] = deal(.7*[1 1 1]);

[hd.vertical.ax(:,1).XLim] = deal([0 5.5]);
[hd.vertical.ax(:,1).YLim] = deal([0 9]);

[hd.vertical.ax(:,1).XTick] = deal(unique(barxpos));
[hd.vertical.ax(:,1).XTickLabel] = deal({'Luu','Lud','Ruu','Rud'});

for panel = 1:2
  hd.vertical.ax(panel,1).YLabel.String = 'mean elevation  (deg)';
  hd.vertical.ax(panel,1).YLabel.Units = 'pixels';
  hd.vertical.ax(panel,1).YLabel.Position(1) = hd.vertical.ax(panel,1).YLabel.Position(1) - 15;
end

hd.vertical.ax(1,1).Title.String = {'relative to body axis','(with s.e.m.)'};
hd.vertical.ax(2,1).Title.String = {'relative to true horizon','(with s.e.m.)'};


