hd.mercator.fg = figure();
hd.mercator.fg.Color = [1 1 1];
hd.mercator.Units = 'pixels';
hd.mercator.fg.Position = hd.collage.fg.Position .* [1 1 1 .35];


if variant == 3
  
  % Median eye position, pooled once, from positionAnalysis20181217.m:
  leftmedianazim =  -90 +6.2450;
  rightmedianazim = +90 -9.8760;
  leftmeanazim =  -90 +5.2455;
  rightmeanazim = +90 -9.8840;
  leftstdazim = 6.1703;
  rightstdazim = 6.5227;
  leftsemazim = 0.2472;
  rightsemazim = 0.2613;

  % Median vertical eye position, from figureVertical20190225.m:
  leftmeanelev = 3.4937;  % meanmeanposition.UUH(:,:,1);
  rightmeanelev = 4.8735; % meanmeanposition.UUH(:,:,2);
  
else
  
  leftmedianazim = NaN;
  rightmedianazim = NaN;
  leftmeanazim = NaN;
  rightmeanazim = NaN;
  leftstdazim = NaN;
  rightstdazim = NaN;
  leftsemazim = NaN;
  rightsemazim = NaN;
  leftmeanelev = NaN;
  rightmeanelev = NaN;
  
end

    
panellist = {'left eye gain','merge stimulated','right eye gain'};
for chosenpanel = 1:numel(panellist)
  
  hd.mercator.ax(1,chosenpanel) = axes();
  hd.mercator.ax(1,chosenpanel).Units = 'pixels';
  hd.mercator.ax(1,chosenpanel).Position = [325*(chosenpanel-1)+120 70 280 220];

  azimaxis = -180:360/(size(fitdata(chosenpanel).matrix,1)-1):180;
  elevaxis =  -90:180/(size(fitdata(chosenpanel).matrix,2)-1):90;
  [azimgrid,elevgrid] = meshgrid(azimaxis,elevaxis);

  switch leftparam.tableconvention{:}
    case 'azimuth (CCW)'
      azimlist = leftparam.azimuth;
    case 'azimuth (CW)'
      azimlist = -leftparam.azimuth;
  end
  elevlist = leftparam.elevation;
  radiuslist = leftparam.radius;
  switch panellist{chosenpanel}
    case 'left eye gain'
      gainlist = diskdata(variant).left(end-37:end);
    case 'merge stimulated'
      gainlist = [diskdata(variant).right(end-37:end-19),diskdata(variant).left(end-18:end)];
    case 'right eye gain'
      gainlist = diskdata(variant).right(end-37:end);
  end
  
  pcolor(azimgrid,elevgrid,fliplr(fitdata(chosenpanel).matrix))
  shading interp

  for diskindex = 1:numel(azimlist)

    chosenazim = azimlist(diskindex);
    chosenelev = elevlist(diskindex);
    chosenradius = radiuslist(diskindex);

    boundary.angle = chosenradius;
    centre.azimuth = chosenazim;
    centre.elevation = chosenelev;
    boundary.resolution = .01/2;
    [boundary.azimuth,boundary.elevation] = ...
      diskBoundary(centre.azimuth,centre.elevation,boundary.angle,boundary.resolution);
    hold on
    brightlist = [[6:8,10,12:14],19+[6:8,10,12:14]];
    if sum(diskindex == brightlist)
      plot(boundary.azimuth,boundary.elevation,'-','LineWidth',1,'Color',.2*[1 1 1])    
    else
      plot(boundary.azimuth,boundary.elevation,'-','LineWidth',1,'Color',1*[1 1 1])
    end
    hold off

  end
  for diskindex = 1:numel(azimlist)

    chosenazim = azimlist(diskindex);
    chosenelev = elevlist(diskindex);
    chosengain = gainlist(diskindex);
    hold on
    if sum(diskindex == brightlist)
      text(chosenazim,chosenelev,num2str(chosengain,'%1.2f'), ...
        'HorizontalAlignment','center','VerticalAlignment','middle','FontSize',9,'Color',.1*[1 1 1])
    else
      text(chosenazim,chosenelev,num2str(chosengain,'%1.2f'), ...
        'HorizontalAlignment','center','VerticalAlignment','middle','FontSize',9,'Color',.9*[1 1 1])
     end
    hold off

  end
  hold on
  switch panellist{chosenpanel}
    case 'left eye gain'
      scatter(leftmeanazim,leftmeanelev,20,'o','MarkerFaceColor','r','MarkerEdgeColor',.6*[1 0 0])
      patch([0 0 1 1]*hd.mercator.ax(1,1).XLim(2), hd.mercator.ax(1,1).YLim*[1 0 0 1; 0 1 1 0], ...
            [1 1 1],'FaceAlpha',.6,'EdgeColor','none')
    case 'merge stimulated'
      scatter(leftmeanazim,leftmeanelev,20,'o','MarkerFaceColor','r','MarkerEdgeColor',.6*[1 0 0])
      scatter(rightmeanazim,rightmeanelev,20,'o','MarkerFaceColor','r','MarkerEdgeColor',.6*[1 0 0])
      plot([0 0],hd.mercator.ax(1,1).YLim,'Color',.2*[1 1 1],'LineStyle','--','LineWidth',1)
    case 'right eye gain'
      scatter(rightmeanazim,rightmeanelev,20,'o','MarkerFaceColor','r','MarkerEdgeColor',.6*[1 0 0])
      patch([0 0 1 1]*hd.mercator.ax(1,1).XLim(1), hd.mercator.ax(1,1).YLim*[1 0 0 1; 0 1 1 0], ...
            [1 1 1],'FaceAlpha',.6,'EdgeColor','none')
  end
  hold off

  hd.mercator.ax(1,chosenpanel).FontSize = 14;
  hd.mercator.ax(1,chosenpanel).XTick = -180:90:180;
  hd.mercator.ax(1,chosenpanel).YTick = -90:30:90;
  hd.mercator.ax(1,chosenpanel).XLim = [-180 180];
  hd.mercator.ax(1,chosenpanel).YLim = [-87 87];
  xlabel('left - azimuth (deg) - right')
  ylabel('elevation (deg)')
  hd.mercator.ax(1,chosenpanel).Title.String = panellist{chosenpanel};
  hd.mercator.ax(1,chosenpanel).Title.FontWeight = 'normal';
  hd.mercator.ax(1,chosenpanel).Title.Position(2) = ...
    hd.mercator.ax(1,chosenpanel).Title.Position(2) + 5;

  
  hd.mercator.ax(1,chosenpanel).CLim = hd.collage.ax(2,end).CLim;
  if chosenpanel > 1
    hd.mercator.ax(1,chosenpanel).YAxis.Visible = 'off';
%     hd.mercator.ax(1,chosenpanel).XTick(1) = [];
  end

end

% Display panel lettering:
hd.mercator.ax(2,1) = axes;
hd.mercator.ax(2,1).Color = 'none';
hd.mercator.ax(2,1).Position = [0 0 1 1];
hd.mercator.ax(2,1).Units = 'pixels';
hd.mercator.ax(2,1).Visible = 'off';
hold on
hd.mercator.lt(1) = text(hd.collage.ax(2,2).Position(1) - 50, ...
                        hd.mercator.ax(1,1).Position(2) + hd.mercator.ax(1,1).Position(4) + 20, ...
                        'e', 'Units', 'pixels');
hold off
[hd.mercator.lt(:).FontSize] = deal(15);
[hd.mercator.lt(:).FontWeight] = deal('bold');



[hd.mercator.ax(1,:).LabelFontSizeMultiplier, ...
 hd.mercator.ax(1,:).TitleFontSizeMultiplier] = deal(1);



% add white patch to sphere plots from main figure, too
figure(hd.collage.fg)
extent = 1;
for subpanel = [2 5]
  axes(hd.collage.ax(2,subpanel))
  hold on
  patch(extent*ones(4,1), [0 0 -1 -1]*extent, extent*[-1 1]*[1 0 0 1; 0 1 1 0], ...
            [1 1 1],'FaceAlpha',.6,'EdgeColor','none')
  patch(extent*[-1 1]*[1 0 0 1; 0 1 1 0], [0 0 -1 -1]*extent, extent*ones(4,1),...
            [1 1 1],'FaceAlpha',.6,'EdgeColor','none')
  hold off
end
for subpanel = [4 7]
  axes(hd.collage.ax(2,subpanel))
  hold on
  patch(extent*ones(4,1), [0 0 1 1]*extent, extent*[-1 1]*[1 0 0 1; 0 1 1 0], ...
            [1 1 1],'FaceAlpha',.6,'EdgeColor','none')
  patch(extent*[-1 1]*[1 0 0 1; 0 1 1 0], [0 0 1 1]*extent, extent*ones(4,1), ...
            [1 1 1],'FaceAlpha',.6,'EdgeColor','none')
  hold off
end


    

% add dashed outline around or instead of white patches
figure(hd.mercator.fg)

hd.mercator.ax(3,1) = axes();
hd.mercator.ax(3,1).Units = 'pixels';
hd.mercator.ax(3,1).Position = hd.mercator.ax(1,1).Position + [0 -2 +2 +4];
plot([.5,1,1,.5,.5],[1 1 0 0 1],'--k','LineWidth',1)
hd.mercator.ax(3,1).Color = 'none';
hd.mercator.ax(3,1).XAxis.Visible = 'off';
hd.mercator.ax(3,1).YAxis.Visible = 'off';
hd.mercator.ax(3,1).XLim = [0 1];
hd.mercator.ax(3,1).YLim = [0 1];

hd.mercator.ax(3,3) = axes();
hd.mercator.ax(3,3).Units = 'pixels';
hd.mercator.ax(3,3).Position = hd.mercator.ax(1,3).Position + [-2 -2 +4 +4];
plot([.5,1,1,.5,.5]-.5,[1 1 0 0 1],'--k','LineWidth',1)
hd.mercator.ax(3,3).Color = 'none';
hd.mercator.ax(3,3).XAxis.Visible = 'off';
hd.mercator.ax(3,3).YAxis.Visible = 'off';
hd.mercator.ax(3,3).XLim = [0 1];
hd.mercator.ax(3,3).YLim = [0 1];    
    
    


function [azimuthOut, elevationOut] = diskBoundary(azimuthIn, elevationIn, angleIn, resolutionIn)

  centre.azimuth = azimuthIn;
  centre.elevation = elevationIn;
  border.angle = angleIn / 2; % convert solid angle ("diameter") to "radius"
  border.resolution = resolutionIn;

  % The following equation describes orthodromic (or "great circle") distance as an angle:
  % arccos(sin(centre.elevation)*sin(border.elevation) + ...
  %        cos(centre.elevation)*cos(border.elevation)*cos(border.azimuth-centre.azimuth)) = angle;

%   border.elevation = centre.elevation-border.angle/2 : .1 : centre.elevation+border.angle/2;
  intended  = -90 : border.resolution : 90;
%   intended  = (centre.elevation-border.angle) : border.resolution : (centre.elevation+border.angle);
  % "auxiliary" elevations are explicitly added to guarantee coverage near top/bottom of circle:
  auxiliary = centre.elevation + border.angle*[-1 1];
%   border.elevation = unique([intended,auxiliary]);
  
  limit = cosd([centre.elevation-border.angle centre.elevation+border.angle]);
%   intended = acosd(min(limit) : border.resolution : max(limit));

  %   % XXX Not sure why the following line leads to half of the curve segments not being computed...
%   intended = [-acosd(0:border.resolution:1),acosd(1-border.resolution:-border.resolution:0)];
%   auxiliary = centre.elevation + border.angle*[-1 1];

  border.elevation = unique([intended,auxiliary]);
%   figure(6)
%   plot(intended)

  border.azimuth = centre.azimuth + ...
                   acosd((cosd(border.angle) - sind(centre.elevation)*sind(border.elevation)) ./ ...
                         (cosd(centre.elevation)*cosd(border.elevation)));


  % Eliminate complex elements...
  border.azimuth(imag(border.azimuth)~=0) = NaN; % This statement sometimes fails horribly.
%   border.azimuth(imag(border.azimuth)>1e-5) = NaN; % This statement is silly, but more stable.

  % ...and compute corresponding values for the second half of the boundary.
  border.azimuth = [border.azimuth, 2*centre.azimuth-border.azimuth];
  border.elevation = [border.elevation, border.elevation];
  
  border.azimuth = mod(border.azimuth+180,360)-180;
%   jump = diff(border.azimuth) > 10*border.resolution;
%   border.azimuth(jump)   = NaN;
%   border.elevation(jump) = NaN;
  
  % Eliminate unwanted horizontal lines when boundarys cross the rear meridian:
  border.azimuth(abs(diff(border.azimuth))>10) = NaN;
  
  azimuthOut   = border.azimuth;
  elevationOut = border.elevation;

end
