/*SAS scripts for data analyses*/
/*data analyses for loss of a co-twin at birth*/
%sign (matrix);
rsubmit;
libname Crime3m odbc complete="driver=SQL Server; server=meb-sql02.meb.ki.se; database=MGRCRIME3; Trusted_Connection=yes" schema=MGRCRIME3;
libname myHome '/nfs/home/sonhua'; 
endrsubmit;

*local submit; 
libname Crime3 slibref=Crime3m server=matrix;
libname mt  slibref=myHome server=matrix; 
libname mtw slibref=work server=matrix; 
option compress=yes;
libname STR 'Z:\projects\PTSD\STR\Data';


/*********************************************Population-based matched cohort*****************************************************/
/*1. twins exposed vs unexposed to loss of a co-twin at birth*/
/*data file:myhome.lossatbirth_c1_0906_; */
data test1;set myhome.lossatbirth_c1_0906_;run;
proc sort data=test1;by _cc;
proc means sum data=test1;by _cc; var xcum_y psy_n;
output out=ir sum=;run;

DATA ir;
 SET ir;
 ir=psy_n/xcum_y*1000;
run;

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model (xage_1 xage_2)*psy_n(0)=_cc kon/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_1; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model1';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c gesta_c/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;
data tab_2; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model2';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c apgar_c gesta_c/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_3; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model3';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_4; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model4';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

data hr_all;set tab_1-tab_4;
mark=compress('cohort1'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

ods rtf file='Z:\projects\PTSD\STR\cohort1matched_HR0919.rtf';
proc print data=mtw.hr_all noobs;
title 'COHORT1_Gmatched';
run;

proc print data=mtw.ir noobs;
title 'COHORT1_Gmatched';
run;

ods rtf close;

/*subgroup analyses*/
%macro forsub(data=,n=,label=);
proc sort data=&data;by _cc;
proc means sum data=&data;by _cc; var xcum_y psy_n;
output out=ir sum=;run;

DATA ir0;
 SET ir;
 length mark $32.;
mark=&label;
 ir=psy_n/xcum_y*1000;
run;

data irs1;set ir0;
perc=compress(psy_n||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_all;
var perc;
by mark;
id _cc;run;

data ir_&n;set ir_all;
ir=compress(_1||' /'||_0);run;

proc phreg data=&data;
class _cc(ref='0') kon bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_&n; 
retain label HR; 
set tab1; 
length mark $32.;
mark=&label;
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 
%mend;

data test1;set myhome.lossatbirth_c1_0906_;run;
data kon1 kon2;set test1;
if kon=1 then output kon1;
else if kon=2 then output kon2;run;
%forsub(data=kon1,n=1,label='sub1:age1_male');
%forsub(data=kon2,n=2,label='sub1:age2_female');


data his1 his2;set test1;
if inf_fh_n=1 then output his1;
else if inf_fh_n=0 then output his2;run;
%forsub(data=his1,n=3,label='sub3:his1_yes');
%forsub(data=his2,n=4,label='sub3:his2_no');

data ir_all;set ir_1-ir_4;
mark=compress('cohort1Gmatched'||'_'||mark);
run;


data hr_all;set tab_1-tab_4;
mark=compress('cohort1Gmatched'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

ods rtf file='Z:\projects\PTSD\STR\cohort1matched_sub1HR0924.rtf';
proc print data=mtw.hr_all noobs;
title 'COHORT1Gmatched';
run;

proc print data=mtw.ir_all noobs;
title 'COHORT1Gmatched';
run;
ods rtf close;


data test1;
Set myhome.lossatbirth_c1_0906_;
xsibdeathdate=xtwindeathdate;
run;

data test2;
set test1;
format psy_date_group1 YYMMDD10.   psy_date_group2 YYMMDD10.;
psy_date_group1=min(psy_date_8,psy_date_9,psy_date_10);/*nuerodevelopmental disorders*/
psy_date_group2=min(psy_date_4,psy_date_51,psy_date_52,psy_date_11);/*emtional disorder*/
psy_date_group3=psy_date_3;/*psychotic disorder*/
psy_date_group4=min(psy_date_12,psy_date_6,psy_date_7);/*other*/
psy_date_group5=min(psy_date_12,psy_date_6,psy_date_7,psy_date_3);/*other_big*/
if .<psy_date_group1<psy_date_group2 then con_develop1=1;else con_develop1=0;
if .<psy_date_group1<psy_date_group3 then con_develop2=1;else con_develop2=0;
if .<psy_date_group1<psy_date_group4 then con_develop3=1;else con_develop3=0;
run;

%macro subtype_big(data=,var=,n=,name=);
data test3;set &data;
format xend_sub YYMMDD10.  ;
if _cc=0 then xend_sub=min(xsibdeathdate,&var,xmigrationdate,xdeathdate,'31dec2013'd);
if _cc=1 then xend_sub=min(&var,xmigrationdate,xdeathdate,'31dec2013'd);
if xend_sub=&var then psy_n=1;else psy_n=0;
xcum=intck('day',xstart_cox,xend_sub);
xcum_y=xcum/365.25;
if psy_n=1 then subtype=1;else subtype=0;
drop psy_n;
xage_1=intck('day',xbirthdate,xstart_cox);
xage_2=intck('day',xbirthdate,xend_sub);
run;

data ana_2;set test3;
rename subtype=ai_all;
rename xcum=xcum_n;
xcum_y=xcum/365.25;
person=1;
run;

proc sort data=ana_2; by _cc;run;
proc means sum data=ana_2;
var xcum_y ai_all person;
by _cc;output out=ir_all sum= ;
run;

DATA ir0;
 SET ir_all;
 ir=ai_all/xcum_y*1000;
 risk=ai_all/person;
length mark $32.;
mark=&name;
DROP _TYPE_ _FREQ_;
run;

data irs1;set ir0;
perc=compress(ai_all||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_n;
var perc;
by mark;
id _cc;run;

data ir_&n;set ir_n;
ir=compress(_1||' /'||_0);run;

proc phreg data=ana_2;
class _cc(ref='0') kon;
model (xage_1 xage_2)*ai_all(0)=_cc kon/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_1; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model1';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=ana_2;
class _cc(ref='0') kon bweight_s_c m_age_c apgar_c gesta_c;
model (xage_1 xage_2)*ai_all(0)=_cc kon bweight_s_c m_age_c gesta_c/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_2; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model2';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=ana_2;
class _cc(ref='0') kon gesta_c apgar_c bweight_s_c m_age_c;
model (xage_1 xage_2)*ai_all(0)=_cc kon gesta_c apgar_c bweight_s_c m_age_c/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;


data tab_3; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model3';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=ana_2;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n;
model (xage_1 xage_2)*ai_all(0)=_cc kon bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_4; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model4';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

data hr_&n;set tab_1-tab_4;
mark=compress(&name||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;
%mend;

%subtype_big(data=test2,var=psy_date_group1,n=1,name='neuro');
%subtype_big(data=test2,var=psy_date_group2,n=2,name='mood');
%subtype_big(data=test2,var=psy_date_group3,n=3,name='psychotic');
%subtype_big(data=test2,var=psy_date_group4,n=4,name='others');
%subtype_big(data=test2,var=psy_date_group5,n=5,name='others-big');

data subtypehr_c1;
set hr_1-hr_5;
mark=compress('cohort1Gmatched'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtypeir_c1;
set ir_1-ir_5;
mark=compress('cohort1Gmatched'||'_'||mark);
run;


/*********************************************Population-based matched cohort*****************************************************/
/*2. twins exposed vs singeltons*/
/*data file:myhome.lossatbirth_newc3; */
data test1;set myhome.lossatbirth_newc3;run;
proc sort data=test1;by _cc;
proc means sum data=test1;by _cc; var xcum_y psy_n;
output out=ir sum=;run;

DATA ir;
 SET ir;
 ir=psy_n/xcum_y*1000;
run;

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model (xage_1 xage_2)*psy_n(0)=_cc kon/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_1; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model1';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c gesta_c/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_2; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model2';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c apgar_c gesta_c/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_3; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model3';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n;
model (xage_1 xage_2)*psy_n(0)=_cc kon bweight_s_c m_age_c apgar_c gesta_c mor_maritaln xedu_nmor inf_fh_n/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_4; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model4';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

data hr_all;set tab_1-tab_4;
mark=compress('cohort3'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

ods rtf file='Z:\projects\PTSD\STR\newcohort3_HR1119.rtf';
proc print data=mtw.hr_all noobs;
title 'COHORT3';
run;

proc print data=mtw.ir noobs;
title 'COHORT3';
run;
ods rtf close;

data test1;set myhome.lossatbirth_newc3;run;
data kon1 kon2;set test1;
if kon=1 then output kon1;
else if kon=2 then output kon2;run;
%forsub(data=kon1,n=1,label='sub1:age1_male');
%forsub(data=kon2,n=2,label='sub1:age2_female');


data his1 his2;set test1;
if inf_fh_n=1 then output his1;
else if inf_fh_n=0 then output his2;run;
%forsub(data=his1,n=3,label='sub3:his1_yes');
%forsub(data=his2,n=4,label='sub3:his2_no');

data ir_all;set ir_1-ir_4;
mark=compress('cohort3'||'_'||mark);
run;


data hr_all;set tab_1-tab_4;
mark=compress('cohort3'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

ods rtf file='Z:\projects\PTSD\STR\newcohort3_sub1HR1119.rtf';
proc print data=mtw.hr_all noobs;
title 'COHORT3';
run;

proc print data=mtw.ir_all noobs;
title 'COHORT3';
run;
ods rtf close;

data test1;
Set myhome.lossatbirth_newc3;
run;

data test2;
set test1;
format psy_date_group1 YYMMDD10.   psy_date_group2 YYMMDD10.;
psy_date_group1=min(psy_date_8,psy_date_9,psy_date_10);/*nuerodevelopmental disorders*/
psy_date_group2=min(psy_date_4,psy_date_51,psy_date_52,psy_date_11);/*emtional disorder*/
psy_date_group3=psy_date_3;/*psychotic disorder*/
psy_date_group4=min(psy_date_12,psy_date_6,psy_date_7);/*other*/
psy_date_group5=min(psy_date_12,psy_date_6,psy_date_7,psy_date_3);/*other_big*/
if .<psy_date_group1<psy_date_group2 then con_develop1=1;else con_develop1=0;
if .<psy_date_group1<psy_date_group3 then con_develop2=1;else con_develop2=0;
if .<psy_date_group1<psy_date_group4 then con_develop3=1;else con_develop3=0;
run;


%subtype_big(data=test2,var=psy_date_group1,n=1,name='neuro');
%subtype_big(data=test2,var=psy_date_group2,n=2,name='mood');
%subtype_big(data=test2,var=psy_date_group3,n=3,name='psychotic');
%subtype_big(data=test2,var=psy_date_group4,n=4,name='others');
%subtype_big(data=test2,var=psy_date_group5,n=5,name='others-big');

data subtypehr_c3;
set hr_1-hr_5;
mark=compress('cohort3'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtypeir_c3;
set ir_1-ir_5;
mark=compress('cohort3'||'_'||mark);
run;


ods rtf file='Z:\projects\PTSD\STR\newcohort3_sub2HR1119.rtf';
proc print data=mtw.subtypehr_c3 noobs;
title 'COHORT3';
run;

proc print data=mtw.subtypeir_c3 noobs;
title 'COHORT3';
run;
ods rtf close;


data test1;set myhome.lossatbirth_newc3;run;
data kon1 kon2;set test1;
if dkon=1 then output kon1;
else if dkon=2 then output kon2;run;
%forsub(data=kon1,n=1,label='sub1:age1_same');
%forsub(data=kon2,n=2,label='sub1:age2_dif');

data dper1 dper2 dper3;set test1;
if dperiod=1 then output dper1;
else if dperiod=2 then output dper2;
else if dperiod=3 then output dper3;
run;
%forsub(data=dper1,n=3,label='sub2:0-6');
%forsub(data=dper2,n=4,label='sub2:7-27');
%forsub(data=dper3,n=5,label='sub2:28-60');


/*********************************************Twin-sibling family cohort*****************************************************/
/*1. twins exposed vs their full siblings*/
/*data file:myhome.lossatbirth_c2_0920; */
proc sort data=test1;by _cc;
proc means sum data=test1;by _cc; var xcum_y psy_n;
output out=ir sum=;run;

DATA ir;
 SET ir;
 ir=psy_n/xcum_y*1000;
run;

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model (xage_1 xage_2)*psy_n(0)=_cc kon/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_1; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model1';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

data test2;set test1;
if bweight_s_c=. then bweight_s_c=9;
if  m_age_c=. then  m_age_c=.=9;
if apgar_c=. then apgar_c=9;
if gesta_c=. then gesta_c=9;
run;

proc freq data=test2;
table _cc*bweight_s_c/missing;
table _cc*apgar_c/missing;
table _cc*gesta_c/missing;
table _cc*m_age_c/missing;
run;

proc phreg data=test2;
class _cc(ref='0') kon(ref='1') apgar_c gesta_c bweight_s_c;
model (xage_1 xage_2)*psy_n(0)=_cc kon gesta_c bweight_s_c/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_2; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model2';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test2;
class _cc(ref='0') kon(ref='1') apgar_c gesta_c bweight_s_c;
model (xage_1 xage_2)*psy_n(0)=_cc kon apgar_c gesta_c bweight_s_c/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_3; 
retain label HR; 
set tab1; 
length mark $32.;
mark='all_model3';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 


data hr_all;set tab_1-tab_3;
mark=compress('cohort2'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

ods rtf file='Z:\projects\PTSD\STR\cohort2_HR0919.rtf';
proc print data=mtw.hr_all noobs;
title 'COHORT2';
run;

proc print data=mtw.ir noobs;
title 'COHORT2';
run;

ods rtf close;

data test1;set myhome.lossatbirth_c2_0920;run;
data kon1 kon2;set test1;
if kon=1 then output kon1;
else if kon=2 then output kon2;run;
%forsub(data=kon1,n=1,label='sub1:age1_male');
%forsub(data=kon2,n=2,label='sub1:age2_female');
%forsub(data=test1,n=3,label='sub1:all');


data his1 his2;set test1;
if inf_fh_n=1 then output his1;
else if inf_fh_n=0 then output his2;run;
%forsub(data=his1,n=4,label='sub3:his1_yes');
%forsub(data=his2,n=5,label='sub3:his2_no');

data ir_all;set ir_1-ir_5;
mark=compress('cohort2'||'_'||mark);
run;


data hr_all;set tab_1-tab_5;
mark=compress('cohort2'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

ods rtf file='Z:\projects\PTSD\STR\cohort2_sub1HR0924.rtf';
proc print data=mtw.hr_all noobs;
title 'COHORT2';
run;

proc print data=mtw.ir_all noobs;
title 'COHORT2';
run;
ods rtf close;

data test2;
set test1;
format psy_date_group1 YYMMDD10.   psy_date_group2 YYMMDD10.;
psy_date_group1=min(psy_date_8,psy_date_9,psy_date_10);/*nuerodevelopmental disorders*/
psy_date_group2=min(psy_date_4,psy_date_51,psy_date_52,psy_date_11);/*emtional disorder*/
psy_date_group3=psy_date_3;/*psychotic disorder*/
psy_date_group4=min(psy_date_12,psy_date_6,psy_date_7);/*other*/
psy_date_group5=min(psy_date_12,psy_date_6,psy_date_7,psy_date_3);/*other_big*/
if .<psy_date_group1<psy_date_group2 then con_develop1=1;else con_develop1=0;
if .<psy_date_group1<psy_date_group3 then con_develop2=1;else con_develop2=0;
if .<psy_date_group1<psy_date_group4 then con_develop3=1;else con_develop3=0;
run;


%subtype_big(data=test2,var=psy_date_group1,n=1,name='neuro');
%subtype_big(data=test2,var=psy_date_group2,n=2,name='mood');
%subtype_big(data=test2,var=psy_date_group3,n=3,name='psychotic');
%subtype_big(data=test2,var=psy_date_group4,n=4,name='others');
%subtype_big(data=test2,var=psy_date_group5,n=5,name='others-big');

data subtypehr_c1;
set hr_1-hr_5;
mark=compress('cohort2'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtypeir_c1;
set ir_1-ir_5;
mark=compress('cohort2'||'_'||mark);
run;
