

###################
# Set environment #
###################

# load libraries and initialize environment
source("set_env.R")


############################################
# Load global sensitivity analysis results #
############################################

# This file is generated by script "1-Model_construction.R".
setwd(results_dir)
load("mc_results_100.RData")


########################################
# Metabolic control analyses - Model 4 #
########################################

setwd(model_dir)
loadModel("Millard2020_Ecoli_glc_ace_kinetic_model.cps")
setwd(results_dir)

# delete events and fix concentrations of biomass and extracellular glc and acetate
deleteEvent(getEvents()$key)
setSpecies(key="Ace_out", type="fixed")
setSpecies(key="Glc", type="fixed")
setSpecies(key="X", type="fixed")

# calculate flux control coefficients
n_step <- 50
ace_range <- 10**(seq(-1,2,length.out = n_step))
res_ace_MCA <- matrix(NA, nrow=length(ace_range), ncol=7)
res_ace_MCA[,1] <- ace_range
for (i in seq(n_step)){
  setSpecies(key="Ace_out{cell}", initial_concentration = ace_range[i], model = getCurrentModel())
  applyInitialState(model = getCurrentModel())
  res_MCA <- runMetabolicControlAnalysis(perform_steady_state_analysis=TRUE, model = getCurrentModel())
  if (res_MCA$result_ss != "found"){
    print("error")
  }else{
    fcc <- res_MCA$flux_control_coefficients_scaled
    res_ace_MCA[i,seq(2,7)] <- fcc["(ackA)", colnames(fcc) != "'Summation Error'"]
  }
}
colnames(res_ace_MCA) <- c("ace_conc", colnames(fcc)[colnames(fcc) != "'Summation Error'"])

# plot results
pdf(file = "Figure 4.pdf", height = 4, width = 5)

setSpecies(key="Ace_out{cell}", initial_concentration = 0.1, model = getCurrentModel())
applyInitialState(model = getCurrentModel())
res_MCA <- runMetabolicControlAnalysis(model = getCurrentModel())

hmc <- res_MCA$flux_control_coefficients_scaled[c("(glc_upt)", "(ackA)", "(sink)"), c("(glc_upt)", "(sink)", "(pta)", "(ackA)", "(ace_xch)")]
colnames(hmc) <- c("glycolysis", "TCA", "Pta", "AckA", "Ace_xch")
rownames(hmc) <- c("glycolysis", "acetate", "TCA")
rgb.palette <- colorRampPalette(brewer.pal(n = 11, name = "RdBu"))
breaks <- c(-1, -0.5, -0.2, -0.1, -0.05, -0.01, 0.01, 0.05, 0.1, 0.2, 0.5, 1, 1.5)
col_scale <- rgb.palette(length(breaks)-1)
col_scale[6] <- "#DDDDDD"
heatmap.2(hmc, Rowv=FALSE, Colv=FALSE, dendrogram="none", col=col_scale, breaks=breaks,
          scale="none", trace="none", colsep=seq(0,ncol(hmc)), rowsep=seq(0,nrow(hmc)), sepwidth=c(0.04,0.02))

dev.off()

# sensitivity analysis
run_mca_sa <- function(){
  n_step <- 50
  ace_range <- 10**(seq(-1,2,length.out = n_step))
  res_ace_MCA <- matrix(NA, nrow=length(ace_range), ncol=7)
  res_ace_MCA[,1] <- ace_range
  for (i in seq(n_step)){
    setSpecies(key="Ace_out{cell}", initial_concentration = ace_range[i], model = getCurrentModel())
    applyInitialState(model = getCurrentModel())
    res_MCA <- runMetabolicControlAnalysis(perform_steady_state_analysis=TRUE, model = getCurrentModel())
    if (res_MCA$result_ss != "found"){
      print("error")
    }else{
      fcc <- res_MCA$flux_control_coefficients_scaled
      res_ace_MCA[i,seq(2,7)] <- fcc["(ackA)", colnames(fcc) != "'Summation Error'"]
    }
  }
  colnames(res_ace_MCA) <- c("ace_conc", colnames(fcc)[colnames(fcc) != "'Summation Error'"])
  return(res_ace_MCA)
}

# create progress bar
pb <- txtProgressBar(min=0, max=ncol(fit_results$res_par)-1, style=3)

# sensitivity analysis
res <- array(NA, dim=c(ncol(fit_results$res_par)-1, length(ace_range), 7), dimnames=list(iter=NULL, ace_conc=NULL, fcc=c("ace_conc", colnames(fcc)[colnames(fcc) != "'Summation Error'"])))
for (i in seq(ncol(fit_results$res_par)-1)){
  rp <- c(fit_results$res_par[,i+1])
  names(rp) <- fit_results$res_par[,"parameter"]
  model <- update_params(getCurrentModel(), rp)
  res[i,,] <- run_mca_sa()
  setTxtProgressBar(pb, i)
}

# close progress bar
close(pb)

# plot results
pdf(file="Figure 5.pdf", width = 7, height = 9)
par(mfrow=c(4,3))

xlab_main <- c(0.1, 1, 10, 100)
xlab_sec <- c(seq(0.2, 0.9, by=0.1), seq(2, 9, by=1), seq(20, 90, by=10))
conc_threshold <- 13.27174

ctrl_by_acetate_pathway <- apply(apply(res[,,c("(ackA)", "(pta)", "(ace_xch)")], c(1,2), sum), 2, mean)
ctrl_by_glc_upt <- apply(res[,,"(glc_upt)"], 2, mean)
ctrl_by_TCA <- apply(res[,,"(sink)"], 2, mean)

plot(x=ace_range, y=ctrl_by_acetate_pathway, type="l", xaxt="n", las=1, ylim=c(0,1), log="x", xaxs="i", yaxs="i", xlab="[acetate] (mM)", ylab="control by acetate pathway", lwd=1.2)
polygon(x=c(ace_range, rev(ace_range)),
        y=c(apply(apply(res[,,c("(ackA)", "(pta)", "(ace_xch)")], c(1,2), sum), 2, max), rev(apply(apply(res[,,c("(ackA)", "(pta)", "(ace_xch)")], c(1,2), sum), 2, min))),
        col="#00000055", border=NA)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

fconc <- 0.8
lines_threshold(x=ace_range, y=ctrl_by_glc_upt, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by glycolysis", lwd=1.2)
polygon(x=c(ace_range[ace_range < conc_threshold*fconc], rev(ace_range[ace_range < conc_threshold*fconc])),
        y=c(apply(res[,ace_range < conc_threshold*fconc,"(glc_upt)"], 2, max), rev(apply(res[,ace_range < conc_threshold*fconc,"(glc_upt)"], 2, min))),
        col="#00000055", border=NA)

polygon(x=c(ace_range[ace_range > conc_threshold/fconc], rev(ace_range[ace_range > conc_threshold/fconc])),
        y=c(apply(res[,ace_range > conc_threshold/fconc,"(glc_upt)"], 2, max), rev(apply(res[,ace_range > conc_threshold/fconc,"(glc_upt)"], 2, min))),
        col="#00000055", border=NA)

axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

lines_threshold(x=ace_range, y=ctrl_by_TCA, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by TCA", lwd=1.2)
polygon(x=c(ace_range[ace_range < conc_threshold*fconc], rev(ace_range[ace_range < conc_threshold*fconc])),
        y=c(apply(res[,ace_range < conc_threshold*fconc,"(sink)"], 2, max), rev(apply(res[,ace_range < conc_threshold*fconc,"(sink)"], 2, min))),
        col="#00000055", border=NA)

polygon(x=c(ace_range[ace_range > conc_threshold/fconc], rev(ace_range[ace_range > conc_threshold/fconc])),
        y=c(apply(res[,ace_range > conc_threshold/fconc,"(sink)"], 2, max), rev(apply(res[,ace_range > conc_threshold/fconc,"(sink)"], 2, min))),
        col="#00000055", border=NA)

axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

plot(x=ace_range, y=ctrl_by_TCA+ctrl_by_glc_upt, type="l", ylim=c(0,1), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA+glycolysis", lwd=1.2)
polygon(x=c(ace_range, rev(ace_range)),
        y=c(apply(res[,,"(sink)"]+res[,,"(glc_upt)"], 2, max), rev(apply(res[,,"(sink)"]+res[,,"(glc_upt)"], 2, min))),
        col="#00000055", border=NA)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

plot(x=ace_range, y=-ctrl_by_TCA/ctrl_by_glc_upt, type="l", ylim=c(0,2), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA/glycolysis", lwd=1.2)
polygon(x=c(ace_range, rev(ace_range)),
        y=c(apply(-res[,,"(sink)"]/res[,,"(glc_upt)"], 2, max), rev(apply(-res[,,"(sink)"]/res[,,"(glc_upt)"], 2, min))),
        col="#00000055", border=NA)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=1)

dev.off()


#####################################################
# Metabolic control analyses for alternative models #
#####################################################

###########
# Model 1 #
###########

setwd(model_dir)
loadModel("Millard2020_Ecoli_glc_ace_kinetic_model_1.cps")
setwd(results_dir)

# delete events and fix concentrations of biomass and extracellular glc and acetate
deleteEvent(getEvents()$key)
setSpecies(key="Ace_out", type="fixed")
setSpecies(key="Glc", type="fixed")
setSpecies(key="X", type="fixed")

# calculate flux control coefficients
n_step <- 50
ace_range <- 10**(seq(-1,2,length.out = n_step))
res_ace_MCA <- matrix(NA, nrow=length(ace_range), ncol=7)
res_ace_MCA[,1] <- ace_range
for (i in seq(n_step)){
  setSpecies(key="Ace_out{cell}", initial_concentration = ace_range[i], model = getCurrentModel())
  applyInitialState(model = getCurrentModel())
  res_MCA <- runMetabolicControlAnalysis(model = getCurrentModel())
  if (res_MCA$result_ss != "found"){
    print("error")
  }else{
    fcc <- res_MCA$flux_control_coefficients_scaled
    res_ace_MCA[i,seq(2,7)] <- fcc["(ackA)", colnames(fcc) != "'Summation Error'"]
  }
}
colnames(res_ace_MCA) <- c("ace_conc", colnames(fcc)[colnames(fcc) != "'Summation Error'"])

pdf(file="Figure 5-figure supplement 1.pdf", width = 7, height = 9)
par(mfrow=c(4,3))

xlab_main <- c(0.1, 1, 10, 100)
xlab_sec <- c(seq(0.2, 0.9, by=0.1), seq(2, 9, by=1), seq(20, 90, by=10))
conc_threshold <- 16

ctrl_by_acetate_pathway <- apply(res_ace_MCA[,c("(ackA)", "(pta)", "(ace_xch)")], 1, sum)
ctrl_by_glc_upt <- res_ace_MCA[,"(glc_upt)"]
ctrl_by_TCA <- res_ace_MCA[,"(sink)"]

plot(x=ace_range, y=ctrl_by_acetate_pathway, type="l", xaxt="n", las=1, ylim=c(0,1), log="x", xaxs="i", yaxs="i", xlab="[acetate] (mM)", ylab="control by acetate pathway", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

lines_threshold(x=ace_range, y=ctrl_by_glc_upt, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

lines_threshold(x=ace_range, y=ctrl_by_TCA, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by TCA", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

plot(x=ace_range, y=ctrl_by_TCA+ctrl_by_glc_upt, type="l", ylim=c(0,1), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA+glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

plot(x=ace_range, y=-ctrl_by_TCA/ctrl_by_glc_upt, type="l", ylim=c(0,2), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA/glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=1)

dev.off()

###########
# Model 2 #
###########

setwd(model_dir)
loadModel("Millard2020_Ecoli_glc_ace_kinetic_model_2.cps")
setwd(results_dir)

# delete events and fix concentrations of biomass and extracellular glc and acetate
deleteEvent(getEvents()$key)
setSpecies(key="Ace_out", type="fixed")
setSpecies(key="Glc", type="fixed")
setSpecies(key="X", type="fixed")

# calculate flux control coefficients
n_step <- 50
ace_range <- 10**(seq(-1,2,length.out = n_step))
res_ace_MCA <- matrix(NA, nrow=length(ace_range), ncol=7)
res_ace_MCA[,1] <- ace_range
for (i in seq(n_step)){
  setSpecies(key="Ace_out{cell}", initial_concentration = ace_range[i], model = getCurrentModel())
  applyInitialState(model = getCurrentModel())
  res_MCA <- runMetabolicControlAnalysis(model = getCurrentModel())
  if (res_MCA$result_ss != "found"){
    print("error")
  }else{
    fcc <- res_MCA$flux_control_coefficients_scaled
    res_ace_MCA[i,seq(2,7)] <- fcc["(ackA)", colnames(fcc) != "'Summation Error'"]
  }
}
colnames(res_ace_MCA) <- c("ace_conc", colnames(fcc)[colnames(fcc) != "'Summation Error'"])

pdf(file="Figure 5-figure supplement 2.pdf", width = 7, height = 9)
par(mfrow=c(4,3))

xlab_main <- c(0.1, 1, 10, 100)
xlab_sec <- c(seq(0.2, 0.9, by=0.1), seq(2, 9, by=1), seq(20, 90, by=10))
conc_threshold <- 14

ctrl_by_acetate_pathway <- apply(res_ace_MCA[,c("(ackA)", "(pta)", "(ace_xch)")], 1, sum)
ctrl_by_glc_upt <- res_ace_MCA[,"(glc_upt)"]
ctrl_by_TCA <- res_ace_MCA[,"(sink)"]

plot(x=ace_range, y=ctrl_by_acetate_pathway, type="l", xaxt="n", las=1, ylim=c(0,1), log="x", xaxs="i", yaxs="i", xlab="[acetate] (mM)", ylab="control by acetate pathway", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

lines_threshold(x=ace_range, y=ctrl_by_glc_upt, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

lines_threshold(x=ace_range, y=ctrl_by_TCA, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by TCA", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

plot(x=ace_range, y=ctrl_by_TCA+ctrl_by_glc_upt, type="l", ylim=c(0,1), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA+glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

plot(x=ace_range, y=-ctrl_by_TCA/ctrl_by_glc_upt, type="l", ylim=c(0,2), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA/glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=1)

dev.off()

###########
# Model 3 #
###########

setwd(model_dir)
loadModel("Millard2020_Ecoli_glc_ace_kinetic_model_3.cps")
setwd(results_dir)

# delete events and fix concentrations of biomass and extracellular glc and acetate
deleteEvent(getEvents()$key)
setSpecies(key="Ace_out", type="fixed")
setSpecies(key="Glc", type="fixed")
setSpecies(key="X", type="fixed")

# calculate flux control coefficients
n_step <- 50
ace_range <- 10**(seq(-1,2,length.out = n_step))
res_ace_MCA <- matrix(NA, nrow=length(ace_range), ncol=7)
res_ace_MCA[,1] <- ace_range
for (i in seq(n_step)){
  setSpecies(key="Ace_out{cell}", initial_concentration = ace_range[i], model = getCurrentModel())
  applyInitialState(model = getCurrentModel())
  res_MCA <- runMetabolicControlAnalysis(model = getCurrentModel())
  if (res_MCA$result_ss != "found"){
    print("error")
  }else{
    fcc <- res_MCA$flux_control_coefficients_scaled
    res_ace_MCA[i,seq(2,7)] <- fcc["(ackA)", colnames(fcc) != "'Summation Error'"]
  }
}
colnames(res_ace_MCA) <- c("ace_conc", colnames(fcc)[colnames(fcc) != "'Summation Error'"])

pdf(file="Figure 5-figure supplement 3.pdf", width = 7, height = 9)
par(mfrow=c(4,3))

xlab_main <- c(0.1, 1, 10, 100)
xlab_sec <- c(seq(0.2, 0.9, by=0.1), seq(2, 9, by=1), seq(20, 90, by=10))
conc_threshold <- 2.3

ctrl_by_acetate_pathway <- apply(res_ace_MCA[,c("(ackA)", "(pta)", "(ace_xch)")], 1, sum)
ctrl_by_glc_upt <- res_ace_MCA[,"(glc_upt)"]
ctrl_by_TCA <- res_ace_MCA[,"(sink)"]

plot(x=ace_range, y=ctrl_by_acetate_pathway, type="l", xaxt="n", las=1, ylim=c(0,1), log="x", xaxs="i", yaxs="i", xlab="[acetate] (mM)", ylab="control by acetate pathway", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

lines_threshold(x=ace_range, y=ctrl_by_glc_upt, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

lines_threshold(x=ace_range, y=ctrl_by_TCA, threshold=conc_threshold, new=TRUE, xaxt="n", xaxs="i", yaxs="i", las=1, xlim=c(0.1,100), type="l", ylim=c(-3,3), log="x", xlab="[acetate] (mM)", ylab="control by TCA", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=0)

plot(x=ace_range, y=ctrl_by_TCA+ctrl_by_glc_upt, type="l", ylim=c(0,1), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA+glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)

plot(x=ace_range, y=-ctrl_by_TCA/ctrl_by_glc_upt, type="l", ylim=c(0,2), xaxt="n", xaxs="i", yaxs="i", las=1, log="x", xlab="[acetate] (mM)", ylab="control by TCA/glycolysis", lwd=2)
axis(side = 1, at = xlab_main, labels = TRUE)
axis(side = 1, at = xlab_sec, labels = FALSE, tcl=-0.3)
abline(h=1)

dev.off()

