function output = CellTrackingAnalysisGJB(input)

 % analyse per movie, copy results to origin per movie. 
  
 % added functionality, it can generate a tracking file which can be read by the
 % manual tracking tool. This is a workaround for the bug in the plugin,
 % which cannot read its own tracking files. 
 
 T=1; % time is defined in minutes 
 pixelsize=1;%m/pixel
 Fname='Results from seq5_opa50_00001_RandomGCAMP2.txt'
 
 % Correct pixel size and dwell time for correct distance and velocity:
 input(:,5)=input(:,5).*pixelsize;
 input(:,6)=input(:,6).*pixelsize./T; 
 
 inputlength=size(input,1); % part to generate an output called 'input2', which can be saved as a tab delimited file (below), to be read in fiji. 
 addcolumn=ones(inputlength,1);
 addrows=ones(1,8);
 input2=cat(2, addcolumn, input);
 input2=cat(1,addrows,input2); 
 
 indexL=size(input,1);
 indexW=size(input,2);
 analysed=zeros(0,indexW);
 % TRtemp=zeros(0,indexW);
 % TRtemp=[input{:,3}./pixelsize, input{:,4}./pixelsize, 100.*ones(indexL,4), input{:,2}, input{:,1}, T.*ones(indexL,1), movienr.*ones(indexL,1)];
 
 s=1;
for i=2:indexL
    if i==indexL
        k=input(:,1)==input(indexL,1);
        TRtemp=input(k,:);
        k=TRtemp(:,6) >= 0;
        TRtemp=TRtemp(k,:);
        TRtemp=mean(TRtemp);
        analysed=cat(1,analysed,TRtemp);
    elseif input(i,1)==input(i-1,1)
        s=input(i,1);
    else
        k=(input(:,1)==s);% && (input(:,6)=~-1);
        TRtemp=input(k,:);
        k=TRtemp(:,6) >= 0;
        TRtemp=TRtemp(k,:);
        TRtemp=mean(TRtemp);
        analysed=cat(1,analysed,TRtemp);   
    end
end

DataFile=input2;%analysed; %[tlag, MeanMSD, ErrorMSD, TmsdFit, FitMSD];
save(Fname,'DataFile', '-ASCII' , '-tabs');    
   
output=analysed;
