// Macro to measure the number of pixels above the threshold, with the areas that 
// were already above the threshold before the OPA treatment being excluded. 
// Input: composite z-stack before and after OPA exposure, 
// Channel to be analysed, 
// Threshold (BG + 3*SD, determined from non-OPA exposed "raw" image from timelapse stack),
// "raw" is not completely raw, but the unfiltered image stack from ProcessRedChannel.ijm. 
// ROI with the selected cell area opened in the ROI manager.
// Output: pixel area (number of pixels) for each z-slice, in the results window.

// Preparation: 
// Analyse, Set Measurements ..., select "Limit to threshold" and check Area.
// Open ROI manager and load the Cell area of the sequence. This ROI should be the 
// first in the list.

//Variables
Dialog.create("Select channel, set the threshold for the channel and select last frame before exposure");
Dialog.addNumber("channel", 2);
Dialog.addNumber("threshold value", 372);
Dialog.addNumber("last frame before exposure", 50);
Dialog.show();
chnnl = Dialog.getNumber();
thrshld = Dialog.getNumber();
lstfrm = Dialog.getNumber(); 
print("Channel:",chnnl);
print("Threshold:",thrshld);
print("Frame number:",lstfrm);
path1 = File.openDialog("Select timelapse stack");
dir = File.getParent(path1);
name1 = File.getName(path1);
print("Name timelapse stack:", name1);
print("Directory:", dir);

//Main
close("ROI Cell Area before (1) and after (2) adjustment")
close("Area above threshold within Adjusted ROI Cell Area")
open(path1);

// Measure and print the total pixel area within the cellArea ROI
selectWindow(name1);
run("Duplicate...", "duplicate channels=" + chnnl);
roiManager("Select", 0);
run("Measure");
ROIarea = getResult("Area",0)
print("ROI Cell Area, all pixels included:", ROIarea);
close()

// Create mask before OPA exposure, pixels above threshold are high.
selectWindow(name1);
run("Duplicate...", "duplicate channels=" + chnnl + " frames=" + lstfrm); // slices instead of frames for seq50
run("Add...", "value=20"); // prevent negative values
run("Multiply...", "value=10.000"); // reduce inaccuracy caused by rounding to integers during filtering
run("Median...", "radius=2"); // filtering to reduce noise in mask
setThreshold(thrshld,65000) // find positive area above threshold  
run("Convert to Mask", "method=Default background=Dark black");
run("Options...", "iterations=6 count=1 black pad do=Dilate"); // dilate, because these pre-exposure positive areas expand and drift during the measurement.
rename("GateBefore.tif");

// Measure ROI Cell Area without the areas where cells were already positive before exposure
run("Duplicate...", "duplicate");
run("Invert");
setThreshold(1,255)
roiManager("Select", 0);
roiManager("Measure");
IJ.renameResults("ROI Cell Area before (1) and after (2) adjustment" );
close()

// Create mask after OPA exposure, pixels above threshold are high.
selectWindow(name1);
run("Duplicate...", "duplicate channels=" + chnnl);
run("Add...", "value=20 stack");
run("Multiply...", "value=10.000 stack");
run("Median...", "radius=2 stack");
run("Enhance Contrast", "saturated=0.35");
setThreshold(thrshld,65000)
run("Convert to Mask", "method=Default background=Dark black");
rename("GateTimelapseStack.tif");

// Measure pixel area above threshold, within ROI cell area, already positive regions excluded.
imageCalculator("Subtract create stack", "GateTimelapseStack.tif","GateBefore.tif");
setThreshold(1,255);
roiManager("Select", 0);
roiManager("Multi Measure");
IJ.renameResults("Area above threshold within Adjusted ROI Cell Area" );
close("*")
