// Macro to measure the number of pixels above the threshold, with the areas that 
// were already above the threshold before the OPA treatment being excluded. 
// Input: composite z-stack before and after OPA exposure, 
// Channel to be analysed, 
// Threshold (BG + 3*SD, determined from non-OPA exposed "raw" image from timelapse stack),
// "raw" is not completely raw, but the unfiltered image stack from ProcessRedChannel.ijm. 
// ROI with the selected cell area opened in the ROI manager.
// Output: ajusted ROI Cell Area with the pixels being positive before exposure excluded,
// pixel area (number of pixels) for each z-slice, former and latter in results windows.

// Preparation: 
// Analyse, Set Measurements ..., select "Limit to threshold" and check Area.
// Open ROI manager and load the Cell area of the sequence. This ROI should be the 
// first in the list.

//Variables
Dialog.create("Select channel and set the threshold for the channel");
Dialog.addNumber("channel", 1);
Dialog.addNumber("threshold value", 197);
Dialog.show();
chnnl = Dialog.getNumber();
thrshld = Dialog.getNumber();
print("Channel:",chnnl);
print("Threshold:",thrshld);
path1 = File.openDialog("Select stack before");
path2 = File.openDialog("Select stack after");
dir = File.getParent(path1);
name1 = File.getName(path1);
name2 = File.getName(path2);
print("Name1:", name1);
print("Name2:", name2);
print("Directory:", dir);

//Main
close("Adjusted ROI Cell Area")
close("Area above threshold within Adjusted ROI Cell Area")
open(path1);
open(path2);

// Measure and print the total pixel area within the cellArea ROI
selectWindow(name1);
run("Duplicate...", "duplicate channels=" + chnnl);
roiManager("Select", 0);
run("Measure");
ROIarea = getResult("Area",0)
print("ROI Cell Area, all pixels included:", ROIarea);
close()

// Create mask before OPA exposure, pixels above threshold are high.
selectWindow(name1);
run("Duplicate...", "duplicate channels=" + chnnl); //
run("Add...", "value=20 stack"); // prevent negative values
run("Multiply...", "value=10.000 stack"); // reduce inaccuracy caused by rounding to integers during filtering
run("Median...", "radius=2 stack"); // filtering to reduce noise in mask
setThreshold(thrshld,65000) // find positive area above threshold  
run("Convert to Mask", "method=Default background=Dark black");
run("Options...", "iterations=6 count=1 black pad do=Dilate stack"); // dilate, because these pre-exposure positive areas expand and drift during the measurement.
rename("GateBefore.tif");

// Measure ROI Cell Area without the areas where cells were already positive before exposure, to calculate relative area in Origin
run("Duplicate...", "duplicate");
run("Invert", "stack");
setThreshold(1,255)
roiManager("Select", 0);
roiManager("Multi Measure");
IJ.renameResults("Adjusted ROI Cell Area" );
close()

// Create mask after OPA exposure, pixels above threshold are high.
selectWindow(name2);
run("Duplicate...", "duplicate channels=" + chnnl);
run("Add...", "value=20 stack");
run("Multiply...", "value=10.000 stack");
run("Median...", "radius=2 stack");
run("Enhance Contrast", "saturated=0.35");
setThreshold(thrshld,65000)
run("Convert to Mask", "method=Default background=Dark black");
rename("GateAfter.tif");

// Measure pixel area above threshold, within ROI cell area, already positive regions excluded.
imageCalculator("Subtract create stack", "GateAfter.tif","GateBefore.tif");
setThreshold(1,255)
roiManager("Select", 0);
roiManager("Multi Measure");
IJ.renameResults("Area above threshold within Adjusted ROI Cell Area" );
close("*")
