function output = MaxDerivativeGJB1(profiles)

% add z-axis to stacks:
% zstepsize=2.5; 
% test=(1:size(profiles,1))*zstepsize;
% then, select the specific range of the z-profiles generated by imageJ
% over te complete stack.

NrProfiles=size(profiles,2)
lengthProfiles=size(profiles,1);
normalizedprofiles=profiles;
diffprofiles=profiles(1:end-1,:);
absdiffpr=profiles(1:end-1,:);
maxdiff=zeros(1,NrProfiles);

dx=profiles(2,1)-profiles(1,1)
for i=2:NrProfiles
    [~,n] = min(profiles(:,i)); % calculate BG, by average around minimum
    if n>2 && n<=(lengthProfiles-1)
        BG=mean(profiles((n-2):(n+1),i))
    elseif n<=2
        BG=mean(profiles(n:(n+3),i))
    elseif n>(lengthProfiles-1)
        BG=mean(profiles((n-3):n,i))
    end
    normalizedprofiles(:,i)=(profiles(:,i)-BG)./(max(profiles(:,i))-BG);
    diffprofiles(:,i)=diff(normalizedprofiles(:,i))./dx;
    absdiffpr(:,i)=abs(diffprofiles(:,i));
    maxdiff(i)=max(absdiffpr(:,i));
    %plot(diffprofiles(:,1),diffprofiles(:,i))
    plot(profiles(:,1),profiles(:,i))
    pause
end

%plot(diffprofiles(:,1),diffprofiles(:,2))
output=maxdiff(2:end).';