multistep.evolution.adaptive <-
function( benefit, cost, decay, dose=dose, delta, t2cmax, PK, antibiotics, tmax, treat, maxpat){
    treatment=list(P01=rlist::list.append(treat,maxpat=maxpat,num=1),
                   P02=rlist::list.append(treat,maxpat=maxpat,num=1*12),
                   P03=rlist::list.append(treat,maxpat=maxpat,num=2*12),
                   P04=rlist::list.append(treat,maxpat=maxpat,num=3*12),
                   P05=rlist::list.append(treat,maxpat=maxpat,num=4*12),
                   P06=rlist::list.append(treat,maxpat=maxpat,num=5*12),
                   P07=rlist::list.append(treat,maxpat=maxpat,num=6*12),
                   P08=rlist::list.append(treat,maxpat=maxpat,num=7*12),
                   P09=rlist::list.append(treat,maxpat=maxpat,num=8*12))
    
  iR_1=floor(dose/benefit)
  n.subpops=iR_1+1

  if(antibiotics=='AB'){
    # antibiotics
    PDpars=list(MIC=1, benefit, phiminS=-5, phiminR=-5, kappa=1.5,r=1, leftbirth=1/100, c, u=3*10^-6,
                gamma=0, K=10^9)
  }
  if(antibiotics=='AMP'){
    # AMPs
    PDpars=list(MIC=1, benefit, phiminS=-50, phiminR=-50, kappa=5, r=1,leftbirth=1/100, c, u=10^-6,
                gamma=0, K=10^9)
  }

  ## antimicrobial concentration function
  # adaptive dependence on total population and individual mutants
  if(PK=='adaptive'){
      eta <- function(Ri,t.vec, a, treat2=treatment){
    with(as.list(treat2),{
        R=sum(Ri)
        out=max(sapply(2:(n.subpops+1), function(il)
          { with(as.list(c(R,Ri,a,dose,maxpat)), {
          if(R>maxpat && Ri[il]>(maxpat/10) && a< (benefit*(il-1)))
          out=min(benefit,max(dose-a,0))
          else if(Ri[1]>(maxpat/10) && a<1)
            out=1
          else out=0})
        }))
     return(out)
    })
  }
  }

  # comparison with peak for same number and initial values of starting populations as adaptive
  if(PK=='adaptivepeak'){
      decay=0
      eta.1 <- function(t, treat2){
        with(as.list(treat2),{
           if(any(num <= t & t < num+duration))
            out = dose
          else out=0
         return(out)
        })
      }

      eta <-  function(Ri, t.vec, a, treat2=treatment) {
        conc= sapply(treat2, function(treat2){
          sapply(t.vec, function(t) eta.1(t, treat2))
        })
        if (length(t.vec)>1){
          conc_fin=rowSums(conc)
        }   else {
          conc_fin=sum(conc)
        }
        return(conc_fin)
      }
  }

  # stochastic gamma function
  gammaR_G <- function(a, pars=PDpars){
    with(as.list(pars), {
      phimaxR=r*(1-cost)^(0:n.subpops)-gamma
      gR=((phimaxR-phiminR)*(a/(MIC*c(1,benefit*(1:n.subpops))))^kappa)/
    ((a/(MIC*c(1,benefit*(1:n.subpops))))^kappa-phiminR/phimaxR)
      return(gR)})
  }

 # stochastic population model

    if(antibiotics=='AB'){
    N0=AB_neutral_mutations
    }
    if(antibiotics=='AMP'){
      N0=AMP_neutral_mutations
    }
    N0=matrix(as.numeric(as.matrix(N0[c(12,1:11),])),12,9)

    R.init <- with(as.list(PDpars), {
    b1=c(2,3,6,9,15,24,50,75,100)
    ib=which(b1==benefit)
     R.init <- rep(0, iR_1+2)
    iN0=min(iR_1+1, dim(N0)[1])
    R.init[1:iN0]=round(N0[1:iN0,ib])
    R.init[iR_1+2]=floor(((maxpat/K-sqrt((maxpat/K)^2-4*(u*(1-maxpat/K)*(R.init[iR_1+1]/K))/(1-cost)))/2)*K)+1
    if(sum(R.init)>10^5) browser()
    if(sum(R.init)<10^5) R.init[1]=10^5-sum(R.init)
    return(R.init)
    })
    names(R.init) <- paste0("R",1:(n.subpops+1))
    a.init=0
    names(a.init) <- paste("a")
    inits <- c(R.init,a.init)
    stoch.equ <- (length(inits)-1)*3-1   # number of equations to simulate stochastically (3*number the Ri except only two for last Ri)

    transitions <-
      adaptivetau::ssa.maketrans(c(paste0("R",1:(n.subpops+1)),"a"),
                    rbind(paste0("R",1:(n.subpops+1)), +1), # growthRi
                    rbind(paste0("R",1:(n.subpops+1)), -1), # deathRi
                    rbind(paste0("R",2:(n.subpops+1)), +1, paste0("R",1:n.subpops), -1), # mutation to Ri+1
                    rbind("a", +1), # growth
                    rbind("a", -1) # decay
      )

    trans.rates <- function(y, p, t){
      a <- y[n.subpops+2]
      Ri <- y[1:(n.subpops+1)]
      dRi <- y[1:(n.subpops+1)]
      R <- sum(Ri)
      with(as.list(p),{
         rates <-
          c(r*(1-u)*(1-cost)^(0:n.subpops)*(1+leftbirth)*Ri,
          (gamma+gammaR_G(a)+r*(1-u)*(1-cost)^(0:n.subpops)*(delta*R/K+leftbirth))*Ri+r*u*c((1-cost)^(0:(n.subpops-1)),0)*(delta*R/K+leftbirth)*c(Ri[1:n.subpops],0),
            r*u*(1-cost)^(0:(n.subpops-1))*(1+leftbirth)*Ri[1:n.subpops],
            eta(Ri,t,a),
            decay*a
       )
        names(rates) <- NULL
        return(rates)
      })
    }

    output <-
      as.data.frame(adaptivetau::ssa.adaptivetau(inits, transitions, trans.rates, PDpars, tf=tmax, tl.params = list(epsilon=0.01)))
    
    #  calculate selection coefficient (start= far away from carrying capacity )
    output$a[which(output$a<0)]=0
    start_selcoeff <- with(as.list(PDpars),{
      sapply(output$a, function(a) {
        (r*(1-u)*(1-cost)^(1:n.subpops)-(gamma+gammaR_G(a)[2:(n.subpops+1)]))-(r*(1-u)*(1-cost)^(0:(n.subpops-1))-(gamma+gammaR_G(a)[1:(n.subpops)]))
      })
    })
    
    output.all = cbind(output, t(start_selcoeff))
    return(output.all)
}
