run.diff.pars <-
function(simrun, benefit, n.subpops, dose,delta, t2cmax,PK, antibiotics,tmax, maxpat)
{
  treat=list( absorption=0.5,   tau=1/24, duration=1)

  cost=log(benefit)* 0.0087+0.0565
par1=rbind(benefit,cost)

sim.res.d <- sapply(dose,function(d1) {
    sim.res <- apply(par1,2, function(p1) {

  b1=p1[1]
  c1=p1[2]

il=1:simrun
stats.data=sapply(il, function(il) extract.vars(benefit=b1, cost=c1, n.subpops, dose=d1, delta, t2cmax,  PK, antibiotics, tmax, treat,maxpat))
stats.data.t=t(stats.data)

Temergence.stats=sapply(1:length(il), function(d2) as.matrix(stats.data.t[[d2]]))
Temergence.stats.mean=rowMeans(Temergence.stats, na.rm=T)
Temergence.stats.sd=matrixStats::rowSds(Temergence.stats,na.rm=T)

DiversityIndex.stats.mean=mean(as.numeric(stats.data[2,]),na.rm=TRUE)
DiversityIndex.stats.sd=sd(as.numeric(stats.data[2,]),na.rm=TRUE)

Treatfail=length(which(as.numeric(stats.data[4,])>10))/tail(il,1)
if(PK=='adaptive' || PK=='adaptivepeak'){
Treatfail=length(any(as.numeric(stats.data[4,])>=10^8))/tail(il,1)
Treatfail_time=mean(as.numeric(stats.data[7,]), na.rm=T)
}

Mutnumber.stats.mean=mean(as.numeric(stats.data[3,]),na.rm=TRUE)
Mutnumber.stats.sd=sd(as.numeric(stats.data[3,]),na.rm=TRUE)

Relpatload.stats=sapply((1+length(il)*4):(length(il)*5), function(d2) as.matrix(stats.data.t[[d2]]))
Relpatload.stats.mean=rowMeans(Relpatload.stats, na.rm=T)
Relpatload.stats.sd=matrixStats::rowSds(Relpatload.stats,na.rm=T)

Endpatload.stats=sapply((1+length(il)*3):(length(il)*4), function(d2) as.matrix(stats.data.t[[d2]]))
Endpatload.stats.mean=mean(Endpatload.stats, na.rm=T)

if(PK=='adaptive' || PK=='adaptivepeak'){
  return(list(   "DiversityIndex.mean"=DiversityIndex.stats.mean, "DiversityIndex.sd"=DiversityIndex.stats.sd, "Treatfail"=Treatfail, "Mutnumber.mean"=Mutnumber.stats.mean, "Mutnumber.sd"=Mutnumber.stats.sd, "Relpatload"=Relpatload.stats.mean, "Endpatload"=Endpatload.stats.mean, "Treatfail_time"=Treatfail_time))
} else {
return(list(   "DiversityIndex.mean"=DiversityIndex.stats.mean, "DiversityIndex.sd"=DiversityIndex.stats.sd, "Treatfail"=Treatfail, "Mutnumber.mean"=Mutnumber.stats.mean, "Mutnumber.sd"=Mutnumber.stats.sd, "Relpatload"=Relpatload.stats.mean, "Endpatload"=Endpatload.stats.mean))
}
})

  indres=1:length(sim.res)
  DiversityIndex.mean=sapply(indres, function(i2) sim.res[[i2]]$DiversityIndex.mean)
  DiversityIndex.sd=sapply(indres, function(i2) sim.res[[i2]]$DiversityIndex.sd)
  Temergence.mean=sapply(indres, function(i2) sim.res[[i2]]$Temergence.mean[2])  # emergence of first mutant
  Temergence.sd=sapply(indres, function(i2) sim.res[[i2]]$Temergence.sd[2])
  Mutnumber.mean=sapply(indres, function(i2) sim.res[[i2]]$Mutnumber.mean)
  Mutnumber.sd=sapply(indres, function(i2) sim.res[[i2]]$Mutnumber.sd)
  Treatfail=sapply(indres, function(i2) sim.res[[i2]]$Treatfail)
  if(PK=='adaptive' || PK=='adaptivepeak'){
  Treatfail_time=sapply(indres, function(i2) sim.res[[i2]]$Treatfail_time)
  }
  Relpatload=sapply(indres, function(i2) sim.res[[i2]]$Relpatload)
  Endpatload=sapply(indres, function(i2) sim.res[[i2]]$Endpatload)

  if(PK=='adaptive' || PK=='adaptivepeak'){
    return(list(  "DiversityIndex.mean"=DiversityIndex.mean, "Treatfail"=Treatfail,  "Mutnumber.mean"=Mutnumber.mean, "Relpatload"=Relpatload, "Endpatload"=Endpatload, "Treatfail_time"=Treatfail_time))
  } else {
  return(list(  "DiversityIndex.mean"=DiversityIndex.mean, "Treatfail"=Treatfail, "Mutnumber.mean"=Mutnumber.mean, "Relpatload"=Relpatload, "Endpatload"=Endpatload))
  }
  })


if(length(benefit)>1){
sim.res.d.t=t(sim.res.d)
indresd1=1:dim(sim.res.d.t)[1]
indresd2=1:dim(sim.res.d.t)[2]
DiversityIndex=sapply(indresd1, function(i1) as.vector(sapply(indresd2, function(i2) sim.res.d.t[,i2])[[i1]]))
Mutnumber=sapply(indresd1+2*length(indresd1), function(i1) as.vector(sapply(indresd2, function(i2) sim.res.d.t[,i2])[[i1]]))
Mutnumber[is.na(Mutnumber)]=0
Treatfail=sapply(indresd1+1*length(indresd1), function(i1) as.vector(sapply(indresd2, function(i2) sim.res.d.t[,i2])[[i1]]))
if(PK=='adaptive' || PK=='adaptivepeak'){
  Treatfail_time=sapply(indresd1+5*length(indresd1), function(i1) as.vector(sapply(indresd2, function(i2) sim.res.d.t[,i2])[[i1]]))
}
Relpatload=sapply(indresd1+3*length(indresd1), function(i1) as.vector(sapply(indresd2, function(i2) sim.res.d.t[,i2])[[i1]]))
Relpatload[is.na(Relpatload)]=0

if(length(dose)>1){
filled.contour(benefit,dose,Treatfail, nlevels=6, levels=c(0.1,0.25,0.5,0.75,0.90,1.05), xlab='Benefit', ylab='Dose', main='Treatment failure')
filled.contour(benefit,dose,DiversityIndex, nlevels=6, levels=c(0.1, 0.2,0.3, 0.4, 0.5,1), xlab='Benefit', ylab='Dose', main='Diversity')
filled.contour(benefit,dose,Mutnumber,nlevels=6, levels=c(0.5, 1, 1.5,2,2.5,3), xlab='Benefit', ylab='Dose', main=' "Fixed" nr of mutations')
}

if(PK=='peak' || PK=='const' || PK=='ramp') return(list(DiversityIndex, Mutnumber, Treatfail, Relpatload))

if(PK=='adaptive' || PK=='adaptivepeak') return(list(DiversityIndex, Mutnumber, Treatfail, Treatfail_time))

}
}
