\name{multistep.evolution}
\alias{multistep.evolution}
\title{
 PKPD model for multi-step resistance evolution.
}
\description{
This function runs the stochastic pharmacodynamic model to simulate emergence of mutations for three different drug pharmacokinetics.
}
\usage{
multistep.evolution( benefit=2, cost=0.008, n.subpops=5, decay=0.1,dose=10, t2cmax=48,  PK='peak', antibiotics='AB', tmax=200, treat=list(absorption=0.5,   tau=1/24, duration=1))
}

\arguments{
\item{benefit}{
Numerical value giving the fold MIC increase due to one mutation.
}
  \item{cost}{
Numerical value giving the amount of growth reduction due to one mutation (with WT growth normalized to 1).
}
  \item{n.subpops}{
Numerical value giving the number of mutations allowed.
}
 \item{decay}{
Numerical value giving the rate of drug decay (in minutes).
}
  \item{dose}{
Numerical value giving the drug dose (in fold MIC units).
}
  \item{t2cmax}{
Numerical value for rampPK simulations, giving the time (in minutes) until the peak drug dose is reached (this defines the speed of drug concentration increase, which occurs in linear increments as defined by d/t2cmx).
}
  \item{PK}{
Character string giving the pharmacokinetic curve used for the simulations (one of 'peak','ramp','cons't,'adaptive','adaptivepeak')
}
\item{antibiotics}{
Character string to determine the pharmacodynamics of the drug used (one of 'AB', 'AMP')
}
  \item{tmax}{
Numerical value giving the treatment time in minutes.
}
\item{treat}{
List of parameters giving treatment characteristics like adsorption rate, treatment frequency and individual pulse duration.
}
}

\value{
Dataframe containing the time trajectories of the individual subpopulations and the drug concentration.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Claudia Igler <claudia.igler@env.ethz.ch>
}
\seealso{
  \code{\link{run.diff.pars}}, \code{\link{extract.vars}}, \code{\link{multistep.evolution.adaptive}}
}

\examples{
multistep.evolution(benefit=2, cost=0.008, n.subpops=5, decay=0.1,dose=10, t2cmax=48,  PK='peak', antibiotics='AB', tmax=200, treat=list(absorption=0.5,   tau=1/24, duration=1))

}
