\name{run.diff.pars}
\alias{run.diff.pars}
\title{
 Running many PKPD simulations over a range of parameters and producing summary statistics.
}
\description{
This funcion calls the individual simulation runs and iterates over a give parameter range to produce summary statistics and plots.
}
\usage{
run.diff.pars(simrun=10, benefit=2, cost=0.008, n.subpops=5, dose=10, delta=1, t2cmax=48,PK='peak', antibiotics='AB',tmax=200, maxpat=10^5)
}
\arguments{
 \item{simrun}{
Numerical value giving the number of simulation runs for each parameter.
}
  \item{benefit}{
Numerical range of values giving the fold MIC increase due to one mutation (one parameter is taken per simulation round). Note: The cost is calculated from the benefit through a linear correlation. 
}
  \item{n.subpops}{
Numerical value giving the number of mutations allowed.
}
  \item{dose}{
Numerical range giving the drug dose (in fold MIC units) (one parameter taken per simulation round).
}
 \item{delta}{
Numerical value modulating the amount of competition between the (partially) sensitive and the resistant subpopulations.
}
  \item{t2cmax}{
Numerical value for rampPK simulations, giving the time (in minutes) until the peak drug dose is reached (this defines the speed of drug concentration increase, which occurs in linear increments as defined by d/t2cmx).
}
  \item{PK}{
Character string giving the pharmacokinetic curve used for the simulations (one of 'peak','ramp','const','adaptive','adaptivepeak')
}
\item{antibiotics}{
Character string to determine the pharmacodynamics of the drug used (one of 'AB', 'AMP')
}
  \item{tmax}{
Numerical value giving the treatment time in minutes.
}
  \item{maxpat}{
Numerical value setting the upper limit for the bacterial load in the adaptive treatment.
}
}

\value{
\item{DiversityIndex}{Matrix giving the diversity over the whole treatment period as calculated through the Shannon index for the range of benefits (rows) and the range of doses (columns).}
\item{Mutnumber}{Matrix giving the number of mutations that reached at least 1/10 of the whole population for populations beigger than 10^4 for the range of benefits (rows) and the range of doses (columns).}
\item{Treatfail}{Matrix giving the probability of treatment failure, i.e. either more than 10 bacteria surviving at the end of the treatment ('peak','ramp','const') or more than 10^8 bacterial cells at any point during treatment ('adaptive', 'adaptivepeak') for the range of benefits (rows) and the range of doses (columns).}
\item{Treatfail_time}{Matrix giving the time at which treatment fails, i.e. there are more than 10^8 bacterial cells, in adaptive treatments ('adaptive', 'adaptivepeak') for the range of benefits (rows) and the range of (maximum) doses (columns).}
\item{Relpatload}{Matrix giving the mutational subpopulation load over the treament period relative to the whole population for the range of benefits (rows = number of subpopulations * benefits) and the range of doses (columns).}
}
\note{
Plots are only possible if at least two benefit / cost parameters and at least two drug doses are specified.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Claudia Igler <claudia.igler@env.ethz.ch>
}
\seealso{
  \code{\link{run.diff.pars}}, \code{\link{multistep.evolution}}, \code{\link{multistep.evolution.adaptive}}
}

\examples{
run.diff.pars(simrun=10, benefit=2, n.subpops=5, dose=10, delta=1, t2cmax=48, PK='peak', antibiotics='AB',tmax=200, maxpat=10^5)

}

