multistep.evolution <-
function( benefit, cost, n.subpops, decay, dose, t2cmax,PK,antibiotics,tmax,treat){

  treatment=list(P01=rlist::list.append(treat,num=1),
                 P02=rlist::list.append(treat,num=1*24),
                 P03=rlist::list.append(treat,num=2*24),
                 P04=rlist::list.append(treat,num=3*24),
                 P05=rlist::list.append(treat,num=4*24),
                 P06=rlist::list.append(treat,num=5*24),
                 P07=rlist::list.append(treat,num=6*24),
                 P08=rlist::list.append(treat,num=7*24),
                 P09=rlist::list.append(treat,num=8*24))
  
  if(antibiotics=='AB'){
    # antibiotics
    PDpars=list(MIC=1, benefit, phiminS=-5, phiminR=-5, kappa=1.5,r=1, leftbirth=1/12, c, u=3*10^-6,gamma=0.01, K=10^9)
  }
  if(antibiotics=='AMP'){
    # AMPs
    PDpars=list(MIC=1, benefit, phiminS=-50, phiminR=-50, kappa=5, r=1,leftbirth=1/12, c, u=10^-6, gamma=0.01, K=10^9)
  }

  ## antimicrobial concentration function
  #peak
  if(PK=='peak'){
      a0=0
  eta.1 <- function(t, treat2){
    with(as.list(treat2),{
      if(any(num <= t & t < num+duration))
        out = dose
      else out=0
      return(out)

    })
  }
  eta <-  function(t.vec, a, treat2=treatment) {
    conc= sapply(treat2, function(treat2){
      sapply(t.vec, function(t) eta.1(t, treat2))
    })
    if (length(t.vec)>1){
      conc_fin=rowSums(conc)
    }   else {
      conc_fin=sum(conc)
    }
    return(conc_fin)
  }
  }

  #ramp
  if(PK=='ramp'){
      a0=0
      decay=0
      eta <- function(t.vec, a, treat2=treatment, pars=PDpars){
   with(as.list(treat2, pars),{
     if(a<dose)
       out = dose/t2cmax
     else out=0
     return(out)
   })
  }
  }

  #const
  if(PK=='const'){
      a0=dose
      decay=0
      eta <- function(t.vec, a, treat2=treatment) out=0
  }

  # stochastic gamma function
  gammaR_G <- function(a, pars=PDpars){
    with(as.list(pars), {
      phimaxR=r*(1-cost)^(0:n.subpops)-gamma
      gR=((phimaxR-phiminR)*(a/(MIC*c(1,benefit*(1:n.subpops))))^kappa)/
        ((a/(MIC*c(1,benefit*(1:n.subpops))))^kappa-phiminR/phimaxR)
      return(gR)})
  }

  # stochastic population model

    R.init <- rep(0, n.subpops+1)
    R.init[1]=10^6
    names(R.init) <- paste0("R",1:(n.subpops+1))
    a.init <- a0
    names(a.init) <- paste("a")
    inits <- c(R.init,a.init)
    stoch.equ <- (length(inits)-1)*3-1

    transitions <-
      adaptivetau::ssa.maketrans(c(paste0("R",1:(n.subpops+1)), "a"),
                    rbind(paste0("R",1:(n.subpops+1)), +1), # growthRi
                    rbind(paste0("R",1:(n.subpops+1)), -1), # deathRi
                    rbind(paste0("R",2:(n.subpops+1)), +1, paste0("R",1:n.subpops), -1), # mutation to Ri+1
                    rbind("a", +1), # growth
                    rbind("a", -1) # decay
      )

    trans.rates <- function(y, p, t){
      a <- y[n.subpops+2]
      Ri <- y[1:(n.subpops+1)]
      dRi <- y[1:(n.subpops+1)]
      R <- sum(Ri)
      with(as.list(p),{
        rates <-
          c(r*(1-u)*(1-cost)^(0:n.subpops)*(1+leftbirth)*Ri,
            (gamma+gammaR_G(a)+r*(1-u)*(1-cost)^(0:n.subpops)*(R/K+leftbirth))*Ri,
            r*u*(1-cost)^(0:(n.subpops-1))*(1-R/K)*Ri[1:n.subpops],
            eta(t,a),
            decay*a)
            names(rates) <- NULL
            return(rates)
      })
    }

    output <-
      as.data.frame(adaptivetau::ssa.adaptivetau(inits, transitions, trans.rates, PDpars, tf=tmax, deterministic=as.logical(c(numeric(stoch.equ), 1,1)), tl.params = list(epsilon=0.01)))

    #  calculate selection coefficient (start= far away from carrying capacity )
    output$a[which(output$a<0)]=0
    start_selcoeff <- with(as.list(PDpars),{
      sapply(output$a, function(a) {
        (r*(1-u)*(1-cost)^(1:n.subpops)-(gamma+gammaR_G(a)[2:(n.subpops+1)]))-(r*(1-u)*(1-cost)^(0:(n.subpops-1))-(gamma+gammaR_G(a)[1:(n.subpops)]))
      })
    })
   
    output.all = cbind(output, t(start_selcoeff))
    return(output.all)
    }
