\name{extract.vars}
\alias{extract.vars}
\title{
 Running individual simulations of the specified pharmacodynamic - pharmacokinetic model and extracting features of interest
}
\description{
 This function calls the simulation specified in run.diff.pars and extracts key variables of interest after every run.
}
\usage{
extract.vars(benefit=2, cost=0.008, n.subpops=5, dose=10, delta=1, t2cmax=48,  PK='peak', antibiotics='AB', tmax=200, treat=list(absorption=0.5,   tau=1/24, duration=1), maxpat=10^5)
}
\arguments{
  \item{benefit}{
Numerical value giving the fold MIC increase due to one mutation.
}
  \item{cost}{
Numerical value giving the amount of growth reduction due to one mutation (with WT growth normalized to 1).
}
  \item{n.subpops}{
Numerical value giving the number of mutations allowed.
}
  \item{dose}{
Numerical value giving the drug dose (in fold MIC units).
}
 \item{delta}{
Numerical value modulating the amount of competition between the (partially) sensitive and the resistant subpopulations.
}
  \item{t2cmax}{
Numerical value for rampPK simulations, giving the time (in minutes) until the peak drug dose is reached (this defines the speed of drug concentration increase, which occurs in linear increments as defined by d/t2cmx).
}
  \item{PK}{
Character string giving the pharmacokinetic curve used for the simulations (one of 'peak','ramp','const','adaptive','adaptivepeak')
}
\item{antibiotics}{
Character string to determine the pharmacodynamics of the drug used (one of 'AB', 'AMP')
}
  \item{tmax}{
Numerical value giving the treatment time in minutes.
}
\item{treat}{
List of parameters giving treatment characteristics like adsorption rate, treatment frequency and individual pulse duration.
}
  \item{maxpat}{
Numerical value setting the upper limit for the bacterial load in the adaptive treatment.
}

}

\value{
\item{Temergence}{Numerical value giving the time of (first) emergence for each mutant.}
\item{DiversityIndex}{Numerical value giving the diversity over the whole treatment period as calculated through the Shannon index.}
\item{Mutnumber}{Numerical value giving the number of mutations that reached at least 1/10 of the whole population for populations beigger than 10^4.}
\item{Endpatload}{Numerical value giving the bacterial load at the end of the treatment period.}
\item{Relpatload}{Numerical vector giving the mutational subpopulation load over the treament period relative to the whole population.}
\item{Conc}{Numerical vector giving the drug concentration time trajectory (PK).}
\item{Firstpatload}{Numerical value giving the time point when the bacterial population becomes bigger than 10^8 cells.}

}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Claudia Igler <claudia.igler@env.ethz.ch>
}
\seealso{
  \code{\link{run.diff.pars}}, \code{\link{multistep.evolution}}, \code{\link{multistep.evolution.adaptive}}
}

\examples{
extract.vars(benefit=2, cost=0.008, n.subpops=5, dose=10, delta=1, t2cmax=48,  PK='peak', antibiotics='AB', tmax=200, treat=list(absorption=0.5,   tau=1/24, duration=1), maxpat=10^5)

}
