\name{multistep.evolution.adaptive}
\alias{multistep.evolution.adaptive}
\title{
 PKPD model with multi-step resistance evolution for adaptive treatment.
}
\description{
This function runs a stochastic pharmacokinetic model that adjusts the drug concentration according to the total population density and the presence of mutants, starting from a neutral expectation of mutants. It also contains the control treatment with peak PK, starting from the same mutant distribution.
}
\usage{
multistep.evolution.adaptive(benefit=2, cost=0.008,  decay=0.1, dose=10, delta=1, t2cmax=48,  PK='adaptive', antibiotics='AB', tmax=200, treat=list(absorption=0.5,   tau=1/24, duration=1), maxpat=10^5)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
 \item{benefit}{
Numerical value giving the fold MIC increase due to one mutation. For adaptive treatment simulations only the following values are possible: 2,3,6,9,15,24,50,75,100.
}
  \item{cost}{
Numerical value giving the amount of growth reduction due to one mutation (with WT growth normalized to 1). For adaptive treatment simulations only the following values are possible: 0.008,0.01,0.04,0.1,0.1, 0.12,0.14,0.16,0.2.
}
  
 \item{decay}{
Numerical value giving the rate of drug decay (in minutes).
}
  \item{dose}{
Numerical value giving the drug dose (in fold MIC units).
}
 \item{delta}{
Numerical value modulating the amount of competition between the (partially) sensitive and the resistant subpopulations.
}
   \item{t2cmax}{
Numerical value for rampPK simulations, giving the time (in minutes) until the peak drug dose is reached (this defines the speed of drug concentration increase, which occurs in linear increments as defined by d/t2cmx).
}
  \item{PK}{
Character string giving the pharmacokinetic curve used for the simulations (one of 'peak','ramp','const','adaptive','adaptivepeak')
}
\item{antibiotics}{
Character string to determine the pharmacodynamics of the drug used (one of 'AB', 'AMP')
}
  \item{tmax}{
Numerical value giving the treatment time in minutes.
}
\item{treat}{
List of parameters giving treatment characteristics like adsorption rate, treatment frequency and individual pulse duration.
}
  \item{maxpat}{
Numerical value setting the upper limit for the bacterial load in the adaptive treatment.
}

}
\value{
Dataframe containing the time trajectories of the individual subpopulations and the drug concentration.
}
\note{
  Do not forget to load the neutral distribution of mutants for the drug class you are interested in (one of 'AB' or 'AMP'), e.g. \code{data()}.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Claudia Igler <claudia.igler@env.ethz.ch>
}
\seealso{
  \code{\link{run.diff.pars}}, \code{\link{extract.vars}}, \code{\link{multistep.evolution}}
}

\examples{
multistep.evolution.adaptive( benefit=2, cost=0.008, decay=0.1, dose=10, delta=1, t2cmax=48,  PK='adaptive', antibiotics='AB', tmax=200, treat=list(absorption=0.5,   tau=1/24, duration=1), maxpat=10^5)

}
