clc, clear all, close all
%% ------------------------------INPUTS----------------------
N = 500;                        %number of particles
Rb = 0.5;                       %radius of the "circular" domain
xbound = 2*Rb;                  %size of bound in x
ybound = xbound;                %size of ound in y
velocity = 1.0*ones(1,N);       %velocity of particles
time = 8;                       %total run time
dt = 0.01;                      %time step

kappa0 = 1.0;                   %repulsion strength
mup = 0.5;                      %constant mu+ : strength of alignment interaction
mun = 1.0;                      %constant mu- : strength of anti-alignment interaction
Fexc =  0.0;                    %magnitude of the Central FORCES (+: repulsive, -: attractive)

epr = 0.08 ;                    %repulsion range
epa = 0.1 ;                     %alignment range
epaa = 0.15 ;                   %anti-alignment range ==> NOTE: epaa > epa
dexc = 0.025;                   %exclusion range (attraction/repulsion from Central FORCES) 

DT  = 0.0;                      %translational dffusion coefficient
DR = 0.0;                       %rotational diffusion coefficient

%% ---------------------------------------------------------------------
rho     = N/(xbound*ybound);
rho_mup = rho*mup;
mun_mup = mun/mup;
Lr_Rb = epr/Rb;
La_Rb = epa/Rb;
Laa_Rb = epaa/Rb;

Nt = round(time/dt) + 1;                    %# of time steps
time_vector = linspace(0,time,Nt);          %time vector

theta_init = 2*pi*rand(N,1);                %initial location in the circle
r_init     = Rb*0.99*rand(N,1);             %initial location in the circle

X0 = [Rb+r_init.*cos(theta_init), Rb+r_init.*sin(theta_init), 2*pi*rand(N,1)-pi];          %Initial Conditions Bounded [x0,yo,phi0[-pi:pi]] for all particles

%% -----------------------------------------------------------------------
tic
[X,Y,Phi] = SSP_New(X0,N,Rb,velocity,Nt,dt,time_vector,epr,epa,epaa,mup,mun,kappa0,DR,DT,Fexc,dexc);

%% ------------------------------------------------------------------
run_time = toc/60;
clc
disp('***************************************************')
disp(['run time: ',num2str(run_time),' minutes'])
disp('')
disp(['L_{rep}/R_{domain}: ',num2str(Lr_Rb)])
disp('')
disp(['L_{alig}/R_{domain}: ',num2str(La_Rb)])
disp('')
disp(['L_{antialig}/R_{domain}: ',num2str(Laa_Rb)])
disp('')


