function [X,Y,Phi] = SSP_New(X0,N,Rb,velocity,Nt,dt,time_vector,epr,epa,epaa,mup,mun,kappa0,DR,DT,Fexc,dexc)


X(1,:) = X0(:,1);       Y(1,:) = X0(:,2);       Phi(1,:) = X0(:,3);     %loading initial conditions

for i=1:Nt-1

% Particle-Particle Interaction (allpointj - point_target) 
distX = -(X(i,:) - X(i,:)');            %x2-x1
distY = -(Y(i,:) - Y(i,:)');            %y2-y1
dPhi = -(Phi(i,:) - Phi(i,:)');         %phi2-phi1 used in alignment/anti-alignment interaction term

dist = sqrt(distX.^2+distY.^2);             %sqrt((x2-x1)^2 + (y2-y1)^2)
phi_rel = angle(distX + 1i.*distY);         %angle argument(rji):polar positional angle of particle j in the frame of reference of particle i, used in repulsion interaction term


%-------------Updating Trajectories-------------------------------------
X(i+1,:) = X(i,:) + dt*velocity.*cos(Phi(i,:)) + sqrt(2*DT*dt)*randn(1,N) - dt*sum( Fexc*(dexc - dist)./dexc.*ceil(heaviside(dexc-dist)).*cos(abs(phi_rel)).* (ones(N)-eye(N)) );
Y(i+1,:) = Y(i,:) + dt*velocity.*sin(Phi(i,:)) + sqrt(2*DT*dt)*randn(1,N) - dt*sum( Fexc*(dexc - dist)./dexc.*ceil(heaviside(dexc-dist)).*sin(abs(phi_rel)).* (ones(N)-eye(N)) );

%------Repulsive Interaction---------------------------------------------
F_rep(:,:) = kappa0 .* ceil(heaviside(epr - dist)) .* sin(Phi(i,:) - phi_rel);

%-------Alignment/Anti-Alignment Interaction----------------------------
F_alig(:,:) = ( mup.*(1-(dist/epa).^2).*ceil(heaviside(epa-dist)) - (-mun.*(4*(dist-epa).*(epaa-dist)./(epaa-epa)^2).*ceil(heaviside(epa-dist))) + (-mun.*(4*(dist-epa).*(epaa-dist)./(epaa-epa)^2).*ceil(heaviside(epaa-dist))) ) .* sin(dPhi);

%-----------Sum of All Interactions------------------------------------
% F_ij = F(i,j);        Matrix of inter-particle interactions ==> interactions of particle j with all other particles i (each column includes all the interactiions of a particle with others)    
F(:,:) = (F_rep(:,:) + F_alig(:,:)) .* (ones(N)-eye(N));            %zeroing the contribution from interaction of a particle with itself

%------------Updating the angles ---------------------------------------
Phi(i+1,:) = Phi(i,:) + sqrt(2*DR*dt)*randn(1,N) + dt*sum(F(:,:));       %sum over rows

% %----------------PERIODIC BC----------------------------------------- 
xbound = 2*Rb; ybound = xbound;
X(i+1,find(X(i+1,:)>xbound)) = X(i+1,find(X(i+1,:)>xbound)) - xbound;
X(i+1,find(X(i+1,:)<0)) = X(i+1,find(X(i+1,:)<0)) + xbound;

Y(i+1,find(Y(i+1,:)>ybound)) = Y(i+1,find(Y(i+1,:)>ybound)) - ybound;
Y(i+1,find(Y(i+1,:)<0)) = Y(i+1,find(Y(i+1,:)<0)) + ybound;
%----------------------------------------------------------------------        
end


end

